# Generated by Django 3.0.14 on 2022-06-10 04:16
from fido2 import cbor
import base64
from django.db import migrations


def migrate_att_data_fwd(apps, schema_editor):
    Authenticator = apps.get_model('django_fido', 'Authenticator')
    for auth in Authenticator.objects.all():
        temp = cbor.decode(base64.b64decode(auth.attestation_data))
        if 'fmt' not in temp:
            auth.attestation_data =  base64.b64encode(
                cbor.encode(
                    {"fmt": temp[1],
                     "authData": temp[2],
                     "attStmt": temp[3]})
            ).decode('utf-8')
            auth.save()


def migrate_att_data_back(apps, schema_editor):
    Authenticator = apps.get_model('django_fido', 'Authenticator')
    for auth in Authenticator.objects.all():
        temp = cbor.decode(base64.b64decode(auth.attestation_data))
        if 1 not in temp:
            auth.attestation_data =  base64.b64encode(
                cbor.encode(
                    {1: temp["fmt"],
                     2: temp["authData"],
                     3: temp["attStmt"]})
            ).decode('utf-8')
            auth.save()



class Migration(migrations.Migration):

    dependencies = [
        ('django_fido', '0018_authenticator_user_handle'),
    ]

    operations = [
        migrations.RunPython(migrate_att_data_fwd, migrate_att_data_back, elidable=True),
    ]
