import * as certmgr from '@aws-cdk/aws-certificatemanager';
import * as ec2 from '@aws-cdk/aws-ec2';
import * as ecs from '@aws-cdk/aws-ecs';
import * as rds from '@aws-cdk/aws-rds';
import * as secretsmanager from '@aws-cdk/aws-secretsmanager';
import * as cdk from '@aws-cdk/core';
/**
 * The ECS task autoscaling definition.
 *
 * @stability stable
 */
export interface AutoScaleTask {
    /**
     * The minimal count of the task number.
     *
     * @default - nodeCount
     * @stability stable
     */
    readonly min?: number;
    /**
     * The maximal count of the task number.
     *
     * @default - min + 5
     * @stability stable
     */
    readonly max?: number;
    /**
     * The target cpu utilization for the service autoscaling.
     *
     * @default 75
     * @stability stable
     */
    readonly targetCpuUtilization?: number;
}
/**
 * @stability stable
 */
export interface KeyCloakProps {
    /**
     * VPC for the workload.
     *
     * @stability stable
     */
    readonly vpc?: ec2.IVpc;
    /**
     * ACM certificate ARN to import.
     *
     * @stability stable
     */
    readonly certificateArn: string;
    /**
     * Create a bastion host for debugging or trouble-shooting.
     *
     * @default false
     * @stability stable
     */
    readonly bastion?: boolean;
    /**
     * Number of keycloak node in the cluster.
     *
     * @default 2
     * @stability stable
     */
    readonly nodeCount?: number;
    /**
     * VPC public subnets for ALB.
     *
     * @default - VPC public subnets
     * @stability stable
     */
    readonly publicSubnets?: ec2.SubnetSelection;
    /**
     * VPC private subnets for keycloak service.
     *
     * @default - VPC private subnets
     * @stability stable
     */
    readonly privateSubnets?: ec2.SubnetSelection;
    /**
     * VPC subnets for database.
     *
     * @default - VPC isolated subnets
     * @stability stable
     */
    readonly databaseSubnets?: ec2.SubnetSelection;
    /**
     * Database instance type.
     *
     * @default r5.large
     * @stability stable
     */
    readonly databaseInstanceType?: ec2.InstanceType;
    /**
     * The database instance engine.
     *
     * @default - MySQL 8.0.21
     * @stability stable
     */
    readonly instanceEngine?: rds.IInstanceEngine;
    /**
     * The database cluster engine.
     *
     * @default rds.AuroraMysqlEngineVersion.VER_2_09_1
     * @stability stable
     */
    readonly clusterEngine?: rds.IClusterEngine;
    /**
     * Whether to use aurora serverless.
     *
     * When enabled, the `databaseInstanceType` and
     * `engine` will be ignored. The `rds.DatabaseClusterEngine.AURORA_MYSQL` will be used as
     * the default cluster engine instead.
     *
     * @default false
     * @stability stable
     */
    readonly auroraServerless?: boolean;
    /**
     * Whether to use single RDS instance rather than RDS cluster.
     *
     * Not recommended for production.
     *
     * @default false
     * @stability stable
     */
    readonly singleDbInstance?: boolean;
    /**
     * The sticky session duration for the keycloak workload with ALB.
     *
     * @default - one day
     * @stability stable
     */
    readonly stickinessCookieDuration?: cdk.Duration;
    /**
     * Autoscaling for the ECS Service.
     *
     * @default - no ecs service autoscaling
     * @stability stable
     */
    readonly autoScaleTask?: AutoScaleTask;
}
/**
 * @stability stable
 */
export declare class KeyCloak extends cdk.Construct {
    /**
     * @stability stable
     */
    readonly vpc: ec2.IVpc;
    /**
     * @stability stable
     */
    readonly db?: Database;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props: KeyCloakProps);
    /**
     * @stability stable
     */
    addDatabase(props: DatabaseProps): Database;
    /**
     * @stability stable
     */
    addKeyCloakContainerService(props: ContainerServiceProps): ContainerService;
    private _generateKeycloakSecret;
}
/**
 * @stability stable
 */
export interface DatabaseProps {
    /**
     * The VPC for the database.
     *
     * @stability stable
     */
    readonly vpc: ec2.IVpc;
    /**
     * VPC subnets for database.
     *
     * @stability stable
     */
    readonly databaseSubnets?: ec2.SubnetSelection;
    /**
     * The database instance type.
     *
     * @default r5.large
     * @stability stable
     */
    readonly instanceType?: ec2.InstanceType;
    /**
     * The database instance engine.
     *
     * @default - MySQL 8.0.21
     * @stability stable
     */
    readonly instanceEngine?: rds.IInstanceEngine;
    /**
     * The database cluster engine.
     *
     * @default rds.AuroraMysqlEngineVersion.VER_2_09_1
     * @stability stable
     */
    readonly clusterEngine?: rds.IClusterEngine;
    /**
     * enable aurora serverless.
     *
     * @default false
     * @stability stable
     */
    readonly auroraServerless?: boolean;
    /**
     * Whether to use single RDS instance rather than RDS cluster.
     *
     * Not recommended for production.
     *
     * @default false
     * @stability stable
     */
    readonly singleDbInstance?: boolean;
}
/**
 * Database configuration.
 *
 * @stability stable
 */
export interface DatabaseCofig {
    /**
     * The database secret.
     *
     * @stability stable
     */
    readonly secret: secretsmanager.ISecret;
    /**
     * The database connnections.
     *
     * @stability stable
     */
    readonly connections: ec2.Connections;
    /**
     * The endpoint address for the database.
     *
     * @stability stable
     */
    readonly endpoint: string;
    /**
     * The databasae identifier.
     *
     * @stability stable
     */
    readonly identifier: string;
}
/**
 * Represents the database instance or database cluster.
 *
 * @stability stable
 */
export declare class Database extends cdk.Construct {
    /**
     * @stability stable
     */
    readonly vpc: ec2.IVpc;
    /**
     * @stability stable
     */
    readonly clusterEndpointHostname: string;
    /**
     * @stability stable
     */
    readonly clusterIdentifier: string;
    /**
     * @stability stable
     */
    readonly secret: secretsmanager.ISecret;
    /**
     * @stability stable
     */
    readonly connections: ec2.Connections;
    private readonly _mysqlListenerPort;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props: DatabaseProps);
    private _createRdsInstance;
    private _createRdsCluster;
    private _createServerlessCluster;
}
/**
 * @stability stable
 */
export interface ContainerServiceProps {
    /**
     * The VPC for the service.
     *
     * @stability stable
     */
    readonly vpc: ec2.IVpc;
    /**
     * VPC subnets for keycloak service.
     *
     * @stability stable
     */
    readonly privateSubnets?: ec2.SubnetSelection;
    /**
     * VPC public subnets for ALB.
     *
     * @stability stable
     */
    readonly publicSubnets?: ec2.SubnetSelection;
    /**
     * The RDS database for the service.
     *
     * @stability stable
     */
    readonly database: Database;
    /**
     * The secrets manager secret for the keycloak.
     *
     * @stability stable
     */
    readonly keycloakSecret: secretsmanager.ISecret;
    /**
     * The ACM certificate.
     *
     * @stability stable
     */
    readonly certificate: certmgr.ICertificate;
    /**
     * Whether to create the bastion host.
     *
     * @default false
     * @stability stable
     */
    readonly bastion?: boolean;
    /**
     * Whether to enable the ECS service deployment circuit breaker.
     *
     * @default false
     * @stability stable
     */
    readonly circuitBreaker?: boolean;
    /**
     * Number of keycloak node in the cluster.
     *
     * @default 1
     * @stability stable
     */
    readonly nodeCount?: number;
    /**
     * The sticky session duration for the keycloak workload with ALB.
     *
     * @default - one day
     * @stability stable
     */
    readonly stickinessCookieDuration?: cdk.Duration;
    /**
     * Autoscaling for the ECS Service.
     *
     * @default - no ecs service autoscaling
     * @stability stable
     */
    readonly autoScaleTask?: AutoScaleTask;
}
/**
 * @stability stable
 */
export declare class ContainerService extends cdk.Construct {
    /**
     * @stability stable
     */
    readonly service: ecs.FargateService;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props: ContainerServiceProps);
    private getKeyCloakDockerImageUri;
}
