# coding: utf-8

"""
    ARLAS Exploration API

    Explore the content of ARLAS collections

    OpenAPI spec version: 14.0.2
    Contact: contact@gisaia.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class ExploreApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def aggregate(self, collection, agg, **kwargs):
        """
        Aggregate
        Aggregate the elements in the collection(s), given the filters and the aggregation parameters
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.aggregate(collection, agg, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str collection: collection (required)
        :param list[str] agg: - The agg parameter should be given in the following formats:            {type}:{field}:interval-{interval}:format-{format}:collect_field-{collect_field}:collect_fct-{function}:order-{order}:on-{on}:size-{size}:fetch_hits-{fetch_hits values}    Where :      - **{type}:{field}** part is mandatory.       - **interval** must be specified only when aggregation type is datehistogram, histogram and geohash.      - **format** is optional for datehistogram, and must not be specified for the other types.      - (**collect_field**,**collect_fct**) couple is optional for all aggregation types.       - It's possible to apply multiple metric aggregations by defining multiple (**collect_field**,**collect_fct**) couples.      - (**collect_field**,**collect_fct**) couples should be unique in that case.      - (**order**,**on**) couple is optional for all aggregation types.      - **size** is optional for term and geohash, and must not be specified for the other types.      - **include** is optional for term, and must not be specified for the other types.   - {type} possible values are :           datehistogram, histogram, geohash and term.    - {interval} possible values depends on {type}.           If {type} = datehistogram, then {interval} = {size}(year,quarter,month,week,day,hour,minute,second). Size value must be equal to 1 for year,quarter,month and week unities.           If {type} = histogram, then {interval} = {size}.           If {type} = geohash, then {interval} = {size}. It's an integer between 1 and 12. Lower the length, greater is the surface of aggregation.           If {type} = term, then interval-{interval} is not needed.    - format-{format} is the date format for key aggregation. The default value is yyyy-MM-dd-hh:mm:ss.   - {collect_fct} is the aggregation function to apply to collections on the specified {collect_field}.      {collect_fct} possible values are :           avg,cardinality,max,min,sum   - {order} is set to sort the aggregation buckets on the field name, on the count of the buckets or on the the result of a metric sub-aggregation. Its values are 'asc' or 'desc'.    - {on} is set to specify whether the {order} is on the field name, on the count of the aggregation or on the result of a metric sub-aggregation. Its values are 'field', 'count' or 'result'.    - If {on} is equal to `result` and two or more (**collect_field**,**collect_fct**) couples are specified, then the order is applied on the first `collect_fct` that is different from geobbox and geocentroid   - {size} Defines how many buckets should be returned.    - {include} Specifies the values for which buckets will be created. This values are comma separated. If one value is specified then regular expressions can be used (only in this case) and buckets matching them will be created. If more than one value are specified then only buckets matching the exact values will be created.   - **aggregated_geometries**       > **What it does**: Allows to specify a list of aggregated forms of geometries that represent the bucket.       > __**Syntax**__: `aggregated_geometries-{COMMA_SEPARATED_AGGREGATED_GEOMETRIES}`.       > __**Available aggregated geometries**__: `centroid, bbox, geohash, geohash_center`.          - **centroid**: returns the centroid of data inside the bucket.          - **bbox**: returns the data extent (bbox) in each bucket.          - **geohash**: returns the 'geohash' extent of each bucket. This form is supported for **geohash** aggregation type only.          - **geohash_center**: returns the geohash center of each bucket. This form is supported for **geohash** aggregation type only.       > __**Response**__: the aggregated geometries are returned in `geometries` list in the json response. Each object inside this list has : the reference to the aggregated form, the geojson geometry and an attribute `is_raw` set to false       > __**Example**__: `aggregated_geometries-bbox,geohash`   - **raw_geometries**       > **What it does**: Allows to specify a list of raw geometries provided by hits that represent the bucket and that are elected by a sort       > __**Syntax**__: `raw_geometries-{GEOMETRY_FIELD}({COMMA_SEPERATED_SORT_FIELDS});{GEOMETRY_FIELD2}({COMMA_SEPERATED_SORT_FIELDS2})`.       > __**Available raw geometries**__: any field of the collection whose type is **geo-point** or **geo-shape**.          - sort fields are optional. If no sort is specified, an ascending sort on `collection.params.timestamp_path` is applied          - a sort field can be preceded by '-' for descending sort. Otherwise the sort is ascending       > __**Response**__: the aggregated geometries are returned in `geometries` list in the json response. Each object inside this list has : the reference to the geometry path, the used sort, the geojson geometry and an attribute `is_raw` set to true       > __**Example**__: `raw_geometries-geo_field1,geo_field2  ||  raw_geometries-geo_field(-field1,field2)` || raw_geometries-geo_field1(field1);geo_field2(field2,field3)   - **fetch_hits**        > **What it does**: Specifies the number of hits to retrieve inside each aggregation bucket and which fields to include in the hits.       > __**Syntax**__: `fetch_hits-{sizeOfHitsToFetch}(+{field1}, {field2}, -{field3}, ...)`.       > **Note 1**: `{sizeOfHitsToFetch}` is optional, if not specified, 1 is considered as default.       > **Note 2**: `{field}` can be preceded by **+** or **-** for **ascending** or **descending** sort of the hits. Order matters.       > __**Example**__: `fetch_hits-3(-timestamp, geometry)`. Fetches the 3 last positions for each bucket.   **agg** parameter is multiple. Every agg parameter specified is a subaggregation of the previous one : order matters.    For more details, check https://gitlab.com/GISAIA.ARLAS/ARLAS-server/blob/master/doc/api/API-definition.md. (required)
        :param list[str] f: - A triplet for filtering the result. Multiple filter can be provided in distinct parameters (AND operator is applied) or in the same parameter separated by semi-colons (OR operator is applied). The order does not matter.    - A triplet is composed of a field name, a comparison operator and a value.      The possible values of the comparison operator are :           Operator |                   Description                    | value type          :eq:     | {fieldName} equals {comma separated values}. **OR** operation is applied for the specified values | numeric or strings           :ne:     | {fieldName} must not equal {comma separated values }. **AND** operation is applied for the specified values | numeric or strings           :like:   | {fieldName}  is like {value}                     | numeric or strings           :gte:    | {fieldName} is greater than or equal to  {value} | numeric           :gt:     | {fieldName} is greater than {value}              | numeric           :lte:    | {fieldName} is less than or equal to {value}     | numeric           :lt:     | {fieldName}  is less than {value}                | numeric           :range:  | {fieldName} is between `{comma separated [min<max] values}`. **OR** operation is applied for the specified ranges | numeric or strings. If the field's type is date, then min & max should be timestamps in millisecond or a Date expression          :within: | {GeofieldName}` is within the `{given WKT string or the given BBOX }` | a WKT string or the BBOX string : `\"west, south, east, north\"`           :notwithin:| {GeofieldName} is not within the `{given WKT string or the given BBOX }` | a WKT string or the BBOX string : `\"west, south, east, north\"`           :intersects:| {GeofieldName} intersects the `{given WKT string or the given BBOX }` | a WKT string or the BBOX string : `\"west, south, east, north\"`           :notintersects:| {GeofieldName} does not intersect the `{given WKT string or the given }` | a WKT string or the BBOX string : `\"west, south, east, north\"` 
        :param list[str] q: A full text search. Optionally, it's possible to search on a field using this syntax: {fieldname}:{text}
        :param str dateformat: The format of dates. This parameter should be set only if a date field is queried in `f` param; when using `gt`, `lt`, `gte`, `lte` and `range` operations
        :param bool pretty: Pretty print
        :param bool flat: Flats the property map: only key/value on one level
        :param int max_age_cache: max-age-cache
        :return: AggregationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.aggregate_with_http_info(collection, agg, **kwargs)
        else:
            (data) = self.aggregate_with_http_info(collection, agg, **kwargs)
            return data

    def aggregate_with_http_info(self, collection, agg, **kwargs):
        """
        Aggregate
        Aggregate the elements in the collection(s), given the filters and the aggregation parameters
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.aggregate_with_http_info(collection, agg, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str collection: collection (required)
        :param list[str] agg: - The agg parameter should be given in the following formats:            {type}:{field}:interval-{interval}:format-{format}:collect_field-{collect_field}:collect_fct-{function}:order-{order}:on-{on}:size-{size}:fetch_hits-{fetch_hits values}    Where :      - **{type}:{field}** part is mandatory.       - **interval** must be specified only when aggregation type is datehistogram, histogram and geohash.      - **format** is optional for datehistogram, and must not be specified for the other types.      - (**collect_field**,**collect_fct**) couple is optional for all aggregation types.       - It's possible to apply multiple metric aggregations by defining multiple (**collect_field**,**collect_fct**) couples.      - (**collect_field**,**collect_fct**) couples should be unique in that case.      - (**order**,**on**) couple is optional for all aggregation types.      - **size** is optional for term and geohash, and must not be specified for the other types.      - **include** is optional for term, and must not be specified for the other types.   - {type} possible values are :           datehistogram, histogram, geohash and term.    - {interval} possible values depends on {type}.           If {type} = datehistogram, then {interval} = {size}(year,quarter,month,week,day,hour,minute,second). Size value must be equal to 1 for year,quarter,month and week unities.           If {type} = histogram, then {interval} = {size}.           If {type} = geohash, then {interval} = {size}. It's an integer between 1 and 12. Lower the length, greater is the surface of aggregation.           If {type} = term, then interval-{interval} is not needed.    - format-{format} is the date format for key aggregation. The default value is yyyy-MM-dd-hh:mm:ss.   - {collect_fct} is the aggregation function to apply to collections on the specified {collect_field}.      {collect_fct} possible values are :           avg,cardinality,max,min,sum   - {order} is set to sort the aggregation buckets on the field name, on the count of the buckets or on the the result of a metric sub-aggregation. Its values are 'asc' or 'desc'.    - {on} is set to specify whether the {order} is on the field name, on the count of the aggregation or on the result of a metric sub-aggregation. Its values are 'field', 'count' or 'result'.    - If {on} is equal to `result` and two or more (**collect_field**,**collect_fct**) couples are specified, then the order is applied on the first `collect_fct` that is different from geobbox and geocentroid   - {size} Defines how many buckets should be returned.    - {include} Specifies the values for which buckets will be created. This values are comma separated. If one value is specified then regular expressions can be used (only in this case) and buckets matching them will be created. If more than one value are specified then only buckets matching the exact values will be created.   - **aggregated_geometries**       > **What it does**: Allows to specify a list of aggregated forms of geometries that represent the bucket.       > __**Syntax**__: `aggregated_geometries-{COMMA_SEPARATED_AGGREGATED_GEOMETRIES}`.       > __**Available aggregated geometries**__: `centroid, bbox, geohash, geohash_center`.          - **centroid**: returns the centroid of data inside the bucket.          - **bbox**: returns the data extent (bbox) in each bucket.          - **geohash**: returns the 'geohash' extent of each bucket. This form is supported for **geohash** aggregation type only.          - **geohash_center**: returns the geohash center of each bucket. This form is supported for **geohash** aggregation type only.       > __**Response**__: the aggregated geometries are returned in `geometries` list in the json response. Each object inside this list has : the reference to the aggregated form, the geojson geometry and an attribute `is_raw` set to false       > __**Example**__: `aggregated_geometries-bbox,geohash`   - **raw_geometries**       > **What it does**: Allows to specify a list of raw geometries provided by hits that represent the bucket and that are elected by a sort       > __**Syntax**__: `raw_geometries-{GEOMETRY_FIELD}({COMMA_SEPERATED_SORT_FIELDS});{GEOMETRY_FIELD2}({COMMA_SEPERATED_SORT_FIELDS2})`.       > __**Available raw geometries**__: any field of the collection whose type is **geo-point** or **geo-shape**.          - sort fields are optional. If no sort is specified, an ascending sort on `collection.params.timestamp_path` is applied          - a sort field can be preceded by '-' for descending sort. Otherwise the sort is ascending       > __**Response**__: the aggregated geometries are returned in `geometries` list in the json response. Each object inside this list has : the reference to the geometry path, the used sort, the geojson geometry and an attribute `is_raw` set to true       > __**Example**__: `raw_geometries-geo_field1,geo_field2  ||  raw_geometries-geo_field(-field1,field2)` || raw_geometries-geo_field1(field1);geo_field2(field2,field3)   - **fetch_hits**        > **What it does**: Specifies the number of hits to retrieve inside each aggregation bucket and which fields to include in the hits.       > __**Syntax**__: `fetch_hits-{sizeOfHitsToFetch}(+{field1}, {field2}, -{field3}, ...)`.       > **Note 1**: `{sizeOfHitsToFetch}` is optional, if not specified, 1 is considered as default.       > **Note 2**: `{field}` can be preceded by **+** or **-** for **ascending** or **descending** sort of the hits. Order matters.       > __**Example**__: `fetch_hits-3(-timestamp, geometry)`. Fetches the 3 last positions for each bucket.   **agg** parameter is multiple. Every agg parameter specified is a subaggregation of the previous one : order matters.    For more details, check https://gitlab.com/GISAIA.ARLAS/ARLAS-server/blob/master/doc/api/API-definition.md. (required)
        :param list[str] f: - A triplet for filtering the result. Multiple filter can be provided in distinct parameters (AND operator is applied) or in the same parameter separated by semi-colons (OR operator is applied). The order does not matter.    - A triplet is composed of a field name, a comparison operator and a value.      The possible values of the comparison operator are :           Operator |                   Description                    | value type          :eq:     | {fieldName} equals {comma separated values}. **OR** operation is applied for the specified values | numeric or strings           :ne:     | {fieldName} must not equal {comma separated values }. **AND** operation is applied for the specified values | numeric or strings           :like:   | {fieldName}  is like {value}                     | numeric or strings           :gte:    | {fieldName} is greater than or equal to  {value} | numeric           :gt:     | {fieldName} is greater than {value}              | numeric           :lte:    | {fieldName} is less than or equal to {value}     | numeric           :lt:     | {fieldName}  is less than {value}                | numeric           :range:  | {fieldName} is between `{comma separated [min<max] values}`. **OR** operation is applied for the specified ranges | numeric or strings. If the field's type is date, then min & max should be timestamps in millisecond or a Date expression          :within: | {GeofieldName}` is within the `{given WKT string or the given BBOX }` | a WKT string or the BBOX string : `\"west, south, east, north\"`           :notwithin:| {GeofieldName} is not within the `{given WKT string or the given BBOX }` | a WKT string or the BBOX string : `\"west, south, east, north\"`           :intersects:| {GeofieldName} intersects the `{given WKT string or the given BBOX }` | a WKT string or the BBOX string : `\"west, south, east, north\"`           :notintersects:| {GeofieldName} does not intersect the `{given WKT string or the given }` | a WKT string or the BBOX string : `\"west, south, east, north\"` 
        :param list[str] q: A full text search. Optionally, it's possible to search on a field using this syntax: {fieldname}:{text}
        :param str dateformat: The format of dates. This parameter should be set only if a date field is queried in `f` param; when using `gt`, `lt`, `gte`, `lte` and `range` operations
        :param bool pretty: Pretty print
        :param bool flat: Flats the property map: only key/value on one level
        :param int max_age_cache: max-age-cache
        :return: AggregationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['collection', 'agg', 'f', 'q', 'dateformat', 'pretty', 'flat', 'max_age_cache']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method aggregate" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'collection' is set
        if ('collection' not in params) or (params['collection'] is None):
            raise ValueError("Missing the required parameter `collection` when calling `aggregate`")
        # verify the required parameter 'agg' is set
        if ('agg' not in params) or (params['agg'] is None):
            raise ValueError("Missing the required parameter `agg` when calling `aggregate`")


        collection_formats = {}

        path_params = {}
        if 'collection' in params:
            path_params['collection'] = params['collection']

        query_params = []
        if 'agg' in params:
            query_params.append(('agg', params['agg']))
            collection_formats['agg'] = 'multi'
        if 'f' in params:
            query_params.append(('f', params['f']))
            collection_formats['f'] = 'multi'
        if 'q' in params:
            query_params.append(('q', params['q']))
            collection_formats['q'] = 'multi'
        if 'dateformat' in params:
            query_params.append(('dateformat', params['dateformat']))
        if 'pretty' in params:
            query_params.append(('pretty', params['pretty']))
        if 'flat' in params:
            query_params.append(('flat', params['flat']))
        if 'max_age_cache' in params:
            query_params.append(('max-age-cache', params['max_age_cache']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json;charset=utf-8'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/explore/{collection}/_aggregate', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='AggregationResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def aggregate_post(self, collection, **kwargs):
        """
        Aggregate
        Aggregate the elements in the collection(s), given the filters and the aggregation parameters
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.aggregate_post(collection, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str collection: collection (required)
        :param AggregationsRequest body:
        :param bool pretty: Pretty print
        :param int max_age_cache: max-age-cache
        :return: AggregationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.aggregate_post_with_http_info(collection, **kwargs)
        else:
            (data) = self.aggregate_post_with_http_info(collection, **kwargs)
            return data

    def aggregate_post_with_http_info(self, collection, **kwargs):
        """
        Aggregate
        Aggregate the elements in the collection(s), given the filters and the aggregation parameters
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.aggregate_post_with_http_info(collection, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str collection: collection (required)
        :param AggregationsRequest body:
        :param bool pretty: Pretty print
        :param int max_age_cache: max-age-cache
        :return: AggregationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['collection', 'body', 'pretty', 'max_age_cache']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method aggregate_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'collection' is set
        if ('collection' not in params) or (params['collection'] is None):
            raise ValueError("Missing the required parameter `collection` when calling `aggregate_post`")


        collection_formats = {}

        path_params = {}
        if 'collection' in params:
            path_params['collection'] = params['collection']

        query_params = []
        if 'pretty' in params:
            query_params.append(('pretty', params['pretty']))
        if 'max_age_cache' in params:
            query_params.append(('max-age-cache', params['max_age_cache']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json;charset=utf-8'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/explore/{collection}/_aggregate', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='AggregationResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def compute(self, collection, field, metric, **kwargs):
        """
        Compute
        Computes the given metric on a field in the collection, given the filters
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.compute(collection, field, metric, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str collection: collection (required)
        :param str field: The field on which the metric is calculated. (required)
        :param str metric: The metric to compute : `max, min, avg, sum, cardinality, spanning, geobbox, geocentroid`. (required)
        :param list[str] f: - A triplet for filtering the result. Multiple filter can be provided in distinct parameters (AND operator is applied) or in the same parameter separated by semi-colons (OR operator is applied). The order does not matter.    - A triplet is composed of a field name, a comparison operator and a value.      The possible values of the comparison operator are :           Operator |                   Description                    | value type          :eq:     | {fieldName} equals {comma separated values}. **OR** operation is applied for the specified values | numeric or strings           :ne:     | {fieldName} must not equal {comma separated values }. **AND** operation is applied for the specified values | numeric or strings           :like:   | {fieldName}  is like {value}                     | numeric or strings           :gte:    | {fieldName} is greater than or equal to  {value} | numeric           :gt:     | {fieldName} is greater than {value}              | numeric           :lte:    | {fieldName} is less than or equal to {value}     | numeric           :lt:     | {fieldName}  is less than {value}                | numeric           :range:  | {fieldName} is between `{comma separated [min<max] values}`. **OR** operation is applied for the specified ranges | numeric or strings. If the field's type is date, then min & max should be timestamps in millisecond or a Date expression          :within: | {GeofieldName}` is within the `{given WKT string or the given BBOX }` | a WKT string or the BBOX string : `\"west, south, east, north\"`           :notwithin:| {GeofieldName} is not within the `{given WKT string or the given BBOX }` | a WKT string or the BBOX string : `\"west, south, east, north\"`           :intersects:| {GeofieldName} intersects the `{given WKT string or the given BBOX }` | a WKT string or the BBOX string : `\"west, south, east, north\"`           :notintersects:| {GeofieldName} does not intersect the `{given WKT string or the given }` | a WKT string or the BBOX string : `\"west, south, east, north\"` 
        :param list[str] q: A full text search. Optionally, it's possible to search on a field using this syntax: {fieldname}:{text}
        :param str dateformat: The format of dates. This parameter should be set only if a date field is queried in `f` param; when using `gt`, `lt`, `gte`, `lte` and `range` operations
        :param bool pretty: Pretty print
        :param int max_age_cache: max-age-cache
        :return: ComputationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.compute_with_http_info(collection, field, metric, **kwargs)
        else:
            (data) = self.compute_with_http_info(collection, field, metric, **kwargs)
            return data

    def compute_with_http_info(self, collection, field, metric, **kwargs):
        """
        Compute
        Computes the given metric on a field in the collection, given the filters
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.compute_with_http_info(collection, field, metric, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str collection: collection (required)
        :param str field: The field on which the metric is calculated. (required)
        :param str metric: The metric to compute : `max, min, avg, sum, cardinality, spanning, geobbox, geocentroid`. (required)
        :param list[str] f: - A triplet for filtering the result. Multiple filter can be provided in distinct parameters (AND operator is applied) or in the same parameter separated by semi-colons (OR operator is applied). The order does not matter.    - A triplet is composed of a field name, a comparison operator and a value.      The possible values of the comparison operator are :           Operator |                   Description                    | value type          :eq:     | {fieldName} equals {comma separated values}. **OR** operation is applied for the specified values | numeric or strings           :ne:     | {fieldName} must not equal {comma separated values }. **AND** operation is applied for the specified values | numeric or strings           :like:   | {fieldName}  is like {value}                     | numeric or strings           :gte:    | {fieldName} is greater than or equal to  {value} | numeric           :gt:     | {fieldName} is greater than {value}              | numeric           :lte:    | {fieldName} is less than or equal to {value}     | numeric           :lt:     | {fieldName}  is less than {value}                | numeric           :range:  | {fieldName} is between `{comma separated [min<max] values}`. **OR** operation is applied for the specified ranges | numeric or strings. If the field's type is date, then min & max should be timestamps in millisecond or a Date expression          :within: | {GeofieldName}` is within the `{given WKT string or the given BBOX }` | a WKT string or the BBOX string : `\"west, south, east, north\"`           :notwithin:| {GeofieldName} is not within the `{given WKT string or the given BBOX }` | a WKT string or the BBOX string : `\"west, south, east, north\"`           :intersects:| {GeofieldName} intersects the `{given WKT string or the given BBOX }` | a WKT string or the BBOX string : `\"west, south, east, north\"`           :notintersects:| {GeofieldName} does not intersect the `{given WKT string or the given }` | a WKT string or the BBOX string : `\"west, south, east, north\"` 
        :param list[str] q: A full text search. Optionally, it's possible to search on a field using this syntax: {fieldname}:{text}
        :param str dateformat: The format of dates. This parameter should be set only if a date field is queried in `f` param; when using `gt`, `lt`, `gte`, `lte` and `range` operations
        :param bool pretty: Pretty print
        :param int max_age_cache: max-age-cache
        :return: ComputationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['collection', 'field', 'metric', 'f', 'q', 'dateformat', 'pretty', 'max_age_cache']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method compute" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'collection' is set
        if ('collection' not in params) or (params['collection'] is None):
            raise ValueError("Missing the required parameter `collection` when calling `compute`")
        # verify the required parameter 'field' is set
        if ('field' not in params) or (params['field'] is None):
            raise ValueError("Missing the required parameter `field` when calling `compute`")
        # verify the required parameter 'metric' is set
        if ('metric' not in params) or (params['metric'] is None):
            raise ValueError("Missing the required parameter `metric` when calling `compute`")


        collection_formats = {}

        path_params = {}
        if 'collection' in params:
            path_params['collection'] = params['collection']

        query_params = []
        if 'field' in params:
            query_params.append(('field', params['field']))
        if 'metric' in params:
            query_params.append(('metric', params['metric']))
        if 'f' in params:
            query_params.append(('f', params['f']))
            collection_formats['f'] = 'multi'
        if 'q' in params:
            query_params.append(('q', params['q']))
            collection_formats['q'] = 'multi'
        if 'dateformat' in params:
            query_params.append(('dateformat', params['dateformat']))
        if 'pretty' in params:
            query_params.append(('pretty', params['pretty']))
        if 'max_age_cache' in params:
            query_params.append(('max-age-cache', params['max_age_cache']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json;charset=utf-8'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/explore/{collection}/_compute', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ComputationResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def compute_post(self, collection, **kwargs):
        """
        Compute
        Computes the given metric on a field in the collection, given the filters
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.compute_post(collection, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str collection: collection (required)
        :param ComputationRequest body:
        :param bool pretty: Pretty print
        :param int max_age_cache: max-age-cache
        :return: ComputationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.compute_post_with_http_info(collection, **kwargs)
        else:
            (data) = self.compute_post_with_http_info(collection, **kwargs)
            return data

    def compute_post_with_http_info(self, collection, **kwargs):
        """
        Compute
        Computes the given metric on a field in the collection, given the filters
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.compute_post_with_http_info(collection, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str collection: collection (required)
        :param ComputationRequest body:
        :param bool pretty: Pretty print
        :param int max_age_cache: max-age-cache
        :return: ComputationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['collection', 'body', 'pretty', 'max_age_cache']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method compute_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'collection' is set
        if ('collection' not in params) or (params['collection'] is None):
            raise ValueError("Missing the required parameter `collection` when calling `compute_post`")


        collection_formats = {}

        path_params = {}
        if 'collection' in params:
            path_params['collection'] = params['collection']

        query_params = []
        if 'pretty' in params:
            query_params.append(('pretty', params['pretty']))
        if 'max_age_cache' in params:
            query_params.append(('max-age-cache', params['max_age_cache']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json;charset=utf-8'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/explore/{collection}/_compute', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ComputationResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def count(self, collection, **kwargs):
        """
        Count
        Count the number of elements found in the collection(s), given the filters
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.count(collection, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str collection: collections (required)
        :param list[str] f: - A triplet for filtering the result. Multiple filter can be provided in distinct parameters (AND operator is applied) or in the same parameter separated by semi-colons (OR operator is applied). The order does not matter.    - A triplet is composed of a field name, a comparison operator and a value.      The possible values of the comparison operator are :           Operator |                   Description                    | value type          :eq:     | {fieldName} equals {comma separated values}. **OR** operation is applied for the specified values | numeric or strings           :ne:     | {fieldName} must not equal {comma separated values }. **AND** operation is applied for the specified values | numeric or strings           :like:   | {fieldName}  is like {value}                     | numeric or strings           :gte:    | {fieldName} is greater than or equal to  {value} | numeric           :gt:     | {fieldName} is greater than {value}              | numeric           :lte:    | {fieldName} is less than or equal to {value}     | numeric           :lt:     | {fieldName}  is less than {value}                | numeric           :range:  | {fieldName} is between `{comma separated [min<max] values}`. **OR** operation is applied for the specified ranges | numeric or strings. If the field's type is date, then min & max should be timestamps in millisecond or a Date expression          :within: | {GeofieldName}` is within the `{given WKT string or the given BBOX }` | a WKT string or the BBOX string : `\"west, south, east, north\"`           :notwithin:| {GeofieldName} is not within the `{given WKT string or the given BBOX }` | a WKT string or the BBOX string : `\"west, south, east, north\"`           :intersects:| {GeofieldName} intersects the `{given WKT string or the given BBOX }` | a WKT string or the BBOX string : `\"west, south, east, north\"`           :notintersects:| {GeofieldName} does not intersect the `{given WKT string or the given }` | a WKT string or the BBOX string : `\"west, south, east, north\"` 
        :param list[str] q: A full text search. Optionally, it's possible to search on a field using this syntax: {fieldname}:{text}
        :param str dateformat: The format of dates. This parameter should be set only if a date field is queried in `f` param; when using `gt`, `lt`, `gte`, `lte` and `range` operations
        :param bool pretty: Pretty print
        :param int max_age_cache: max-age-cache
        :return: Hits
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.count_with_http_info(collection, **kwargs)
        else:
            (data) = self.count_with_http_info(collection, **kwargs)
            return data

    def count_with_http_info(self, collection, **kwargs):
        """
        Count
        Count the number of elements found in the collection(s), given the filters
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.count_with_http_info(collection, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str collection: collections (required)
        :param list[str] f: - A triplet for filtering the result. Multiple filter can be provided in distinct parameters (AND operator is applied) or in the same parameter separated by semi-colons (OR operator is applied). The order does not matter.    - A triplet is composed of a field name, a comparison operator and a value.      The possible values of the comparison operator are :           Operator |                   Description                    | value type          :eq:     | {fieldName} equals {comma separated values}. **OR** operation is applied for the specified values | numeric or strings           :ne:     | {fieldName} must not equal {comma separated values }. **AND** operation is applied for the specified values | numeric or strings           :like:   | {fieldName}  is like {value}                     | numeric or strings           :gte:    | {fieldName} is greater than or equal to  {value} | numeric           :gt:     | {fieldName} is greater than {value}              | numeric           :lte:    | {fieldName} is less than or equal to {value}     | numeric           :lt:     | {fieldName}  is less than {value}                | numeric           :range:  | {fieldName} is between `{comma separated [min<max] values}`. **OR** operation is applied for the specified ranges | numeric or strings. If the field's type is date, then min & max should be timestamps in millisecond or a Date expression          :within: | {GeofieldName}` is within the `{given WKT string or the given BBOX }` | a WKT string or the BBOX string : `\"west, south, east, north\"`           :notwithin:| {GeofieldName} is not within the `{given WKT string or the given BBOX }` | a WKT string or the BBOX string : `\"west, south, east, north\"`           :intersects:| {GeofieldName} intersects the `{given WKT string or the given BBOX }` | a WKT string or the BBOX string : `\"west, south, east, north\"`           :notintersects:| {GeofieldName} does not intersect the `{given WKT string or the given }` | a WKT string or the BBOX string : `\"west, south, east, north\"` 
        :param list[str] q: A full text search. Optionally, it's possible to search on a field using this syntax: {fieldname}:{text}
        :param str dateformat: The format of dates. This parameter should be set only if a date field is queried in `f` param; when using `gt`, `lt`, `gte`, `lte` and `range` operations
        :param bool pretty: Pretty print
        :param int max_age_cache: max-age-cache
        :return: Hits
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['collection', 'f', 'q', 'dateformat', 'pretty', 'max_age_cache']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method count" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'collection' is set
        if ('collection' not in params) or (params['collection'] is None):
            raise ValueError("Missing the required parameter `collection` when calling `count`")


        collection_formats = {}

        path_params = {}
        if 'collection' in params:
            path_params['collection'] = params['collection']

        query_params = []
        if 'f' in params:
            query_params.append(('f', params['f']))
            collection_formats['f'] = 'multi'
        if 'q' in params:
            query_params.append(('q', params['q']))
            collection_formats['q'] = 'multi'
        if 'dateformat' in params:
            query_params.append(('dateformat', params['dateformat']))
        if 'pretty' in params:
            query_params.append(('pretty', params['pretty']))
        if 'max_age_cache' in params:
            query_params.append(('max-age-cache', params['max_age_cache']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json;charset=utf-8'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/explore/{collection}/_count', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Hits',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def count_post(self, collection, **kwargs):
        """
        Count
        Count the number of elements found in the collection(s), given the filters
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.count_post(collection, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str collection: collections (required)
        :param bool pretty: Pretty print
        :param Count body:
        :return: Hits
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.count_post_with_http_info(collection, **kwargs)
        else:
            (data) = self.count_post_with_http_info(collection, **kwargs)
            return data

    def count_post_with_http_info(self, collection, **kwargs):
        """
        Count
        Count the number of elements found in the collection(s), given the filters
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.count_post_with_http_info(collection, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str collection: collections (required)
        :param bool pretty: Pretty print
        :param Count body:
        :return: Hits
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['collection', 'pretty', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method count_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'collection' is set
        if ('collection' not in params) or (params['collection'] is None):
            raise ValueError("Missing the required parameter `collection` when calling `count_post`")


        collection_formats = {}

        path_params = {}
        if 'collection' in params:
            path_params['collection'] = params['collection']

        query_params = []
        if 'pretty' in params:
            query_params.append(('pretty', params['pretty']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json;charset=utf-8'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/explore/{collection}/_count', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Hits',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def describe(self, collection, **kwargs):
        """
        Describe
        Describe the structure and the content of the given collection. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.describe(collection, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str collection: collection (required)
        :param bool pretty: Pretty print
        :param int max_age_cache: max-age-cache
        :return: CollectionReferenceDescription
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.describe_with_http_info(collection, **kwargs)
        else:
            (data) = self.describe_with_http_info(collection, **kwargs)
            return data

    def describe_with_http_info(self, collection, **kwargs):
        """
        Describe
        Describe the structure and the content of the given collection. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.describe_with_http_info(collection, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str collection: collection (required)
        :param bool pretty: Pretty print
        :param int max_age_cache: max-age-cache
        :return: CollectionReferenceDescription
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['collection', 'pretty', 'max_age_cache']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method describe" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'collection' is set
        if ('collection' not in params) or (params['collection'] is None):
            raise ValueError("Missing the required parameter `collection` when calling `describe`")


        collection_formats = {}

        path_params = {}
        if 'collection' in params:
            path_params['collection'] = params['collection']

        query_params = []
        if 'pretty' in params:
            query_params.append(('pretty', params['pretty']))
        if 'max_age_cache' in params:
            query_params.append(('max-age-cache', params['max_age_cache']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json;charset=utf-8'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/explore/{collection}/_describe', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CollectionReferenceDescription',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def geoaggregate(self, collection, agg, **kwargs):
        """
        GeoAggregate
        Aggregate the elements in the collection(s) as features, given the filters and the aggregation parameters.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.geoaggregate(collection, agg, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str collection: collection (required)
        :param list[str] agg: - The agg parameter should be given in the following formats:            {type}:{field}:interval-{interval}:format-{format}:collect_field-{collect_field}:collect_fct-{function}:order-{order}:on-{on}:size-{size}:raw_geometries-{raw_geometries values}:aggregated_geometries-{aggregated_geometries values}:fetch_hits-{fetch_hits values}   Where :      - **{type}:{field}** part is mandatory.       - **interval** must be specified only when aggregation type is datehistogram, histogram and geohash.      - **format** is optional for datehistogram, and must not be specified for the other types.      - (**collect_field**,**collect_fct**) couple is optional for all aggregation types.      - (**order**,**on**) couple is optional for all aggregation types.      - **size** is optional for term and geohash, and must not be specified for the other types.      - **include** is optional for term, and must not be specified for the other types.   - {type} possible values are :           geohash, datehistogram, histogram and term. geohash must be the main aggregation.   - {interval} possible values depends on {type}.           If {type} = datehistogram, then {interval} = {size}(year,quarter,month,week,day,hour,minute,second). Size value must be equal to 1 for year,quarter,month and week unities.           If {type} = histogram, then {interval} = {size}.           If {type} = geohash, then {interval} = {size}. It's an integer between 1 and 12. Lower the length, greater is the surface of aggregation.           If {type} = term, then interval-{interval} is not needed.    - format-{format} is the date format for key aggregation. The default value is yyyy-MM-dd-hh:mm:ss.   - {collect_fct} is the aggregation function to apply to collections on the specified {collect_field}.      {collect_fct} possible values are :           avg,cardinality,max,min,sum,geobbox,geocentroid   - (collect_field,collect_fct) should both be specified, except when collect_fct = `geobbox` or `geocentroid`, it could be specified alone. The metrics `geobbox` and `geocentroid` are returned as features collections.   - {order} is set to sort the aggregation buckets on the field name, on the count of the buckets or on the the result of a metric sub-aggregation. Its values are 'asc' or 'desc'.    - {on} is set to specify whether the {order} is on the field name, on the count of the aggregation or on the result of a metric sub-aggregation. Its values are 'field', 'count' or 'result'.    - When {on} = `result`, then (collect_field,collect_fct) should be specified. Except when {collect_fct} = `geobbox` or `geocentroid`, then {on}=`result` is prohibited   - {size} Defines how many buckets should be returned.    - {include} Specifies the values for which buckets will be created. This values are comma separated. If one value is specified then regular expressions can be used (only in this case) and buckets matching them will be created. If more than one value are specified then only buckets matching the exact values will be created.   - **aggregated_geometries**       > **What it does**: Allows to specify a list of aggregated forms of geometries that represent the bucket.       > __**Syntax**__: `aggregated_geometries-{COMMA_SEPARATED_AGGREGATED_GEOMETRIES}`.       > __**Available aggregated geometries**__: `centroid, bbox, geohash, geohash_center`.          - **centroid**: returns the centroid of data inside the bucket.          - **bbox**: returns the data extent (bbox) in each bucket.          - **geohash**: returns the 'geohash' extent of each bucket. This form is supported for **geohash** aggregation type only.          - **geohash_center**: returns the geohash center of each bucket. This form is supported for **geohash** aggregation type only.       > __**Response**__: Each bucket of the aggregation will be represented with as many features (in a feature collection) as there are specified aggregated geometries. The properties of each feature has :          - **geometry_ref** attribute that informs which aggregated form is returned           - **geometry_type** attribute set to *aggregated*       > __**Example**__: `aggregated_geometries-bbox,geohash`   - **raw_geometries**       > **What it does**: Allows to specify a list of raw geometries provided by hits that represent the bucket and thata are elected by a sort       > __**Syntax**__: `raw_geometries-{GEOMETRY_FIELD}({COMMA_SEPERATED_SORT_FIELDS});{GEOMETRY_FIELD2}({COMMA_SEPERATED_SORT_FIELDS2})`.       > __**Available raw geometries**__: any field of the collection whose type is **geo-point** or **geo-shape**.          - sort fields are optional. If no sort is specified, an ascending sort on `collection.params.timestamp_path` is applied          - a sort field can be preceded by '-' for descending sort. Otherwise the sort is ascending       > __**Response**__: each bucket of the aggregation will be represented with as many features (in a feature collection) as there are specified raw geometries. The properties of each feature has :          - **geometry_ref** attribute that informs which geometry path is returned           - **geometry_type** attribute set to *raw*          - **geometry_sort** attribute that informs how the geometry path is fetched (with what sort)       > __**Example**__: `raw_geometries-geo_field1,geo_field2  ||  raw_geometries-geo_field(-field1,field2)` || raw_geometries-geo_field1(field1);geo_field2(field2,field3)   - **fetch_hits**        > **What it does**: Specifies the number of hits to retrieve inside each aggregation bucket and which fields to include in the hits.       > __**Syntax**__: `fetch_hits-{sizeOfHitsToFetch}(+{field1}, {field2}, -{field3}, ...)`.       > **Note 1**: `{sizeOfHitsToFetch}` is optional, if not specified, 1 is considered as default.       > **Note 2**: `{field}` can be preceded by **+** or **-** for **ascending** or **descending** sort of the hits. Order matters.       > __**Example**__: `fetch_hits-3(-timestamp, geometry)`. Fetches the 3 last positions for each bucket.   **agg** parameter is multiple. The first (main) aggregation must be geohash. Every agg parameter specified is a subaggregation of the previous one : order matters.    For more details, check https://github.com/gisaia/ARLAS-server/blob/master/docs/arlas-api-exploration.md  (required)
        :param list[str] f: - A triplet for filtering the result. Multiple filter can be provided in distinct parameters (AND operator is applied) or in the same parameter separated by semi-colons (OR operator is applied). The order does not matter.    - A triplet is composed of a field name, a comparison operator and a value.      The possible values of the comparison operator are :           Operator |                   Description                    | value type          :eq:     | {fieldName} equals {comma separated values}. **OR** operation is applied for the specified values | numeric or strings           :ne:     | {fieldName} must not equal {comma separated values }. **AND** operation is applied for the specified values | numeric or strings           :like:   | {fieldName}  is like {value}                     | numeric or strings           :gte:    | {fieldName} is greater than or equal to  {value} | numeric           :gt:     | {fieldName} is greater than {value}              | numeric           :lte:    | {fieldName} is less than or equal to {value}     | numeric           :lt:     | {fieldName}  is less than {value}                | numeric           :range:  | {fieldName} is between `{comma separated [min<max] values}`. **OR** operation is applied for the specified ranges | numeric or strings. If the field's type is date, then min & max should be timestamps in millisecond or a Date expression          :within: | {GeofieldName}` is within the `{given WKT string or the given BBOX }` | a WKT string or the BBOX string : `\"west, south, east, north\"`           :notwithin:| {GeofieldName} is not within the `{given WKT string or the given BBOX }` | a WKT string or the BBOX string : `\"west, south, east, north\"`           :intersects:| {GeofieldName} intersects the `{given WKT string or the given BBOX }` | a WKT string or the BBOX string : `\"west, south, east, north\"`           :notintersects:| {GeofieldName} does not intersect the `{given WKT string or the given }` | a WKT string or the BBOX string : `\"west, south, east, north\"` 
        :param list[str] q: A full text search. Optionally, it's possible to search on a field using this syntax: {fieldname}:{text}
        :param str dateformat: The format of dates. This parameter should be set only if a date field is queried in `f` param; when using `gt`, `lt`, `gte`, `lte` and `range` operations
        :param bool pretty: Pretty print
        :param bool flat: Flats the property map: only key/value on one level
        :param int max_age_cache: max-age-cache
        :return: FeatureCollection
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.geoaggregate_with_http_info(collection, agg, **kwargs)
        else:
            (data) = self.geoaggregate_with_http_info(collection, agg, **kwargs)
            return data

    def geoaggregate_with_http_info(self, collection, agg, **kwargs):
        """
        GeoAggregate
        Aggregate the elements in the collection(s) as features, given the filters and the aggregation parameters.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.geoaggregate_with_http_info(collection, agg, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str collection: collection (required)
        :param list[str] agg: - The agg parameter should be given in the following formats:            {type}:{field}:interval-{interval}:format-{format}:collect_field-{collect_field}:collect_fct-{function}:order-{order}:on-{on}:size-{size}:raw_geometries-{raw_geometries values}:aggregated_geometries-{aggregated_geometries values}:fetch_hits-{fetch_hits values}   Where :      - **{type}:{field}** part is mandatory.       - **interval** must be specified only when aggregation type is datehistogram, histogram and geohash.      - **format** is optional for datehistogram, and must not be specified for the other types.      - (**collect_field**,**collect_fct**) couple is optional for all aggregation types.      - (**order**,**on**) couple is optional for all aggregation types.      - **size** is optional for term and geohash, and must not be specified for the other types.      - **include** is optional for term, and must not be specified for the other types.   - {type} possible values are :           geohash, datehistogram, histogram and term. geohash must be the main aggregation.   - {interval} possible values depends on {type}.           If {type} = datehistogram, then {interval} = {size}(year,quarter,month,week,day,hour,minute,second). Size value must be equal to 1 for year,quarter,month and week unities.           If {type} = histogram, then {interval} = {size}.           If {type} = geohash, then {interval} = {size}. It's an integer between 1 and 12. Lower the length, greater is the surface of aggregation.           If {type} = term, then interval-{interval} is not needed.    - format-{format} is the date format for key aggregation. The default value is yyyy-MM-dd-hh:mm:ss.   - {collect_fct} is the aggregation function to apply to collections on the specified {collect_field}.      {collect_fct} possible values are :           avg,cardinality,max,min,sum,geobbox,geocentroid   - (collect_field,collect_fct) should both be specified, except when collect_fct = `geobbox` or `geocentroid`, it could be specified alone. The metrics `geobbox` and `geocentroid` are returned as features collections.   - {order} is set to sort the aggregation buckets on the field name, on the count of the buckets or on the the result of a metric sub-aggregation. Its values are 'asc' or 'desc'.    - {on} is set to specify whether the {order} is on the field name, on the count of the aggregation or on the result of a metric sub-aggregation. Its values are 'field', 'count' or 'result'.    - When {on} = `result`, then (collect_field,collect_fct) should be specified. Except when {collect_fct} = `geobbox` or `geocentroid`, then {on}=`result` is prohibited   - {size} Defines how many buckets should be returned.    - {include} Specifies the values for which buckets will be created. This values are comma separated. If one value is specified then regular expressions can be used (only in this case) and buckets matching them will be created. If more than one value are specified then only buckets matching the exact values will be created.   - **aggregated_geometries**       > **What it does**: Allows to specify a list of aggregated forms of geometries that represent the bucket.       > __**Syntax**__: `aggregated_geometries-{COMMA_SEPARATED_AGGREGATED_GEOMETRIES}`.       > __**Available aggregated geometries**__: `centroid, bbox, geohash, geohash_center`.          - **centroid**: returns the centroid of data inside the bucket.          - **bbox**: returns the data extent (bbox) in each bucket.          - **geohash**: returns the 'geohash' extent of each bucket. This form is supported for **geohash** aggregation type only.          - **geohash_center**: returns the geohash center of each bucket. This form is supported for **geohash** aggregation type only.       > __**Response**__: Each bucket of the aggregation will be represented with as many features (in a feature collection) as there are specified aggregated geometries. The properties of each feature has :          - **geometry_ref** attribute that informs which aggregated form is returned           - **geometry_type** attribute set to *aggregated*       > __**Example**__: `aggregated_geometries-bbox,geohash`   - **raw_geometries**       > **What it does**: Allows to specify a list of raw geometries provided by hits that represent the bucket and thata are elected by a sort       > __**Syntax**__: `raw_geometries-{GEOMETRY_FIELD}({COMMA_SEPERATED_SORT_FIELDS});{GEOMETRY_FIELD2}({COMMA_SEPERATED_SORT_FIELDS2})`.       > __**Available raw geometries**__: any field of the collection whose type is **geo-point** or **geo-shape**.          - sort fields are optional. If no sort is specified, an ascending sort on `collection.params.timestamp_path` is applied          - a sort field can be preceded by '-' for descending sort. Otherwise the sort is ascending       > __**Response**__: each bucket of the aggregation will be represented with as many features (in a feature collection) as there are specified raw geometries. The properties of each feature has :          - **geometry_ref** attribute that informs which geometry path is returned           - **geometry_type** attribute set to *raw*          - **geometry_sort** attribute that informs how the geometry path is fetched (with what sort)       > __**Example**__: `raw_geometries-geo_field1,geo_field2  ||  raw_geometries-geo_field(-field1,field2)` || raw_geometries-geo_field1(field1);geo_field2(field2,field3)   - **fetch_hits**        > **What it does**: Specifies the number of hits to retrieve inside each aggregation bucket and which fields to include in the hits.       > __**Syntax**__: `fetch_hits-{sizeOfHitsToFetch}(+{field1}, {field2}, -{field3}, ...)`.       > **Note 1**: `{sizeOfHitsToFetch}` is optional, if not specified, 1 is considered as default.       > **Note 2**: `{field}` can be preceded by **+** or **-** for **ascending** or **descending** sort of the hits. Order matters.       > __**Example**__: `fetch_hits-3(-timestamp, geometry)`. Fetches the 3 last positions for each bucket.   **agg** parameter is multiple. The first (main) aggregation must be geohash. Every agg parameter specified is a subaggregation of the previous one : order matters.    For more details, check https://github.com/gisaia/ARLAS-server/blob/master/docs/arlas-api-exploration.md  (required)
        :param list[str] f: - A triplet for filtering the result. Multiple filter can be provided in distinct parameters (AND operator is applied) or in the same parameter separated by semi-colons (OR operator is applied). The order does not matter.    - A triplet is composed of a field name, a comparison operator and a value.      The possible values of the comparison operator are :           Operator |                   Description                    | value type          :eq:     | {fieldName} equals {comma separated values}. **OR** operation is applied for the specified values | numeric or strings           :ne:     | {fieldName} must not equal {comma separated values }. **AND** operation is applied for the specified values | numeric or strings           :like:   | {fieldName}  is like {value}                     | numeric or strings           :gte:    | {fieldName} is greater than or equal to  {value} | numeric           :gt:     | {fieldName} is greater than {value}              | numeric           :lte:    | {fieldName} is less than or equal to {value}     | numeric           :lt:     | {fieldName}  is less than {value}                | numeric           :range:  | {fieldName} is between `{comma separated [min<max] values}`. **OR** operation is applied for the specified ranges | numeric or strings. If the field's type is date, then min & max should be timestamps in millisecond or a Date expression          :within: | {GeofieldName}` is within the `{given WKT string or the given BBOX }` | a WKT string or the BBOX string : `\"west, south, east, north\"`           :notwithin:| {GeofieldName} is not within the `{given WKT string or the given BBOX }` | a WKT string or the BBOX string : `\"west, south, east, north\"`           :intersects:| {GeofieldName} intersects the `{given WKT string or the given BBOX }` | a WKT string or the BBOX string : `\"west, south, east, north\"`           :notintersects:| {GeofieldName} does not intersect the `{given WKT string or the given }` | a WKT string or the BBOX string : `\"west, south, east, north\"` 
        :param list[str] q: A full text search. Optionally, it's possible to search on a field using this syntax: {fieldname}:{text}
        :param str dateformat: The format of dates. This parameter should be set only if a date field is queried in `f` param; when using `gt`, `lt`, `gte`, `lte` and `range` operations
        :param bool pretty: Pretty print
        :param bool flat: Flats the property map: only key/value on one level
        :param int max_age_cache: max-age-cache
        :return: FeatureCollection
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['collection', 'agg', 'f', 'q', 'dateformat', 'pretty', 'flat', 'max_age_cache']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method geoaggregate" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'collection' is set
        if ('collection' not in params) or (params['collection'] is None):
            raise ValueError("Missing the required parameter `collection` when calling `geoaggregate`")
        # verify the required parameter 'agg' is set
        if ('agg' not in params) or (params['agg'] is None):
            raise ValueError("Missing the required parameter `agg` when calling `geoaggregate`")


        collection_formats = {}

        path_params = {}
        if 'collection' in params:
            path_params['collection'] = params['collection']

        query_params = []
        if 'agg' in params:
            query_params.append(('agg', params['agg']))
            collection_formats['agg'] = 'multi'
        if 'f' in params:
            query_params.append(('f', params['f']))
            collection_formats['f'] = 'multi'
        if 'q' in params:
            query_params.append(('q', params['q']))
            collection_formats['q'] = 'multi'
        if 'dateformat' in params:
            query_params.append(('dateformat', params['dateformat']))
        if 'pretty' in params:
            query_params.append(('pretty', params['pretty']))
        if 'flat' in params:
            query_params.append(('flat', params['flat']))
        if 'max_age_cache' in params:
            query_params.append(('max-age-cache', params['max_age_cache']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json;charset=utf-8'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/explore/{collection}/_geoaggregate', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='FeatureCollection',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def geoaggregate_post(self, collection, **kwargs):
        """
        GeoAggregate
        Aggregate the elements in the collection(s) as features, given the filters and the aggregation parameters.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.geoaggregate_post(collection, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str collection: collection (required)
        :param AggregationsRequest body:
        :param bool pretty: Pretty print
        :param int max_age_cache: max-age-cache
        :return: FeatureCollection
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.geoaggregate_post_with_http_info(collection, **kwargs)
        else:
            (data) = self.geoaggregate_post_with_http_info(collection, **kwargs)
            return data

    def geoaggregate_post_with_http_info(self, collection, **kwargs):
        """
        GeoAggregate
        Aggregate the elements in the collection(s) as features, given the filters and the aggregation parameters.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.geoaggregate_post_with_http_info(collection, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str collection: collection (required)
        :param AggregationsRequest body:
        :param bool pretty: Pretty print
        :param int max_age_cache: max-age-cache
        :return: FeatureCollection
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['collection', 'body', 'pretty', 'max_age_cache']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method geoaggregate_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'collection' is set
        if ('collection' not in params) or (params['collection'] is None):
            raise ValueError("Missing the required parameter `collection` when calling `geoaggregate_post`")


        collection_formats = {}

        path_params = {}
        if 'collection' in params:
            path_params['collection'] = params['collection']

        query_params = []
        if 'pretty' in params:
            query_params.append(('pretty', params['pretty']))
        if 'max_age_cache' in params:
            query_params.append(('max-age-cache', params['max_age_cache']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json;charset=utf-8'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/explore/{collection}/_geoaggregate', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='FeatureCollection',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def geohashgeoaggregate(self, collection, geohash, **kwargs):
        """
        GeoAggregate on a geohash
        Aggregate the elements in the collection(s) and localized in the given geohash as features, given the filters and the aggregation parameters.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.geohashgeoaggregate(collection, geohash, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str collection: collection (required)
        :param str geohash: geohash (required)
        :param list[str] agg: - The agg parameter should be given in the following formats:            {type}:{field}:interval-{interval}:format-{format}:collect_field-{collect_field}:collect_fct-{function}:order-{order}:on-{on}:size-{size}:raw_geometries-{raw_geometries values}:aggregated_geometries-{aggregated_geometries values}:fetch_hits-{fetch_hits values}   Where :      - **{type}:{field}** part is mandatory.       - **interval** must be specified only when aggregation type is datehistogram, histogram and geohash.      - **format** is optional for datehistogram, and must not be specified for the other types.      - (**collect_field**,**collect_fct**) couple is optional for all aggregation types.      - (**order**,**on**) couple is optional for all aggregation types.      - **size** is optional for term and geohash, and must not be specified for the other types.      - **include** is optional for term, and must not be specified for the other types.   - {type} possible values are :           geohash, datehistogram, histogram and term. geohash must be the main aggregation.   - {interval} possible values depends on {type}.           If {type} = datehistogram, then {interval} = {size}(year,quarter,month,week,day,hour,minute,second). Size value must be equal to 1 for year,quarter,month and week unities.           If {type} = histogram, then {interval} = {size}.           If {type} = geohash, then {interval} = {size}. It's an integer between 1 and 12. Lower the length, greater is the surface of aggregation.           If {type} = term, then interval-{interval} is not needed.    - format-{format} is the date format for key aggregation. The default value is yyyy-MM-dd-hh:mm:ss.   - {collect_fct} is the aggregation function to apply to collections on the specified {collect_field}.      {collect_fct} possible values are :           avg,cardinality,max,min,sum,geobbox,geocentroid   - (collect_field,collect_fct) should both be specified, except when collect_fct = `geobbox` or `geocentroid`, it could be specified alone. The metrics `geobbox` and `geocentroid` are returned as features collections.   - {order} is set to sort the aggregation buckets on the field name, on the count of the buckets or on the the result of a metric sub-aggregation. Its values are 'asc' or 'desc'.    - {on} is set to specify whether the {order} is on the field name, on the count of the aggregation or on the result of a metric sub-aggregation. Its values are 'field', 'count' or 'result'.    - When {on} = `result`, then (collect_field,collect_fct) should be specified. Except when {collect_fct} = `geobbox` or `geocentroid`, then {on}=`result` is prohibited   - {size} Defines how many buckets should be returned.    - {include} Specifies the values for which buckets will be created. This values are comma separated. If one value is specified then regular expressions can be used (only in this case) and buckets matching them will be created. If more than one value are specified then only buckets matching the exact values will be created.   - **aggregated_geometries**       > **What it does**: Allows to specify a list of aggregated forms of geometries that represent the bucket.       > __**Syntax**__: `aggregated_geometries-{COMMA_SEPARATED_AGGREGATED_GEOMETRIES}`.       > __**Available aggregated geometries**__: `centroid, bbox, geohash, geohash_center`.          - **centroid**: returns the centroid of data inside the bucket.          - **bbox**: returns the data extent (bbox) in each bucket.          - **geohash**: returns the 'geohash' extent of each bucket. This form is supported for **geohash** aggregation type only.          - **geohash_center**: returns the geohash center of each bucket. This form is supported for **geohash** aggregation type only.       > __**Response**__: Each bucket of the aggregation will be represented with as many features (in a feature collection) as there are specified aggregated geometries. The properties of each feature has :          - **geometry_ref** attribute that informs which aggregated form is returned           - **geometry_type** attribute set to *aggregated*       > __**Example**__: `aggregated_geometries-bbox,geohash`   - **raw_geometries**       > **What it does**: Allows to specify a list of raw geometries provided by hits that represent the bucket and thata are elected by a sort       > __**Syntax**__: `raw_geometries-{GEOMETRY_FIELD}({COMMA_SEPERATED_SORT_FIELDS});{GEOMETRY_FIELD2}({COMMA_SEPERATED_SORT_FIELDS2})`.       > __**Available raw geometries**__: any field of the collection whose type is **geo-point** or **geo-shape**.          - sort fields are optional. If no sort is specified, an ascending sort on `collection.params.timestamp_path` is applied          - a sort field can be preceded by '-' for descending sort. Otherwise the sort is ascending       > __**Response**__: each bucket of the aggregation will be represented with as many features (in a feature collection) as there are specified raw geometries. The properties of each feature has :          - **geometry_ref** attribute that informs which geometry path is returned           - **geometry_type** attribute set to *raw*          - **geometry_sort** attribute that informs how the geometry path is fetched (with what sort)       > __**Example**__: `raw_geometries-geo_field1,geo_field2  ||  raw_geometries-geo_field(-field1,field2)` || raw_geometries-geo_field1(field1);geo_field2(field2,field3)   - **fetch_hits**        > **What it does**: Specifies the number of hits to retrieve inside each aggregation bucket and which fields to include in the hits.       > __**Syntax**__: `fetch_hits-{sizeOfHitsToFetch}(+{field1}, {field2}, -{field3}, ...)`.       > **Note 1**: `{sizeOfHitsToFetch}` is optional, if not specified, 1 is considered as default.       > **Note 2**: `{field}` can be preceded by **+** or **-** for **ascending** or **descending** sort of the hits. Order matters.       > __**Example**__: `fetch_hits-3(-timestamp, geometry)`. Fetches the 3 last positions for each bucket.   **agg** parameter is multiple. The first (main) aggregation must be geohash. Every agg parameter specified is a subaggregation of the previous one : order matters.    For more details, check https://github.com/gisaia/ARLAS-server/blob/master/docs/arlas-api-exploration.md 
        :param list[str] f: - A triplet for filtering the result. Multiple filter can be provided in distinct parameters (AND operator is applied) or in the same parameter separated by semi-colons (OR operator is applied). The order does not matter.    - A triplet is composed of a field name, a comparison operator and a value.      The possible values of the comparison operator are :           Operator |                   Description                    | value type          :eq:     | {fieldName} equals {comma separated values}. **OR** operation is applied for the specified values | numeric or strings           :ne:     | {fieldName} must not equal {comma separated values }. **AND** operation is applied for the specified values | numeric or strings           :like:   | {fieldName}  is like {value}                     | numeric or strings           :gte:    | {fieldName} is greater than or equal to  {value} | numeric           :gt:     | {fieldName} is greater than {value}              | numeric           :lte:    | {fieldName} is less than or equal to {value}     | numeric           :lt:     | {fieldName}  is less than {value}                | numeric           :range:  | {fieldName} is between `{comma separated [min<max] values}`. **OR** operation is applied for the specified ranges | numeric or strings. If the field's type is date, then min & max should be timestamps in millisecond or a Date expression          :within: | {GeofieldName}` is within the `{given WKT string or the given BBOX }` | a WKT string or the BBOX string : `\"west, south, east, north\"`           :notwithin:| {GeofieldName} is not within the `{given WKT string or the given BBOX }` | a WKT string or the BBOX string : `\"west, south, east, north\"`           :intersects:| {GeofieldName} intersects the `{given WKT string or the given BBOX }` | a WKT string or the BBOX string : `\"west, south, east, north\"`           :notintersects:| {GeofieldName} does not intersect the `{given WKT string or the given }` | a WKT string or the BBOX string : `\"west, south, east, north\"` 
        :param list[str] q: A full text search. Optionally, it's possible to search on a field using this syntax: {fieldname}:{text}
        :param str dateformat: The format of dates. This parameter should be set only if a date field is queried in `f` param; when using `gt`, `lt`, `gte`, `lte` and `range` operations
        :param bool pretty: Pretty print
        :param bool flat: Flats the property map: only key/value on one level
        :param int max_age_cache: max-age-cache
        :return: FeatureCollection
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.geohashgeoaggregate_with_http_info(collection, geohash, **kwargs)
        else:
            (data) = self.geohashgeoaggregate_with_http_info(collection, geohash, **kwargs)
            return data

    def geohashgeoaggregate_with_http_info(self, collection, geohash, **kwargs):
        """
        GeoAggregate on a geohash
        Aggregate the elements in the collection(s) and localized in the given geohash as features, given the filters and the aggregation parameters.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.geohashgeoaggregate_with_http_info(collection, geohash, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str collection: collection (required)
        :param str geohash: geohash (required)
        :param list[str] agg: - The agg parameter should be given in the following formats:            {type}:{field}:interval-{interval}:format-{format}:collect_field-{collect_field}:collect_fct-{function}:order-{order}:on-{on}:size-{size}:raw_geometries-{raw_geometries values}:aggregated_geometries-{aggregated_geometries values}:fetch_hits-{fetch_hits values}   Where :      - **{type}:{field}** part is mandatory.       - **interval** must be specified only when aggregation type is datehistogram, histogram and geohash.      - **format** is optional for datehistogram, and must not be specified for the other types.      - (**collect_field**,**collect_fct**) couple is optional for all aggregation types.      - (**order**,**on**) couple is optional for all aggregation types.      - **size** is optional for term and geohash, and must not be specified for the other types.      - **include** is optional for term, and must not be specified for the other types.   - {type} possible values are :           geohash, datehistogram, histogram and term. geohash must be the main aggregation.   - {interval} possible values depends on {type}.           If {type} = datehistogram, then {interval} = {size}(year,quarter,month,week,day,hour,minute,second). Size value must be equal to 1 for year,quarter,month and week unities.           If {type} = histogram, then {interval} = {size}.           If {type} = geohash, then {interval} = {size}. It's an integer between 1 and 12. Lower the length, greater is the surface of aggregation.           If {type} = term, then interval-{interval} is not needed.    - format-{format} is the date format for key aggregation. The default value is yyyy-MM-dd-hh:mm:ss.   - {collect_fct} is the aggregation function to apply to collections on the specified {collect_field}.      {collect_fct} possible values are :           avg,cardinality,max,min,sum,geobbox,geocentroid   - (collect_field,collect_fct) should both be specified, except when collect_fct = `geobbox` or `geocentroid`, it could be specified alone. The metrics `geobbox` and `geocentroid` are returned as features collections.   - {order} is set to sort the aggregation buckets on the field name, on the count of the buckets or on the the result of a metric sub-aggregation. Its values are 'asc' or 'desc'.    - {on} is set to specify whether the {order} is on the field name, on the count of the aggregation or on the result of a metric sub-aggregation. Its values are 'field', 'count' or 'result'.    - When {on} = `result`, then (collect_field,collect_fct) should be specified. Except when {collect_fct} = `geobbox` or `geocentroid`, then {on}=`result` is prohibited   - {size} Defines how many buckets should be returned.    - {include} Specifies the values for which buckets will be created. This values are comma separated. If one value is specified then regular expressions can be used (only in this case) and buckets matching them will be created. If more than one value are specified then only buckets matching the exact values will be created.   - **aggregated_geometries**       > **What it does**: Allows to specify a list of aggregated forms of geometries that represent the bucket.       > __**Syntax**__: `aggregated_geometries-{COMMA_SEPARATED_AGGREGATED_GEOMETRIES}`.       > __**Available aggregated geometries**__: `centroid, bbox, geohash, geohash_center`.          - **centroid**: returns the centroid of data inside the bucket.          - **bbox**: returns the data extent (bbox) in each bucket.          - **geohash**: returns the 'geohash' extent of each bucket. This form is supported for **geohash** aggregation type only.          - **geohash_center**: returns the geohash center of each bucket. This form is supported for **geohash** aggregation type only.       > __**Response**__: Each bucket of the aggregation will be represented with as many features (in a feature collection) as there are specified aggregated geometries. The properties of each feature has :          - **geometry_ref** attribute that informs which aggregated form is returned           - **geometry_type** attribute set to *aggregated*       > __**Example**__: `aggregated_geometries-bbox,geohash`   - **raw_geometries**       > **What it does**: Allows to specify a list of raw geometries provided by hits that represent the bucket and thata are elected by a sort       > __**Syntax**__: `raw_geometries-{GEOMETRY_FIELD}({COMMA_SEPERATED_SORT_FIELDS});{GEOMETRY_FIELD2}({COMMA_SEPERATED_SORT_FIELDS2})`.       > __**Available raw geometries**__: any field of the collection whose type is **geo-point** or **geo-shape**.          - sort fields are optional. If no sort is specified, an ascending sort on `collection.params.timestamp_path` is applied          - a sort field can be preceded by '-' for descending sort. Otherwise the sort is ascending       > __**Response**__: each bucket of the aggregation will be represented with as many features (in a feature collection) as there are specified raw geometries. The properties of each feature has :          - **geometry_ref** attribute that informs which geometry path is returned           - **geometry_type** attribute set to *raw*          - **geometry_sort** attribute that informs how the geometry path is fetched (with what sort)       > __**Example**__: `raw_geometries-geo_field1,geo_field2  ||  raw_geometries-geo_field(-field1,field2)` || raw_geometries-geo_field1(field1);geo_field2(field2,field3)   - **fetch_hits**        > **What it does**: Specifies the number of hits to retrieve inside each aggregation bucket and which fields to include in the hits.       > __**Syntax**__: `fetch_hits-{sizeOfHitsToFetch}(+{field1}, {field2}, -{field3}, ...)`.       > **Note 1**: `{sizeOfHitsToFetch}` is optional, if not specified, 1 is considered as default.       > **Note 2**: `{field}` can be preceded by **+** or **-** for **ascending** or **descending** sort of the hits. Order matters.       > __**Example**__: `fetch_hits-3(-timestamp, geometry)`. Fetches the 3 last positions for each bucket.   **agg** parameter is multiple. The first (main) aggregation must be geohash. Every agg parameter specified is a subaggregation of the previous one : order matters.    For more details, check https://github.com/gisaia/ARLAS-server/blob/master/docs/arlas-api-exploration.md 
        :param list[str] f: - A triplet for filtering the result. Multiple filter can be provided in distinct parameters (AND operator is applied) or in the same parameter separated by semi-colons (OR operator is applied). The order does not matter.    - A triplet is composed of a field name, a comparison operator and a value.      The possible values of the comparison operator are :           Operator |                   Description                    | value type          :eq:     | {fieldName} equals {comma separated values}. **OR** operation is applied for the specified values | numeric or strings           :ne:     | {fieldName} must not equal {comma separated values }. **AND** operation is applied for the specified values | numeric or strings           :like:   | {fieldName}  is like {value}                     | numeric or strings           :gte:    | {fieldName} is greater than or equal to  {value} | numeric           :gt:     | {fieldName} is greater than {value}              | numeric           :lte:    | {fieldName} is less than or equal to {value}     | numeric           :lt:     | {fieldName}  is less than {value}                | numeric           :range:  | {fieldName} is between `{comma separated [min<max] values}`. **OR** operation is applied for the specified ranges | numeric or strings. If the field's type is date, then min & max should be timestamps in millisecond or a Date expression          :within: | {GeofieldName}` is within the `{given WKT string or the given BBOX }` | a WKT string or the BBOX string : `\"west, south, east, north\"`           :notwithin:| {GeofieldName} is not within the `{given WKT string or the given BBOX }` | a WKT string or the BBOX string : `\"west, south, east, north\"`           :intersects:| {GeofieldName} intersects the `{given WKT string or the given BBOX }` | a WKT string or the BBOX string : `\"west, south, east, north\"`           :notintersects:| {GeofieldName} does not intersect the `{given WKT string or the given }` | a WKT string or the BBOX string : `\"west, south, east, north\"` 
        :param list[str] q: A full text search. Optionally, it's possible to search on a field using this syntax: {fieldname}:{text}
        :param str dateformat: The format of dates. This parameter should be set only if a date field is queried in `f` param; when using `gt`, `lt`, `gte`, `lte` and `range` operations
        :param bool pretty: Pretty print
        :param bool flat: Flats the property map: only key/value on one level
        :param int max_age_cache: max-age-cache
        :return: FeatureCollection
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['collection', 'geohash', 'agg', 'f', 'q', 'dateformat', 'pretty', 'flat', 'max_age_cache']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method geohashgeoaggregate" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'collection' is set
        if ('collection' not in params) or (params['collection'] is None):
            raise ValueError("Missing the required parameter `collection` when calling `geohashgeoaggregate`")
        # verify the required parameter 'geohash' is set
        if ('geohash' not in params) or (params['geohash'] is None):
            raise ValueError("Missing the required parameter `geohash` when calling `geohashgeoaggregate`")


        collection_formats = {}

        path_params = {}
        if 'collection' in params:
            path_params['collection'] = params['collection']
        if 'geohash' in params:
            path_params['geohash'] = params['geohash']

        query_params = []
        if 'agg' in params:
            query_params.append(('agg', params['agg']))
            collection_formats['agg'] = 'multi'
        if 'f' in params:
            query_params.append(('f', params['f']))
            collection_formats['f'] = 'multi'
        if 'q' in params:
            query_params.append(('q', params['q']))
            collection_formats['q'] = 'multi'
        if 'dateformat' in params:
            query_params.append(('dateformat', params['dateformat']))
        if 'pretty' in params:
            query_params.append(('pretty', params['pretty']))
        if 'flat' in params:
            query_params.append(('flat', params['flat']))
        if 'max_age_cache' in params:
            query_params.append(('max-age-cache', params['max_age_cache']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json;charset=utf-8'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/explore/{collection}/_geoaggregate/{geohash}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='FeatureCollection',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def geosearch(self, collection, **kwargs):
        """
        GeoSearch
        Search and return the elements found in the collection(s) as features, given the filters
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.geosearch(collection, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str collection: collection (required)
        :param list[str] f: - A triplet for filtering the result. Multiple filter can be provided in distinct parameters (AND operator is applied) or in the same parameter separated by semi-colons (OR operator is applied). The order does not matter.    - A triplet is composed of a field name, a comparison operator and a value.      The possible values of the comparison operator are :           Operator |                   Description                    | value type          :eq:     | {fieldName} equals {comma separated values}. **OR** operation is applied for the specified values | numeric or strings           :ne:     | {fieldName} must not equal {comma separated values }. **AND** operation is applied for the specified values | numeric or strings           :like:   | {fieldName}  is like {value}                     | numeric or strings           :gte:    | {fieldName} is greater than or equal to  {value} | numeric           :gt:     | {fieldName} is greater than {value}              | numeric           :lte:    | {fieldName} is less than or equal to {value}     | numeric           :lt:     | {fieldName}  is less than {value}                | numeric           :range:  | {fieldName} is between `{comma separated [min<max] values}`. **OR** operation is applied for the specified ranges | numeric or strings. If the field's type is date, then min & max should be timestamps in millisecond or a Date expression          :within: | {GeofieldName}` is within the `{given WKT string or the given BBOX }` | a WKT string or the BBOX string : `\"west, south, east, north\"`           :notwithin:| {GeofieldName} is not within the `{given WKT string or the given BBOX }` | a WKT string or the BBOX string : `\"west, south, east, north\"`           :intersects:| {GeofieldName} intersects the `{given WKT string or the given BBOX }` | a WKT string or the BBOX string : `\"west, south, east, north\"`           :notintersects:| {GeofieldName} does not intersect the `{given WKT string or the given }` | a WKT string or the BBOX string : `\"west, south, east, north\"` 
        :param list[str] q: A full text search. Optionally, it's possible to search on a field using this syntax: {fieldname}:{text}
        :param str dateformat: The format of dates. This parameter should be set only if a date field is queried in `f` param; when using `gt`, `lt`, `gte`, `lte` and `range` operations
        :param bool pretty: Pretty print
        :param bool flat: Flats the property map: only key/value on one level
        :param list[str] include: List the name patterns of the field to be included in the result. Separate patterns with a comma.
        :param list[str] exclude: List the name patterns of the field to be excluded in the result. Separate patterns with a comma.
        :param str returned_geometries: Comma separated geometry field_paths to be included in the result. If not specified, only geometry_path is returned. If geometry_path is null, then centroid_path is returned
        :param int size: The maximum number of entries or sub-entries to be returned. The default value is 10
        :param int _from: From index to start the search from. Defaults to 0.
        :param list[str] sort: Sorts the resulted hits on the given fields and/or by distance to a given point:   > __**Syntax**__: `{field1},{field2},-{field3},geodistance:{lat} {lon},{field4}  ...`.   > **Note 1**: `{field}` can be preceded by **'-'**  for **descending** sort. By default, sort is ascending.   > **Note 2**: The order of fields matters.   > **Note 3** ***geodistance sort***: Sorts the hits centroids by distance to the given **{lat} {lon}** (ascending distance sort). It can be specified at most 1 time.   > __**Example 1**__: sort=`age,-timestamp`. Resulted hits are sorted by age. For same age hits, they are decreasingly sorted in time.   > __**Example 2**__: sort=`age,geodistance:89 179`. Resulted hits are sorted by age. For same age hits, they are sorted by closest distance to the point(89°,179°)   
        :param str after: List of values of fields present in sort param that are used to search after.    > **What it does**: Retrieve the data placed after the pointed element, given the provided order (sort).   > __**Restriction 1**__: **after** param works only combined with **sort** param.   > __**Syntax**__: `after={value1},{value2},...,{valueN} & sort={field1},{field2},...,{fieldN}`.   > **Note 1**: *{value1}` and `{value2}` are the values of `{field1}` and `{field2}` in the last hit returned in the previous search   > **Note 2**: The order of fields and values matters. *{value1},{value2}* must be in the same order of *{field1},{field2}* in **sort** param   > **Note 3**:  The last field `{fieldN}` must be the id field specified in the collection **collection.params.idPath** (returned as **md.id**) and `{valueN}` its corresponding value.   > __**Example**__: *sort=`-date,id` & **after**=`01/02/2019,abcd1234`*. Gets the following hits of the previous search that stopped at date *01/02/2019* and id *abcd1234*.   > __**Restriction 2**__: **from** param must be set to 0 or kept unset   
        :param str before: Same idea that after param, but to retrieve the data placed before the pointed element, given the provided order (sort).
        :param int max_age_cache: max-age-cache
        :return: FeatureCollection
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.geosearch_with_http_info(collection, **kwargs)
        else:
            (data) = self.geosearch_with_http_info(collection, **kwargs)
            return data

    def geosearch_with_http_info(self, collection, **kwargs):
        """
        GeoSearch
        Search and return the elements found in the collection(s) as features, given the filters
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.geosearch_with_http_info(collection, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str collection: collection (required)
        :param list[str] f: - A triplet for filtering the result. Multiple filter can be provided in distinct parameters (AND operator is applied) or in the same parameter separated by semi-colons (OR operator is applied). The order does not matter.    - A triplet is composed of a field name, a comparison operator and a value.      The possible values of the comparison operator are :           Operator |                   Description                    | value type          :eq:     | {fieldName} equals {comma separated values}. **OR** operation is applied for the specified values | numeric or strings           :ne:     | {fieldName} must not equal {comma separated values }. **AND** operation is applied for the specified values | numeric or strings           :like:   | {fieldName}  is like {value}                     | numeric or strings           :gte:    | {fieldName} is greater than or equal to  {value} | numeric           :gt:     | {fieldName} is greater than {value}              | numeric           :lte:    | {fieldName} is less than or equal to {value}     | numeric           :lt:     | {fieldName}  is less than {value}                | numeric           :range:  | {fieldName} is between `{comma separated [min<max] values}`. **OR** operation is applied for the specified ranges | numeric or strings. If the field's type is date, then min & max should be timestamps in millisecond or a Date expression          :within: | {GeofieldName}` is within the `{given WKT string or the given BBOX }` | a WKT string or the BBOX string : `\"west, south, east, north\"`           :notwithin:| {GeofieldName} is not within the `{given WKT string or the given BBOX }` | a WKT string or the BBOX string : `\"west, south, east, north\"`           :intersects:| {GeofieldName} intersects the `{given WKT string or the given BBOX }` | a WKT string or the BBOX string : `\"west, south, east, north\"`           :notintersects:| {GeofieldName} does not intersect the `{given WKT string or the given }` | a WKT string or the BBOX string : `\"west, south, east, north\"` 
        :param list[str] q: A full text search. Optionally, it's possible to search on a field using this syntax: {fieldname}:{text}
        :param str dateformat: The format of dates. This parameter should be set only if a date field is queried in `f` param; when using `gt`, `lt`, `gte`, `lte` and `range` operations
        :param bool pretty: Pretty print
        :param bool flat: Flats the property map: only key/value on one level
        :param list[str] include: List the name patterns of the field to be included in the result. Separate patterns with a comma.
        :param list[str] exclude: List the name patterns of the field to be excluded in the result. Separate patterns with a comma.
        :param str returned_geometries: Comma separated geometry field_paths to be included in the result. If not specified, only geometry_path is returned. If geometry_path is null, then centroid_path is returned
        :param int size: The maximum number of entries or sub-entries to be returned. The default value is 10
        :param int _from: From index to start the search from. Defaults to 0.
        :param list[str] sort: Sorts the resulted hits on the given fields and/or by distance to a given point:   > __**Syntax**__: `{field1},{field2},-{field3},geodistance:{lat} {lon},{field4}  ...`.   > **Note 1**: `{field}` can be preceded by **'-'**  for **descending** sort. By default, sort is ascending.   > **Note 2**: The order of fields matters.   > **Note 3** ***geodistance sort***: Sorts the hits centroids by distance to the given **{lat} {lon}** (ascending distance sort). It can be specified at most 1 time.   > __**Example 1**__: sort=`age,-timestamp`. Resulted hits are sorted by age. For same age hits, they are decreasingly sorted in time.   > __**Example 2**__: sort=`age,geodistance:89 179`. Resulted hits are sorted by age. For same age hits, they are sorted by closest distance to the point(89°,179°)   
        :param str after: List of values of fields present in sort param that are used to search after.    > **What it does**: Retrieve the data placed after the pointed element, given the provided order (sort).   > __**Restriction 1**__: **after** param works only combined with **sort** param.   > __**Syntax**__: `after={value1},{value2},...,{valueN} & sort={field1},{field2},...,{fieldN}`.   > **Note 1**: *{value1}` and `{value2}` are the values of `{field1}` and `{field2}` in the last hit returned in the previous search   > **Note 2**: The order of fields and values matters. *{value1},{value2}* must be in the same order of *{field1},{field2}* in **sort** param   > **Note 3**:  The last field `{fieldN}` must be the id field specified in the collection **collection.params.idPath** (returned as **md.id**) and `{valueN}` its corresponding value.   > __**Example**__: *sort=`-date,id` & **after**=`01/02/2019,abcd1234`*. Gets the following hits of the previous search that stopped at date *01/02/2019* and id *abcd1234*.   > __**Restriction 2**__: **from** param must be set to 0 or kept unset   
        :param str before: Same idea that after param, but to retrieve the data placed before the pointed element, given the provided order (sort).
        :param int max_age_cache: max-age-cache
        :return: FeatureCollection
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['collection', 'f', 'q', 'dateformat', 'pretty', 'flat', 'include', 'exclude', 'returned_geometries', 'size', '_from', 'sort', 'after', 'before', 'max_age_cache']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method geosearch" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'collection' is set
        if ('collection' not in params) or (params['collection'] is None):
            raise ValueError("Missing the required parameter `collection` when calling `geosearch`")

        if 'size' in params and params['size'] < 1:
            raise ValueError("Invalid value for parameter `size` when calling `geosearch`, must be a value greater than or equal to `1`")
        if '_from' in params and params['_from'] < 0:
            raise ValueError("Invalid value for parameter `_from` when calling `geosearch`, must be a value greater than or equal to `0`")

        collection_formats = {}

        path_params = {}
        if 'collection' in params:
            path_params['collection'] = params['collection']

        query_params = []
        if 'f' in params:
            query_params.append(('f', params['f']))
            collection_formats['f'] = 'multi'
        if 'q' in params:
            query_params.append(('q', params['q']))
            collection_formats['q'] = 'multi'
        if 'dateformat' in params:
            query_params.append(('dateformat', params['dateformat']))
        if 'pretty' in params:
            query_params.append(('pretty', params['pretty']))
        if 'flat' in params:
            query_params.append(('flat', params['flat']))
        if 'include' in params:
            query_params.append(('include', params['include']))
            collection_formats['include'] = 'multi'
        if 'exclude' in params:
            query_params.append(('exclude', params['exclude']))
            collection_formats['exclude'] = 'multi'
        if 'returned_geometries' in params:
            query_params.append(('returned_geometries', params['returned_geometries']))
        if 'size' in params:
            query_params.append(('size', params['size']))
        if '_from' in params:
            query_params.append(('from', params['_from']))
        if 'sort' in params:
            query_params.append(('sort', params['sort']))
            collection_formats['sort'] = 'multi'
        if 'after' in params:
            query_params.append(('after', params['after']))
        if 'before' in params:
            query_params.append(('before', params['before']))
        if 'max_age_cache' in params:
            query_params.append(('max-age-cache', params['max_age_cache']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json;charset=utf-8'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/explore/{collection}/_geosearch', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='FeatureCollection',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def geosearch_post(self, collection, **kwargs):
        """
        GeoSearch
        Search and return the elements found in the collection(s) as features, given the filters
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.geosearch_post(collection, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str collection: collection (required)
        :param Search body:
        :param bool pretty: Pretty print
        :param int max_age_cache: max-age-cache
        :return: FeatureCollection
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.geosearch_post_with_http_info(collection, **kwargs)
        else:
            (data) = self.geosearch_post_with_http_info(collection, **kwargs)
            return data

    def geosearch_post_with_http_info(self, collection, **kwargs):
        """
        GeoSearch
        Search and return the elements found in the collection(s) as features, given the filters
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.geosearch_post_with_http_info(collection, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str collection: collection (required)
        :param Search body:
        :param bool pretty: Pretty print
        :param int max_age_cache: max-age-cache
        :return: FeatureCollection
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['collection', 'body', 'pretty', 'max_age_cache']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method geosearch_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'collection' is set
        if ('collection' not in params) or (params['collection'] is None):
            raise ValueError("Missing the required parameter `collection` when calling `geosearch_post`")


        collection_formats = {}

        path_params = {}
        if 'collection' in params:
            path_params['collection'] = params['collection']

        query_params = []
        if 'pretty' in params:
            query_params.append(('pretty', params['pretty']))
        if 'max_age_cache' in params:
            query_params.append(('max-age-cache', params['max_age_cache']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json;charset=utf-8'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/explore/{collection}/_geosearch', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='FeatureCollection',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_arlas_hit(self, collection, identifier, **kwargs):
        """
        Get an Arlas document
        Returns a raw indexed document.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_arlas_hit(collection, identifier, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str collection: collection (required)
        :param str identifier: identifier (required)
        :param bool pretty: Pretty print
        :param bool flat: Flats the property map: only key/value on one level
        :param int max_age_cache: max-age-cache
        :return: Hit
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_arlas_hit_with_http_info(collection, identifier, **kwargs)
        else:
            (data) = self.get_arlas_hit_with_http_info(collection, identifier, **kwargs)
            return data

    def get_arlas_hit_with_http_info(self, collection, identifier, **kwargs):
        """
        Get an Arlas document
        Returns a raw indexed document.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_arlas_hit_with_http_info(collection, identifier, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str collection: collection (required)
        :param str identifier: identifier (required)
        :param bool pretty: Pretty print
        :param bool flat: Flats the property map: only key/value on one level
        :param int max_age_cache: max-age-cache
        :return: Hit
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['collection', 'identifier', 'pretty', 'flat', 'max_age_cache']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_arlas_hit" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'collection' is set
        if ('collection' not in params) or (params['collection'] is None):
            raise ValueError("Missing the required parameter `collection` when calling `get_arlas_hit`")
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params) or (params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_arlas_hit`")


        collection_formats = {}

        path_params = {}
        if 'collection' in params:
            path_params['collection'] = params['collection']
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']

        query_params = []
        if 'pretty' in params:
            query_params.append(('pretty', params['pretty']))
        if 'flat' in params:
            query_params.append(('flat', params['flat']))
        if 'max_age_cache' in params:
            query_params.append(('max-age-cache', params['max_age_cache']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json;charset=utf-8'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/explore/{collection}/{identifier}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Hit',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def list(self, **kwargs):
        """
        List
        List the collections configured in ARLAS. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param bool pretty: Pretty print
        :param int max_age_cache: max-age-cache
        :return: list[CollectionReferenceDescription]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_with_http_info(**kwargs)
        else:
            (data) = self.list_with_http_info(**kwargs)
            return data

    def list_with_http_info(self, **kwargs):
        """
        List
        List the collections configured in ARLAS. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param bool pretty: Pretty print
        :param int max_age_cache: max-age-cache
        :return: list[CollectionReferenceDescription]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pretty', 'max_age_cache']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'pretty' in params:
            query_params.append(('pretty', params['pretty']))
        if 'max_age_cache' in params:
            query_params.append(('max-age-cache', params['max_age_cache']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json;charset=utf-8'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/explore/_list', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[CollectionReferenceDescription]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def opensearch(self, collection, **kwargs):
        """
        OpenSearch Description Document
        Access to the OpenSearch Description document for the given collection
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.opensearch(collection, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str collection: collection (required)
        :param int max_age_cache: max-age-cache
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.opensearch_with_http_info(collection, **kwargs)
        else:
            (data) = self.opensearch_with_http_info(collection, **kwargs)
            return data

    def opensearch_with_http_info(self, collection, **kwargs):
        """
        OpenSearch Description Document
        Access to the OpenSearch Description document for the given collection
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.opensearch_with_http_info(collection, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str collection: collection (required)
        :param int max_age_cache: max-age-cache
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['collection', 'max_age_cache']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method opensearch" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'collection' is set
        if ('collection' not in params) or (params['collection'] is None):
            raise ValueError("Missing the required parameter `collection` when calling `opensearch`")


        collection_formats = {}

        path_params = {}
        if 'collection' in params:
            path_params['collection'] = params['collection']

        query_params = []
        if 'max_age_cache' in params:
            query_params.append(('max-age-cache', params['max_age_cache']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/xml'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/explore/ogc/opensearch/{collection}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def search(self, collection, **kwargs):
        """
        Search
        Search and return the elements found in the collection, given the filters
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.search(collection, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str collection: collection (required)
        :param list[str] f: - A triplet for filtering the result. Multiple filter can be provided in distinct parameters (AND operator is applied) or in the same parameter separated by semi-colons (OR operator is applied). The order does not matter.    - A triplet is composed of a field name, a comparison operator and a value.      The possible values of the comparison operator are :           Operator |                   Description                    | value type          :eq:     | {fieldName} equals {comma separated values}. **OR** operation is applied for the specified values | numeric or strings           :ne:     | {fieldName} must not equal {comma separated values }. **AND** operation is applied for the specified values | numeric or strings           :like:   | {fieldName}  is like {value}                     | numeric or strings           :gte:    | {fieldName} is greater than or equal to  {value} | numeric           :gt:     | {fieldName} is greater than {value}              | numeric           :lte:    | {fieldName} is less than or equal to {value}     | numeric           :lt:     | {fieldName}  is less than {value}                | numeric           :range:  | {fieldName} is between `{comma separated [min<max] values}`. **OR** operation is applied for the specified ranges | numeric or strings. If the field's type is date, then min & max should be timestamps in millisecond or a Date expression          :within: | {GeofieldName}` is within the `{given WKT string or the given BBOX }` | a WKT string or the BBOX string : `\"west, south, east, north\"`           :notwithin:| {GeofieldName} is not within the `{given WKT string or the given BBOX }` | a WKT string or the BBOX string : `\"west, south, east, north\"`           :intersects:| {GeofieldName} intersects the `{given WKT string or the given BBOX }` | a WKT string or the BBOX string : `\"west, south, east, north\"`           :notintersects:| {GeofieldName} does not intersect the `{given WKT string or the given }` | a WKT string or the BBOX string : `\"west, south, east, north\"` 
        :param list[str] q: A full text search. Optionally, it's possible to search on a field using this syntax: {fieldname}:{text}
        :param str dateformat: The format of dates. This parameter should be set only if a date field is queried in `f` param; when using `gt`, `lt`, `gte`, `lte` and `range` operations
        :param bool pretty: Pretty print
        :param bool flat: Flats the property map: only key/value on one level
        :param list[str] include: List the name patterns of the field to be included in the result. Separate patterns with a comma.
        :param list[str] exclude: List the name patterns of the field to be excluded in the result. Separate patterns with a comma.
        :param str returned_geometries: Comma separated geometry field_paths to be included in the result. If not specified, only geometry_path is returned. If geometry_path is null, then centroid_path is returned
        :param int size: The maximum number of entries or sub-entries to be returned. The default value is 10
        :param int _from: From index to start the search from. Defaults to 0.
        :param str sort: Sorts the resulted hits on the given fields and/or by distance to a given point:   > __**Syntax**__: `{field1},{field2},-{field3},geodistance:{lat} {lon},{field4}  ...`.   > **Note 1**: `{field}` can be preceded by **'-'**  for **descending** sort. By default, sort is ascending.   > **Note 2**: The order of fields matters.   > **Note 3** ***geodistance sort***: Sorts the hits centroids by distance to the given **{lat} {lon}** (ascending distance sort). It can be specified at most 1 time.   > __**Example 1**__: sort=`age,-timestamp`. Resulted hits are sorted by age. For same age hits, they are decreasingly sorted in time.   > __**Example 2**__: sort=`age,geodistance:89 179`. Resulted hits are sorted by age. For same age hits, they are sorted by closest distance to the point(89°,179°)   
        :param str after: List of values of fields present in sort param that are used to search after.    > **What it does**: Retrieve the data placed after the pointed element, given the provided order (sort).   > __**Restriction 1**__: **after** param works only combined with **sort** param.   > __**Syntax**__: `after={value1},{value2},...,{valueN} & sort={field1},{field2},...,{fieldN}`.   > **Note 1**: *{value1}` and `{value2}` are the values of `{field1}` and `{field2}` in the last hit returned in the previous search   > **Note 2**: The order of fields and values matters. *{value1},{value2}* must be in the same order of *{field1},{field2}* in **sort** param   > **Note 3**:  The last field `{fieldN}` must be the id field specified in the collection **collection.params.idPath** (returned as **md.id**) and `{valueN}` its corresponding value.   > __**Example**__: *sort=`-date,id` & **after**=`01/02/2019,abcd1234`*. Gets the following hits of the previous search that stopped at date *01/02/2019* and id *abcd1234*.   > __**Restriction 2**__: **from** param must be set to 0 or kept unset   
        :param str before: Same idea that after param, but to retrieve the data placed before the pointed element, given the provided order (sort).
        :param int max_age_cache: max-age-cache
        :return: Hits
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.search_with_http_info(collection, **kwargs)
        else:
            (data) = self.search_with_http_info(collection, **kwargs)
            return data

    def search_with_http_info(self, collection, **kwargs):
        """
        Search
        Search and return the elements found in the collection, given the filters
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.search_with_http_info(collection, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str collection: collection (required)
        :param list[str] f: - A triplet for filtering the result. Multiple filter can be provided in distinct parameters (AND operator is applied) or in the same parameter separated by semi-colons (OR operator is applied). The order does not matter.    - A triplet is composed of a field name, a comparison operator and a value.      The possible values of the comparison operator are :           Operator |                   Description                    | value type          :eq:     | {fieldName} equals {comma separated values}. **OR** operation is applied for the specified values | numeric or strings           :ne:     | {fieldName} must not equal {comma separated values }. **AND** operation is applied for the specified values | numeric or strings           :like:   | {fieldName}  is like {value}                     | numeric or strings           :gte:    | {fieldName} is greater than or equal to  {value} | numeric           :gt:     | {fieldName} is greater than {value}              | numeric           :lte:    | {fieldName} is less than or equal to {value}     | numeric           :lt:     | {fieldName}  is less than {value}                | numeric           :range:  | {fieldName} is between `{comma separated [min<max] values}`. **OR** operation is applied for the specified ranges | numeric or strings. If the field's type is date, then min & max should be timestamps in millisecond or a Date expression          :within: | {GeofieldName}` is within the `{given WKT string or the given BBOX }` | a WKT string or the BBOX string : `\"west, south, east, north\"`           :notwithin:| {GeofieldName} is not within the `{given WKT string or the given BBOX }` | a WKT string or the BBOX string : `\"west, south, east, north\"`           :intersects:| {GeofieldName} intersects the `{given WKT string or the given BBOX }` | a WKT string or the BBOX string : `\"west, south, east, north\"`           :notintersects:| {GeofieldName} does not intersect the `{given WKT string or the given }` | a WKT string or the BBOX string : `\"west, south, east, north\"` 
        :param list[str] q: A full text search. Optionally, it's possible to search on a field using this syntax: {fieldname}:{text}
        :param str dateformat: The format of dates. This parameter should be set only if a date field is queried in `f` param; when using `gt`, `lt`, `gte`, `lte` and `range` operations
        :param bool pretty: Pretty print
        :param bool flat: Flats the property map: only key/value on one level
        :param list[str] include: List the name patterns of the field to be included in the result. Separate patterns with a comma.
        :param list[str] exclude: List the name patterns of the field to be excluded in the result. Separate patterns with a comma.
        :param str returned_geometries: Comma separated geometry field_paths to be included in the result. If not specified, only geometry_path is returned. If geometry_path is null, then centroid_path is returned
        :param int size: The maximum number of entries or sub-entries to be returned. The default value is 10
        :param int _from: From index to start the search from. Defaults to 0.
        :param str sort: Sorts the resulted hits on the given fields and/or by distance to a given point:   > __**Syntax**__: `{field1},{field2},-{field3},geodistance:{lat} {lon},{field4}  ...`.   > **Note 1**: `{field}` can be preceded by **'-'**  for **descending** sort. By default, sort is ascending.   > **Note 2**: The order of fields matters.   > **Note 3** ***geodistance sort***: Sorts the hits centroids by distance to the given **{lat} {lon}** (ascending distance sort). It can be specified at most 1 time.   > __**Example 1**__: sort=`age,-timestamp`. Resulted hits are sorted by age. For same age hits, they are decreasingly sorted in time.   > __**Example 2**__: sort=`age,geodistance:89 179`. Resulted hits are sorted by age. For same age hits, they are sorted by closest distance to the point(89°,179°)   
        :param str after: List of values of fields present in sort param that are used to search after.    > **What it does**: Retrieve the data placed after the pointed element, given the provided order (sort).   > __**Restriction 1**__: **after** param works only combined with **sort** param.   > __**Syntax**__: `after={value1},{value2},...,{valueN} & sort={field1},{field2},...,{fieldN}`.   > **Note 1**: *{value1}` and `{value2}` are the values of `{field1}` and `{field2}` in the last hit returned in the previous search   > **Note 2**: The order of fields and values matters. *{value1},{value2}* must be in the same order of *{field1},{field2}* in **sort** param   > **Note 3**:  The last field `{fieldN}` must be the id field specified in the collection **collection.params.idPath** (returned as **md.id**) and `{valueN}` its corresponding value.   > __**Example**__: *sort=`-date,id` & **after**=`01/02/2019,abcd1234`*. Gets the following hits of the previous search that stopped at date *01/02/2019* and id *abcd1234*.   > __**Restriction 2**__: **from** param must be set to 0 or kept unset   
        :param str before: Same idea that after param, but to retrieve the data placed before the pointed element, given the provided order (sort).
        :param int max_age_cache: max-age-cache
        :return: Hits
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['collection', 'f', 'q', 'dateformat', 'pretty', 'flat', 'include', 'exclude', 'returned_geometries', 'size', '_from', 'sort', 'after', 'before', 'max_age_cache']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'collection' is set
        if ('collection' not in params) or (params['collection'] is None):
            raise ValueError("Missing the required parameter `collection` when calling `search`")

        if 'size' in params and params['size'] < 1:
            raise ValueError("Invalid value for parameter `size` when calling `search`, must be a value greater than or equal to `1`")
        if '_from' in params and params['_from'] < 0:
            raise ValueError("Invalid value for parameter `_from` when calling `search`, must be a value greater than or equal to `0`")

        collection_formats = {}

        path_params = {}
        if 'collection' in params:
            path_params['collection'] = params['collection']

        query_params = []
        if 'f' in params:
            query_params.append(('f', params['f']))
            collection_formats['f'] = 'multi'
        if 'q' in params:
            query_params.append(('q', params['q']))
            collection_formats['q'] = 'multi'
        if 'dateformat' in params:
            query_params.append(('dateformat', params['dateformat']))
        if 'pretty' in params:
            query_params.append(('pretty', params['pretty']))
        if 'flat' in params:
            query_params.append(('flat', params['flat']))
        if 'include' in params:
            query_params.append(('include', params['include']))
            collection_formats['include'] = 'multi'
        if 'exclude' in params:
            query_params.append(('exclude', params['exclude']))
            collection_formats['exclude'] = 'multi'
        if 'returned_geometries' in params:
            query_params.append(('returned_geometries', params['returned_geometries']))
        if 'size' in params:
            query_params.append(('size', params['size']))
        if '_from' in params:
            query_params.append(('from', params['_from']))
        if 'sort' in params:
            query_params.append(('sort', params['sort']))
        if 'after' in params:
            query_params.append(('after', params['after']))
        if 'before' in params:
            query_params.append(('before', params['before']))
        if 'max_age_cache' in params:
            query_params.append(('max-age-cache', params['max_age_cache']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json;charset=utf-8', 'application/atom+xml'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json;charset=utf-8'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/explore/{collection}/_search', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Hits',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def search_post(self, collection, **kwargs):
        """
        Search
        Search and return the elements found in the collection, given the filters
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.search_post(collection, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str collection: collection (required)
        :param Search body:
        :param bool pretty: Pretty print
        :param int max_age_cache: max-age-cache
        :return: Hits
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.search_post_with_http_info(collection, **kwargs)
        else:
            (data) = self.search_post_with_http_info(collection, **kwargs)
            return data

    def search_post_with_http_info(self, collection, **kwargs):
        """
        Search
        Search and return the elements found in the collection, given the filters
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.search_post_with_http_info(collection, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str collection: collection (required)
        :param Search body:
        :param bool pretty: Pretty print
        :param int max_age_cache: max-age-cache
        :return: Hits
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['collection', 'body', 'pretty', 'max_age_cache']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'collection' is set
        if ('collection' not in params) or (params['collection'] is None):
            raise ValueError("Missing the required parameter `collection` when calling `search_post`")


        collection_formats = {}

        path_params = {}
        if 'collection' in params:
            path_params['collection'] = params['collection']

        query_params = []
        if 'pretty' in params:
            query_params.append(('pretty', params['pretty']))
        if 'max_age_cache' in params:
            query_params.append(('max-age-cache', params['max_age_cache']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json;charset=utf-8'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/explore/{collection}/_search', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Hits',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def suggest(self, collections, **kwargs):
        """
        Suggest
        Suggest the the n (n=size) most relevant terms given the filters
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.suggest(collections, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str collections: collections, comma separated (required)
        :param list[str] f: - A triplet for filtering the result. Multiple filter can be provided. The order does not matter.    - A triplet is composed of a field name, a comparison operator and a value.      The possible values of the comparison operator are :           Operator   |                   Description                      | value type          :          |  {fieldName} equals {value}                        | numeric or strings           :gte:      |  {fieldName} is greater than or equal to  {value}  | numeric           :gt:       |  {fieldName} is greater than {value}               | numeric           :lte:      |  {fieldName} is less than or equal to {value}      | numeric           :lt:       |  {fieldName}  is less than {value}                 | numeric       - The AND operator is applied between filters having different fieldNames.    - The OR operator is applied on filters having the same fieldName.    - If the fieldName starts with - then a must not filter is used   - If the fieldName starts with - then a must not filter is used   For more details, check https://gitlab.com/GISAIA.ARLAS/ARLAS-server/blob/master/doc/api/API-definition.md 
        :param str q: A full text search
        :param bool pretty: Pretty print
        :param int size: The maximum number of entries or sub-entries to be returned. The default value is 10
        :param int _from: From index to start the search from. Defaults to 0.
        :param str field: Name of the field to be used for retrieving the most relevant terms
        :param int max_age_cache: max-age-cache
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.suggest_with_http_info(collections, **kwargs)
        else:
            (data) = self.suggest_with_http_info(collections, **kwargs)
            return data

    def suggest_with_http_info(self, collections, **kwargs):
        """
        Suggest
        Suggest the the n (n=size) most relevant terms given the filters
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.suggest_with_http_info(collections, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str collections: collections, comma separated (required)
        :param list[str] f: - A triplet for filtering the result. Multiple filter can be provided. The order does not matter.    - A triplet is composed of a field name, a comparison operator and a value.      The possible values of the comparison operator are :           Operator   |                   Description                      | value type          :          |  {fieldName} equals {value}                        | numeric or strings           :gte:      |  {fieldName} is greater than or equal to  {value}  | numeric           :gt:       |  {fieldName} is greater than {value}               | numeric           :lte:      |  {fieldName} is less than or equal to {value}      | numeric           :lt:       |  {fieldName}  is less than {value}                 | numeric       - The AND operator is applied between filters having different fieldNames.    - The OR operator is applied on filters having the same fieldName.    - If the fieldName starts with - then a must not filter is used   - If the fieldName starts with - then a must not filter is used   For more details, check https://gitlab.com/GISAIA.ARLAS/ARLAS-server/blob/master/doc/api/API-definition.md 
        :param str q: A full text search
        :param bool pretty: Pretty print
        :param int size: The maximum number of entries or sub-entries to be returned. The default value is 10
        :param int _from: From index to start the search from. Defaults to 0.
        :param str field: Name of the field to be used for retrieving the most relevant terms
        :param int max_age_cache: max-age-cache
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['collections', 'f', 'q', 'pretty', 'size', '_from', 'field', 'max_age_cache']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method suggest" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'collections' is set
        if ('collections' not in params) or (params['collections'] is None):
            raise ValueError("Missing the required parameter `collections` when calling `suggest`")

        if 'size' in params and params['size'] < 1:
            raise ValueError("Invalid value for parameter `size` when calling `suggest`, must be a value greater than or equal to `1`")
        if '_from' in params and params['_from'] < 1:
            raise ValueError("Invalid value for parameter `_from` when calling `suggest`, must be a value greater than or equal to `1`")

        collection_formats = {}

        path_params = {}
        if 'collections' in params:
            path_params['collections'] = params['collections']

        query_params = []
        if 'f' in params:
            query_params.append(('f', params['f']))
            collection_formats['f'] = 'multi'
        if 'q' in params:
            query_params.append(('q', params['q']))
        if 'pretty' in params:
            query_params.append(('pretty', params['pretty']))
        if 'size' in params:
            query_params.append(('size', params['size']))
        if '_from' in params:
            query_params.append(('from', params['_from']))
        if 'field' in params:
            query_params.append(('field', params['field']))
        if 'max_age_cache' in params:
            query_params.append(('max-age-cache', params['max_age_cache']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json;charset=utf-8'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/explore/{collections}/_suggest', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def tiledgeosearch(self, collection, x, y, z, **kwargs):
        """
        Tiled GeoSearch
        Search and return the elements found in the collection(s) and localized in the given tile(x,y,z) as features, given the filters
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.tiledgeosearch(collection, x, y, z, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str collection: collection (required)
        :param int x: x (required)
        :param int y: y (required)
        :param int z: z (required)
        :param list[str] f: - A triplet for filtering the result. Multiple filter can be provided in distinct parameters (AND operator is applied) or in the same parameter separated by semi-colons (OR operator is applied). The order does not matter.    - A triplet is composed of a field name, a comparison operator and a value.      The possible values of the comparison operator are :           Operator |                   Description                    | value type          :eq:     | {fieldName} equals {comma separated values}. **OR** operation is applied for the specified values | numeric or strings           :ne:     | {fieldName} must not equal {comma separated values }. **AND** operation is applied for the specified values | numeric or strings           :like:   | {fieldName}  is like {value}                     | numeric or strings           :gte:    | {fieldName} is greater than or equal to  {value} | numeric           :gt:     | {fieldName} is greater than {value}              | numeric           :lte:    | {fieldName} is less than or equal to {value}     | numeric           :lt:     | {fieldName}  is less than {value}                | numeric           :range:  | {fieldName} is between `{comma separated [min<max] values}`. **OR** operation is applied for the specified ranges | numeric or strings. If the field's type is date, then min & max should be timestamps in millisecond or a Date expression          :within: | {GeofieldName}` is within the `{given WKT string or the given BBOX }` | a WKT string or the BBOX string : `\"west, south, east, north\"`           :notwithin:| {GeofieldName} is not within the `{given WKT string or the given BBOX }` | a WKT string or the BBOX string : `\"west, south, east, north\"`           :intersects:| {GeofieldName} intersects the `{given WKT string or the given BBOX }` | a WKT string or the BBOX string : `\"west, south, east, north\"`           :notintersects:| {GeofieldName} does not intersect the `{given WKT string or the given }` | a WKT string or the BBOX string : `\"west, south, east, north\"` 
        :param list[str] q: A full text search. Optionally, it's possible to search on a field using this syntax: {fieldname}:{text}
        :param str dateformat: The format of dates. This parameter should be set only if a date field is queried in `f` param; when using `gt`, `lt`, `gte`, `lte` and `range` operations
        :param bool pretty: Pretty print
        :param bool flat: Flats the property map: only key/value on one level
        :param list[str] include: List the name patterns of the field to be included in the result. Separate patterns with a comma.
        :param list[str] exclude: List the name patterns of the field to be excluded in the result. Separate patterns with a comma.
        :param str returned_geometries: Comma separated geometry field_paths to be included in the result. If not specified, only geometry_path is returned. If geometry_path is null, then centroid_path is returned
        :param int size: The maximum number of entries or sub-entries to be returned. The default value is 10
        :param int _from: From index to start the search from. Defaults to 0.
        :param list[str] sort: Sorts the resulted hits on the given fields and/or by distance to a given point:   > __**Syntax**__: `{field1},{field2},-{field3},geodistance:{lat} {lon},{field4}  ...`.   > **Note 1**: `{field}` can be preceded by **'-'**  for **descending** sort. By default, sort is ascending.   > **Note 2**: The order of fields matters.   > **Note 3** ***geodistance sort***: Sorts the hits centroids by distance to the given **{lat} {lon}** (ascending distance sort). It can be specified at most 1 time.   > __**Example 1**__: sort=`age,-timestamp`. Resulted hits are sorted by age. For same age hits, they are decreasingly sorted in time.   > __**Example 2**__: sort=`age,geodistance:89 179`. Resulted hits are sorted by age. For same age hits, they are sorted by closest distance to the point(89°,179°)   
        :param str after: List of values of fields present in sort param that are used to search after.    > **What it does**: Retrieve the data placed after the pointed element, given the provided order (sort).   > __**Restriction 1**__: **after** param works only combined with **sort** param.   > __**Syntax**__: `after={value1},{value2},...,{valueN} & sort={field1},{field2},...,{fieldN}`.   > **Note 1**: *{value1}` and `{value2}` are the values of `{field1}` and `{field2}` in the last hit returned in the previous search   > **Note 2**: The order of fields and values matters. *{value1},{value2}* must be in the same order of *{field1},{field2}* in **sort** param   > **Note 3**:  The last field `{fieldN}` must be the id field specified in the collection **collection.params.idPath** (returned as **md.id**) and `{valueN}` its corresponding value.   > __**Example**__: *sort=`-date,id` & **after**=`01/02/2019,abcd1234`*. Gets the following hits of the previous search that stopped at date *01/02/2019* and id *abcd1234*.   > __**Restriction 2**__: **from** param must be set to 0 or kept unset   
        :param str before: Same idea that after param, but to retrieve the data placed before the pointed element, given the provided order (sort).
        :param int max_age_cache: max-age-cache
        :return: FeatureCollection
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.tiledgeosearch_with_http_info(collection, x, y, z, **kwargs)
        else:
            (data) = self.tiledgeosearch_with_http_info(collection, x, y, z, **kwargs)
            return data

    def tiledgeosearch_with_http_info(self, collection, x, y, z, **kwargs):
        """
        Tiled GeoSearch
        Search and return the elements found in the collection(s) and localized in the given tile(x,y,z) as features, given the filters
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.tiledgeosearch_with_http_info(collection, x, y, z, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str collection: collection (required)
        :param int x: x (required)
        :param int y: y (required)
        :param int z: z (required)
        :param list[str] f: - A triplet for filtering the result. Multiple filter can be provided in distinct parameters (AND operator is applied) or in the same parameter separated by semi-colons (OR operator is applied). The order does not matter.    - A triplet is composed of a field name, a comparison operator and a value.      The possible values of the comparison operator are :           Operator |                   Description                    | value type          :eq:     | {fieldName} equals {comma separated values}. **OR** operation is applied for the specified values | numeric or strings           :ne:     | {fieldName} must not equal {comma separated values }. **AND** operation is applied for the specified values | numeric or strings           :like:   | {fieldName}  is like {value}                     | numeric or strings           :gte:    | {fieldName} is greater than or equal to  {value} | numeric           :gt:     | {fieldName} is greater than {value}              | numeric           :lte:    | {fieldName} is less than or equal to {value}     | numeric           :lt:     | {fieldName}  is less than {value}                | numeric           :range:  | {fieldName} is between `{comma separated [min<max] values}`. **OR** operation is applied for the specified ranges | numeric or strings. If the field's type is date, then min & max should be timestamps in millisecond or a Date expression          :within: | {GeofieldName}` is within the `{given WKT string or the given BBOX }` | a WKT string or the BBOX string : `\"west, south, east, north\"`           :notwithin:| {GeofieldName} is not within the `{given WKT string or the given BBOX }` | a WKT string or the BBOX string : `\"west, south, east, north\"`           :intersects:| {GeofieldName} intersects the `{given WKT string or the given BBOX }` | a WKT string or the BBOX string : `\"west, south, east, north\"`           :notintersects:| {GeofieldName} does not intersect the `{given WKT string or the given }` | a WKT string or the BBOX string : `\"west, south, east, north\"` 
        :param list[str] q: A full text search. Optionally, it's possible to search on a field using this syntax: {fieldname}:{text}
        :param str dateformat: The format of dates. This parameter should be set only if a date field is queried in `f` param; when using `gt`, `lt`, `gte`, `lte` and `range` operations
        :param bool pretty: Pretty print
        :param bool flat: Flats the property map: only key/value on one level
        :param list[str] include: List the name patterns of the field to be included in the result. Separate patterns with a comma.
        :param list[str] exclude: List the name patterns of the field to be excluded in the result. Separate patterns with a comma.
        :param str returned_geometries: Comma separated geometry field_paths to be included in the result. If not specified, only geometry_path is returned. If geometry_path is null, then centroid_path is returned
        :param int size: The maximum number of entries or sub-entries to be returned. The default value is 10
        :param int _from: From index to start the search from. Defaults to 0.
        :param list[str] sort: Sorts the resulted hits on the given fields and/or by distance to a given point:   > __**Syntax**__: `{field1},{field2},-{field3},geodistance:{lat} {lon},{field4}  ...`.   > **Note 1**: `{field}` can be preceded by **'-'**  for **descending** sort. By default, sort is ascending.   > **Note 2**: The order of fields matters.   > **Note 3** ***geodistance sort***: Sorts the hits centroids by distance to the given **{lat} {lon}** (ascending distance sort). It can be specified at most 1 time.   > __**Example 1**__: sort=`age,-timestamp`. Resulted hits are sorted by age. For same age hits, they are decreasingly sorted in time.   > __**Example 2**__: sort=`age,geodistance:89 179`. Resulted hits are sorted by age. For same age hits, they are sorted by closest distance to the point(89°,179°)   
        :param str after: List of values of fields present in sort param that are used to search after.    > **What it does**: Retrieve the data placed after the pointed element, given the provided order (sort).   > __**Restriction 1**__: **after** param works only combined with **sort** param.   > __**Syntax**__: `after={value1},{value2},...,{valueN} & sort={field1},{field2},...,{fieldN}`.   > **Note 1**: *{value1}` and `{value2}` are the values of `{field1}` and `{field2}` in the last hit returned in the previous search   > **Note 2**: The order of fields and values matters. *{value1},{value2}* must be in the same order of *{field1},{field2}* in **sort** param   > **Note 3**:  The last field `{fieldN}` must be the id field specified in the collection **collection.params.idPath** (returned as **md.id**) and `{valueN}` its corresponding value.   > __**Example**__: *sort=`-date,id` & **after**=`01/02/2019,abcd1234`*. Gets the following hits of the previous search that stopped at date *01/02/2019* and id *abcd1234*.   > __**Restriction 2**__: **from** param must be set to 0 or kept unset   
        :param str before: Same idea that after param, but to retrieve the data placed before the pointed element, given the provided order (sort).
        :param int max_age_cache: max-age-cache
        :return: FeatureCollection
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['collection', 'x', 'y', 'z', 'f', 'q', 'dateformat', 'pretty', 'flat', 'include', 'exclude', 'returned_geometries', 'size', '_from', 'sort', 'after', 'before', 'max_age_cache']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method tiledgeosearch" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'collection' is set
        if ('collection' not in params) or (params['collection'] is None):
            raise ValueError("Missing the required parameter `collection` when calling `tiledgeosearch`")
        # verify the required parameter 'x' is set
        if ('x' not in params) or (params['x'] is None):
            raise ValueError("Missing the required parameter `x` when calling `tiledgeosearch`")
        # verify the required parameter 'y' is set
        if ('y' not in params) or (params['y'] is None):
            raise ValueError("Missing the required parameter `y` when calling `tiledgeosearch`")
        # verify the required parameter 'z' is set
        if ('z' not in params) or (params['z'] is None):
            raise ValueError("Missing the required parameter `z` when calling `tiledgeosearch`")

        if 'size' in params and params['size'] < 1:
            raise ValueError("Invalid value for parameter `size` when calling `tiledgeosearch`, must be a value greater than or equal to `1`")
        if '_from' in params and params['_from'] < 0:
            raise ValueError("Invalid value for parameter `_from` when calling `tiledgeosearch`, must be a value greater than or equal to `0`")

        collection_formats = {}

        path_params = {}
        if 'collection' in params:
            path_params['collection'] = params['collection']
        if 'x' in params:
            path_params['x'] = params['x']
        if 'y' in params:
            path_params['y'] = params['y']
        if 'z' in params:
            path_params['z'] = params['z']

        query_params = []
        if 'f' in params:
            query_params.append(('f', params['f']))
            collection_formats['f'] = 'multi'
        if 'q' in params:
            query_params.append(('q', params['q']))
            collection_formats['q'] = 'multi'
        if 'dateformat' in params:
            query_params.append(('dateformat', params['dateformat']))
        if 'pretty' in params:
            query_params.append(('pretty', params['pretty']))
        if 'flat' in params:
            query_params.append(('flat', params['flat']))
        if 'include' in params:
            query_params.append(('include', params['include']))
            collection_formats['include'] = 'multi'
        if 'exclude' in params:
            query_params.append(('exclude', params['exclude']))
            collection_formats['exclude'] = 'multi'
        if 'returned_geometries' in params:
            query_params.append(('returned_geometries', params['returned_geometries']))
        if 'size' in params:
            query_params.append(('size', params['size']))
        if '_from' in params:
            query_params.append(('from', params['_from']))
        if 'sort' in params:
            query_params.append(('sort', params['sort']))
            collection_formats['sort'] = 'multi'
        if 'after' in params:
            query_params.append(('after', params['after']))
        if 'before' in params:
            query_params.append(('before', params['before']))
        if 'max_age_cache' in params:
            query_params.append(('max-age-cache', params['max_age_cache']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json;charset=utf-8'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/explore/{collection}/_geosearch/{z}/{x}/{y}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='FeatureCollection',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def tiledgeosearch1(self, collection, x, y, z, **kwargs):
        """
        Tiled GeoSearch
        Search and return the elements found in the collection(s) and localized in the given tile(x,y,z) as features, given the filters
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.tiledgeosearch1(collection, x, y, z, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str collection: collection (required)
        :param int x: x (required)
        :param int y: y (required)
        :param int z: z (required)
        :param list[str] f: - A triplet for filtering the result. Multiple filter can be provided in distinct parameters (AND operator is applied) or in the same parameter separated by semi-colons (OR operator is applied). The order does not matter.    - A triplet is composed of a field name, a comparison operator and a value.      The possible values of the comparison operator are :           Operator |                   Description                    | value type          :eq:     | {fieldName} equals {comma separated values}. **OR** operation is applied for the specified values | numeric or strings           :ne:     | {fieldName} must not equal {comma separated values }. **AND** operation is applied for the specified values | numeric or strings           :like:   | {fieldName}  is like {value}                     | numeric or strings           :gte:    | {fieldName} is greater than or equal to  {value} | numeric           :gt:     | {fieldName} is greater than {value}              | numeric           :lte:    | {fieldName} is less than or equal to {value}     | numeric           :lt:     | {fieldName}  is less than {value}                | numeric           :range:  | {fieldName} is between `{comma separated [min<max] values}`. **OR** operation is applied for the specified ranges | numeric or strings. If the field's type is date, then min & max should be timestamps in millisecond or a Date expression          :within: | {GeofieldName}` is within the `{given WKT string or the given BBOX }` | a WKT string or the BBOX string : `\"west, south, east, north\"`           :notwithin:| {GeofieldName} is not within the `{given WKT string or the given BBOX }` | a WKT string or the BBOX string : `\"west, south, east, north\"`           :intersects:| {GeofieldName} intersects the `{given WKT string or the given BBOX }` | a WKT string or the BBOX string : `\"west, south, east, north\"`           :notintersects:| {GeofieldName} does not intersect the `{given WKT string or the given }` | a WKT string or the BBOX string : `\"west, south, east, north\"` 
        :param list[str] q: A full text search. Optionally, it's possible to search on a field using this syntax: {fieldname}:{text}
        :param str dateformat: The format of dates. This parameter should be set only if a date field is queried in `f` param; when using `gt`, `lt`, `gte`, `lte` and `range` operations
        :param int size: The maximum number of entries or sub-entries to be returned. The default value is 10
        :param int _from: From index to start the search from. Defaults to 0.
        :param list[str] sort: Sorts the resulted hits on the given fields and/or by distance to a given point:   > __**Syntax**__: `{field1},{field2},-{field3},geodistance:{lat} {lon},{field4}  ...`.   > **Note 1**: `{field}` can be preceded by **'-'**  for **descending** sort. By default, sort is ascending.   > **Note 2**: The order of fields matters.   > **Note 3** ***geodistance sort***: Sorts the hits centroids by distance to the given **{lat} {lon}** (ascending distance sort). It can be specified at most 1 time.   > __**Example 1**__: sort=`age,-timestamp`. Resulted hits are sorted by age. For same age hits, they are decreasingly sorted in time.   > __**Example 2**__: sort=`age,geodistance:89 179`. Resulted hits are sorted by age. For same age hits, they are sorted by closest distance to the point(89°,179°)   
        :param str after: List of values of fields present in sort param that are used to search after.    > **What it does**: Retrieve the data placed after the pointed element, given the provided order (sort).   > __**Restriction 1**__: **after** param works only combined with **sort** param.   > __**Syntax**__: `after={value1},{value2},...,{valueN} & sort={field1},{field2},...,{fieldN}`.   > **Note 1**: *{value1}` and `{value2}` are the values of `{field1}` and `{field2}` in the last hit returned in the previous search   > **Note 2**: The order of fields and values matters. *{value1},{value2}* must be in the same order of *{field1},{field2}* in **sort** param   > **Note 3**:  The last field `{fieldN}` must be the id field specified in the collection **collection.params.idPath** (returned as **md.id**) and `{valueN}` its corresponding value.   > __**Example**__: *sort=`-date,id` & **after**=`01/02/2019,abcd1234`*. Gets the following hits of the previous search that stopped at date *01/02/2019* and id *abcd1234*.   > __**Restriction 2**__: **from** param must be set to 0 or kept unset   
        :param str before: Same idea that after param, but to retrieve the data placed before the pointed element, given the provided order (sort).
        :param int sampling: Size of the sampling for testing transparency: 1: test every pixel, 10: test 1 pixel every 10 pixels, etc.
        :param int coverage: Percentage (]0-100]) of acceptable transparent pixels. Higher the percentage, more tiles could be used for filling the tile
        :param int max_age_cache: max-age-cache
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.tiledgeosearch1_with_http_info(collection, x, y, z, **kwargs)
        else:
            (data) = self.tiledgeosearch1_with_http_info(collection, x, y, z, **kwargs)
            return data

    def tiledgeosearch1_with_http_info(self, collection, x, y, z, **kwargs):
        """
        Tiled GeoSearch
        Search and return the elements found in the collection(s) and localized in the given tile(x,y,z) as features, given the filters
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.tiledgeosearch1_with_http_info(collection, x, y, z, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str collection: collection (required)
        :param int x: x (required)
        :param int y: y (required)
        :param int z: z (required)
        :param list[str] f: - A triplet for filtering the result. Multiple filter can be provided in distinct parameters (AND operator is applied) or in the same parameter separated by semi-colons (OR operator is applied). The order does not matter.    - A triplet is composed of a field name, a comparison operator and a value.      The possible values of the comparison operator are :           Operator |                   Description                    | value type          :eq:     | {fieldName} equals {comma separated values}. **OR** operation is applied for the specified values | numeric or strings           :ne:     | {fieldName} must not equal {comma separated values }. **AND** operation is applied for the specified values | numeric or strings           :like:   | {fieldName}  is like {value}                     | numeric or strings           :gte:    | {fieldName} is greater than or equal to  {value} | numeric           :gt:     | {fieldName} is greater than {value}              | numeric           :lte:    | {fieldName} is less than or equal to {value}     | numeric           :lt:     | {fieldName}  is less than {value}                | numeric           :range:  | {fieldName} is between `{comma separated [min<max] values}`. **OR** operation is applied for the specified ranges | numeric or strings. If the field's type is date, then min & max should be timestamps in millisecond or a Date expression          :within: | {GeofieldName}` is within the `{given WKT string or the given BBOX }` | a WKT string or the BBOX string : `\"west, south, east, north\"`           :notwithin:| {GeofieldName} is not within the `{given WKT string or the given BBOX }` | a WKT string or the BBOX string : `\"west, south, east, north\"`           :intersects:| {GeofieldName} intersects the `{given WKT string or the given BBOX }` | a WKT string or the BBOX string : `\"west, south, east, north\"`           :notintersects:| {GeofieldName} does not intersect the `{given WKT string or the given }` | a WKT string or the BBOX string : `\"west, south, east, north\"` 
        :param list[str] q: A full text search. Optionally, it's possible to search on a field using this syntax: {fieldname}:{text}
        :param str dateformat: The format of dates. This parameter should be set only if a date field is queried in `f` param; when using `gt`, `lt`, `gte`, `lte` and `range` operations
        :param int size: The maximum number of entries or sub-entries to be returned. The default value is 10
        :param int _from: From index to start the search from. Defaults to 0.
        :param list[str] sort: Sorts the resulted hits on the given fields and/or by distance to a given point:   > __**Syntax**__: `{field1},{field2},-{field3},geodistance:{lat} {lon},{field4}  ...`.   > **Note 1**: `{field}` can be preceded by **'-'**  for **descending** sort. By default, sort is ascending.   > **Note 2**: The order of fields matters.   > **Note 3** ***geodistance sort***: Sorts the hits centroids by distance to the given **{lat} {lon}** (ascending distance sort). It can be specified at most 1 time.   > __**Example 1**__: sort=`age,-timestamp`. Resulted hits are sorted by age. For same age hits, they are decreasingly sorted in time.   > __**Example 2**__: sort=`age,geodistance:89 179`. Resulted hits are sorted by age. For same age hits, they are sorted by closest distance to the point(89°,179°)   
        :param str after: List of values of fields present in sort param that are used to search after.    > **What it does**: Retrieve the data placed after the pointed element, given the provided order (sort).   > __**Restriction 1**__: **after** param works only combined with **sort** param.   > __**Syntax**__: `after={value1},{value2},...,{valueN} & sort={field1},{field2},...,{fieldN}`.   > **Note 1**: *{value1}` and `{value2}` are the values of `{field1}` and `{field2}` in the last hit returned in the previous search   > **Note 2**: The order of fields and values matters. *{value1},{value2}* must be in the same order of *{field1},{field2}* in **sort** param   > **Note 3**:  The last field `{fieldN}` must be the id field specified in the collection **collection.params.idPath** (returned as **md.id**) and `{valueN}` its corresponding value.   > __**Example**__: *sort=`-date,id` & **after**=`01/02/2019,abcd1234`*. Gets the following hits of the previous search that stopped at date *01/02/2019* and id *abcd1234*.   > __**Restriction 2**__: **from** param must be set to 0 or kept unset   
        :param str before: Same idea that after param, but to retrieve the data placed before the pointed element, given the provided order (sort).
        :param int sampling: Size of the sampling for testing transparency: 1: test every pixel, 10: test 1 pixel every 10 pixels, etc.
        :param int coverage: Percentage (]0-100]) of acceptable transparent pixels. Higher the percentage, more tiles could be used for filling the tile
        :param int max_age_cache: max-age-cache
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['collection', 'x', 'y', 'z', 'f', 'q', 'dateformat', 'size', '_from', 'sort', 'after', 'before', 'sampling', 'coverage', 'max_age_cache']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method tiledgeosearch1" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'collection' is set
        if ('collection' not in params) or (params['collection'] is None):
            raise ValueError("Missing the required parameter `collection` when calling `tiledgeosearch1`")
        # verify the required parameter 'x' is set
        if ('x' not in params) or (params['x'] is None):
            raise ValueError("Missing the required parameter `x` when calling `tiledgeosearch1`")
        # verify the required parameter 'y' is set
        if ('y' not in params) or (params['y'] is None):
            raise ValueError("Missing the required parameter `y` when calling `tiledgeosearch1`")
        # verify the required parameter 'z' is set
        if ('z' not in params) or (params['z'] is None):
            raise ValueError("Missing the required parameter `z` when calling `tiledgeosearch1`")

        if 'size' in params and params['size'] < 1:
            raise ValueError("Invalid value for parameter `size` when calling `tiledgeosearch1`, must be a value greater than or equal to `1`")
        if '_from' in params and params['_from'] < 0:
            raise ValueError("Invalid value for parameter `_from` when calling `tiledgeosearch1`, must be a value greater than or equal to `0`")

        collection_formats = {}

        path_params = {}
        if 'collection' in params:
            path_params['collection'] = params['collection']
        if 'x' in params:
            path_params['x'] = params['x']
        if 'y' in params:
            path_params['y'] = params['y']
        if 'z' in params:
            path_params['z'] = params['z']

        query_params = []
        if 'f' in params:
            query_params.append(('f', params['f']))
            collection_formats['f'] = 'multi'
        if 'q' in params:
            query_params.append(('q', params['q']))
            collection_formats['q'] = 'multi'
        if 'dateformat' in params:
            query_params.append(('dateformat', params['dateformat']))
        if 'size' in params:
            query_params.append(('size', params['size']))
        if '_from' in params:
            query_params.append(('from', params['_from']))
        if 'sort' in params:
            query_params.append(('sort', params['sort']))
            collection_formats['sort'] = 'multi'
        if 'after' in params:
            query_params.append(('after', params['after']))
        if 'before' in params:
            query_params.append(('before', params['before']))
        if 'sampling' in params:
            query_params.append(('sampling', params['sampling']))
        if 'coverage' in params:
            query_params.append(('coverage', params['coverage']))
        if 'max_age_cache' in params:
            query_params.append(('max-age-cache', params['max_age_cache']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['image/png'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json;charset=utf-8'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/explore/{collection}/_tile/{z}/{x}/{y}.png', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
