
# DREEM Clustering Module
Contributors: Matty Allan, Scott Grote, Yves Martin

## Purpose
- Divide reads into sections, if a library is provided.
- Cluster the (sectioned) reads using EM clustering.
- For each (sectioned) read, compute the likelihood of belonging to each cluster. 
- Store this result in a json file.

## Interface

### Input files
- [=1] `{reference}.fasta`. Fasta file containing the reference for each sequence of the bitvectors. 
- [≥1] ```{input_dir}:= path/to/{sample_k}``` Sequence alignment map files folder(s) generated by ```vectoring```. Its content is the following:
```
{input_dir}:=/output/vectoring/{sample_1}/
  |- report.txt
  |- reference_1/
     |- section_1.orc
     |- section_2.orc
     |- ...
  |- reference_2/
    |- ...
  |- ...
{input_dir}:=/output/vectoring/{sample_2}/
  |- ..
```

### Output files
- [=1] `{output_file}`. 

This json file is structured as follow:

```
{sample_1}:      # name of the sequence alignment map files folder (from `{input_dir}`)
  {reference_1}: # name of the bitvector file (from fasta file)
    {section_1}: # name of the clustered section (from library)
      {read_1}:  # read number (from bitvector)
        K1_1: likelihood that this read belongs to cluster 1 when using 1 cluster
        K2_1: likelihood that this read belongs to cluster 1 when using 2 clusters
        K2_2: likelihood that this read belongs to cluster 2 when using 2 clusters
        K3_1: likelihood that this read belongs to cluster 1 when using 3 clusters
        K3_2: likelihood that this read belongs to cluster 2 when using 3 clusters
        K3_3: likelihood that this read belongs to cluster 3 when using 3 clusters    
        - ...
```
        
### Command-line usage

```
dreem-clustering --input_dir [path/to/{sample_1}] --input_dir [path/to/{sample_2}] —-fasta {reference}.fasta  --out_dir [path]
```

- `dreem-clustering`: wrapper for function run in dreem.clustering.run.
- [=1] `-fa / --fasta`: path to `{reference}.fasta` fasta file
- [≥1] `-id / --input_dir`: folder(s) containing bitvector(s) `{reference}.orc`
- [=1] `-o / --out_dir`: output_file
- [≤1] `-mc / --max_n_clusters`: use the optimal number of clusters below or equal to this value
- [≤1] `-st / --signal_thresh`: signal threshold #TODO, float in [0,1]
- [≤1] `-mi / --min_iter`: minimal number of iterations for the EM loop
- [≤1] `-igu / --include_g_u`: include G and U bases 
- [≤1] `-idel / --include_del`: include deleted bases
- [≤1] `-it / --info_thresh`: #TODO
- [≤1] `-mr / --min_reads`: minimum amount of reads for a sequence to be clustered
- [≤1] `-cc / --convergence_cutoff`: float. When the likelihood difference between two iterations is below that threshold and the number of iterations is above `min_iter`, the EM loop breaks.
- [≤1] `-nr / --num_runs`: number of iterations with random parameters initialisation
- [≥0] `-c`: 3 arguments: reference sequence name, start, stop. Multiple `-c` arguments are possible.
- [≥0] `-p`: 3 arguments: reference sequence name, forward primer, reverse primer. Multiple `-p` arguments are possible.
