---
hide:
  - navigation
  - toc
---

<p align="center" style="margin: -15px 0 10px 0">
    <img width="160" height="160" src="img/anaplan-sdk.webp" alt='Python' style="border-radius: 15px">
</p>

<h1 align="center" style="font-size: 3rem; font-weight: 600; margin: -15px 0; color: var(--md-typeset-color)">
Anaplan SDK
</h1>

<h1 align="center" style="font-size: 1.2rem; font-weight: 300; margin: 15px 0">
    Streamlined Python Interface for Anaplan
</h1>

<div align="center">
    <a href="https://pepy.tech/projects/anaplan-sdk">
        <img src="https://static.pepy.tech/badge/anaplan-sdk" alt="">
    </a>
    <a href="https://pypi.org/project/anaplan-sdk/">
        <img src="https://img.shields.io/pypi/v/anaplan-sdk.svg" alt="PyPi Latest Release"/>
    </a>
    <a href="https://pepy.tech/projects/anaplan-sdk">
        <img src="https://static.pepy.tech/badge/anaplan-sdk/month" alt="PyPI Downloads">
    </a>
</div>

---

Anaplan SDK is an independent, unofficial project providing pythonic access to Anaplan. It delivers high-level
abstractions over all Anaplan APIs, allowing you to focus on business requirements rather than implementation details.

## Key Features

- **Pythonic Interface**: Clean, intuitive access to Anaplan functionality
- **Simplified API Interactions**: Automatic handling of authentication, error handling, and data formatting
- **Performance Optimizations**: Built-in chunking and compression techniques
- **Multiple API Support**: Compatible with all major Anaplan API endpoints
- **Flexible Client Options**: Both synchronous and asynchronous implementations
- **Developer-Friendly**: Designed to reduce boilerplate code and accelerate development

---

## Getting Started

Head over to the [Quick Start](quickstart.md) for basic usage instructions and examples.


## Contributing

All contributions are appreciated, from reporting bugs to implementing new features. Pull requests are welcome. For
large changes, please open an issue first to discuss what you would like to change. Please ensure your code adheres to
the existing style and includes appropriate tests.

If you encounter any issues or have feature requests,
please [open an issue](https://github.com/VinzenzKlass/anaplan-sdk/issues/new) on GitHub.
