"use strict";
/**
 *  Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.CheckProps = void 0;
function CheckProps(propsObject) {
    let errorMessages = '';
    let errorFound = false;
    if (propsObject.dynamoTableProps && propsObject.existingTableObj) {
        errorMessages += 'Error - Either provide existingTableObj or dynamoTableProps, but not both.\n';
        errorFound = true;
    }
    if (propsObject.dynamoTableProps && propsObject.existingTableInterface) {
        errorMessages += 'Error - Either provide existingTableInterface or dynamoTableProps, but not both.\n';
        errorFound = true;
    }
    if (propsObject.existingStreamObj && propsObject.kinesisStreamProps) {
        errorMessages += 'Error - Either provide existingStreamObj or kinesisStreamProps, but not both.\n';
        errorFound = true;
    }
    if (propsObject.existingLambdaObj && propsObject.lambdaFunctionProps) {
        errorMessages += 'Error - Either provide lambdaFunctionProps or existingLambdaObj, but not both.\n';
        errorFound = true;
    }
    if (propsObject.existingQueueObj && propsObject.queueProps) {
        errorMessages += 'Error - Either provide queueProps or existingQueueObj, but not both.\n';
        errorFound = true;
    }
    if (((propsObject === null || propsObject === void 0 ? void 0 : propsObject.deployDeadLetterQueue) === false) && propsObject.deadLetterQueueProps) {
        errorMessages += 'Error - If deployDeadLetterQueue is false then deadLetterQueueProps cannot be specified.\n';
        errorFound = true;
    }
    if (propsObject.existingMediaStoreContainerObj && propsObject.mediaStoreContainerProps) {
        errorMessages += 'Error - Either provide mediaStoreContainerProps or existingMediaStoreContainerObj, but not both.\n';
        errorFound = true;
    }
    if (propsObject.existingBucketObj && propsObject.bucketProps) {
        errorMessages += 'Error - Either provide bucketProps or existingBucketObj, but not both.\n';
        errorFound = true;
    }
    if (propsObject.existingBucketInterface && propsObject.bucketProps) {
        errorMessages += 'Error - Either provide bucketProps or existingBucketInterface, but not both.\n';
        errorFound = true;
    }
    if ((propsObject.topicProps) && propsObject.existingTopicObj) {
        errorMessages += 'Error - Either provide topicProps or existingTopicObj, but not both.\n';
        errorFound = true;
    }
    if (propsObject.glueJobProps && propsObject.existingGlueJob) {
        errorMessages += 'Error - Either provide glueJobProps or existingGlueJob, but not both.\n';
        errorFound = true;
    }
    if (propsObject.existingSagemakerEndpointObj && propsObject.endpointProps) {
        errorMessages += 'Error - Either provide endpointProps or existingSagemakerEndpointObj, but not both.\n';
        errorFound = true;
    }
    if (propsObject.existingSecretObj && propsObject.secretProps) {
        errorMessages += 'Error - Either provide secretProps or existingSecretObj, but not both.\n';
        errorFound = true;
    }
    // if (deployVpc || vpcProp) and existingVpc
    if ((propsObject.deployVpc || propsObject.vpcProps) && propsObject.existingVpc) {
        errorMessages += 'Error - Either provide an existingVpc or some combination of deployVpc and vpcProps, but not both.\n';
        errorFound = true;
    }
    if (propsObject.encryptionKey && propsObject.encryptionKeyProps) {
        errorMessages += 'Error - Either provide encryptionKey or encryptionKeyProps, but not both.\n';
        errorFound = true;
    }
    if (errorFound) {
        throw new Error(errorMessages);
    }
}
exports.CheckProps = CheckProps;
//# sourceMappingURL=data:application/json;base64,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