"use strict";
/**
 *  Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.buildKinesisAnalyticsApp = void 0;
// Imports
const kinesisAnalytics = require("@aws-cdk/aws-kinesisanalytics");
const iam = require("@aws-cdk/aws-iam");
const defaults = require("./kinesis-analytics-defaults");
const utils_1 = require("./utils");
function buildKinesisAnalyticsApp(scope, props) {
    // Setup the IAM role for Kinesis Analytics
    const analyticsRole = new iam.Role(scope, 'KinesisAnalyticsRole', {
        assumedBy: new iam.ServicePrincipal('kinesisanalytics.amazonaws.com'),
    });
    // Setup the IAM policy for Kinesis Analytics
    const analyticsPolicy = new iam.Policy(scope, 'KinesisAnalyticsPolicy', {
        statements: [
            new iam.PolicyStatement({
                actions: [
                    'firehose:DescribeDeliveryStream',
                    'firehose:Get*'
                ],
                resources: [props.kinesisFirehose.attrArn]
            })
        ]
    });
    // Attach policy to role
    analyticsPolicy.attachToRole(analyticsRole);
    // Setup the Kinesis application properties
    const kinesisAnalyticsProps = utils_1.overrideProps(defaults.DefaultCfnApplicationProps, props.kinesisAnalyticsProps);
    kinesisAnalyticsProps.inputs[0].kinesisFirehoseInput = {
        resourceArn: props.kinesisFirehose.attrArn,
        roleArn: analyticsRole.roleArn
    };
    // Setup the Kinesis application and add dependencies
    const kinesisAnalyticsApp = new kinesisAnalytics.CfnApplication(scope, 'KinesisAnalytics', kinesisAnalyticsProps);
    kinesisAnalyticsApp.addDependsOn(analyticsPolicy.node.findChild('Resource'));
    // Create the application and return
    return kinesisAnalyticsApp;
}
exports.buildKinesisAnalyticsApp = buildKinesisAnalyticsApp;
//# sourceMappingURL=data:application/json;base64,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