import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [amplifybackend](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsamplifyadmin.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Amplifybackend extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [amplifybackend](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsamplifyadmin.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to clone an existing Amplify Admin backend environment into a new Amplify Admin backend enviroment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-environments-backendenvironmentname-clone.html#CloneBackend
     */
    toCloneBackend(): this;
    /**
     * Grants permission to create a new Amplify Admin backend environment by Amplify appId
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend.html#CreateBackend
     */
    toCreateBackend(): this;
    /**
     * Grants permission to create an API for an existing Amplify Admin backend environment by appId and backendEnvironmentName
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-api.html#CreateBackendAPI
     */
    toCreateBackendAPI(): this;
    /**
     * Grants permission to create an auth resource for an existing Amplify Admin backend environment by appId and backendEnvironmentName
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-auth.html#CreateBackendAuth
     */
    toCreateBackendAuth(): this;
    /**
     * Grants permission to create a new Amplify Admin backend config by Amplify appId
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-config.html#CreateBackendConfig
     */
    toCreateBackendConfig(): this;
    /**
     * Grants permission to create a backend storage resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-storage.html#CreateBackendStorage
     */
    toCreateBackendStorage(): this;
    /**
     * Grants permission to create an Amplify Admin challenge token by appId
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-challenge.html#CreateToken
     */
    toCreateToken(): this;
    /**
     * Grants permission to delete an existing Amplify Admin backend environment by appId and backendEnvironmentName
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-environments-backendenvironmentname-remove.html#DeleteBackend
     */
    toDeleteBackend(): this;
    /**
     * Grants permission to delete an API of an existing Amplify Admin backend environment by appId and backendEnvironmentName
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-api-backendenvironmentname-remove.html#DeleteBackendAPI
     */
    toDeleteBackendAPI(): this;
    /**
     * Grants permission to delete an auth resource of an existing Amplify Admin backend environment by appId and backendEnvironmentName
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-auth-backendenvironmentname-remove.html#DeleteBackendAuth
     */
    toDeleteBackendAuth(): this;
    /**
     * Grants permission to delete a backend storage resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-storage.html#DeleteBackendStorage
     */
    toDeleteBackendStorage(): this;
    /**
     * Grants permission to delete an Amplify Admin challenge token by appId
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-challenge-sessionid-remove.html#DeleteToken
     */
    toDeleteToken(): this;
    /**
     * Grants permission to generate models for an API of an existing Amplify Admin backend environment by appId and backendEnvironmentName
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-api-backendenvironmentname-generatemodels.html#GenerateBackendAPIModels
     */
    toGenerateBackendAPIModels(): this;
    /**
     * Grants permission to retrieve an existing Amplify Admin backend environment by appId and backendEnvironmentName
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-details.html#GetBackend
     */
    toGetBackend(): this;
    /**
     * Grants permission to retrieve an API of an existing Amplify Admin backend environment by appId and backendEnvironmentName
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-api-backendenvironmentname-details.html#GetBackendAPI
     */
    toGetBackendAPI(): this;
    /**
     * Grants permission to retrieve models for an API of an existing Amplify Admin backend environment by appId and backendEnvironmentName
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-api-backendenvironmentname-getmodels.html#GetBackendAPIModels
     */
    toGetBackendAPIModels(): this;
    /**
     * Grants permission to retrieve an auth resource of an existing Amplify Admin backend environment by appId and backendEnvironmentName
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-auth-backendenvironmentname-details.html#GetBackendAuth
     */
    toGetBackendAuth(): this;
    /**
     * Grants permission to retrieve a job of an existing Amplify Admin backend environment by appId and backendEnvironmentName
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-job-backendenvironmentname-jobid.html#GetBackendJob
     */
    toGetBackendJob(): this;
    /**
     * Grants permission to retrieve an existing backend storage resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-storage.html#GetBackendStorage
     */
    toGetBackendStorage(): this;
    /**
     * Grants permission to retrieve an Amplify Admin challenge token by appId
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-challenge-sessionid.html#GetToken
     */
    toGetToken(): this;
    /**
     * Grants permission to import an existing auth resource of an Amplify Admin backend environment by appId and backendEnvironmentName
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-auth-backendenvironmentname.html#ImportBackendAuth
     */
    toImportBackendAuth(): this;
    /**
     * Grants permission to import an existing backend storage resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-storage.html#ImportBackendStorage
     */
    toImportBackendStorage(): this;
    /**
     * Grants permission to retrieve the jobs of an existing Amplify Admin backend environment by appId and backendEnvironmentName
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-job-backendenvironmentname.html#ListBackendJobs
     */
    toListBackendJobs(): this;
    /**
     * Grants permission to retrieve s3 buckets
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-storage.html#ListS3Buckets
     */
    toListS3Buckets(): this;
    /**
     * Grants permission to delete all existing Amplify Admin backend environments by appId
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-remove.html#RemoveAllBackends
     */
    toRemoveAllBackends(): this;
    /**
     * Grants permission to delete an Amplify Admin backend config by Amplify appId
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-config-remove.html#RemoveBackendConfig
     */
    toRemoveBackendConfig(): this;
    /**
     * Grants permission to update an API of an existing Amplify Admin backend environment by appId and backendEnvironmentName
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-api-backendenvironmentname.html#UpdateBackendAPI
     */
    toUpdateBackendAPI(): this;
    /**
     * Grants permission to update an auth resource of an existing Amplify Admin backend environment by appId and backendEnvironmentName
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-auth-backendenvironmentname.html#UpdateBackendAuth
     */
    toUpdateBackendAuth(): this;
    /**
     * Grants permission to update an Amplify Admin backend config by Amplify appId
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-config-update.html#UpdateBackendConfig
     */
    toUpdateBackendConfig(): this;
    /**
     * Grants permission to update a job of an existing Amplify Admin backend environment by appId and backendEnvironmentName
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-job-backendenvironmentname-jobid.html#UpdateBackendJob
     */
    toUpdateBackendJob(): this;
    /**
     * Grants permission to update a backend storage resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-storage.html#UpdateBackendStorage
     */
    toUpdateBackendStorage(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type backend to the statement
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend.html
     *
     * @param appId - Identifier for the appId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onBackend(appId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type environment to the statement
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-api-backendenvironmentname-details.html
     *
     * @param appId - Identifier for the appId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onEnvironment(appId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type api to the statement
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-api.html
     *
     * @param appId - Identifier for the appId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onApi(appId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type auth to the statement
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-auth.html
     *
     * @param appId - Identifier for the appId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onAuth(appId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type job to the statement
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-job-backendenvironmentname.html
     *
     * @param appId - Identifier for the appId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onJob(appId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type config to the statement
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-config.html
     *
     * @param appId - Identifier for the appId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onConfig(appId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type token to the statement
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-token.html
     *
     * @param appId - Identifier for the appId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onToken(appId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type storage to the statement
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-storage.html
     *
     * @param appId - Identifier for the appId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onStorage(appId: string, account?: string, region?: string, partition?: string): this;
}
//# sourceMappingURL=amplifyadmin.d.ts.map