"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Discovery = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [discovery](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsapplicationdiscoveryservice.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Discovery extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [discovery](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsapplicationdiscoveryservice.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'discovery';
        this.accessLevelList = {
            Write: [
                'AssociateConfigurationItemsToApplication',
                'BatchDeleteImportData',
                'CreateApplication',
                'DeleteApplications',
                'DisassociateConfigurationItemsFromApplication',
                'ExportConfigurations',
                'StartContinuousExport',
                'StartDataCollectionByAgentIds',
                'StartExportTask',
                'StartImportTask',
                'StopContinuousExport',
                'StopDataCollectionByAgentIds',
                'UpdateApplication'
            ],
            Tagging: [
                'CreateTags',
                'DeleteTags'
            ],
            Read: [
                'DescribeAgents',
                'DescribeConfigurations',
                'DescribeContinuousExports',
                'DescribeExportConfigurations',
                'DescribeExportTasks',
                'DescribeTags',
                'GetDiscoverySummary',
                'GetNetworkConnectionGraph'
            ],
            List: [
                'DescribeImportTasks',
                'ListConfigurations',
                'ListServerNeighbors'
            ]
        };
    }
    /**
     * Grants permission to AssociateConfigurationItemsToApplication API. AssociateConfigurationItemsToApplication associates one or more configuration items with an application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_AssociateConfigurationItemsToApplication.html
     */
    toAssociateConfigurationItemsToApplication() {
        return this.to('AssociateConfigurationItemsToApplication');
    }
    /**
     * Grants permission to BatchDeleteImportData API. BatchDeleteImportData deletes one or more Migration Hub import tasks, each identified by their import ID. Each import task has a number of records, which can identify servers or applications
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_BatchDeleteImportData.html
     */
    toBatchDeleteImportData() {
        return this.to('BatchDeleteImportData');
    }
    /**
     * Grants permission to CreateApplication API. CreateApplication creates an application with the given name and description
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_CreateApplication.html
     */
    toCreateApplication() {
        return this.to('CreateApplication');
    }
    /**
     * Grants permission to CreateTags API. CreateTags creates one or more tags for configuration items. Tags are metadata that help you categorize IT assets. This API accepts a list of multiple configuration items
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_CreateTags.html
     */
    toCreateTags() {
        return this.to('CreateTags');
    }
    /**
     * Grants permission to DeleteApplications API. DeleteApplications deletes a list of applications and their associations with configuration items
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DeleteApplications.html
     */
    toDeleteApplications() {
        return this.to('DeleteApplications');
    }
    /**
     * Grants permission to DeleteTags API. DeleteTags deletes the association between configuration items and one or more tags. This API accepts a list of multiple configuration items
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DeleteTags.html
     */
    toDeleteTags() {
        return this.to('DeleteTags');
    }
    /**
     * Grants permission to DescribeAgents API. DescribeAgents lists agents or the Connector by ID or lists all agents/Connectors associated with your user account if you did not specify an ID
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeAgents.html
     */
    toDescribeAgents() {
        return this.to('DescribeAgents');
    }
    /**
     * Grants permission to DescribeConfigurations API. DescribeConfigurations retrieves attributes for a list of configuration item IDs. All of the supplied IDs must be for the same asset type (server, application, process, or connection). Output fields are specific to the asset type selected. For example, the output for a server configuration item includes a list of attributes about the server, such as host name, operating system, and number of network cards
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeConfigurations.html
     */
    toDescribeConfigurations() {
        return this.to('DescribeConfigurations');
    }
    /**
     * Grants permission to DescribeContinuousExports API. DescribeContinuousExports lists exports as specified by ID. All continuous exports associated with your user account can be listed if you call DescribeContinuousExports as is without passing any parameters
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeContinuousExports.html
     */
    toDescribeContinuousExports() {
        return this.to('DescribeContinuousExports');
    }
    /**
     * Grants permission to DescribeExportConfigurations API. DescribeExportConfigurations retrieves the status of a given export process. You can retrieve status from a maximum of 100 processes
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeExportConfigurations.html
     */
    toDescribeExportConfigurations() {
        return this.to('DescribeExportConfigurations');
    }
    /**
     * Grants permission to DescribeExportTasks API. DescribeExportTasks retrieve status of one or more export tasks. You can retrieve the status of up to 100 export tasks
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeExportTasks.html
     */
    toDescribeExportTasks() {
        return this.to('DescribeExportTasks');
    }
    /**
     * Grants permission to DescribeImportTasks API. DescribeImportTasks returns an array of import tasks for your account, including status information, times, IDs, the Amazon S3 Object URL for the import file, and more
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeImportTasks.html
     */
    toDescribeImportTasks() {
        return this.to('DescribeImportTasks');
    }
    /**
     * Grants permission to DescribeTags API. DescribeTags retrieves a list of configuration items that are tagged with a specific tag. Or retrieves a list of all tags assigned to a specific configuration item
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeTags.html
     */
    toDescribeTags() {
        return this.to('DescribeTags');
    }
    /**
     * Grants permission to DisassociateConfigurationItemsFromApplication API. DisassociateConfigurationItemsFromApplication disassociates one or more configuration items from an application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DisassociateConfigurationItemsFromApplication.html
     */
    toDisassociateConfigurationItemsFromApplication() {
        return this.to('DisassociateConfigurationItemsFromApplication');
    }
    /**
     * Grants permission to ExportConfigurations API. ExportConfigurations exports all discovered configuration data to an Amazon S3 bucket or an application that enables you to view and evaluate the data. Data includes tags and tag associations, processes, connections, servers, and system performance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_ExportConfigurations.html
     */
    toExportConfigurations() {
        return this.to('ExportConfigurations');
    }
    /**
     * Grants permission to GetDiscoverySummary API. GetDiscoverySummary retrieves a short summary of discovered assets
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_GetDiscoverySummary.html
     */
    toGetDiscoverySummary() {
        return this.to('GetDiscoverySummary');
    }
    /**
     * Grants permission to GetNetworkConnectionGraph API. GetNetworkConnectionGraph accepts input list of one of - Ip Addresses, server ids or node ids. Returns a list of nodes and edges which help customer visualize network connection graph. This API is used for visualize network graph functionality in MigrationHub console
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_GetNetworkConnectionGraph.html
     */
    toGetNetworkConnectionGraph() {
        return this.to('GetNetworkConnectionGraph');
    }
    /**
     * Grants permission to ListConfigurations API. ListConfigurations retrieves a list of configuration items according to criteria you specify in a filter. The filter criteria identify relationship requirements
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_ListConfigurations.html
     */
    toListConfigurations() {
        return this.to('ListConfigurations');
    }
    /**
     * Grants permission to ListServerNeighbors API. ListServerNeighbors retrieves a list of servers which are one network hop away from a specified server
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_ListServerNeighbors.html
     */
    toListServerNeighbors() {
        return this.to('ListServerNeighbors');
    }
    /**
     * Grants permission to StartContinuousExport API. StartContinuousExport start the continuous flow of agent's discovered data into Amazon Athena
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:AttachRolePolicy
     * - iam:CreatePolicy
     * - iam:CreateRole
     * - iam:CreateServiceLinkedRole
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_StartContinuousExport.html
     */
    toStartContinuousExport() {
        return this.to('StartContinuousExport');
    }
    /**
     * Grants permission to StartDataCollectionByAgentIds API. StartDataCollectionByAgentIds instructs the specified agents or Connectors to start collecting data
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_StartDataCollectionByAgentIds.html
     */
    toStartDataCollectionByAgentIds() {
        return this.to('StartDataCollectionByAgentIds');
    }
    /**
     * Grants permission to StartExportTask API. StartExportTask export the configuration data about discovered configuration items and relationships to an S3 bucket in a specified format
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_StartExportTask.html
     */
    toStartExportTask() {
        return this.to('StartExportTask');
    }
    /**
     * Grants permission to StartImportTask API. StartImportTask starts an import task. The Migration Hub import feature allows you to import details of your on-premises environment directly into AWS without having to use the Application Discovery Service (ADS) tools such as the Discovery Connector or Discovery Agent. This gives you the option to perform migration assessment and planning directly from your imported data including the ability to group your devices as applications and track their migration status
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - discovery:AssociateConfigurationItemsToApplication
     * - discovery:CreateApplication
     * - discovery:CreateTags
     * - discovery:ListConfigurations
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_StartImportTask.html
     */
    toStartImportTask() {
        return this.to('StartImportTask');
    }
    /**
     * Grants permission to StopContinuousExport API. StopContinuousExport stops the continuous flow of agent's discovered data into Amazon Athena
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_StopContinuousExport.html
     */
    toStopContinuousExport() {
        return this.to('StopContinuousExport');
    }
    /**
     * Grants permission to StopDataCollectionByAgentIds API. StopDataCollectionByAgentIds instructs the specified agents or Connectors to stop collecting data
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_StopDataCollectionByAgentIds.html
     */
    toStopDataCollectionByAgentIds() {
        return this.to('StopDataCollectionByAgentIds');
    }
    /**
     * Grants permission to UpdateApplication API. UpdateApplication updates metadata about an application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_UpdateApplication.html
     */
    toUpdateApplication() {
        return this.to('UpdateApplication');
    }
}
exports.Discovery = Discovery;
_a = JSII_RTTI_SYMBOL_1;
Discovery[_a] = { fqn: "iam-floyd.Discovery", version: "0.376.0" };
//# sourceMappingURL=data:application/json;base64,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