import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [dbqms](https://docs.aws.amazon.com/service-authorization/latest/reference/list_databasequerymetadataservice.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Dbqms extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [dbqms](https://docs.aws.amazon.com/service-authorization/latest/reference/list_databasequerymetadataservice.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to create a new favorite query
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#CreateFavoriteQuery
     */
    toCreateFavoriteQuery(): this;
    /**
     * Grants permission to add a query to the history
     *
     * Access Level: Write
     */
    toCreateQueryHistory(): this;
    /**
     * Grants permission to create a new query tab
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#CreateTab
     */
    toCreateTab(): this;
    /**
     * Grants permission to delete saved queries
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#DeleteFavoriteQueries
     */
    toDeleteFavoriteQueries(): this;
    /**
     * Grants permission to delete a historical query
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#DeleteQueryHistory
     */
    toDeleteQueryHistory(): this;
    /**
     * Grants permission to delete query tab
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#DeleteTab
     */
    toDeleteTab(): this;
    /**
     * Grants permission to list saved queries and associated metadata
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#DescribeFavoriteQueries
     */
    toDescribeFavoriteQueries(): this;
    /**
     * Grants permission to list history of queries that were run
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#DescribeQueryHistory
     */
    toDescribeQueryHistory(): this;
    /**
     * Grants permission to list query tabs and associated metadata
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#DescribeTabs
     */
    toDescribeTabs(): this;
    /**
     * Grants permission to retrieve favorite or history query string by id
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#GetQueryString
     */
    toGetQueryString(): this;
    /**
     * Grants permission to update saved query and description
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#UpdateFavoriteQuery
     */
    toUpdateFavoriteQuery(): this;
    /**
     * Grants permission to update the query history
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#UpdateQueryHistory
     */
    toUpdateQueryHistory(): this;
    /**
     * Grants permission to update query tab
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#UpdateTab
     */
    toUpdateTab(): this;
    protected accessLevelList: AccessLevelList;
}
//# sourceMappingURL=databasequerymetadataservice.d.ts.map