import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [memorydb](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmemorydb.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Memorydb extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [memorydb](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmemorydb.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permissions to apply service updates
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * Dependent actions:
     * - ec2:CreateNetworkInterface
     * - ec2:DeleteNetworkInterface
     * - ec2:DescribeNetworkInterfaces
     * - ec2:DescribeSubnets
     * - ec2:DescribeVpcs
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_BatchUpdateClusters.html
     */
    toBatchUpdateClusters(): this;
    /**
     * Grants permissions to make a copy of an existing snapshot
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - memorydb:TagResource
     * - s3:DeleteObject
     * - s3:GetBucketAcl
     * - s3:PutObject
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_CopySnapshot.html
     */
    toCopySnapshot(): this;
    /**
     * Grants permissions to create a new access control list
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - memorydb:TagResource
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_CreateAcl.html
     */
    toCreateAcl(): this;
    /**
     * Grants permissions to create a cluster
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - ec2:CreateNetworkInterface
     * - ec2:DeleteNetworkInterface
     * - ec2:DescribeNetworkInterfaces
     * - ec2:DescribeSubnets
     * - ec2:DescribeVpcs
     * - memorydb:TagResource
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_CreateCluster.html
     */
    toCreateCluster(): this;
    /**
     * Grants permissions to create a new parameter group
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - memorydb:TagResource
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_CreateParameterGroup.html
     */
    toCreateParameterGroup(): this;
    /**
     * Grants permissions to create a backup of a cluster at the current point in time
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - memorydb:TagResource
     * - s3:DeleteObject
     * - s3:GetBucketAcl
     * - s3:PutObject
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_CreateSnapshot.html
     */
    toCreateSnapshot(): this;
    /**
     * Grants permissions to create a new subnet group
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - memorydb:TagResource
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_CreateSubnetGroup.html
     */
    toCreateSubnetGroup(): this;
    /**
     * Grants permissions to create a new user
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - memorydb:TagResource
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_CreateUser.html
     */
    toCreateUser(): this;
    /**
     * Grants permissions to delete an access control list
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_DeleteAcl.html
     */
    toDeleteAcl(): this;
    /**
     * Grants permissions to delete a previously provisioned cluster
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * Dependent actions:
     * - ec2:CreateNetworkInterface
     * - ec2:DeleteNetworkInterface
     * - ec2:DescribeNetworkInterfaces
     * - ec2:DescribeSubnets
     * - ec2:DescribeVpcs
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_DeleteCluster.html
     */
    toDeleteCluster(): this;
    /**
     * Grants permissions to delete a parameter group
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_DeleteParameterGroup.html
     */
    toDeleteParameterGroup(): this;
    /**
     * Grants permissions to delete a snapshot
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_DeleteSnapshot.html
     */
    toDeleteSnapshot(): this;
    /**
     * Grants permissions to delete a subnet group
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * Dependent actions:
     * - ec2:CreateNetworkInterface
     * - ec2:DeleteNetworkInterface
     * - ec2:DescribeNetworkInterfaces
     * - ec2:DescribeSubnets
     * - ec2:DescribeVpcs
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_DeleteSubnetGroup.html
     */
    toDeleteSubnetGroup(): this;
    /**
     * Grants permissions to delete a user
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_DeleteUser.html
     */
    toDeleteUser(): this;
    /**
     * Grants permissions to retrieve information about access control lists
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_DescribeAcls.html
     */
    toDescribeAcls(): this;
    /**
     * Grants permissions to retrieve information about all provisioned clusters if no cluster identifier is specified, or about a specific cluster if a cluster identifier is supplied
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_DescribeClusters.html
     */
    toDescribeClusters(): this;
    /**
     * Grants permissions to list of the available engines and their versions
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_DescribeEngineVersions.html
     */
    toDescribeEngineVersions(): this;
    /**
     * Grants permissions to retrieve events related to clusters, subnet groups, and parameter groups
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_DescribeEvents.html
     */
    toDescribeEvents(): this;
    /**
     * Grants permissions to retrieve information about parameter groups
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_DescribeParameterGroups.html
     */
    toDescribeParameterGroups(): this;
    /**
     * Grants permissions to retrieve a detailed parameter list for a particular parameter group
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_DescribeParameters.html
     */
    toDescribeParameters(): this;
    /**
     * Grants permissions to retrieve details of the service updates
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_DescribeServiceUpdates.html
     */
    toDescribeServiceUpdates(): this;
    /**
     * Grants permissions to retrieve information about cluster snapshots
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_DescribeSnapshots.html
     */
    toDescribeSnapshots(): this;
    /**
     * Grants permissions to retrieve a list of subnet group
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_DescribeSubnetGroups.html
     */
    toDescribeSubnetGroups(): this;
    /**
     * Grants permissions to retrieve information about users
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_DescribeUsers.html
     */
    toDescribeUsers(): this;
    /**
     * Grants permissions to test automatic failover on a specified shard in a cluster
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * Dependent actions:
     * - ec2:CreateNetworkInterface
     * - ec2:DeleteNetworkInterface
     * - ec2:DescribeNetworkInterfaces
     * - ec2:DescribeSubnets
     * - ec2:DescribeVpcs
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_FailoverShard.html
     */
    toFailoverShard(): this;
    /**
     * Grants permissions to list available node type updates
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_ListNodeTypeUpdates.html
     */
    toListNodeTypeUpdates(): this;
    /**
     * Grants permissions to list cost allocation tags
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_ListTags.html
     */
    toListTags(): this;
    /**
     * Grants permissions to modify the parameters of a parameter group to the engine or system default value
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_ResetParameterGroup.html
     */
    toResetParameterGroup(): this;
    /**
     * Grants permissions to add up to 10 cost allocation tags to the named resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permissions to remove the tags identified by the TagKeys list from a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permissions to update an access control list
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_UpdateAcl.html
     */
    toUpdateAcl(): this;
    /**
     * Grants permissions to update the settings for a cluster
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * Dependent actions:
     * - ec2:CreateNetworkInterface
     * - ec2:DeleteNetworkInterface
     * - ec2:DescribeNetworkInterfaces
     * - ec2:DescribeSubnets
     * - ec2:DescribeVpcs
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_UpdateCluster.html
     */
    toUpdateCluster(): this;
    /**
     * Grants permissions to update parameters in a parameter group
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_UpdateParameterGroup.html
     */
    toUpdateParameterGroup(): this;
    /**
     * Grants permissions to update a subnet group
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_UpdateSubnetGroup.html
     */
    toUpdateSubnetGroup(): this;
    /**
     * Grants permissions to update a user
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_UpdateUser.html
     */
    toUpdateUser(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type parametergroup to the statement
     *
     * https://docs.aws.amazon.com/memorydb/latest/devguide/WhatIs.Components.html
     *
     * @param parameterGroupName - Identifier for the parameterGroupName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onParametergroup(parameterGroupName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type subnetgroup to the statement
     *
     * https://docs.aws.amazon.com/memorydb/latest/devguide/WhatIs.Components.html
     *
     * @param subnetGroupName - Identifier for the subnetGroupName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onSubnetgroup(subnetGroupName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type cluster to the statement
     *
     * https://docs.aws.amazon.com/memorydb/latest/devguide/WhatIs.Components.html
     *
     * @param clusterName - Identifier for the clusterName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onCluster(clusterName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type snapshot to the statement
     *
     * https://docs.aws.amazon.com/memorydb/latest/devguide/WhatIs.Components.html
     *
     * @param snapshotName - Identifier for the snapshotName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onSnapshot(snapshotName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type user to the statement
     *
     * https://docs.aws.amazon.com/memorydb/latest/devguide/WhatIs.Components.html
     *
     * @param userName - Identifier for the userName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onUser(userName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type acl to the statement
     *
     * https://docs.aws.amazon.com/memorydb/latest/devguide/WhatIs.Components.html
     *
     * @param aclName - Identifier for the aclName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onAcl(aclName: string, account?: string, region?: string, partition?: string): this;
}
//# sourceMappingURL=memorydb.d.ts.map