import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [mobileanalytics](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmobileanalytics.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Mobileanalytics extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [mobileanalytics](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmobileanalytics.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grant access to financial metrics for an app
     *
     * Access Level: Read
     */
    toGetFinancialReports(): this;
    /**
     * Grant access to standard metrics for an app
     *
     * Access Level: Read
     */
    toGetReports(): this;
    /**
     * The PutEvents operation records one or more events
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mobileanalytics/latest/ug/PutEvents.html
     */
    toPutEvents(): this;
    protected accessLevelList: AccessLevelList;
}
//# sourceMappingURL=mobileanalytics.d.ts.map