import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement, Operator } from '../shared';
/**
 * Statement provider for service [redshift-data](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonredshiftdataapi.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class RedshiftData extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [redshift-data](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonredshiftdataapi.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to execute multiple queries under a single connection.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/redshift-data/latest/APIReference/API_BatchExecuteStatement.html
     */
    toBatchExecuteStatement(): this;
    /**
     * Grants permission to cancel a running query
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifStatementOwnerIamUserid()
     *
     * https://docs.aws.amazon.com/redshift-data/latest/APIReference/API_CancelStatement.html
     */
    toCancelStatement(): this;
    /**
     * Grants permission to retrieve detailed information about a statement execution
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifStatementOwnerIamUserid()
     *
     * https://docs.aws.amazon.com/redshift-data/latest/APIReference/API_DescribeStatement.html
     */
    toDescribeStatement(): this;
    /**
     * Grants permission to retrieve metadata about a particular table
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/redshift-data/latest/APIReference/API_DescribeTable.html
     */
    toDescribeTable(): this;
    /**
     * Grants permission to execute a query
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/redshift-data/latest/APIReference/API_ExecuteStatement.html
     */
    toExecuteStatement(): this;
    /**
     * Grants permission to fetch the result of a query
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifStatementOwnerIamUserid()
     *
     * https://docs.aws.amazon.com/redshift-data/latest/APIReference/API_GetStatementResult.html
     */
    toGetStatementResult(): this;
    /**
     * Grants permission to list databases for a given cluster
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/redshift-data/latest/APIReference/API_ListDatabases.html
     */
    toListDatabases(): this;
    /**
     * Grants permission to list schemas for a given cluster
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/redshift-data/latest/APIReference/API_ListSchemas.html
     */
    toListSchemas(): this;
    /**
     * Grants permission to list queries for a given principal
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifStatementOwnerIamUserid()
     *
     * https://docs.aws.amazon.com/redshift-data/latest/APIReference/API_ListStatements.html
     */
    toListStatements(): this;
    /**
     * Grants permission to list tables for a given cluster
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/redshift-data/latest/APIReference/API_ListTables.html
     */
    toListTables(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type cluster to the statement
     *
     * https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html
     *
     * @param clusterName - Identifier for the clusterName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onCluster(clusterName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by statement owner iam userid
     *
     * https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-overview.html#redshift-policy-resources.conditions
     *
     * Applies to actions:
     * - .toCancelStatement()
     * - .toDescribeStatement()
     * - .toGetStatementResult()
     * - .toListStatements()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifStatementOwnerIamUserid(value: string | string[], operator?: Operator | string): this;
}
//# sourceMappingURL=redshiftdataapi.d.ts.map