import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface BigqueryDatasetAccessAConfig extends cdktf.TerraformMetaArguments {
    /**
     * A unique ID for this dataset, without the project name.
     *
     * The ID
     * must contain only letters (a-z, A-Z), numbers (0-9), or
     * underscores (_). The maximum length is 1,024 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access.html#dataset_id BigqueryDatasetAccessA#dataset_id}
     *
     * @stability stable
     */
    readonly datasetId: string;
    /**
     * A domain to grant access to. Any users signed in with the domain specified will be granted the specified access.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access.html#domain BigqueryDatasetAccessA#domain}
     *
     * @stability stable
     */
    readonly domain?: string;
    /**
     * An email address of a Google Group to grant access to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access.html#group_by_email BigqueryDatasetAccessA#group_by_email}
     *
     * @stability stable
     */
    readonly groupByEmail?: string;
    /**
     * Some other type of member that appears in the IAM Policy but isn't a user, group, domain, or special group.
     *
     * For example: 'allUsers'
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access.html#iam_member BigqueryDatasetAccessA#iam_member}
     *
     * @stability stable
     */
    readonly iamMember?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access.html#project BigqueryDatasetAccessA#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * Describes the rights granted to the user specified by the other member of the access object.
     *
     * Basic, predefined, and custom roles are
     * supported. Predefined roles that have equivalent basic roles are
     * swapped by the API to their basic counterparts, and will show a diff
     * post-create. See
     * [official docs](https://cloud.google.com/bigquery/docs/access-control).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access.html#role BigqueryDatasetAccessA#role}
     *
     * @stability stable
     */
    readonly role?: string;
    /**
     * A special group to grant access to. Possible values include:.
     *
     * 'projectOwners': Owners of the enclosing project.
     *
     *
     * 'projectReaders': Readers of the enclosing project.
     *
     *
     * 'projectWriters': Writers of the enclosing project.
     *
     *
     * 'allAuthenticatedUsers': All authenticated BigQuery users.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access.html#special_group BigqueryDatasetAccessA#special_group}
     *
     * @stability stable
     */
    readonly specialGroup?: string;
    /**
     * An email address of a user to grant access to. For example: fred@example.com.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access.html#user_by_email BigqueryDatasetAccessA#user_by_email}
     *
     * @stability stable
     */
    readonly userByEmail?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access.html#timeouts BigqueryDatasetAccessA#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: BigqueryDatasetAccessTimeouts;
    /**
     * view block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access.html#view BigqueryDatasetAccessA#view}
     *
     * @stability stable
     */
    readonly view?: BigqueryDatasetAccessViewA;
}
/**
 * @stability stable
 */
export interface BigqueryDatasetAccessTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access.html#create BigqueryDatasetAccessA#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access.html#delete BigqueryDatasetAccessA#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
/**
 * @stability stable
 */
export declare class BigqueryDatasetAccessTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface BigqueryDatasetAccessViewA {
    /**
     * The ID of the dataset containing this table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access.html#dataset_id BigqueryDatasetAccessA#dataset_id}
     *
     * @stability stable
     */
    readonly datasetId: string;
    /**
     * The ID of the project containing this table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access.html#project_id BigqueryDatasetAccessA#project_id}
     *
     * @stability stable
     */
    readonly projectId: string;
    /**
     * The ID of the table.
     *
     * The ID must contain only letters (a-z,
     * A-Z), numbers (0-9), or underscores (_). The maximum length
     * is 1,024 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access.html#table_id BigqueryDatasetAccessA#table_id}
     *
     * @stability stable
     */
    readonly tableId: string;
}
/**
 * @stability stable
 */
export declare class BigqueryDatasetAccessViewAOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _datasetId?;
    /**
     * @stability stable
     */
    get datasetId(): string;
    /**
     * @stability stable
     */
    set datasetId(value: string);
    /**
     * @stability stable
     */
    get datasetIdInput(): string | undefined;
    private _projectId?;
    /**
     * @stability stable
     */
    get projectId(): string;
    /**
     * @stability stable
     */
    set projectId(value: string);
    /**
     * @stability stable
     */
    get projectIdInput(): string | undefined;
    private _tableId?;
    /**
     * @stability stable
     */
    get tableId(): string;
    /**
     * @stability stable
     */
    set tableId(value: string);
    /**
     * @stability stable
     */
    get tableIdInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access.html google_bigquery_dataset_access}.
 *
 * @stability stable
 */
export declare class BigqueryDatasetAccessA extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access.html google_bigquery_dataset_access} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: BigqueryDatasetAccessAConfig);
    /**
     * @stability stable
     */
    get apiUpdatedMember(): any;
    private _datasetId?;
    /**
     * @stability stable
     */
    get datasetId(): string;
    /**
     * @stability stable
     */
    set datasetId(value: string);
    /**
     * @stability stable
     */
    get datasetIdInput(): string | undefined;
    private _domain?;
    /**
     * @stability stable
     */
    get domain(): string | undefined;
    /**
     * @stability stable
     */
    set domain(value: string | undefined);
    /**
     * @stability stable
     */
    resetDomain(): void;
    /**
     * @stability stable
     */
    get domainInput(): string | undefined;
    private _groupByEmail?;
    /**
     * @stability stable
     */
    get groupByEmail(): string | undefined;
    /**
     * @stability stable
     */
    set groupByEmail(value: string | undefined);
    /**
     * @stability stable
     */
    resetGroupByEmail(): void;
    /**
     * @stability stable
     */
    get groupByEmailInput(): string | undefined;
    private _iamMember?;
    /**
     * @stability stable
     */
    get iamMember(): string | undefined;
    /**
     * @stability stable
     */
    set iamMember(value: string | undefined);
    /**
     * @stability stable
     */
    resetIamMember(): void;
    /**
     * @stability stable
     */
    get iamMemberInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string | undefined;
    /**
     * @stability stable
     */
    set project(value: string | undefined);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _role?;
    /**
     * @stability stable
     */
    get role(): string | undefined;
    /**
     * @stability stable
     */
    set role(value: string | undefined);
    /**
     * @stability stable
     */
    resetRole(): void;
    /**
     * @stability stable
     */
    get roleInput(): string | undefined;
    private _specialGroup?;
    /**
     * @stability stable
     */
    get specialGroup(): string | undefined;
    /**
     * @stability stable
     */
    set specialGroup(value: string | undefined);
    /**
     * @stability stable
     */
    resetSpecialGroup(): void;
    /**
     * @stability stable
     */
    get specialGroupInput(): string | undefined;
    private _userByEmail?;
    /**
     * @stability stable
     */
    get userByEmail(): string | undefined;
    /**
     * @stability stable
     */
    set userByEmail(value: string | undefined);
    /**
     * @stability stable
     */
    resetUserByEmail(): void;
    /**
     * @stability stable
     */
    get userByEmailInput(): string | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): BigqueryDatasetAccessTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: BigqueryDatasetAccessTimeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): BigqueryDatasetAccessTimeouts | undefined;
    private _view?;
    private __viewOutput;
    /**
     * @stability stable
     */
    get view(): BigqueryDatasetAccessViewAOutputReference;
    /**
     * @stability stable
     */
    putView(value: BigqueryDatasetAccessViewA | undefined): void;
    /**
     * @stability stable
     */
    resetView(): void;
    /**
     * @stability stable
     */
    get viewInput(): BigqueryDatasetAccessViewA | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
