import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataprocAutoscalingPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * The  location where the autoscaling policy should reside. The default value is 'global'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy.html#location DataprocAutoscalingPolicy#location}
     *
     * @stability stable
     */
    readonly location?: string;
    /**
     * The policy id.
     *
     * The id must contain only letters (a-z, A-Z), numbers (0-9), underscores (_),
     * and hyphens (-). Cannot begin or end with underscore or hyphen. Must consist of between
     * 3 and 50 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy.html#policy_id DataprocAutoscalingPolicy#policy_id}
     *
     * @stability stable
     */
    readonly policyId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy.html#project DataprocAutoscalingPolicy#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * basic_algorithm block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy.html#basic_algorithm DataprocAutoscalingPolicy#basic_algorithm}
     *
     * @stability stable
     */
    readonly basicAlgorithm?: DataprocAutoscalingPolicyBasicAlgorithm;
    /**
     * secondary_worker_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy.html#secondary_worker_config DataprocAutoscalingPolicy#secondary_worker_config}
     *
     * @stability stable
     */
    readonly secondaryWorkerConfig?: DataprocAutoscalingPolicySecondaryWorkerConfig;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy.html#timeouts DataprocAutoscalingPolicy#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataprocAutoscalingPolicyTimeouts;
    /**
     * worker_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy.html#worker_config DataprocAutoscalingPolicy#worker_config}
     *
     * @stability stable
     */
    readonly workerConfig?: DataprocAutoscalingPolicyWorkerConfig;
}
/**
 * @stability stable
 */
export interface DataprocAutoscalingPolicyBasicAlgorithmYarnConfig {
    /**
     * Timeout for YARN graceful decommissioning of Node Managers.
     *
     * Specifies the
     * duration to wait for jobs to complete before forcefully removing workers
     * (and potentially interrupting jobs). Only applicable to downscaling operations.
     *
     * Bounds: [0s, 1d].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy.html#graceful_decommission_timeout DataprocAutoscalingPolicy#graceful_decommission_timeout}
     *
     * @stability stable
     */
    readonly gracefulDecommissionTimeout: string;
    /**
     * Fraction of average pending memory in the last cooldown period for which to remove workers.
     *
     * A scale-down factor of 1 will result in scaling down so that there
     * is no available memory remaining after the update (more aggressive scaling).
     * A scale-down factor of 0 disables removing workers, which can be beneficial for
     * autoscaling a single job.
     *
     * Bounds: [0.0, 1.0].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy.html#scale_down_factor DataprocAutoscalingPolicy#scale_down_factor}
     *
     * @stability stable
     */
    readonly scaleDownFactor: number;
    /**
     * Minimum scale-down threshold as a fraction of total cluster size before scaling occurs.
     *
     * For example, in a 20-worker cluster, a threshold of 0.1 means the autoscaler must
     * recommend at least a 2 worker scale-down for the cluster to scale. A threshold of 0
     * means the autoscaler will scale down on any recommended change.
     *
     * Bounds: [0.0, 1.0]. Default: 0.0.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy.html#scale_down_min_worker_fraction DataprocAutoscalingPolicy#scale_down_min_worker_fraction}
     *
     * @stability stable
     */
    readonly scaleDownMinWorkerFraction?: number;
    /**
     * Fraction of average pending memory in the last cooldown period for which to add workers.
     *
     * A scale-up factor of 1.0 will result in scaling up so that there
     * is no pending memory remaining after the update (more aggressive scaling).
     * A scale-up factor closer to 0 will result in a smaller magnitude of scaling up
     * (less aggressive scaling).
     *
     * Bounds: [0.0, 1.0].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy.html#scale_up_factor DataprocAutoscalingPolicy#scale_up_factor}
     *
     * @stability stable
     */
    readonly scaleUpFactor: number;
    /**
     * Minimum scale-up threshold as a fraction of total cluster size before scaling occurs.
     *
     * For example, in a 20-worker cluster, a threshold of 0.1 means the autoscaler
     * must recommend at least a 2-worker scale-up for the cluster to scale. A threshold of
     * 0 means the autoscaler will scale up on any recommended change.
     *
     * Bounds: [0.0, 1.0]. Default: 0.0.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy.html#scale_up_min_worker_fraction DataprocAutoscalingPolicy#scale_up_min_worker_fraction}
     *
     * @stability stable
     */
    readonly scaleUpMinWorkerFraction?: number;
}
/**
 * @stability stable
 */
export declare class DataprocAutoscalingPolicyBasicAlgorithmYarnConfigOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _gracefulDecommissionTimeout?;
    /**
     * @stability stable
     */
    get gracefulDecommissionTimeout(): string;
    /**
     * @stability stable
     */
    set gracefulDecommissionTimeout(value: string);
    /**
     * @stability stable
     */
    get gracefulDecommissionTimeoutInput(): string | undefined;
    private _scaleDownFactor?;
    /**
     * @stability stable
     */
    get scaleDownFactor(): number;
    /**
     * @stability stable
     */
    set scaleDownFactor(value: number);
    /**
     * @stability stable
     */
    get scaleDownFactorInput(): number | undefined;
    private _scaleDownMinWorkerFraction?;
    /**
     * @stability stable
     */
    get scaleDownMinWorkerFraction(): number | undefined;
    /**
     * @stability stable
     */
    set scaleDownMinWorkerFraction(value: number | undefined);
    /**
     * @stability stable
     */
    resetScaleDownMinWorkerFraction(): void;
    /**
     * @stability stable
     */
    get scaleDownMinWorkerFractionInput(): number | undefined;
    private _scaleUpFactor?;
    /**
     * @stability stable
     */
    get scaleUpFactor(): number;
    /**
     * @stability stable
     */
    set scaleUpFactor(value: number);
    /**
     * @stability stable
     */
    get scaleUpFactorInput(): number | undefined;
    private _scaleUpMinWorkerFraction?;
    /**
     * @stability stable
     */
    get scaleUpMinWorkerFraction(): number | undefined;
    /**
     * @stability stable
     */
    set scaleUpMinWorkerFraction(value: number | undefined);
    /**
     * @stability stable
     */
    resetScaleUpMinWorkerFraction(): void;
    /**
     * @stability stable
     */
    get scaleUpMinWorkerFractionInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DataprocAutoscalingPolicyBasicAlgorithm {
    /**
     * Duration between scaling events. A scaling period starts after the update operation from the previous event has completed.
     *
     * Bounds: [2m, 1d]. Default: 2m.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy.html#cooldown_period DataprocAutoscalingPolicy#cooldown_period}
     *
     * @stability stable
     */
    readonly cooldownPeriod?: string;
    /**
     * yarn_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy.html#yarn_config DataprocAutoscalingPolicy#yarn_config}
     *
     * @stability stable
     */
    readonly yarnConfig: DataprocAutoscalingPolicyBasicAlgorithmYarnConfig;
}
/**
 * @stability stable
 */
export declare class DataprocAutoscalingPolicyBasicAlgorithmOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _cooldownPeriod?;
    /**
     * @stability stable
     */
    get cooldownPeriod(): string | undefined;
    /**
     * @stability stable
     */
    set cooldownPeriod(value: string | undefined);
    /**
     * @stability stable
     */
    resetCooldownPeriod(): void;
    /**
     * @stability stable
     */
    get cooldownPeriodInput(): string | undefined;
    private _yarnConfig?;
    private __yarnConfigOutput;
    /**
     * @stability stable
     */
    get yarnConfig(): DataprocAutoscalingPolicyBasicAlgorithmYarnConfigOutputReference;
    /**
     * @stability stable
     */
    putYarnConfig(value: DataprocAutoscalingPolicyBasicAlgorithmYarnConfig): void;
    /**
     * @stability stable
     */
    get yarnConfigInput(): DataprocAutoscalingPolicyBasicAlgorithmYarnConfig | undefined;
}
/**
 * @stability stable
 */
export interface DataprocAutoscalingPolicySecondaryWorkerConfig {
    /**
     * Maximum number of instances for this group.
     *
     * Note that by default, clusters will not use
     * secondary workers. Required for secondary workers if the minimum secondary instances is set.
     * Bounds: [minInstances, ). Defaults to 0.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy.html#max_instances DataprocAutoscalingPolicy#max_instances}
     *
     * @stability stable
     */
    readonly maxInstances?: number;
    /**
     * Minimum number of instances for this group. Bounds: [0, maxInstances]. Defaults to 0.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy.html#min_instances DataprocAutoscalingPolicy#min_instances}
     *
     * @stability stable
     */
    readonly minInstances?: number;
    /**
     * Weight for the instance group, which is used to determine the fraction of total workers in the cluster from this instance group.
     *
     * For example, if primary workers have weight 2,
     * and secondary workers have weight 1, the cluster will have approximately 2 primary workers
     * for each secondary worker.
     *
     * The cluster may not reach the specified balance if constrained by min/max bounds or other
     * autoscaling settings. For example, if maxInstances for secondary workers is 0, then only
     * primary workers will be added. The cluster can also be out of balance when created.
     *
     * If weight is not set on any instance group, the cluster will default to equal weight for
     * all groups: the cluster will attempt to maintain an equal number of workers in each group
     * within the configured size bounds for each group. If weight is set for one group only,
     * the cluster will default to zero weight on the unset group. For example if weight is set
     * only on primary workers, the cluster will use primary workers only and no secondary workers.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy.html#weight DataprocAutoscalingPolicy#weight}
     *
     * @stability stable
     */
    readonly weight?: number;
}
/**
 * @stability stable
 */
export declare class DataprocAutoscalingPolicySecondaryWorkerConfigOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _maxInstances?;
    /**
     * @stability stable
     */
    get maxInstances(): number | undefined;
    /**
     * @stability stable
     */
    set maxInstances(value: number | undefined);
    /**
     * @stability stable
     */
    resetMaxInstances(): void;
    /**
     * @stability stable
     */
    get maxInstancesInput(): number | undefined;
    private _minInstances?;
    /**
     * @stability stable
     */
    get minInstances(): number | undefined;
    /**
     * @stability stable
     */
    set minInstances(value: number | undefined);
    /**
     * @stability stable
     */
    resetMinInstances(): void;
    /**
     * @stability stable
     */
    get minInstancesInput(): number | undefined;
    private _weight?;
    /**
     * @stability stable
     */
    get weight(): number | undefined;
    /**
     * @stability stable
     */
    set weight(value: number | undefined);
    /**
     * @stability stable
     */
    resetWeight(): void;
    /**
     * @stability stable
     */
    get weightInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DataprocAutoscalingPolicyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy.html#create DataprocAutoscalingPolicy#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy.html#delete DataprocAutoscalingPolicy#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy.html#update DataprocAutoscalingPolicy#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * @stability stable
 */
export declare class DataprocAutoscalingPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string | undefined;
    /**
     * @stability stable
     */
    set update(value: string | undefined);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DataprocAutoscalingPolicyWorkerConfig {
    /**
     * Maximum number of instances for this group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy.html#max_instances DataprocAutoscalingPolicy#max_instances}
     *
     * @stability stable
     */
    readonly maxInstances: number;
    /**
     * Minimum number of instances for this group. Bounds: [2, maxInstances]. Defaults to 2.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy.html#min_instances DataprocAutoscalingPolicy#min_instances}
     *
     * @stability stable
     */
    readonly minInstances?: number;
    /**
     * Weight for the instance group, which is used to determine the fraction of total workers in the cluster from this instance group.
     *
     * For example, if primary workers have weight 2,
     * and secondary workers have weight 1, the cluster will have approximately 2 primary workers
     * for each secondary worker.
     *
     * The cluster may not reach the specified balance if constrained by min/max bounds or other
     * autoscaling settings. For example, if maxInstances for secondary workers is 0, then only
     * primary workers will be added. The cluster can also be out of balance when created.
     *
     * If weight is not set on any instance group, the cluster will default to equal weight for
     * all groups: the cluster will attempt to maintain an equal number of workers in each group
     * within the configured size bounds for each group. If weight is set for one group only,
     * the cluster will default to zero weight on the unset group. For example if weight is set
     * only on primary workers, the cluster will use primary workers only and no secondary workers.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy.html#weight DataprocAutoscalingPolicy#weight}
     *
     * @stability stable
     */
    readonly weight?: number;
}
/**
 * @stability stable
 */
export declare class DataprocAutoscalingPolicyWorkerConfigOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _maxInstances?;
    /**
     * @stability stable
     */
    get maxInstances(): number;
    /**
     * @stability stable
     */
    set maxInstances(value: number);
    /**
     * @stability stable
     */
    get maxInstancesInput(): number | undefined;
    private _minInstances?;
    /**
     * @stability stable
     */
    get minInstances(): number | undefined;
    /**
     * @stability stable
     */
    set minInstances(value: number | undefined);
    /**
     * @stability stable
     */
    resetMinInstances(): void;
    /**
     * @stability stable
     */
    get minInstancesInput(): number | undefined;
    private _weight?;
    /**
     * @stability stable
     */
    get weight(): number | undefined;
    /**
     * @stability stable
     */
    set weight(value: number | undefined);
    /**
     * @stability stable
     */
    resetWeight(): void;
    /**
     * @stability stable
     */
    get weightInput(): number | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy.html google_dataproc_autoscaling_policy}.
 *
 * @stability stable
 */
export declare class DataprocAutoscalingPolicy extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy.html google_dataproc_autoscaling_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataprocAutoscalingPolicyConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string | undefined;
    /**
     * @stability stable
     */
    set location(value: string | undefined);
    /**
     * @stability stable
     */
    resetLocation(): void;
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    /**
     * @stability stable
     */
    get name(): string;
    private _policyId?;
    /**
     * @stability stable
     */
    get policyId(): string;
    /**
     * @stability stable
     */
    set policyId(value: string);
    /**
     * @stability stable
     */
    get policyIdInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string | undefined;
    /**
     * @stability stable
     */
    set project(value: string | undefined);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _basicAlgorithm?;
    private __basicAlgorithmOutput;
    /**
     * @stability stable
     */
    get basicAlgorithm(): DataprocAutoscalingPolicyBasicAlgorithmOutputReference;
    /**
     * @stability stable
     */
    putBasicAlgorithm(value: DataprocAutoscalingPolicyBasicAlgorithm | undefined): void;
    /**
     * @stability stable
     */
    resetBasicAlgorithm(): void;
    /**
     * @stability stable
     */
    get basicAlgorithmInput(): DataprocAutoscalingPolicyBasicAlgorithm | undefined;
    private _secondaryWorkerConfig?;
    private __secondaryWorkerConfigOutput;
    /**
     * @stability stable
     */
    get secondaryWorkerConfig(): DataprocAutoscalingPolicySecondaryWorkerConfigOutputReference;
    /**
     * @stability stable
     */
    putSecondaryWorkerConfig(value: DataprocAutoscalingPolicySecondaryWorkerConfig | undefined): void;
    /**
     * @stability stable
     */
    resetSecondaryWorkerConfig(): void;
    /**
     * @stability stable
     */
    get secondaryWorkerConfigInput(): DataprocAutoscalingPolicySecondaryWorkerConfig | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): DataprocAutoscalingPolicyTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataprocAutoscalingPolicyTimeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataprocAutoscalingPolicyTimeouts | undefined;
    private _workerConfig?;
    private __workerConfigOutput;
    /**
     * @stability stable
     */
    get workerConfig(): DataprocAutoscalingPolicyWorkerConfigOutputReference;
    /**
     * @stability stable
     */
    putWorkerConfig(value: DataprocAutoscalingPolicyWorkerConfig | undefined): void;
    /**
     * @stability stable
     */
    resetWorkerConfig(): void;
    /**
     * @stability stable
     */
    get workerConfigInput(): DataprocAutoscalingPolicyWorkerConfig | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
