# Generated by Django 2.2.17 on 2020-12-09 11:54

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import tagging.fields
import tendenci.apps.base.fields
import tendenci.libs.tinymce.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('meta', '0001_initial'),
        ('user_groups', '0004_auto_20200902_1545'),
        ('entities', '0004_auto_20200902_1545'),
        ('pages', '0006_auto_20200902_1545'),
    ]

    operations = [
        migrations.CreateModel(
            name='Chapter',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('allow_anonymous_view', models.BooleanField(default=True, verbose_name='Public can view')),
                ('allow_user_view', models.BooleanField(default=True, verbose_name='Signed in user can view')),
                ('allow_member_view', models.BooleanField(default=True)),
                ('allow_user_edit', models.BooleanField(default=False, verbose_name='Signed in user can change')),
                ('allow_member_edit', models.BooleanField(default=False)),
                ('create_dt', models.DateTimeField(auto_now_add=True, verbose_name='Created On')),
                ('update_dt', models.DateTimeField(auto_now=True, verbose_name='Last Updated')),
                ('creator_username', models.CharField(max_length=150)),
                ('owner_username', models.CharField(max_length=150)),
                ('status', models.BooleanField(default=True, verbose_name='Active')),
                ('status_detail', models.CharField(default='active', max_length=50)),
                ('guid', models.CharField(max_length=40)),
                ('title', models.CharField(blank=True, max_length=500)),
                ('slug', tendenci.apps.base.fields.SlugField(db_index=True, max_length=100, verbose_name='URL Path')),
                ('content', tendenci.libs.tinymce.models.HTMLField()),
                ('view_contact_form', models.BooleanField(default=False)),
                ('design_notes', models.TextField(blank=True, verbose_name='Design Notes')),
                ('syndicate', models.BooleanField(default=False, verbose_name='Include in RSS feed')),
                ('template', models.CharField(blank=True, max_length=50, verbose_name='Template')),
                ('tags', tagging.fields.TagField(blank=True, max_length=255)),
                ('mission', tendenci.libs.tinymce.models.HTMLField(blank=True, null=True)),
                ('notes', tendenci.libs.tinymce.models.HTMLField(blank=True, null=True)),
                ('sponsors', tendenci.libs.tinymce.models.HTMLField(blank=True, default='')),
                ('contact_name', models.CharField(blank=True, max_length=200, null=True)),
                ('contact_email', models.CharField(blank=True, max_length=200, null=True)),
                ('join_link', models.CharField(blank=True, max_length=200, null=True)),
                ('creator', models.ForeignKey(default=None, editable=False, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='chapters_chapter_creator', to=settings.AUTH_USER_MODEL)),
                ('entity', models.OneToOneField(null=True, on_delete=django.db.models.deletion.SET_NULL, to='entities.Entity')),
                ('group', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='user_groups.Group')),
                ('header_image', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='pages.HeaderImage')),
                ('meta', models.OneToOneField(null=True, on_delete=django.db.models.deletion.SET_NULL, to='meta.Meta')),
                ('owner', models.ForeignKey(default=None, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='chapters_chapter_owner', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='Position',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=200, verbose_name='title')),
            ],
        ),
        migrations.CreateModel(
            name='Officer',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('phone', models.CharField(blank=True, max_length=50, null=True)),
                ('chapter', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='chapters.Chapter')),
                ('position', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='chapters.Position')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='chapters_officer_user', to=settings.AUTH_USER_MODEL)),
            ],
        ),
    ]
