# AUTOGENERATED! DO NOT EDIT! File to edit: 00_search.ipynb (unless otherwise specified).

__all__ = ['hubspot_search']

# Cell
# export

import os
import json
import requests
from dotenv import load_dotenv
load_dotenv()

# Cell


def hubspot_search(value, property='email', operator='EQ', hapikey=None, properties=None):
    """
    Search hubspot based on one filter condition.
    """
    if hapikey is None:
        hapikey = os.environ.get('HUBSPOT_API_KEY','demo')
    if properties is None:
        properties = ['email', 'createdate', 'firstname', 'lastname', 'lastmodifieddate', 'hs_object_id']
    url = 'https://api.hubapi.com/crm/v3/objects/contacts/search'
    querystring = {"hapikey": hapikey}
    headers = {
        "accept": "application/json",
        "Content-Type": "application/json"
    }
    data = json.dumps({
        "filterGroups": [
            {
                "filters": [
                    {
                        "propertyName": property,
                        "operator": operator,
                        "value": value
                    }
                ]
            }
        ],
        "properties" : properties
    })
    r = requests.post(url=url, data=data, headers=headers, params=querystring)
    return r.json()

