/**
 * @stability stable
 */
export declare enum JsonSchemaVersion {
    /**
     * In API Gateway models are defined using the JSON schema draft 4.
     *
     * @see https://tools.ietf.org/html/draft-zyp-json-schema-04
     * @stability stable
     */
    DRAFT4 = "http://json-schema.org/draft-04/schema#",
    /**
     * @stability stable
     */
    DRAFT7 = "http://json-schema.org/draft-07/schema#"
}
/**
 * @stability stable
 */
export declare enum JsonSchemaType {
    /**
     * @stability stable
     */
    NULL = "null",
    /**
     * @stability stable
     */
    BOOLEAN = "boolean",
    /**
     * @stability stable
     */
    OBJECT = "object",
    /**
     * @stability stable
     */
    ARRAY = "array",
    /**
     * @stability stable
     */
    NUMBER = "number",
    /**
     * @stability stable
     */
    INTEGER = "integer",
    /**
     * @stability stable
     */
    STRING = "string"
}
/**
 * Represents a JSON schema definition of the structure of a REST API model.
 *
 * Copied from npm module jsonschema.
 *
 * @see https://github.com/tdegrunt/jsonschema
 * @stability stable
 */
export interface JsonSchema {
    /**
     * @stability stable
     */
    readonly schema?: JsonSchemaVersion;
    /**
     * @stability stable
     */
    readonly id?: string;
    /**
     * @stability stable
     */
    readonly ref?: string;
    /**
     * @stability stable
     */
    readonly type?: JsonSchemaType | JsonSchemaType[];
    /**
     * @stability stable
     */
    readonly title?: string;
    /**
     * @stability stable
     */
    readonly description?: string;
    /**
     * @stability stable
     */
    readonly 'enum'?: any[];
    /**
     * The default value if you use an enum.
     *
     * @default - not set
     * @stability stable
     */
    readonly default?: any;
    /**
     * @stability stable
     */
    readonly format?: string;
    /**
     * @stability stable
     */
    readonly definitions?: {
        [name: string]: JsonSchema;
    };
    /**
     * @stability stable
     */
    readonly multipleOf?: number;
    /**
     * @stability stable
     */
    readonly maximum?: number;
    /**
     * @stability stable
     */
    readonly exclusiveMaximum?: boolean;
    /**
     * @stability stable
     */
    readonly minimum?: number;
    /**
     * @stability stable
     */
    readonly exclusiveMinimum?: boolean;
    /**
     * @stability stable
     */
    readonly maxLength?: number;
    /**
     * @stability stable
     */
    readonly minLength?: number;
    /**
     * @stability stable
     */
    readonly pattern?: string;
    /**
     * @stability stable
     */
    readonly items?: JsonSchema | JsonSchema[];
    /**
     * @stability stable
     */
    readonly additionalItems?: JsonSchema[];
    /**
     * @stability stable
     */
    readonly maxItems?: number;
    /**
     * @stability stable
     */
    readonly minItems?: number;
    /**
     * @stability stable
     */
    readonly uniqueItems?: boolean;
    /**
     * @stability stable
     */
    readonly contains?: JsonSchema | JsonSchema[];
    /**
     * @stability stable
     */
    readonly maxProperties?: number;
    /**
     * @stability stable
     */
    readonly minProperties?: number;
    /**
     * @stability stable
     */
    readonly required?: string[];
    /**
     * @stability stable
     */
    readonly properties?: {
        [name: string]: JsonSchema;
    };
    /**
     * @stability stable
     */
    readonly additionalProperties?: JsonSchema | boolean;
    /**
     * @stability stable
     */
    readonly patternProperties?: {
        [name: string]: JsonSchema;
    };
    /**
     * @stability stable
     */
    readonly dependencies?: {
        [name: string]: JsonSchema | string[];
    };
    /**
     * @stability stable
     */
    readonly propertyNames?: JsonSchema;
    /**
     * @stability stable
     */
    readonly allOf?: JsonSchema[];
    /**
     * @stability stable
     */
    readonly anyOf?: JsonSchema[];
    /**
     * @stability stable
     */
    readonly oneOf?: JsonSchema[];
    /**
     * @stability stable
     */
    readonly not?: JsonSchema;
}
