"""
    IDX API

    Welcome to the IDX API.  # noqa: E501

    The version of the OpenAPI document: v2
    Contact: support@idx.us
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from openapi_client.api_client import ApiClient, Endpoint as _Endpoint
from openapi_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from openapi_client.model.cyber_scan_exposures_get_dto import CyberScanExposuresGetDto
from openapi_client.model.cyberscan_get_dto import CyberscanGetDto
from openapi_client.model.cyberscan_hash_put_dto import CyberscanHashPutDto
from openapi_client.model.cyberscan_post_dto import CyberscanPostDto
from openapi_client.model.cyberscan_response_dto import CyberscanResponseDto
from openapi_client.model.cyberscan_summary_get_dto import CyberscanSummaryGetDto


class CyberscanApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.v1_cyberscan_member_id_data_type_hash_delete_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'OAuth'
                ],
                'endpoint_path': '/v1/cyberscan/{memberId}/{dataType}/{hash}',
                'operation_id': 'v1_cyberscan_member_id_data_type_hash_delete',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'member_id',
                    'hash',
                    'data_type',
                ],
                'required': [
                    'member_id',
                    'hash',
                    'data_type',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'member_id':
                        (str,),
                    'hash':
                        (str,),
                    'data_type':
                        (str,),
                },
                'attribute_map': {
                    'member_id': 'memberId',
                    'hash': 'hash',
                    'data_type': 'dataType',
                },
                'location_map': {
                    'member_id': 'path',
                    'hash': 'path',
                    'data_type': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.v1_cyberscan_member_id_data_type_hash_exposures_get_endpoint = _Endpoint(
            settings={
                'response_type': (CyberScanExposuresGetDto,),
                'auth': [
                    'OAuth'
                ],
                'endpoint_path': '/v1/cyberscan/{memberId}/{dataType}/{hash}/exposures',
                'operation_id': 'v1_cyberscan_member_id_data_type_hash_exposures_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'member_id',
                    'hash',
                    'data_type',
                ],
                'required': [
                    'member_id',
                    'hash',
                    'data_type',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'member_id':
                        (str,),
                    'hash':
                        (str,),
                    'data_type':
                        (str,),
                },
                'attribute_map': {
                    'member_id': 'memberId',
                    'hash': 'hash',
                    'data_type': 'dataType',
                },
                'location_map': {
                    'member_id': 'path',
                    'hash': 'path',
                    'data_type': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.v1_cyberscan_member_id_data_type_hash_put_endpoint = _Endpoint(
            settings={
                'response_type': (CyberscanResponseDto,),
                'auth': [
                    'OAuth'
                ],
                'endpoint_path': '/v1/cyberscan/{memberId}/{dataType}/{hash}',
                'operation_id': 'v1_cyberscan_member_id_data_type_hash_put',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'member_id',
                    'hash',
                    'data_type',
                    'cyberscan_hash_put_dto',
                ],
                'required': [
                    'member_id',
                    'hash',
                    'data_type',
                    'cyberscan_hash_put_dto',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'member_id':
                        (str,),
                    'hash':
                        (str,),
                    'data_type':
                        (str,),
                    'cyberscan_hash_put_dto':
                        (CyberscanHashPutDto,),
                },
                'attribute_map': {
                    'member_id': 'memberId',
                    'hash': 'hash',
                    'data_type': 'dataType',
                },
                'location_map': {
                    'member_id': 'path',
                    'hash': 'path',
                    'data_type': 'path',
                    'cyberscan_hash_put_dto': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.v1_cyberscan_member_id_get_endpoint = _Endpoint(
            settings={
                'response_type': (CyberscanGetDto,),
                'auth': [
                    'OAuth'
                ],
                'endpoint_path': '/v1/cyberscan/{memberId}',
                'operation_id': 'v1_cyberscan_member_id_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'member_id',
                ],
                'required': [
                    'member_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'member_id':
                        (str,),
                },
                'attribute_map': {
                    'member_id': 'memberId',
                },
                'location_map': {
                    'member_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.v1_cyberscan_member_id_summary_get_endpoint = _Endpoint(
            settings={
                'response_type': (CyberscanSummaryGetDto,),
                'auth': [
                    'OAuth'
                ],
                'endpoint_path': '/v1/cyberscan/{memberId}/summary',
                'operation_id': 'v1_cyberscan_member_id_summary_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'member_id',
                ],
                'required': [
                    'member_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'member_id':
                        (str,),
                },
                'attribute_map': {
                    'member_id': 'memberId',
                },
                'location_map': {
                    'member_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.v1_cyberscan_post_endpoint = _Endpoint(
            settings={
                'response_type': (CyberscanResponseDto,),
                'auth': [
                    'OAuth'
                ],
                'endpoint_path': '/v1/cyberscan',
                'operation_id': 'v1_cyberscan_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'authorization',
                    'cyberscan_post_dto',
                ],
                'required': [
                    'authorization',
                    'cyberscan_post_dto',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'authorization':
                        (str,),
                    'cyberscan_post_dto':
                        (CyberscanPostDto,),
                },
                'attribute_map': {
                    'authorization': 'Authorization',
                },
                'location_map': {
                    'authorization': 'header',
                    'cyberscan_post_dto': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def v1_cyberscan_member_id_data_type_hash_delete(
        self,
        member_id,
        hash,
        data_type,
        **kwargs
    ):
        """Delete the given cyberscan item  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1_cyberscan_member_id_data_type_hash_delete(member_id, hash, data_type, async_req=True)
        >>> result = thread.get()

        Args:
            member_id (str):
            hash (str):
            data_type (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['member_id'] = \
            member_id
        kwargs['hash'] = \
            hash
        kwargs['data_type'] = \
            data_type
        return self.v1_cyberscan_member_id_data_type_hash_delete_endpoint.call_with_http_info(**kwargs)

    def v1_cyberscan_member_id_data_type_hash_exposures_get(
        self,
        member_id,
        hash,
        data_type,
        **kwargs
    ):
        """Get exposures for the given cyberscan item  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1_cyberscan_member_id_data_type_hash_exposures_get(member_id, hash, data_type, async_req=True)
        >>> result = thread.get()

        Args:
            member_id (str):
            hash (str):
            data_type (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            CyberScanExposuresGetDto
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['member_id'] = \
            member_id
        kwargs['hash'] = \
            hash
        kwargs['data_type'] = \
            data_type
        return self.v1_cyberscan_member_id_data_type_hash_exposures_get_endpoint.call_with_http_info(**kwargs)

    def v1_cyberscan_member_id_data_type_hash_put(
        self,
        member_id,
        hash,
        data_type,
        cyberscan_hash_put_dto,
        **kwargs
    ):
        """Create or update the given cyberscan item with no value  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1_cyberscan_member_id_data_type_hash_put(member_id, hash, data_type, cyberscan_hash_put_dto, async_req=True)
        >>> result = thread.get()

        Args:
            member_id (str):
            hash (str):
            data_type (str):
            cyberscan_hash_put_dto (CyberscanHashPutDto):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            CyberscanResponseDto
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['member_id'] = \
            member_id
        kwargs['hash'] = \
            hash
        kwargs['data_type'] = \
            data_type
        kwargs['cyberscan_hash_put_dto'] = \
            cyberscan_hash_put_dto
        return self.v1_cyberscan_member_id_data_type_hash_put_endpoint.call_with_http_info(**kwargs)

    def v1_cyberscan_member_id_get(
        self,
        member_id,
        **kwargs
    ):
        """Get cyberscan data  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1_cyberscan_member_id_get(member_id, async_req=True)
        >>> result = thread.get()

        Args:
            member_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            CyberscanGetDto
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['member_id'] = \
            member_id
        return self.v1_cyberscan_member_id_get_endpoint.call_with_http_info(**kwargs)

    def v1_cyberscan_member_id_summary_get(
        self,
        member_id,
        **kwargs
    ):
        """Get the cyberscan summary  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1_cyberscan_member_id_summary_get(member_id, async_req=True)
        >>> result = thread.get()

        Args:
            member_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            CyberscanSummaryGetDto
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['member_id'] = \
            member_id
        return self.v1_cyberscan_member_id_summary_get_endpoint.call_with_http_info(**kwargs)

    def v1_cyberscan_post(
        self,
        authorization,
        cyberscan_post_dto,
        **kwargs
    ):
        """Create a new cyberscan item  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1_cyberscan_post(authorization, cyberscan_post_dto, async_req=True)
        >>> result = thread.get()

        Args:
            authorization (str):
            cyberscan_post_dto (CyberscanPostDto):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            CyberscanResponseDto
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['authorization'] = \
            authorization
        kwargs['cyberscan_post_dto'] = \
            cyberscan_post_dto
        return self.v1_cyberscan_post_endpoint.call_with_http_info(**kwargs)

