import pathlib
from util import TESTDATA_PATH


def test_structure():
    """
    Ensure "TestData" is structured properly.
    
    This essentially tests that `parse_shakespeare.py` works.
    """
    sonnets_path = TESTDATA_PATH / 'Sonnets'
    plays_path = TESTDATA_PATH / 'Plays'
    assert TESTDATA_PATH.is_dir()
    assert sonnets_path.is_dir()
    assert plays_path.is_dir()

    # Ensure all sonnets are there
    for i in range(1, 155):
        assert (sonnets_path / f'{i}.txt').is_file()

    # Ensure all plays are there, and all scenes and acts are properly saved
    assert (plays_path / 'a-lovers-complaint' / 'a-lovers-complaint.txt').is_file()

    assert make_path('a-midsummer-nights-dream', 'I', 'I').is_file()
    assert make_path('a-midsummer-nights-dream', 'I', 'II').is_file()
    assert make_path('a-midsummer-nights-dream', 'II', 'I').is_file()
    assert make_path('a-midsummer-nights-dream', 'II', 'II').is_file()
    assert make_path('a-midsummer-nights-dream', 'III', 'I').is_file()
    assert make_path('a-midsummer-nights-dream', 'III', 'II').is_file()
    assert make_path('a-midsummer-nights-dream', 'IV', 'I').is_file()
    assert make_path('a-midsummer-nights-dream', 'IV', 'II').is_file()
    assert make_path('a-midsummer-nights-dream', 'V', 'I').is_file()

    assert make_path('alls-well-that-ends-well', 'I', 'I').is_file()
    assert make_path('alls-well-that-ends-well', 'I', 'II').is_file()
    assert make_path('alls-well-that-ends-well', 'I', 'III').is_file()
    assert make_path('alls-well-that-ends-well', 'II', 'I').is_file()
    assert make_path('alls-well-that-ends-well', 'II', 'II').is_file()
    assert make_path('alls-well-that-ends-well', 'II', 'III').is_file()
    assert make_path('alls-well-that-ends-well', 'II', 'IV').is_file()
    assert make_path('alls-well-that-ends-well', 'II', 'V').is_file()
    assert make_path('alls-well-that-ends-well', 'III', 'I').is_file()
    assert make_path('alls-well-that-ends-well', 'III', 'II').is_file()
    assert make_path('alls-well-that-ends-well', 'III', 'III').is_file()
    assert make_path('alls-well-that-ends-well', 'III', 'IV').is_file()
    assert make_path('alls-well-that-ends-well', 'III', 'V').is_file()
    assert make_path('alls-well-that-ends-well', 'III', 'VI').is_file()
    assert make_path('alls-well-that-ends-well', 'III', 'VII').is_file()
    assert make_path('alls-well-that-ends-well', 'IV', 'I').is_file()
    assert make_path('alls-well-that-ends-well', 'IV', 'II').is_file()
    assert make_path('alls-well-that-ends-well', 'IV', 'III').is_file()
    assert make_path('alls-well-that-ends-well', 'IV', 'IV').is_file()
    assert make_path('alls-well-that-ends-well', 'IV', 'V').is_file()
    assert make_path('alls-well-that-ends-well', 'V', 'I').is_file()
    assert make_path('alls-well-that-ends-well', 'V', 'II').is_file()
    assert make_path('alls-well-that-ends-well', 'V', 'III').is_file()

    assert make_path('antony-and-cleopatra', 'I', 'I').is_file()
    assert make_path('antony-and-cleopatra', 'I', 'II').is_file()
    assert make_path('antony-and-cleopatra', 'I', 'III').is_file()
    assert make_path('antony-and-cleopatra', 'I', 'IV').is_file()
    assert make_path('antony-and-cleopatra', 'I', 'V').is_file()
    assert make_path('antony-and-cleopatra', 'II', 'I').is_file()
    assert make_path('antony-and-cleopatra', 'II', 'II').is_file()
    assert make_path('antony-and-cleopatra', 'II', 'III').is_file()
    assert make_path('antony-and-cleopatra', 'II', 'IV').is_file()
    assert make_path('antony-and-cleopatra', 'II', 'V').is_file()
    assert make_path('antony-and-cleopatra', 'II', 'VI').is_file()
    assert make_path('antony-and-cleopatra', 'II', 'VII').is_file()
    assert make_path('antony-and-cleopatra', 'III', 'I').is_file()
    assert make_path('antony-and-cleopatra', 'III', 'II').is_file()
    assert make_path('antony-and-cleopatra', 'III', 'III').is_file()
    assert make_path('antony-and-cleopatra', 'III', 'IV').is_file()
    assert make_path('antony-and-cleopatra', 'III', 'V').is_file()
    assert make_path('antony-and-cleopatra', 'III', 'VI').is_file()
    assert make_path('antony-and-cleopatra', 'III', 'VII').is_file()
    assert make_path('antony-and-cleopatra', 'III', 'VIII').is_file()
    assert make_path('antony-and-cleopatra', 'III', 'IX').is_file()
    assert make_path('antony-and-cleopatra', 'III', 'X').is_file()
    assert make_path('antony-and-cleopatra', 'III', 'XI').is_file()
    assert make_path('antony-and-cleopatra', 'III', 'XII').is_file()
    assert make_path('antony-and-cleopatra', 'III', 'XIII').is_file()
    assert make_path('antony-and-cleopatra', 'IV', 'I').is_file()
    assert make_path('antony-and-cleopatra', 'IV', 'II').is_file()
    assert make_path('antony-and-cleopatra', 'IV', 'III').is_file()
    assert make_path('antony-and-cleopatra', 'IV', 'IV').is_file()
    assert make_path('antony-and-cleopatra', 'IV', 'V').is_file()
    assert make_path('antony-and-cleopatra', 'IV', 'VI').is_file()
    assert make_path('antony-and-cleopatra', 'IV', 'VII').is_file()
    assert make_path('antony-and-cleopatra', 'IV', 'VIII').is_file()
    assert make_path('antony-and-cleopatra', 'IV', 'IX').is_file()
    assert make_path('antony-and-cleopatra', 'IV', 'X').is_file()
    assert make_path('antony-and-cleopatra', 'IV', 'XI').is_file()
    assert make_path('antony-and-cleopatra', 'IV', 'XII').is_file()
    assert make_path('antony-and-cleopatra', 'IV', 'XIII').is_file()
    assert make_path('antony-and-cleopatra', 'IV', 'XIV').is_file()
    assert make_path('antony-and-cleopatra', 'IV', 'XV').is_file()
    assert make_path('antony-and-cleopatra', 'V', 'I').is_file()
    assert make_path('antony-and-cleopatra', 'V', 'II').is_file()

    assert make_path('as-you-like-it', 'I', 'I').is_file()
    assert make_path('as-you-like-it', 'I', 'II').is_file()
    assert make_path('as-you-like-it', 'I', 'III').is_file()
    assert make_path('as-you-like-it', 'II', 'I').is_file()
    assert make_path('as-you-like-it', 'II', 'II').is_file()
    assert make_path('as-you-like-it', 'II', 'III').is_file()
    assert make_path('as-you-like-it', 'II', 'IV').is_file()
    assert make_path('as-you-like-it', 'II', 'V').is_file()
    assert make_path('as-you-like-it', 'II', 'VI').is_file()
    assert make_path('as-you-like-it', 'II', 'VII').is_file()
    assert make_path('as-you-like-it', 'III', 'I').is_file()
    assert make_path('as-you-like-it', 'III', 'II').is_file()
    assert make_path('as-you-like-it', 'III', 'III').is_file()
    assert make_path('as-you-like-it', 'III', 'IV').is_file()
    assert make_path('as-you-like-it', 'III', 'V').is_file()
    assert make_path('as-you-like-it', 'IV', 'I').is_file()
    assert make_path('as-you-like-it', 'IV', 'II').is_file()
    assert make_path('as-you-like-it', 'IV', 'III').is_file()
    assert make_path('as-you-like-it', 'V', 'I').is_file()
    assert make_path('as-you-like-it', 'V', 'II').is_file()
    assert make_path('as-you-like-it', 'V', 'III').is_file()
    assert make_path('as-you-like-it', 'V', 'IV').is_file()

    assert make_path('cymbeline', 'I', 'I').is_file()
    assert make_path('cymbeline', 'I', 'II').is_file()
    assert make_path('cymbeline', 'I', 'III').is_file()
    assert make_path('cymbeline', 'I', 'IV').is_file()
    assert make_path('cymbeline', 'I', 'V').is_file()
    assert make_path('cymbeline', 'I', 'VI').is_file()
    assert make_path('cymbeline', 'I', 'VII').is_file()
    assert make_path('cymbeline', 'II', 'I').is_file()
    assert make_path('cymbeline', 'II', 'II').is_file()
    assert make_path('cymbeline', 'II', 'III').is_file()
    assert make_path('cymbeline', 'II', 'IV').is_file()
    assert make_path('cymbeline', 'II', 'V').is_file()
    assert make_path('cymbeline', 'III', 'I').is_file()
    assert make_path('cymbeline', 'III', 'II').is_file()
    assert make_path('cymbeline', 'III', 'III').is_file()
    assert make_path('cymbeline', 'III', 'IV').is_file()
    assert make_path('cymbeline', 'III', 'V').is_file()
    assert make_path('cymbeline', 'III', 'VI').is_file()
    assert make_path('cymbeline', 'III', 'VII').is_file()
    assert make_path('cymbeline', 'III', 'VIII').is_file()
    assert make_path('cymbeline', 'IV', 'I').is_file()
    assert make_path('cymbeline', 'IV', 'II').is_file()
    assert make_path('cymbeline', 'IV', 'III').is_file()
    assert make_path('cymbeline', 'IV', 'IV').is_file()
    assert make_path('cymbeline', 'V', 'I').is_file()
    assert make_path('cymbeline', 'V', 'II').is_file()
    assert make_path('cymbeline', 'V', 'III').is_file()
    assert make_path('cymbeline', 'V', 'IV').is_file()
    assert make_path('cymbeline', 'V', 'V').is_file()

    assert make_path('king-henry-the-eighth', 'PROLOGUE').is_file()
    assert make_path('king-henry-the-eighth', 'I', '1').is_file()
    assert make_path('king-henry-the-eighth', 'I', '2').is_file()
    assert make_path('king-henry-the-eighth', 'I', '3').is_file()
    assert make_path('king-henry-the-eighth', 'I', '4').is_file()
    assert make_path('king-henry-the-eighth', 'II', '1').is_file()
    assert make_path('king-henry-the-eighth', 'II', '2').is_file()
    assert make_path('king-henry-the-eighth', 'II', '3').is_file()
    assert make_path('king-henry-the-eighth', 'II', '4').is_file()
    assert make_path('king-henry-the-eighth', 'III', '1').is_file()
    assert make_path('king-henry-the-eighth', 'III', '2').is_file()
    assert make_path('king-henry-the-eighth', 'IV', '1').is_file()
    assert make_path('king-henry-the-eighth', 'IV', '2').is_file()
    assert make_path('king-henry-the-eighth', 'V', '1').is_file()
    assert make_path('king-henry-the-eighth', 'V', '2').is_file()
    assert make_path('king-henry-the-eighth', 'V', '3').is_file()
    assert make_path('king-henry-the-eighth', 'V', '4').is_file()
    assert make_path('king-henry-the-eighth', 'V', '5').is_file()

    assert make_path('king-john', 'I', '1').is_file()
    assert make_path('king-john', 'II', '1').is_file()
    assert make_path('king-john', 'III', '1').is_file()
    assert make_path('king-john', 'III', '2').is_file()
    assert make_path('king-john', 'III', '3').is_file()
    assert make_path('king-john', 'III', '4').is_file()
    assert make_path('king-john', 'IV', '1').is_file()
    assert make_path('king-john', 'IV', '2').is_file()
    assert make_path('king-john', 'IV', '3').is_file()
    assert make_path('king-john', 'V', '1').is_file()
    assert make_path('king-john', 'V', '2').is_file()
    assert make_path('king-john', 'V', '3').is_file()
    assert make_path('king-john', 'V', '4').is_file()
    assert make_path('king-john', 'V', '5').is_file()
    assert make_path('king-john', 'V', '6').is_file()
    assert make_path('king-john', 'V', '7').is_file()

    assert make_path('king-richard-the-third', 'I', '1').is_file()
    assert make_path('king-richard-the-third', 'I', '2').is_file()
    assert make_path('king-richard-the-third', 'I', '3').is_file()
    assert make_path('king-richard-the-third', 'I', '4').is_file()
    assert make_path('king-richard-the-third', 'II', '1').is_file()
    assert make_path('king-richard-the-third', 'II', '2').is_file()
    assert make_path('king-richard-the-third', 'II', '3').is_file()
    assert make_path('king-richard-the-third', 'II', '4').is_file()
    assert make_path('king-richard-the-third', 'III', '1').is_file()
    assert make_path('king-richard-the-third', 'III', '2').is_file()
    assert make_path('king-richard-the-third', 'III', '3').is_file()
    assert make_path('king-richard-the-third', 'III', '4').is_file()
    assert make_path('king-richard-the-third', 'III', '5').is_file()
    assert make_path('king-richard-the-third', 'III', '6').is_file()
    assert make_path('king-richard-the-third', 'III', '7').is_file()
    assert make_path('king-richard-the-third', 'IV', '1').is_file()
    assert make_path('king-richard-the-third', 'IV', '2').is_file()
    assert make_path('king-richard-the-third', 'IV', '3').is_file()
    assert make_path('king-richard-the-third', 'IV', '4').is_file()
    assert make_path('king-richard-the-third', 'IV', '5').is_file()
    assert make_path('king-richard-the-third', 'V', '1').is_file()
    assert make_path('king-richard-the-third', 'V', '2').is_file()
    assert make_path('king-richard-the-third', 'V', '3').is_file()
    assert make_path('king-richard-the-third', 'V', '4').is_file()
    assert make_path('king-richard-the-third', 'V', '5').is_file()

    assert make_path('loves-labours-lost', 'I', 'I').is_file()
    assert make_path('loves-labours-lost', 'I', 'II').is_file()
    # TODO: it appears that ACT II / SCENE I is missing from the Gutenberg text
    assert make_path('loves-labours-lost', 'II', 'II').is_file()
    assert make_path('loves-labours-lost', 'III', 'I').is_file()
    assert make_path('loves-labours-lost', 'IV', 'I').is_file()
    assert make_path('loves-labours-lost', 'IV', 'II').is_file()
    assert make_path('loves-labours-lost', 'IV', 'III').is_file()
    assert make_path('loves-labours-lost', 'V', 'I').is_file()
    assert make_path('loves-labours-lost', 'V', 'II').is_file()

    assert make_path('macbeth', 'I', 'I').is_file()
    assert make_path('macbeth', 'I', 'II').is_file()
    assert make_path('macbeth', 'I', 'III').is_file()
    assert make_path('macbeth', 'I', 'IV').is_file()
    assert make_path('macbeth', 'I', 'V').is_file()
    assert make_path('macbeth', 'I', 'VI').is_file()
    assert make_path('macbeth', 'I', 'VII').is_file()
    assert make_path('macbeth', 'II', 'I').is_file()
    assert make_path('macbeth', 'II', 'II').is_file()
    assert make_path('macbeth', 'II', 'III').is_file()
    assert make_path('macbeth', 'II', 'IV').is_file()
    assert make_path('macbeth', 'III', 'I').is_file()
    assert make_path('macbeth', 'III', 'II').is_file()
    assert make_path('macbeth', 'III', 'III').is_file()
    assert make_path('macbeth', 'III', 'IV').is_file()
    assert make_path('macbeth', 'III', 'V').is_file()
    assert make_path('macbeth', 'III', 'VI').is_file()
    assert make_path('macbeth', 'IV', 'I').is_file()
    assert make_path('macbeth', 'IV', 'II').is_file()
    assert make_path('macbeth', 'IV', 'III').is_file()
    assert make_path('macbeth', 'V', 'I').is_file()
    assert make_path('macbeth', 'V', 'II').is_file()
    assert make_path('macbeth', 'V', 'III').is_file()
    assert make_path('macbeth', 'V', 'IV').is_file()
    assert make_path('macbeth', 'V', 'V').is_file()
    assert make_path('macbeth', 'V', 'VI').is_file()
    assert make_path('macbeth', 'V', 'VII').is_file()
    assert make_path('macbeth', 'V', 'VIII').is_file()

    assert make_path('measure-for-measure', 'I', 'I').is_file()
    assert make_path('measure-for-measure', 'I', 'II').is_file()
    assert make_path('measure-for-measure', 'I', 'III').is_file()
    assert make_path('measure-for-measure', 'I', 'IV').is_file()
    assert make_path('measure-for-measure', 'II', 'I').is_file()
    assert make_path('measure-for-measure', 'II', 'II').is_file()
    assert make_path('measure-for-measure', 'II', 'III').is_file()
    assert make_path('measure-for-measure', 'II', 'IV').is_file()
    assert make_path('measure-for-measure', 'IV', 'I').is_file()
    assert make_path('measure-for-measure', 'IV', 'II').is_file()
    assert make_path('measure-for-measure', 'IV', 'III').is_file()
    assert make_path('measure-for-measure', 'IV', 'IV').is_file()
    assert make_path('measure-for-measure', 'IV', 'V').is_file()
    assert make_path('measure-for-measure', 'IV', 'VI').is_file()
    assert make_path('measure-for-measure', 'V', 'I').is_file()

    assert make_path('much-ado-about-nothing', 'I', 'I').is_file()
    assert make_path('much-ado-about-nothing', 'I', 'II').is_file()
    assert make_path('much-ado-about-nothing', 'I', 'III').is_file()
    assert make_path('much-ado-about-nothing', 'II', 'I').is_file()
    assert make_path('much-ado-about-nothing', 'II', 'II').is_file()
    assert make_path('much-ado-about-nothing', 'II', 'III').is_file()
    assert make_path('much-ado-about-nothing', 'III', 'I').is_file()
    assert make_path('much-ado-about-nothing', 'III', 'II').is_file()
    assert make_path('much-ado-about-nothing', 'III', 'III').is_file()
    assert make_path('much-ado-about-nothing', 'III', 'IV').is_file()
    assert make_path('much-ado-about-nothing', 'III', 'V').is_file()
    assert make_path('much-ado-about-nothing', 'IV', 'I').is_file()
    assert make_path('much-ado-about-nothing', 'IV', 'II').is_file()
    assert make_path('much-ado-about-nothing', 'V', 'I').is_file()
    assert make_path('much-ado-about-nothing', 'V', 'II').is_file()
    assert make_path('much-ado-about-nothing', 'V', 'III').is_file()
    assert make_path('much-ado-about-nothing', 'V', 'IV').is_file()

    assert make_path('othello-the-moor-of-venice', 'I', 'I').is_file()
    assert make_path('othello-the-moor-of-venice', 'I', 'II').is_file()
    assert make_path('othello-the-moor-of-venice', 'I', 'III').is_file()
    assert make_path('othello-the-moor-of-venice', 'II', 'I').is_file()
    assert make_path('othello-the-moor-of-venice', 'II', 'II').is_file()
    assert make_path('othello-the-moor-of-venice', 'II', 'III').is_file()
    assert make_path('othello-the-moor-of-venice', 'III', 'I').is_file()
    assert make_path('othello-the-moor-of-venice', 'III', 'II').is_file()
    assert make_path('othello-the-moor-of-venice', 'III', 'III').is_file()
    assert make_path('othello-the-moor-of-venice', 'III', 'IV').is_file()
    assert make_path('othello-the-moor-of-venice', 'IV', 'I').is_file()
    assert make_path('othello-the-moor-of-venice', 'IV', 'II').is_file()
    assert make_path('othello-the-moor-of-venice', 'IV', 'III').is_file()
    assert make_path('othello-the-moor-of-venice', 'V', 'I').is_file()
    assert make_path('othello-the-moor-of-venice', 'V', 'II').is_file()

    # TODO: parse Choruses
    # assert make_path('pericles-prince-of-tyre', 'CHORUS').is_file()
    assert make_path('pericles-prince-of-tyre', 'I', 'I').is_file()
    assert make_path('pericles-prince-of-tyre', 'I', 'II').is_file()
    assert make_path('pericles-prince-of-tyre', 'I', 'III').is_file()
    assert make_path('pericles-prince-of-tyre', 'I', 'IV').is_file()
    # assert make_path('pericles-prince-of-tyre', 'II', 'CHORUS').is_file()
    assert make_path('pericles-prince-of-tyre', 'II', 'I').is_file()
    assert make_path('pericles-prince-of-tyre', 'II', 'II').is_file()
    assert make_path('pericles-prince-of-tyre', 'II', 'III').is_file()
    assert make_path('pericles-prince-of-tyre', 'II', 'IV').is_file()
    assert make_path('pericles-prince-of-tyre', 'II', 'V').is_file()
    # assert make_path('pericles-prince-of-tyre', 'III', 'CHORUS').is_file()
    assert make_path('pericles-prince-of-tyre', 'III', 'I').is_file()
    assert make_path('pericles-prince-of-tyre', 'III', 'II').is_file()
    assert make_path('pericles-prince-of-tyre', 'III', 'III').is_file()
    assert make_path('pericles-prince-of-tyre', 'III', 'IV').is_file()
    # assert make_path('pericles-prince-of-tyre', 'IV', 'CHORUS').is_file()
    assert make_path('pericles-prince-of-tyre', 'IV', 'I').is_file()
    assert make_path('pericles-prince-of-tyre', 'IV', 'II').is_file()
    assert make_path('pericles-prince-of-tyre', 'IV', 'III').is_file()
    assert make_path('pericles-prince-of-tyre', 'IV', 'IV').is_file()
    assert make_path('pericles-prince-of-tyre', 'IV', 'V').is_file()
    assert make_path('pericles-prince-of-tyre', 'IV', 'VI').is_file()
    # assert make_path('pericles-prince-of-tyre', 'V', 'CHORUS').is_file()
    assert make_path('pericles-prince-of-tyre', 'V', 'I').is_file()
    assert make_path('pericles-prince-of-tyre', 'V', 'II').is_file()
    assert make_path('pericles-prince-of-tyre', 'V', 'III').is_file()

    assert make_path('the-comedy-of-errors', 'I', 'I').is_file()
    assert make_path('the-comedy-of-errors', 'I', 'II').is_file()
    assert make_path('the-comedy-of-errors', 'II', 'I').is_file()
    assert make_path('the-comedy-of-errors', 'II', 'II').is_file()
    assert make_path('the-comedy-of-errors', 'III', 'I').is_file()
    assert make_path('the-comedy-of-errors', 'III', 'II').is_file()
    assert make_path('the-comedy-of-errors', 'IV', 'I').is_file()
    assert make_path('the-comedy-of-errors', 'IV', 'II').is_file()
    assert make_path('the-comedy-of-errors', 'IV', 'III').is_file()
    assert make_path('the-comedy-of-errors', 'IV', 'IV').is_file()
    assert make_path('the-comedy-of-errors', 'V', 'I').is_file()

    # TODO: continue at The first part of henry the sixth
def make_path(play: str, act: str, scene: str = None) -> pathlib.Path:
    if scene:
        return TESTDATA_PATH / 'Plays' / play / make_filename(act, scene)
    else:
        return TESTDATA_PATH / 'Plays' / play / (act + '.txt')


def make_filename(act: str, scene: str) -> str:
    return f'ACT-{act}-SCENE-{scene}.txt'
