"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LoadBalancer = exports.LoadBalancerProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const slb_generated_1 = require("./slb.generated");
Object.defineProperty(exports, "LoadBalancerProperty", { enumerable: true, get: function () { return slb_generated_1.RosLoadBalancer; } });
/**
 * A ROS resource type:  `ALIYUN::SLB::LoadBalancer`
 */
class LoadBalancer extends ros.Resource {
    /**
     * Create a new `ALIYUN::SLB::LoadBalancer`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props = {}, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosLoadBalancer = new slb_generated_1.RosLoadBalancer(this, id, {
            autoRenewPeriod: props.autoRenewPeriod,
            resourceGroupId: props.resourceGroupId,
            instanceChargeType: props.instanceChargeType,
            pricingCycle: props.pricingCycle,
            autoRenew: props.autoRenew,
            vSwitchId: props.vSwitchId,
            addressIpVersion: props.addressIpVersion,
            duration: props.duration,
            autoPay: props.autoPay === undefined || props.autoPay === null ? false : props.autoPay,
            deletionProtection: props.deletionProtection === undefined || props.deletionProtection === null ? false : props.deletionProtection,
            payType: props.payType,
            slaveZoneId: props.slaveZoneId,
            modificationProtectionStatus: props.modificationProtectionStatus,
            internetChargeType: props.internetChargeType === undefined || props.internetChargeType === null ? 'paybytraffic' : props.internetChargeType,
            loadBalancerSpec: props.loadBalancerSpec,
            loadBalancerName: props.loadBalancerName,
            vpcId: props.vpcId,
            bandwidth: props.bandwidth === undefined || props.bandwidth === null ? 1 : props.bandwidth,
            modificationProtectionReason: props.modificationProtectionReason,
            addressType: props.addressType === undefined || props.addressType === null ? 'internet' : props.addressType,
            tags: props.tags,
            masterZoneId: props.masterZoneId,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosLoadBalancer;
        this.attrAddressIpVersion = rosLoadBalancer.attrAddressIpVersion;
        this.attrAddressType = rosLoadBalancer.attrAddressType;
        this.attrBandwidth = rosLoadBalancer.attrBandwidth;
        this.attrIpAddress = rosLoadBalancer.attrIpAddress;
        this.attrLoadBalancerId = rosLoadBalancer.attrLoadBalancerId;
        this.attrLoadBalancerName = rosLoadBalancer.attrLoadBalancerName;
        this.attrLoadBalancerSpec = rosLoadBalancer.attrLoadBalancerSpec;
        this.attrMasterZoneId = rosLoadBalancer.attrMasterZoneId;
        this.attrNetworkType = rosLoadBalancer.attrNetworkType;
        this.attrOrderId = rosLoadBalancer.attrOrderId;
        this.attrPayType = rosLoadBalancer.attrPayType;
        this.attrResourceGroupId = rosLoadBalancer.attrResourceGroupId;
        this.attrSlaveZoneId = rosLoadBalancer.attrSlaveZoneId;
        this.attrVSwitchId = rosLoadBalancer.attrVSwitchId;
        this.attrVpcId = rosLoadBalancer.attrVpcId;
    }
}
exports.LoadBalancer = LoadBalancer;
//# sourceMappingURL=data:application/json;base64,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