"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LoadBalancerClone = exports.LoadBalancerCloneProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const slb_generated_1 = require("./slb.generated");
Object.defineProperty(exports, "LoadBalancerCloneProperty", { enumerable: true, get: function () { return slb_generated_1.RosLoadBalancerClone; } });
/**
 * A ROS resource type:  `ALIYUN::SLB::LoadBalancerClone`
 */
class LoadBalancerClone extends ros.Resource {
    /**
     * Create a new `ALIYUN::SLB::LoadBalancerClone`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosLoadBalancerClone = new slb_generated_1.RosLoadBalancerClone(this, id, {
            loadBalancerName: props.loadBalancerName,
            sourceLoadBalancerId: props.sourceLoadBalancerId,
            tagsPolicy: props.tagsPolicy === undefined || props.tagsPolicy === null ? 'empty' : props.tagsPolicy,
            resourceGroupId: props.resourceGroupId,
            instanceChargeType: props.instanceChargeType,
            vSwitchId: props.vSwitchId,
            backendServers: props.backendServers,
            tags: props.tags,
            loadBalancerSpec: props.loadBalancerSpec,
            backendServersPolicy: props.backendServersPolicy === undefined || props.backendServersPolicy === null ? 'clone' : props.backendServersPolicy,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosLoadBalancerClone;
        this.attrLoadBalancerId = rosLoadBalancerClone.attrLoadBalancerId;
    }
}
exports.LoadBalancerClone = LoadBalancerClone;
//# sourceMappingURL=data:application/json;base64,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