"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MasterSlaveServerGroup = exports.MasterSlaveServerGroupProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const slb_generated_1 = require("./slb.generated");
Object.defineProperty(exports, "MasterSlaveServerGroupProperty", { enumerable: true, get: function () { return slb_generated_1.RosMasterSlaveServerGroup; } });
/**
 * A ROS resource type:  `ALIYUN::SLB::MasterSlaveServerGroup`
 */
class MasterSlaveServerGroup extends ros.Resource {
    /**
     * Create a new `ALIYUN::SLB::MasterSlaveServerGroup`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosMasterSlaveServerGroup = new slb_generated_1.RosMasterSlaveServerGroup(this, id, {
            loadBalancerId: props.loadBalancerId,
            masterSlaveServerGroupName: props.masterSlaveServerGroupName,
            masterSlaveBackendServers: props.masterSlaveBackendServers,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosMasterSlaveServerGroup;
        this.attrMasterSlaveServerGroupId = rosMasterSlaveServerGroup.attrMasterSlaveServerGroupId;
    }
}
exports.MasterSlaveServerGroup = MasterSlaveServerGroup;
//# sourceMappingURL=data:application/json;base64,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