import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AuditRequestHeaderConfig extends cdktf.TerraformMetaArguments {
    /**
    * Whether this header's value should be HMAC'd in the audit logs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/audit_request_header#hmac AuditRequestHeader#hmac}
    */
    readonly hmac?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/audit_request_header#id AuditRequestHeader#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the request header to audit.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/audit_request_header#name AuditRequestHeader#name}
    */
    readonly name: string;
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/audit_request_header#namespace AuditRequestHeader#namespace}
    */
    readonly namespace?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/audit_request_header vault_audit_request_header}
*/
export declare class AuditRequestHeader extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_audit_request_header";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/audit_request_header vault_audit_request_header} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AuditRequestHeaderConfig
    */
    constructor(scope: Construct, id: string, config: AuditRequestHeaderConfig);
    private _hmac?;
    get hmac(): boolean | cdktf.IResolvable;
    set hmac(value: boolean | cdktf.IResolvable);
    resetHmac(): void;
    get hmacInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
