import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AuthBackendConfig extends cdktf.TerraformMetaArguments {
    /**
    * The description of the auth backend
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/auth_backend#description AuthBackend#description}
    */
    readonly description?: string;
    /**
    * If set, opts out of mount migration on path updates.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/auth_backend#disable_remount AuthBackend#disable_remount}
    */
    readonly disableRemount?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/auth_backend#id AuthBackend#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Specifies if the auth method is local only
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/auth_backend#local AuthBackend#local}
    */
    readonly local?: boolean | cdktf.IResolvable;
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/auth_backend#namespace AuthBackend#namespace}
    */
    readonly namespace?: string;
    /**
    * path to mount the backend. This defaults to the type.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/auth_backend#path AuthBackend#path}
    */
    readonly path?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/auth_backend#tune AuthBackend#tune}
    */
    readonly tune?: AuthBackendTune[] | cdktf.IResolvable;
    /**
    * Name of the auth backend
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/auth_backend#type AuthBackend#type}
    */
    readonly type: string;
}
export interface AuthBackendTune {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/auth_backend#allowed_response_headers AuthBackend#allowed_response_headers}
    */
    readonly allowedResponseHeaders?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/auth_backend#audit_non_hmac_request_keys AuthBackend#audit_non_hmac_request_keys}
    */
    readonly auditNonHmacRequestKeys?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/auth_backend#audit_non_hmac_response_keys AuthBackend#audit_non_hmac_response_keys}
    */
    readonly auditNonHmacResponseKeys?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/auth_backend#default_lease_ttl AuthBackend#default_lease_ttl}
    */
    readonly defaultLeaseTtl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/auth_backend#listing_visibility AuthBackend#listing_visibility}
    */
    readonly listingVisibility?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/auth_backend#max_lease_ttl AuthBackend#max_lease_ttl}
    */
    readonly maxLeaseTtl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/auth_backend#passthrough_request_headers AuthBackend#passthrough_request_headers}
    */
    readonly passthroughRequestHeaders?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/auth_backend#token_type AuthBackend#token_type}
    */
    readonly tokenType?: string;
}
export declare function authBackendTuneToTerraform(struct?: AuthBackendTune | cdktf.IResolvable): any;
export declare class AuthBackendTuneOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AuthBackendTune | cdktf.IResolvable | undefined;
    set internalValue(value: AuthBackendTune | cdktf.IResolvable | undefined);
    private _allowedResponseHeaders?;
    get allowedResponseHeaders(): string[];
    set allowedResponseHeaders(value: string[]);
    resetAllowedResponseHeaders(): void;
    get allowedResponseHeadersInput(): string[] | undefined;
    private _auditNonHmacRequestKeys?;
    get auditNonHmacRequestKeys(): string[];
    set auditNonHmacRequestKeys(value: string[]);
    resetAuditNonHmacRequestKeys(): void;
    get auditNonHmacRequestKeysInput(): string[] | undefined;
    private _auditNonHmacResponseKeys?;
    get auditNonHmacResponseKeys(): string[];
    set auditNonHmacResponseKeys(value: string[]);
    resetAuditNonHmacResponseKeys(): void;
    get auditNonHmacResponseKeysInput(): string[] | undefined;
    private _defaultLeaseTtl?;
    get defaultLeaseTtl(): string;
    set defaultLeaseTtl(value: string);
    resetDefaultLeaseTtl(): void;
    get defaultLeaseTtlInput(): string | undefined;
    private _listingVisibility?;
    get listingVisibility(): string;
    set listingVisibility(value: string);
    resetListingVisibility(): void;
    get listingVisibilityInput(): string | undefined;
    private _maxLeaseTtl?;
    get maxLeaseTtl(): string;
    set maxLeaseTtl(value: string);
    resetMaxLeaseTtl(): void;
    get maxLeaseTtlInput(): string | undefined;
    private _passthroughRequestHeaders?;
    get passthroughRequestHeaders(): string[];
    set passthroughRequestHeaders(value: string[]);
    resetPassthroughRequestHeaders(): void;
    get passthroughRequestHeadersInput(): string[] | undefined;
    private _tokenType?;
    get tokenType(): string;
    set tokenType(value: string);
    resetTokenType(): void;
    get tokenTypeInput(): string | undefined;
}
export declare class AuthBackendTuneList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AuthBackendTune[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AuthBackendTuneOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/auth_backend vault_auth_backend}
*/
export declare class AuthBackend extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_auth_backend";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/auth_backend vault_auth_backend} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AuthBackendConfig
    */
    constructor(scope: Construct, id: string, config: AuthBackendConfig);
    get accessor(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _disableRemount?;
    get disableRemount(): boolean | cdktf.IResolvable;
    set disableRemount(value: boolean | cdktf.IResolvable);
    resetDisableRemount(): void;
    get disableRemountInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _local?;
    get local(): boolean | cdktf.IResolvable;
    set local(value: boolean | cdktf.IResolvable);
    resetLocal(): void;
    get localInput(): boolean | cdktf.IResolvable | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _tune;
    get tune(): AuthBackendTuneList;
    putTune(value: AuthBackendTune[] | cdktf.IResolvable): void;
    resetTune(): void;
    get tuneInput(): cdktf.IResolvable | AuthBackendTune[] | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
