import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AwsAuthBackendConfigIdentityConfig extends cdktf.TerraformMetaArguments {
    /**
    * Unique name of the auth backend to configure.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_config_identity#backend AwsAuthBackendConfigIdentity#backend}
    */
    readonly backend?: string;
    /**
    * Configures how to generate the identity alias when using the ec2 auth method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_config_identity#ec2_alias AwsAuthBackendConfigIdentity#ec2_alias}
    */
    readonly ec2Alias?: string;
    /**
    * The metadata to include on the token returned by the login endpoint.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_config_identity#ec2_metadata AwsAuthBackendConfigIdentity#ec2_metadata}
    */
    readonly ec2Metadata?: string[];
    /**
    * How to generate the identity alias when using the iam auth method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_config_identity#iam_alias AwsAuthBackendConfigIdentity#iam_alias}
    */
    readonly iamAlias?: string;
    /**
    * The metadata to include on the token returned by the login endpoint.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_config_identity#iam_metadata AwsAuthBackendConfigIdentity#iam_metadata}
    */
    readonly iamMetadata?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_config_identity#id AwsAuthBackendConfigIdentity#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_config_identity vault_aws_auth_backend_config_identity}
*/
export declare class AwsAuthBackendConfigIdentity extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_aws_auth_backend_config_identity";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_config_identity vault_aws_auth_backend_config_identity} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AwsAuthBackendConfigIdentityConfig = {}
    */
    constructor(scope: Construct, id: string, config?: AwsAuthBackendConfigIdentityConfig);
    private _backend?;
    get backend(): string;
    set backend(value: string);
    resetBackend(): void;
    get backendInput(): string | undefined;
    private _ec2Alias?;
    get ec2Alias(): string;
    set ec2Alias(value: string);
    resetEc2Alias(): void;
    get ec2AliasInput(): string | undefined;
    private _ec2Metadata?;
    get ec2Metadata(): string[];
    set ec2Metadata(value: string[]);
    resetEc2Metadata(): void;
    get ec2MetadataInput(): string[] | undefined;
    private _iamAlias?;
    get iamAlias(): string;
    set iamAlias(value: string);
    resetIamAlias(): void;
    get iamAliasInput(): string | undefined;
    private _iamMetadata?;
    get iamMetadata(): string[];
    set iamMetadata(value: string[]);
    resetIamMetadata(): void;
    get iamMetadataInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
