import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataVaultRaftAutopilotStateConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/raft_autopilot_state#id DataVaultRaftAutopilotState#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/raft_autopilot_state#namespace DataVaultRaftAutopilotState#namespace}
    */
    readonly namespace?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/d/raft_autopilot_state vault_raft_autopilot_state}
*/
export declare class DataVaultRaftAutopilotState extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "vault_raft_autopilot_state";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/d/raft_autopilot_state vault_raft_autopilot_state} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataVaultRaftAutopilotStateConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataVaultRaftAutopilotStateConfig);
    get failureTolerance(): number;
    get healthy(): cdktf.IResolvable;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get leader(): string;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    get optimisticFailureTolerance(): number;
    private _redundancyZones;
    get redundancyZones(): cdktf.StringMap;
    get redundancyZonesJson(): string;
    private _servers;
    get servers(): cdktf.StringMap;
    get serversJson(): string;
    private _upgradeInfo;
    get upgradeInfo(): cdktf.StringMap;
    get upgradeInfoJson(): string;
    get voters(): string[];
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
