import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DatabaseSecretBackendConnectionConfig extends cdktf.TerraformMetaArguments {
    /**
    * A list of roles that are allowed to use this connection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#allowed_roles DatabaseSecretBackendConnection#allowed_roles}
    */
    readonly allowedRoles?: string[];
    /**
    * Unique name of the Vault mount to configure.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#backend DatabaseSecretBackendConnection#backend}
    */
    readonly backend: string;
    /**
    * A map of sensitive data to pass to the endpoint. Useful for templated connection strings.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#data DatabaseSecretBackendConnection#data}
    */
    readonly data?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#id DatabaseSecretBackendConnection#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the database connection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#name DatabaseSecretBackendConnection#name}
    */
    readonly name: string;
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#namespace DatabaseSecretBackendConnection#namespace}
    */
    readonly namespace?: string;
    /**
    * Specifies the name of the plugin to use for this connection. Must be prefixed with the name of one of the supported database engine types.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#plugin_name DatabaseSecretBackendConnection#plugin_name}
    */
    readonly pluginName?: string;
    /**
    * A list of database statements to be executed to rotate the root user's credentials.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#root_rotation_statements DatabaseSecretBackendConnection#root_rotation_statements}
    */
    readonly rootRotationStatements?: string[];
    /**
    * Specifies if the connection is verified during initial configuration.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#verify_connection DatabaseSecretBackendConnection#verify_connection}
    */
    readonly verifyConnection?: boolean | cdktf.IResolvable;
    /**
    * cassandra block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#cassandra DatabaseSecretBackendConnection#cassandra}
    */
    readonly cassandra?: DatabaseSecretBackendConnectionCassandra;
    /**
    * couchbase block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#couchbase DatabaseSecretBackendConnection#couchbase}
    */
    readonly couchbase?: DatabaseSecretBackendConnectionCouchbase;
    /**
    * elasticsearch block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#elasticsearch DatabaseSecretBackendConnection#elasticsearch}
    */
    readonly elasticsearch?: DatabaseSecretBackendConnectionElasticsearch;
    /**
    * hana block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#hana DatabaseSecretBackendConnection#hana}
    */
    readonly hana?: DatabaseSecretBackendConnectionHana;
    /**
    * influxdb block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#influxdb DatabaseSecretBackendConnection#influxdb}
    */
    readonly influxdb?: DatabaseSecretBackendConnectionInfluxdb;
    /**
    * mongodb block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#mongodb DatabaseSecretBackendConnection#mongodb}
    */
    readonly mongodb?: DatabaseSecretBackendConnectionMongodb;
    /**
    * mongodbatlas block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#mongodbatlas DatabaseSecretBackendConnection#mongodbatlas}
    */
    readonly mongodbatlas?: DatabaseSecretBackendConnectionMongodbatlas;
    /**
    * mssql block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#mssql DatabaseSecretBackendConnection#mssql}
    */
    readonly mssql?: DatabaseSecretBackendConnectionMssql;
    /**
    * mysql block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#mysql DatabaseSecretBackendConnection#mysql}
    */
    readonly mysql?: DatabaseSecretBackendConnectionMysql;
    /**
    * mysql_aurora block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#mysql_aurora DatabaseSecretBackendConnection#mysql_aurora}
    */
    readonly mysqlAurora?: DatabaseSecretBackendConnectionMysqlAurora;
    /**
    * mysql_legacy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#mysql_legacy DatabaseSecretBackendConnection#mysql_legacy}
    */
    readonly mysqlLegacy?: DatabaseSecretBackendConnectionMysqlLegacy;
    /**
    * mysql_rds block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#mysql_rds DatabaseSecretBackendConnection#mysql_rds}
    */
    readonly mysqlRds?: DatabaseSecretBackendConnectionMysqlRds;
    /**
    * oracle block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#oracle DatabaseSecretBackendConnection#oracle}
    */
    readonly oracle?: DatabaseSecretBackendConnectionOracle;
    /**
    * postgresql block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#postgresql DatabaseSecretBackendConnection#postgresql}
    */
    readonly postgresql?: DatabaseSecretBackendConnectionPostgresql;
    /**
    * redis block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#redis DatabaseSecretBackendConnection#redis}
    */
    readonly redis?: DatabaseSecretBackendConnectionRedis;
    /**
    * redis_elasticache block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#redis_elasticache DatabaseSecretBackendConnection#redis_elasticache}
    */
    readonly redisElasticache?: DatabaseSecretBackendConnectionRedisElasticache;
    /**
    * redshift block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#redshift DatabaseSecretBackendConnection#redshift}
    */
    readonly redshift?: DatabaseSecretBackendConnectionRedshift;
    /**
    * snowflake block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#snowflake DatabaseSecretBackendConnection#snowflake}
    */
    readonly snowflake?: DatabaseSecretBackendConnectionSnowflake;
}
export interface DatabaseSecretBackendConnectionCassandra {
    /**
    * The number of seconds to use as a connection timeout.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#connect_timeout DatabaseSecretBackendConnection#connect_timeout}
    */
    readonly connectTimeout?: number;
    /**
    * Cassandra hosts to connect to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#hosts DatabaseSecretBackendConnection#hosts}
    */
    readonly hosts?: string[];
    /**
    * Whether to skip verification of the server certificate when using TLS.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#insecure_tls DatabaseSecretBackendConnection#insecure_tls}
    */
    readonly insecureTls?: boolean | cdktf.IResolvable;
    /**
    * The password to use when authenticating with Cassandra.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#password DatabaseSecretBackendConnection#password}
    */
    readonly password?: string;
    /**
    * Concatenated PEM blocks containing a certificate and private key; a certificate, private key, and issuing CA certificate; or just a CA certificate.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#pem_bundle DatabaseSecretBackendConnection#pem_bundle}
    */
    readonly pemBundle?: string;
    /**
    * Specifies JSON containing a certificate and private key; a certificate, private key, and issuing CA certificate; or just a CA certificate.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#pem_json DatabaseSecretBackendConnection#pem_json}
    */
    readonly pemJson?: string;
    /**
    * The transport port to use to connect to Cassandra.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#port DatabaseSecretBackendConnection#port}
    */
    readonly port?: number;
    /**
    * The CQL protocol version to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#protocol_version DatabaseSecretBackendConnection#protocol_version}
    */
    readonly protocolVersion?: number;
    /**
    * Whether to use TLS when connecting to Cassandra.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#tls DatabaseSecretBackendConnection#tls}
    */
    readonly tls?: boolean | cdktf.IResolvable;
    /**
    * The username to use when authenticating with Cassandra.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#username DatabaseSecretBackendConnection#username}
    */
    readonly username?: string;
}
export declare function databaseSecretBackendConnectionCassandraToTerraform(struct?: DatabaseSecretBackendConnectionCassandraOutputReference | DatabaseSecretBackendConnectionCassandra): any;
export declare class DatabaseSecretBackendConnectionCassandraOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DatabaseSecretBackendConnectionCassandra | undefined;
    set internalValue(value: DatabaseSecretBackendConnectionCassandra | undefined);
    private _connectTimeout?;
    get connectTimeout(): number;
    set connectTimeout(value: number);
    resetConnectTimeout(): void;
    get connectTimeoutInput(): number | undefined;
    private _hosts?;
    get hosts(): string[];
    set hosts(value: string[]);
    resetHosts(): void;
    get hostsInput(): string[] | undefined;
    private _insecureTls?;
    get insecureTls(): boolean | cdktf.IResolvable;
    set insecureTls(value: boolean | cdktf.IResolvable);
    resetInsecureTls(): void;
    get insecureTlsInput(): boolean | cdktf.IResolvable | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _pemBundle?;
    get pemBundle(): string;
    set pemBundle(value: string);
    resetPemBundle(): void;
    get pemBundleInput(): string | undefined;
    private _pemJson?;
    get pemJson(): string;
    set pemJson(value: string);
    resetPemJson(): void;
    get pemJsonInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _protocolVersion?;
    get protocolVersion(): number;
    set protocolVersion(value: number);
    resetProtocolVersion(): void;
    get protocolVersionInput(): number | undefined;
    private _tls?;
    get tls(): boolean | cdktf.IResolvable;
    set tls(value: boolean | cdktf.IResolvable);
    resetTls(): void;
    get tlsInput(): boolean | cdktf.IResolvable | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    resetUsername(): void;
    get usernameInput(): string | undefined;
}
export interface DatabaseSecretBackendConnectionCouchbase {
    /**
    * Required if `tls` is `true`. Specifies the certificate authority of the Couchbase server, as a PEM certificate that has been base64 encoded.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#base64_pem DatabaseSecretBackendConnection#base64_pem}
    */
    readonly base64Pem?: string;
    /**
    * Required for Couchbase versions prior to 6.5.0. This is only used to verify vault's connection to the server.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#bucket_name DatabaseSecretBackendConnection#bucket_name}
    */
    readonly bucketName?: string;
    /**
    * A set of Couchbase URIs to connect to. Must use `couchbases://` scheme if `tls` is `true`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#hosts DatabaseSecretBackendConnection#hosts}
    */
    readonly hosts: string[];
    /**
    *  Specifies whether to skip verification of the server certificate when using TLS.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#insecure_tls DatabaseSecretBackendConnection#insecure_tls}
    */
    readonly insecureTls?: boolean | cdktf.IResolvable;
    /**
    * Specifies the password corresponding to the given username.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#password DatabaseSecretBackendConnection#password}
    */
    readonly password: string;
    /**
    * Specifies whether to use TLS when connecting to Couchbase.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#tls DatabaseSecretBackendConnection#tls}
    */
    readonly tls?: boolean | cdktf.IResolvable;
    /**
    * Specifies the username for Vault to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#username DatabaseSecretBackendConnection#username}
    */
    readonly username: string;
    /**
    * Template describing how dynamic usernames are generated.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#username_template DatabaseSecretBackendConnection#username_template}
    */
    readonly usernameTemplate?: string;
}
export declare function databaseSecretBackendConnectionCouchbaseToTerraform(struct?: DatabaseSecretBackendConnectionCouchbaseOutputReference | DatabaseSecretBackendConnectionCouchbase): any;
export declare class DatabaseSecretBackendConnectionCouchbaseOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DatabaseSecretBackendConnectionCouchbase | undefined;
    set internalValue(value: DatabaseSecretBackendConnectionCouchbase | undefined);
    private _base64Pem?;
    get base64Pem(): string;
    set base64Pem(value: string);
    resetBase64Pem(): void;
    get base64PemInput(): string | undefined;
    private _bucketName?;
    get bucketName(): string;
    set bucketName(value: string);
    resetBucketName(): void;
    get bucketNameInput(): string | undefined;
    private _hosts?;
    get hosts(): string[];
    set hosts(value: string[]);
    get hostsInput(): string[] | undefined;
    private _insecureTls?;
    get insecureTls(): boolean | cdktf.IResolvable;
    set insecureTls(value: boolean | cdktf.IResolvable);
    resetInsecureTls(): void;
    get insecureTlsInput(): boolean | cdktf.IResolvable | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _tls?;
    get tls(): boolean | cdktf.IResolvable;
    set tls(value: boolean | cdktf.IResolvable);
    resetTls(): void;
    get tlsInput(): boolean | cdktf.IResolvable | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
    private _usernameTemplate?;
    get usernameTemplate(): string;
    set usernameTemplate(value: string);
    resetUsernameTemplate(): void;
    get usernameTemplateInput(): string | undefined;
}
export interface DatabaseSecretBackendConnectionElasticsearch {
    /**
    * The path to a PEM-encoded CA cert file to use to verify the Elasticsearch server's identity
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#ca_cert DatabaseSecretBackendConnection#ca_cert}
    */
    readonly caCert?: string;
    /**
    * The path to a directory of PEM-encoded CA cert files to use to verify the Elasticsearch server's identity
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#ca_path DatabaseSecretBackendConnection#ca_path}
    */
    readonly caPath?: string;
    /**
    * The path to the certificate for the Elasticsearch client to present for communication
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#client_cert DatabaseSecretBackendConnection#client_cert}
    */
    readonly clientCert?: string;
    /**
    * The path to the key for the Elasticsearch client to use for communication
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#client_key DatabaseSecretBackendConnection#client_key}
    */
    readonly clientKey?: string;
    /**
    * Whether to disable certificate verification
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#insecure DatabaseSecretBackendConnection#insecure}
    */
    readonly insecure?: boolean | cdktf.IResolvable;
    /**
    * The password to be used in the connection URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#password DatabaseSecretBackendConnection#password}
    */
    readonly password: string;
    /**
    * This, if set, is used to set the SNI host when connecting via TLS
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#tls_server_name DatabaseSecretBackendConnection#tls_server_name}
    */
    readonly tlsServerName?: string;
    /**
    * The URL for Elasticsearch's API
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#url DatabaseSecretBackendConnection#url}
    */
    readonly url: string;
    /**
    * The username to be used in the connection URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#username DatabaseSecretBackendConnection#username}
    */
    readonly username: string;
    /**
    * Template describing how dynamic usernames are generated.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#username_template DatabaseSecretBackendConnection#username_template}
    */
    readonly usernameTemplate?: string;
}
export declare function databaseSecretBackendConnectionElasticsearchToTerraform(struct?: DatabaseSecretBackendConnectionElasticsearchOutputReference | DatabaseSecretBackendConnectionElasticsearch): any;
export declare class DatabaseSecretBackendConnectionElasticsearchOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DatabaseSecretBackendConnectionElasticsearch | undefined;
    set internalValue(value: DatabaseSecretBackendConnectionElasticsearch | undefined);
    private _caCert?;
    get caCert(): string;
    set caCert(value: string);
    resetCaCert(): void;
    get caCertInput(): string | undefined;
    private _caPath?;
    get caPath(): string;
    set caPath(value: string);
    resetCaPath(): void;
    get caPathInput(): string | undefined;
    private _clientCert?;
    get clientCert(): string;
    set clientCert(value: string);
    resetClientCert(): void;
    get clientCertInput(): string | undefined;
    private _clientKey?;
    get clientKey(): string;
    set clientKey(value: string);
    resetClientKey(): void;
    get clientKeyInput(): string | undefined;
    private _insecure?;
    get insecure(): boolean | cdktf.IResolvable;
    set insecure(value: boolean | cdktf.IResolvable);
    resetInsecure(): void;
    get insecureInput(): boolean | cdktf.IResolvable | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _tlsServerName?;
    get tlsServerName(): string;
    set tlsServerName(value: string);
    resetTlsServerName(): void;
    get tlsServerNameInput(): string | undefined;
    private _url?;
    get url(): string;
    set url(value: string);
    get urlInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
    private _usernameTemplate?;
    get usernameTemplate(): string;
    set usernameTemplate(value: string);
    resetUsernameTemplate(): void;
    get usernameTemplateInput(): string | undefined;
}
export interface DatabaseSecretBackendConnectionHana {
    /**
    * Connection string to use to connect to the database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#connection_url DatabaseSecretBackendConnection#connection_url}
    */
    readonly connectionUrl?: string;
    /**
    * Disable special character escaping in username and password
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#disable_escaping DatabaseSecretBackendConnection#disable_escaping}
    */
    readonly disableEscaping?: boolean | cdktf.IResolvable;
    /**
    * Maximum number of seconds a connection may be reused.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#max_connection_lifetime DatabaseSecretBackendConnection#max_connection_lifetime}
    */
    readonly maxConnectionLifetime?: number;
    /**
    * Maximum number of idle connections to the database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#max_idle_connections DatabaseSecretBackendConnection#max_idle_connections}
    */
    readonly maxIdleConnections?: number;
    /**
    * Maximum number of open connections to the database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#max_open_connections DatabaseSecretBackendConnection#max_open_connections}
    */
    readonly maxOpenConnections?: number;
    /**
    * The root credential password used in the connection URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#password DatabaseSecretBackendConnection#password}
    */
    readonly password?: string;
    /**
    * The root credential username used in the connection URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#username DatabaseSecretBackendConnection#username}
    */
    readonly username?: string;
}
export declare function databaseSecretBackendConnectionHanaToTerraform(struct?: DatabaseSecretBackendConnectionHanaOutputReference | DatabaseSecretBackendConnectionHana): any;
export declare class DatabaseSecretBackendConnectionHanaOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DatabaseSecretBackendConnectionHana | undefined;
    set internalValue(value: DatabaseSecretBackendConnectionHana | undefined);
    private _connectionUrl?;
    get connectionUrl(): string;
    set connectionUrl(value: string);
    resetConnectionUrl(): void;
    get connectionUrlInput(): string | undefined;
    private _disableEscaping?;
    get disableEscaping(): boolean | cdktf.IResolvable;
    set disableEscaping(value: boolean | cdktf.IResolvable);
    resetDisableEscaping(): void;
    get disableEscapingInput(): boolean | cdktf.IResolvable | undefined;
    private _maxConnectionLifetime?;
    get maxConnectionLifetime(): number;
    set maxConnectionLifetime(value: number);
    resetMaxConnectionLifetime(): void;
    get maxConnectionLifetimeInput(): number | undefined;
    private _maxIdleConnections?;
    get maxIdleConnections(): number;
    set maxIdleConnections(value: number);
    resetMaxIdleConnections(): void;
    get maxIdleConnectionsInput(): number | undefined;
    private _maxOpenConnections?;
    get maxOpenConnections(): number;
    set maxOpenConnections(value: number);
    resetMaxOpenConnections(): void;
    get maxOpenConnectionsInput(): number | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    resetUsername(): void;
    get usernameInput(): string | undefined;
}
export interface DatabaseSecretBackendConnectionInfluxdb {
    /**
    * The number of seconds to use as a connection timeout.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#connect_timeout DatabaseSecretBackendConnection#connect_timeout}
    */
    readonly connectTimeout?: number;
    /**
    * Influxdb host to connect to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#host DatabaseSecretBackendConnection#host}
    */
    readonly host: string;
    /**
    * Whether to skip verification of the server certificate when using TLS.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#insecure_tls DatabaseSecretBackendConnection#insecure_tls}
    */
    readonly insecureTls?: boolean | cdktf.IResolvable;
    /**
    * Specifies the password corresponding to the given username.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#password DatabaseSecretBackendConnection#password}
    */
    readonly password: string;
    /**
    * Concatenated PEM blocks containing a certificate and private key; a certificate, private key, and issuing CA certificate; or just a CA certificate.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#pem_bundle DatabaseSecretBackendConnection#pem_bundle}
    */
    readonly pemBundle?: string;
    /**
    * Specifies JSON containing a certificate and private key; a certificate, private key, and issuing CA certificate; or just a CA certificate.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#pem_json DatabaseSecretBackendConnection#pem_json}
    */
    readonly pemJson?: string;
    /**
    * The transport port to use to connect to Influxdb.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#port DatabaseSecretBackendConnection#port}
    */
    readonly port?: number;
    /**
    * Whether to use TLS when connecting to Influxdb.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#tls DatabaseSecretBackendConnection#tls}
    */
    readonly tls?: boolean | cdktf.IResolvable;
    /**
    * Specifies the username to use for superuser access.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#username DatabaseSecretBackendConnection#username}
    */
    readonly username: string;
    /**
    * Template describing how dynamic usernames are generated.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#username_template DatabaseSecretBackendConnection#username_template}
    */
    readonly usernameTemplate?: string;
}
export declare function databaseSecretBackendConnectionInfluxdbToTerraform(struct?: DatabaseSecretBackendConnectionInfluxdbOutputReference | DatabaseSecretBackendConnectionInfluxdb): any;
export declare class DatabaseSecretBackendConnectionInfluxdbOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DatabaseSecretBackendConnectionInfluxdb | undefined;
    set internalValue(value: DatabaseSecretBackendConnectionInfluxdb | undefined);
    private _connectTimeout?;
    get connectTimeout(): number;
    set connectTimeout(value: number);
    resetConnectTimeout(): void;
    get connectTimeoutInput(): number | undefined;
    private _host?;
    get host(): string;
    set host(value: string);
    get hostInput(): string | undefined;
    private _insecureTls?;
    get insecureTls(): boolean | cdktf.IResolvable;
    set insecureTls(value: boolean | cdktf.IResolvable);
    resetInsecureTls(): void;
    get insecureTlsInput(): boolean | cdktf.IResolvable | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _pemBundle?;
    get pemBundle(): string;
    set pemBundle(value: string);
    resetPemBundle(): void;
    get pemBundleInput(): string | undefined;
    private _pemJson?;
    get pemJson(): string;
    set pemJson(value: string);
    resetPemJson(): void;
    get pemJsonInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _tls?;
    get tls(): boolean | cdktf.IResolvable;
    set tls(value: boolean | cdktf.IResolvable);
    resetTls(): void;
    get tlsInput(): boolean | cdktf.IResolvable | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
    private _usernameTemplate?;
    get usernameTemplate(): string;
    set usernameTemplate(value: string);
    resetUsernameTemplate(): void;
    get usernameTemplateInput(): string | undefined;
}
export interface DatabaseSecretBackendConnectionMongodb {
    /**
    * Connection string to use to connect to the database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#connection_url DatabaseSecretBackendConnection#connection_url}
    */
    readonly connectionUrl?: string;
    /**
    * Maximum number of seconds a connection may be reused.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#max_connection_lifetime DatabaseSecretBackendConnection#max_connection_lifetime}
    */
    readonly maxConnectionLifetime?: number;
    /**
    * Maximum number of idle connections to the database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#max_idle_connections DatabaseSecretBackendConnection#max_idle_connections}
    */
    readonly maxIdleConnections?: number;
    /**
    * Maximum number of open connections to the database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#max_open_connections DatabaseSecretBackendConnection#max_open_connections}
    */
    readonly maxOpenConnections?: number;
    /**
    * The root credential password used in the connection URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#password DatabaseSecretBackendConnection#password}
    */
    readonly password?: string;
    /**
    * The root credential username used in the connection URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#username DatabaseSecretBackendConnection#username}
    */
    readonly username?: string;
    /**
    * Username generation template.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#username_template DatabaseSecretBackendConnection#username_template}
    */
    readonly usernameTemplate?: string;
}
export declare function databaseSecretBackendConnectionMongodbToTerraform(struct?: DatabaseSecretBackendConnectionMongodbOutputReference | DatabaseSecretBackendConnectionMongodb): any;
export declare class DatabaseSecretBackendConnectionMongodbOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DatabaseSecretBackendConnectionMongodb | undefined;
    set internalValue(value: DatabaseSecretBackendConnectionMongodb | undefined);
    private _connectionUrl?;
    get connectionUrl(): string;
    set connectionUrl(value: string);
    resetConnectionUrl(): void;
    get connectionUrlInput(): string | undefined;
    private _maxConnectionLifetime?;
    get maxConnectionLifetime(): number;
    set maxConnectionLifetime(value: number);
    resetMaxConnectionLifetime(): void;
    get maxConnectionLifetimeInput(): number | undefined;
    private _maxIdleConnections?;
    get maxIdleConnections(): number;
    set maxIdleConnections(value: number);
    resetMaxIdleConnections(): void;
    get maxIdleConnectionsInput(): number | undefined;
    private _maxOpenConnections?;
    get maxOpenConnections(): number;
    set maxOpenConnections(value: number);
    resetMaxOpenConnections(): void;
    get maxOpenConnectionsInput(): number | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    resetUsername(): void;
    get usernameInput(): string | undefined;
    private _usernameTemplate?;
    get usernameTemplate(): string;
    set usernameTemplate(value: string);
    resetUsernameTemplate(): void;
    get usernameTemplateInput(): string | undefined;
}
export interface DatabaseSecretBackendConnectionMongodbatlas {
    /**
    * The Private Programmatic API Key used to connect with MongoDB Atlas API.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#private_key DatabaseSecretBackendConnection#private_key}
    */
    readonly privateKey: string;
    /**
    * The Project ID the Database User should be created within.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#project_id DatabaseSecretBackendConnection#project_id}
    */
    readonly projectId: string;
    /**
    * The Public Programmatic API Key used to authenticate with the MongoDB Atlas API.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#public_key DatabaseSecretBackendConnection#public_key}
    */
    readonly publicKey: string;
}
export declare function databaseSecretBackendConnectionMongodbatlasToTerraform(struct?: DatabaseSecretBackendConnectionMongodbatlasOutputReference | DatabaseSecretBackendConnectionMongodbatlas): any;
export declare class DatabaseSecretBackendConnectionMongodbatlasOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DatabaseSecretBackendConnectionMongodbatlas | undefined;
    set internalValue(value: DatabaseSecretBackendConnectionMongodbatlas | undefined);
    private _privateKey?;
    get privateKey(): string;
    set privateKey(value: string);
    get privateKeyInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _publicKey?;
    get publicKey(): string;
    set publicKey(value: string);
    get publicKeyInput(): string | undefined;
}
export interface DatabaseSecretBackendConnectionMssql {
    /**
    * Connection string to use to connect to the database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#connection_url DatabaseSecretBackendConnection#connection_url}
    */
    readonly connectionUrl?: string;
    /**
    * Set to true when the target is a Contained Database, e.g. AzureSQL.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#contained_db DatabaseSecretBackendConnection#contained_db}
    */
    readonly containedDb?: boolean | cdktf.IResolvable;
    /**
    * Disable special character escaping in username and password
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#disable_escaping DatabaseSecretBackendConnection#disable_escaping}
    */
    readonly disableEscaping?: boolean | cdktf.IResolvable;
    /**
    * Maximum number of seconds a connection may be reused.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#max_connection_lifetime DatabaseSecretBackendConnection#max_connection_lifetime}
    */
    readonly maxConnectionLifetime?: number;
    /**
    * Maximum number of idle connections to the database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#max_idle_connections DatabaseSecretBackendConnection#max_idle_connections}
    */
    readonly maxIdleConnections?: number;
    /**
    * Maximum number of open connections to the database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#max_open_connections DatabaseSecretBackendConnection#max_open_connections}
    */
    readonly maxOpenConnections?: number;
    /**
    * The root credential password used in the connection URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#password DatabaseSecretBackendConnection#password}
    */
    readonly password?: string;
    /**
    * The root credential username used in the connection URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#username DatabaseSecretBackendConnection#username}
    */
    readonly username?: string;
    /**
    * Username generation template.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#username_template DatabaseSecretBackendConnection#username_template}
    */
    readonly usernameTemplate?: string;
}
export declare function databaseSecretBackendConnectionMssqlToTerraform(struct?: DatabaseSecretBackendConnectionMssqlOutputReference | DatabaseSecretBackendConnectionMssql): any;
export declare class DatabaseSecretBackendConnectionMssqlOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DatabaseSecretBackendConnectionMssql | undefined;
    set internalValue(value: DatabaseSecretBackendConnectionMssql | undefined);
    private _connectionUrl?;
    get connectionUrl(): string;
    set connectionUrl(value: string);
    resetConnectionUrl(): void;
    get connectionUrlInput(): string | undefined;
    private _containedDb?;
    get containedDb(): boolean | cdktf.IResolvable;
    set containedDb(value: boolean | cdktf.IResolvable);
    resetContainedDb(): void;
    get containedDbInput(): boolean | cdktf.IResolvable | undefined;
    private _disableEscaping?;
    get disableEscaping(): boolean | cdktf.IResolvable;
    set disableEscaping(value: boolean | cdktf.IResolvable);
    resetDisableEscaping(): void;
    get disableEscapingInput(): boolean | cdktf.IResolvable | undefined;
    private _maxConnectionLifetime?;
    get maxConnectionLifetime(): number;
    set maxConnectionLifetime(value: number);
    resetMaxConnectionLifetime(): void;
    get maxConnectionLifetimeInput(): number | undefined;
    private _maxIdleConnections?;
    get maxIdleConnections(): number;
    set maxIdleConnections(value: number);
    resetMaxIdleConnections(): void;
    get maxIdleConnectionsInput(): number | undefined;
    private _maxOpenConnections?;
    get maxOpenConnections(): number;
    set maxOpenConnections(value: number);
    resetMaxOpenConnections(): void;
    get maxOpenConnectionsInput(): number | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    resetUsername(): void;
    get usernameInput(): string | undefined;
    private _usernameTemplate?;
    get usernameTemplate(): string;
    set usernameTemplate(value: string);
    resetUsernameTemplate(): void;
    get usernameTemplateInput(): string | undefined;
}
export interface DatabaseSecretBackendConnectionMysql {
    /**
    * Connection string to use to connect to the database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#connection_url DatabaseSecretBackendConnection#connection_url}
    */
    readonly connectionUrl?: string;
    /**
    * Maximum number of seconds a connection may be reused.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#max_connection_lifetime DatabaseSecretBackendConnection#max_connection_lifetime}
    */
    readonly maxConnectionLifetime?: number;
    /**
    * Maximum number of idle connections to the database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#max_idle_connections DatabaseSecretBackendConnection#max_idle_connections}
    */
    readonly maxIdleConnections?: number;
    /**
    * Maximum number of open connections to the database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#max_open_connections DatabaseSecretBackendConnection#max_open_connections}
    */
    readonly maxOpenConnections?: number;
    /**
    * The root credential password used in the connection URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#password DatabaseSecretBackendConnection#password}
    */
    readonly password?: string;
    /**
    * x509 CA file for validating the certificate presented by the MySQL server. Must be PEM encoded.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#tls_ca DatabaseSecretBackendConnection#tls_ca}
    */
    readonly tlsCa?: string;
    /**
    * x509 certificate for connecting to the database. This must be a PEM encoded version of the private key and the certificate combined.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#tls_certificate_key DatabaseSecretBackendConnection#tls_certificate_key}
    */
    readonly tlsCertificateKey?: string;
    /**
    * The root credential username used in the connection URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#username DatabaseSecretBackendConnection#username}
    */
    readonly username?: string;
    /**
    * Username generation template.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#username_template DatabaseSecretBackendConnection#username_template}
    */
    readonly usernameTemplate?: string;
}
export declare function databaseSecretBackendConnectionMysqlToTerraform(struct?: DatabaseSecretBackendConnectionMysqlOutputReference | DatabaseSecretBackendConnectionMysql): any;
export declare class DatabaseSecretBackendConnectionMysqlOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DatabaseSecretBackendConnectionMysql | undefined;
    set internalValue(value: DatabaseSecretBackendConnectionMysql | undefined);
    private _connectionUrl?;
    get connectionUrl(): string;
    set connectionUrl(value: string);
    resetConnectionUrl(): void;
    get connectionUrlInput(): string | undefined;
    private _maxConnectionLifetime?;
    get maxConnectionLifetime(): number;
    set maxConnectionLifetime(value: number);
    resetMaxConnectionLifetime(): void;
    get maxConnectionLifetimeInput(): number | undefined;
    private _maxIdleConnections?;
    get maxIdleConnections(): number;
    set maxIdleConnections(value: number);
    resetMaxIdleConnections(): void;
    get maxIdleConnectionsInput(): number | undefined;
    private _maxOpenConnections?;
    get maxOpenConnections(): number;
    set maxOpenConnections(value: number);
    resetMaxOpenConnections(): void;
    get maxOpenConnectionsInput(): number | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _tlsCa?;
    get tlsCa(): string;
    set tlsCa(value: string);
    resetTlsCa(): void;
    get tlsCaInput(): string | undefined;
    private _tlsCertificateKey?;
    get tlsCertificateKey(): string;
    set tlsCertificateKey(value: string);
    resetTlsCertificateKey(): void;
    get tlsCertificateKeyInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    resetUsername(): void;
    get usernameInput(): string | undefined;
    private _usernameTemplate?;
    get usernameTemplate(): string;
    set usernameTemplate(value: string);
    resetUsernameTemplate(): void;
    get usernameTemplateInput(): string | undefined;
}
export interface DatabaseSecretBackendConnectionMysqlAurora {
    /**
    * Connection string to use to connect to the database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#connection_url DatabaseSecretBackendConnection#connection_url}
    */
    readonly connectionUrl?: string;
    /**
    * Maximum number of seconds a connection may be reused.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#max_connection_lifetime DatabaseSecretBackendConnection#max_connection_lifetime}
    */
    readonly maxConnectionLifetime?: number;
    /**
    * Maximum number of idle connections to the database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#max_idle_connections DatabaseSecretBackendConnection#max_idle_connections}
    */
    readonly maxIdleConnections?: number;
    /**
    * Maximum number of open connections to the database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#max_open_connections DatabaseSecretBackendConnection#max_open_connections}
    */
    readonly maxOpenConnections?: number;
    /**
    * The root credential password used in the connection URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#password DatabaseSecretBackendConnection#password}
    */
    readonly password?: string;
    /**
    * The root credential username used in the connection URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#username DatabaseSecretBackendConnection#username}
    */
    readonly username?: string;
    /**
    * Username generation template.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#username_template DatabaseSecretBackendConnection#username_template}
    */
    readonly usernameTemplate?: string;
}
export declare function databaseSecretBackendConnectionMysqlAuroraToTerraform(struct?: DatabaseSecretBackendConnectionMysqlAuroraOutputReference | DatabaseSecretBackendConnectionMysqlAurora): any;
export declare class DatabaseSecretBackendConnectionMysqlAuroraOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DatabaseSecretBackendConnectionMysqlAurora | undefined;
    set internalValue(value: DatabaseSecretBackendConnectionMysqlAurora | undefined);
    private _connectionUrl?;
    get connectionUrl(): string;
    set connectionUrl(value: string);
    resetConnectionUrl(): void;
    get connectionUrlInput(): string | undefined;
    private _maxConnectionLifetime?;
    get maxConnectionLifetime(): number;
    set maxConnectionLifetime(value: number);
    resetMaxConnectionLifetime(): void;
    get maxConnectionLifetimeInput(): number | undefined;
    private _maxIdleConnections?;
    get maxIdleConnections(): number;
    set maxIdleConnections(value: number);
    resetMaxIdleConnections(): void;
    get maxIdleConnectionsInput(): number | undefined;
    private _maxOpenConnections?;
    get maxOpenConnections(): number;
    set maxOpenConnections(value: number);
    resetMaxOpenConnections(): void;
    get maxOpenConnectionsInput(): number | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    resetUsername(): void;
    get usernameInput(): string | undefined;
    private _usernameTemplate?;
    get usernameTemplate(): string;
    set usernameTemplate(value: string);
    resetUsernameTemplate(): void;
    get usernameTemplateInput(): string | undefined;
}
export interface DatabaseSecretBackendConnectionMysqlLegacy {
    /**
    * Connection string to use to connect to the database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#connection_url DatabaseSecretBackendConnection#connection_url}
    */
    readonly connectionUrl?: string;
    /**
    * Maximum number of seconds a connection may be reused.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#max_connection_lifetime DatabaseSecretBackendConnection#max_connection_lifetime}
    */
    readonly maxConnectionLifetime?: number;
    /**
    * Maximum number of idle connections to the database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#max_idle_connections DatabaseSecretBackendConnection#max_idle_connections}
    */
    readonly maxIdleConnections?: number;
    /**
    * Maximum number of open connections to the database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#max_open_connections DatabaseSecretBackendConnection#max_open_connections}
    */
    readonly maxOpenConnections?: number;
    /**
    * The root credential password used in the connection URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#password DatabaseSecretBackendConnection#password}
    */
    readonly password?: string;
    /**
    * The root credential username used in the connection URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#username DatabaseSecretBackendConnection#username}
    */
    readonly username?: string;
    /**
    * Username generation template.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#username_template DatabaseSecretBackendConnection#username_template}
    */
    readonly usernameTemplate?: string;
}
export declare function databaseSecretBackendConnectionMysqlLegacyToTerraform(struct?: DatabaseSecretBackendConnectionMysqlLegacyOutputReference | DatabaseSecretBackendConnectionMysqlLegacy): any;
export declare class DatabaseSecretBackendConnectionMysqlLegacyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DatabaseSecretBackendConnectionMysqlLegacy | undefined;
    set internalValue(value: DatabaseSecretBackendConnectionMysqlLegacy | undefined);
    private _connectionUrl?;
    get connectionUrl(): string;
    set connectionUrl(value: string);
    resetConnectionUrl(): void;
    get connectionUrlInput(): string | undefined;
    private _maxConnectionLifetime?;
    get maxConnectionLifetime(): number;
    set maxConnectionLifetime(value: number);
    resetMaxConnectionLifetime(): void;
    get maxConnectionLifetimeInput(): number | undefined;
    private _maxIdleConnections?;
    get maxIdleConnections(): number;
    set maxIdleConnections(value: number);
    resetMaxIdleConnections(): void;
    get maxIdleConnectionsInput(): number | undefined;
    private _maxOpenConnections?;
    get maxOpenConnections(): number;
    set maxOpenConnections(value: number);
    resetMaxOpenConnections(): void;
    get maxOpenConnectionsInput(): number | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    resetUsername(): void;
    get usernameInput(): string | undefined;
    private _usernameTemplate?;
    get usernameTemplate(): string;
    set usernameTemplate(value: string);
    resetUsernameTemplate(): void;
    get usernameTemplateInput(): string | undefined;
}
export interface DatabaseSecretBackendConnectionMysqlRds {
    /**
    * Connection string to use to connect to the database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#connection_url DatabaseSecretBackendConnection#connection_url}
    */
    readonly connectionUrl?: string;
    /**
    * Maximum number of seconds a connection may be reused.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#max_connection_lifetime DatabaseSecretBackendConnection#max_connection_lifetime}
    */
    readonly maxConnectionLifetime?: number;
    /**
    * Maximum number of idle connections to the database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#max_idle_connections DatabaseSecretBackendConnection#max_idle_connections}
    */
    readonly maxIdleConnections?: number;
    /**
    * Maximum number of open connections to the database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#max_open_connections DatabaseSecretBackendConnection#max_open_connections}
    */
    readonly maxOpenConnections?: number;
    /**
    * The root credential password used in the connection URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#password DatabaseSecretBackendConnection#password}
    */
    readonly password?: string;
    /**
    * The root credential username used in the connection URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#username DatabaseSecretBackendConnection#username}
    */
    readonly username?: string;
    /**
    * Username generation template.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#username_template DatabaseSecretBackendConnection#username_template}
    */
    readonly usernameTemplate?: string;
}
export declare function databaseSecretBackendConnectionMysqlRdsToTerraform(struct?: DatabaseSecretBackendConnectionMysqlRdsOutputReference | DatabaseSecretBackendConnectionMysqlRds): any;
export declare class DatabaseSecretBackendConnectionMysqlRdsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DatabaseSecretBackendConnectionMysqlRds | undefined;
    set internalValue(value: DatabaseSecretBackendConnectionMysqlRds | undefined);
    private _connectionUrl?;
    get connectionUrl(): string;
    set connectionUrl(value: string);
    resetConnectionUrl(): void;
    get connectionUrlInput(): string | undefined;
    private _maxConnectionLifetime?;
    get maxConnectionLifetime(): number;
    set maxConnectionLifetime(value: number);
    resetMaxConnectionLifetime(): void;
    get maxConnectionLifetimeInput(): number | undefined;
    private _maxIdleConnections?;
    get maxIdleConnections(): number;
    set maxIdleConnections(value: number);
    resetMaxIdleConnections(): void;
    get maxIdleConnectionsInput(): number | undefined;
    private _maxOpenConnections?;
    get maxOpenConnections(): number;
    set maxOpenConnections(value: number);
    resetMaxOpenConnections(): void;
    get maxOpenConnectionsInput(): number | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    resetUsername(): void;
    get usernameInput(): string | undefined;
    private _usernameTemplate?;
    get usernameTemplate(): string;
    set usernameTemplate(value: string);
    resetUsernameTemplate(): void;
    get usernameTemplateInput(): string | undefined;
}
export interface DatabaseSecretBackendConnectionOracle {
    /**
    * Connection string to use to connect to the database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#connection_url DatabaseSecretBackendConnection#connection_url}
    */
    readonly connectionUrl?: string;
    /**
    * Maximum number of seconds a connection may be reused.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#max_connection_lifetime DatabaseSecretBackendConnection#max_connection_lifetime}
    */
    readonly maxConnectionLifetime?: number;
    /**
    * Maximum number of idle connections to the database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#max_idle_connections DatabaseSecretBackendConnection#max_idle_connections}
    */
    readonly maxIdleConnections?: number;
    /**
    * Maximum number of open connections to the database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#max_open_connections DatabaseSecretBackendConnection#max_open_connections}
    */
    readonly maxOpenConnections?: number;
    /**
    * The root credential password used in the connection URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#password DatabaseSecretBackendConnection#password}
    */
    readonly password?: string;
    /**
    * The root credential username used in the connection URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#username DatabaseSecretBackendConnection#username}
    */
    readonly username?: string;
    /**
    * Username generation template.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#username_template DatabaseSecretBackendConnection#username_template}
    */
    readonly usernameTemplate?: string;
}
export declare function databaseSecretBackendConnectionOracleToTerraform(struct?: DatabaseSecretBackendConnectionOracleOutputReference | DatabaseSecretBackendConnectionOracle): any;
export declare class DatabaseSecretBackendConnectionOracleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DatabaseSecretBackendConnectionOracle | undefined;
    set internalValue(value: DatabaseSecretBackendConnectionOracle | undefined);
    private _connectionUrl?;
    get connectionUrl(): string;
    set connectionUrl(value: string);
    resetConnectionUrl(): void;
    get connectionUrlInput(): string | undefined;
    private _maxConnectionLifetime?;
    get maxConnectionLifetime(): number;
    set maxConnectionLifetime(value: number);
    resetMaxConnectionLifetime(): void;
    get maxConnectionLifetimeInput(): number | undefined;
    private _maxIdleConnections?;
    get maxIdleConnections(): number;
    set maxIdleConnections(value: number);
    resetMaxIdleConnections(): void;
    get maxIdleConnectionsInput(): number | undefined;
    private _maxOpenConnections?;
    get maxOpenConnections(): number;
    set maxOpenConnections(value: number);
    resetMaxOpenConnections(): void;
    get maxOpenConnectionsInput(): number | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    resetUsername(): void;
    get usernameInput(): string | undefined;
    private _usernameTemplate?;
    get usernameTemplate(): string;
    set usernameTemplate(value: string);
    resetUsernameTemplate(): void;
    get usernameTemplateInput(): string | undefined;
}
export interface DatabaseSecretBackendConnectionPostgresql {
    /**
    * Connection string to use to connect to the database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#connection_url DatabaseSecretBackendConnection#connection_url}
    */
    readonly connectionUrl?: string;
    /**
    * Disable special character escaping in username and password
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#disable_escaping DatabaseSecretBackendConnection#disable_escaping}
    */
    readonly disableEscaping?: boolean | cdktf.IResolvable;
    /**
    * Maximum number of seconds a connection may be reused.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#max_connection_lifetime DatabaseSecretBackendConnection#max_connection_lifetime}
    */
    readonly maxConnectionLifetime?: number;
    /**
    * Maximum number of idle connections to the database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#max_idle_connections DatabaseSecretBackendConnection#max_idle_connections}
    */
    readonly maxIdleConnections?: number;
    /**
    * Maximum number of open connections to the database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#max_open_connections DatabaseSecretBackendConnection#max_open_connections}
    */
    readonly maxOpenConnections?: number;
    /**
    * The root credential password used in the connection URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#password DatabaseSecretBackendConnection#password}
    */
    readonly password?: string;
    /**
    * The root credential username used in the connection URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#username DatabaseSecretBackendConnection#username}
    */
    readonly username?: string;
    /**
    * Username generation template.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#username_template DatabaseSecretBackendConnection#username_template}
    */
    readonly usernameTemplate?: string;
}
export declare function databaseSecretBackendConnectionPostgresqlToTerraform(struct?: DatabaseSecretBackendConnectionPostgresqlOutputReference | DatabaseSecretBackendConnectionPostgresql): any;
export declare class DatabaseSecretBackendConnectionPostgresqlOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DatabaseSecretBackendConnectionPostgresql | undefined;
    set internalValue(value: DatabaseSecretBackendConnectionPostgresql | undefined);
    private _connectionUrl?;
    get connectionUrl(): string;
    set connectionUrl(value: string);
    resetConnectionUrl(): void;
    get connectionUrlInput(): string | undefined;
    private _disableEscaping?;
    get disableEscaping(): boolean | cdktf.IResolvable;
    set disableEscaping(value: boolean | cdktf.IResolvable);
    resetDisableEscaping(): void;
    get disableEscapingInput(): boolean | cdktf.IResolvable | undefined;
    private _maxConnectionLifetime?;
    get maxConnectionLifetime(): number;
    set maxConnectionLifetime(value: number);
    resetMaxConnectionLifetime(): void;
    get maxConnectionLifetimeInput(): number | undefined;
    private _maxIdleConnections?;
    get maxIdleConnections(): number;
    set maxIdleConnections(value: number);
    resetMaxIdleConnections(): void;
    get maxIdleConnectionsInput(): number | undefined;
    private _maxOpenConnections?;
    get maxOpenConnections(): number;
    set maxOpenConnections(value: number);
    resetMaxOpenConnections(): void;
    get maxOpenConnectionsInput(): number | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    resetUsername(): void;
    get usernameInput(): string | undefined;
    private _usernameTemplate?;
    get usernameTemplate(): string;
    set usernameTemplate(value: string);
    resetUsernameTemplate(): void;
    get usernameTemplateInput(): string | undefined;
}
export interface DatabaseSecretBackendConnectionRedis {
    /**
    * The contents of a PEM-encoded CA cert file to use to verify the Redis server's identity.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#ca_cert DatabaseSecretBackendConnection#ca_cert}
    */
    readonly caCert?: string;
    /**
    * Specifies the host to connect to
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#host DatabaseSecretBackendConnection#host}
    */
    readonly host: string;
    /**
    * Specifies whether to skip verification of the server certificate when using TLS.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#insecure_tls DatabaseSecretBackendConnection#insecure_tls}
    */
    readonly insecureTls?: boolean | cdktf.IResolvable;
    /**
    * Specifies the password corresponding to the given username.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#password DatabaseSecretBackendConnection#password}
    */
    readonly password: string;
    /**
    * The transport port to use to connect to Redis.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#port DatabaseSecretBackendConnection#port}
    */
    readonly port?: number;
    /**
    * Specifies whether to use TLS when connecting to Redis.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#tls DatabaseSecretBackendConnection#tls}
    */
    readonly tls?: boolean | cdktf.IResolvable;
    /**
    * Specifies the username for Vault to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#username DatabaseSecretBackendConnection#username}
    */
    readonly username: string;
}
export declare function databaseSecretBackendConnectionRedisToTerraform(struct?: DatabaseSecretBackendConnectionRedisOutputReference | DatabaseSecretBackendConnectionRedis): any;
export declare class DatabaseSecretBackendConnectionRedisOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DatabaseSecretBackendConnectionRedis | undefined;
    set internalValue(value: DatabaseSecretBackendConnectionRedis | undefined);
    private _caCert?;
    get caCert(): string;
    set caCert(value: string);
    resetCaCert(): void;
    get caCertInput(): string | undefined;
    private _host?;
    get host(): string;
    set host(value: string);
    get hostInput(): string | undefined;
    private _insecureTls?;
    get insecureTls(): boolean | cdktf.IResolvable;
    set insecureTls(value: boolean | cdktf.IResolvable);
    resetInsecureTls(): void;
    get insecureTlsInput(): boolean | cdktf.IResolvable | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _tls?;
    get tls(): boolean | cdktf.IResolvable;
    set tls(value: boolean | cdktf.IResolvable);
    resetTls(): void;
    get tlsInput(): boolean | cdktf.IResolvable | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export interface DatabaseSecretBackendConnectionRedisElasticache {
    /**
    * The AWS secret key id to use to talk to ElastiCache. If omitted the credentials chain provider is used instead.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#password DatabaseSecretBackendConnection#password}
    */
    readonly password?: string;
    /**
    * The AWS region where the ElastiCache cluster is hosted. If omitted the plugin tries to infer the region from the environment.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#region DatabaseSecretBackendConnection#region}
    */
    readonly region?: string;
    /**
    * The configuration endpoint for the ElastiCache cluster to connect to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#url DatabaseSecretBackendConnection#url}
    */
    readonly url: string;
    /**
    * The AWS access key id to use to talk to ElastiCache. If omitted the credentials chain provider is used instead.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#username DatabaseSecretBackendConnection#username}
    */
    readonly username?: string;
}
export declare function databaseSecretBackendConnectionRedisElasticacheToTerraform(struct?: DatabaseSecretBackendConnectionRedisElasticacheOutputReference | DatabaseSecretBackendConnectionRedisElasticache): any;
export declare class DatabaseSecretBackendConnectionRedisElasticacheOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DatabaseSecretBackendConnectionRedisElasticache | undefined;
    set internalValue(value: DatabaseSecretBackendConnectionRedisElasticache | undefined);
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _url?;
    get url(): string;
    set url(value: string);
    get urlInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    resetUsername(): void;
    get usernameInput(): string | undefined;
}
export interface DatabaseSecretBackendConnectionRedshift {
    /**
    * Connection string to use to connect to the database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#connection_url DatabaseSecretBackendConnection#connection_url}
    */
    readonly connectionUrl?: string;
    /**
    * Disable special character escaping in username and password
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#disable_escaping DatabaseSecretBackendConnection#disable_escaping}
    */
    readonly disableEscaping?: boolean | cdktf.IResolvable;
    /**
    * Maximum number of seconds a connection may be reused.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#max_connection_lifetime DatabaseSecretBackendConnection#max_connection_lifetime}
    */
    readonly maxConnectionLifetime?: number;
    /**
    * Maximum number of idle connections to the database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#max_idle_connections DatabaseSecretBackendConnection#max_idle_connections}
    */
    readonly maxIdleConnections?: number;
    /**
    * Maximum number of open connections to the database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#max_open_connections DatabaseSecretBackendConnection#max_open_connections}
    */
    readonly maxOpenConnections?: number;
    /**
    * The root credential password used in the connection URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#password DatabaseSecretBackendConnection#password}
    */
    readonly password?: string;
    /**
    * The root credential username used in the connection URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#username DatabaseSecretBackendConnection#username}
    */
    readonly username?: string;
    /**
    * Username generation template.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#username_template DatabaseSecretBackendConnection#username_template}
    */
    readonly usernameTemplate?: string;
}
export declare function databaseSecretBackendConnectionRedshiftToTerraform(struct?: DatabaseSecretBackendConnectionRedshiftOutputReference | DatabaseSecretBackendConnectionRedshift): any;
export declare class DatabaseSecretBackendConnectionRedshiftOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DatabaseSecretBackendConnectionRedshift | undefined;
    set internalValue(value: DatabaseSecretBackendConnectionRedshift | undefined);
    private _connectionUrl?;
    get connectionUrl(): string;
    set connectionUrl(value: string);
    resetConnectionUrl(): void;
    get connectionUrlInput(): string | undefined;
    private _disableEscaping?;
    get disableEscaping(): boolean | cdktf.IResolvable;
    set disableEscaping(value: boolean | cdktf.IResolvable);
    resetDisableEscaping(): void;
    get disableEscapingInput(): boolean | cdktf.IResolvable | undefined;
    private _maxConnectionLifetime?;
    get maxConnectionLifetime(): number;
    set maxConnectionLifetime(value: number);
    resetMaxConnectionLifetime(): void;
    get maxConnectionLifetimeInput(): number | undefined;
    private _maxIdleConnections?;
    get maxIdleConnections(): number;
    set maxIdleConnections(value: number);
    resetMaxIdleConnections(): void;
    get maxIdleConnectionsInput(): number | undefined;
    private _maxOpenConnections?;
    get maxOpenConnections(): number;
    set maxOpenConnections(value: number);
    resetMaxOpenConnections(): void;
    get maxOpenConnectionsInput(): number | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    resetUsername(): void;
    get usernameInput(): string | undefined;
    private _usernameTemplate?;
    get usernameTemplate(): string;
    set usernameTemplate(value: string);
    resetUsernameTemplate(): void;
    get usernameTemplateInput(): string | undefined;
}
export interface DatabaseSecretBackendConnectionSnowflake {
    /**
    * Connection string to use to connect to the database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#connection_url DatabaseSecretBackendConnection#connection_url}
    */
    readonly connectionUrl?: string;
    /**
    * Maximum number of seconds a connection may be reused.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#max_connection_lifetime DatabaseSecretBackendConnection#max_connection_lifetime}
    */
    readonly maxConnectionLifetime?: number;
    /**
    * Maximum number of idle connections to the database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#max_idle_connections DatabaseSecretBackendConnection#max_idle_connections}
    */
    readonly maxIdleConnections?: number;
    /**
    * Maximum number of open connections to the database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#max_open_connections DatabaseSecretBackendConnection#max_open_connections}
    */
    readonly maxOpenConnections?: number;
    /**
    * The root credential password used in the connection URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#password DatabaseSecretBackendConnection#password}
    */
    readonly password?: string;
    /**
    * The root credential username used in the connection URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#username DatabaseSecretBackendConnection#username}
    */
    readonly username?: string;
    /**
    * Username generation template.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection#username_template DatabaseSecretBackendConnection#username_template}
    */
    readonly usernameTemplate?: string;
}
export declare function databaseSecretBackendConnectionSnowflakeToTerraform(struct?: DatabaseSecretBackendConnectionSnowflakeOutputReference | DatabaseSecretBackendConnectionSnowflake): any;
export declare class DatabaseSecretBackendConnectionSnowflakeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DatabaseSecretBackendConnectionSnowflake | undefined;
    set internalValue(value: DatabaseSecretBackendConnectionSnowflake | undefined);
    private _connectionUrl?;
    get connectionUrl(): string;
    set connectionUrl(value: string);
    resetConnectionUrl(): void;
    get connectionUrlInput(): string | undefined;
    private _maxConnectionLifetime?;
    get maxConnectionLifetime(): number;
    set maxConnectionLifetime(value: number);
    resetMaxConnectionLifetime(): void;
    get maxConnectionLifetimeInput(): number | undefined;
    private _maxIdleConnections?;
    get maxIdleConnections(): number;
    set maxIdleConnections(value: number);
    resetMaxIdleConnections(): void;
    get maxIdleConnectionsInput(): number | undefined;
    private _maxOpenConnections?;
    get maxOpenConnections(): number;
    set maxOpenConnections(value: number);
    resetMaxOpenConnections(): void;
    get maxOpenConnectionsInput(): number | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    resetUsername(): void;
    get usernameInput(): string | undefined;
    private _usernameTemplate?;
    get usernameTemplate(): string;
    set usernameTemplate(value: string);
    resetUsernameTemplate(): void;
    get usernameTemplateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection vault_database_secret_backend_connection}
*/
export declare class DatabaseSecretBackendConnection extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_database_secret_backend_connection";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_connection vault_database_secret_backend_connection} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DatabaseSecretBackendConnectionConfig
    */
    constructor(scope: Construct, id: string, config: DatabaseSecretBackendConnectionConfig);
    private _allowedRoles?;
    get allowedRoles(): string[];
    set allowedRoles(value: string[]);
    resetAllowedRoles(): void;
    get allowedRolesInput(): string[] | undefined;
    private _backend?;
    get backend(): string;
    set backend(value: string);
    get backendInput(): string | undefined;
    private _data?;
    get data(): {
        [key: string]: string;
    };
    set data(value: {
        [key: string]: string;
    });
    resetData(): void;
    get dataInput(): {
        [key: string]: string;
    } | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _pluginName?;
    get pluginName(): string;
    set pluginName(value: string);
    resetPluginName(): void;
    get pluginNameInput(): string | undefined;
    private _rootRotationStatements?;
    get rootRotationStatements(): string[];
    set rootRotationStatements(value: string[]);
    resetRootRotationStatements(): void;
    get rootRotationStatementsInput(): string[] | undefined;
    private _verifyConnection?;
    get verifyConnection(): boolean | cdktf.IResolvable;
    set verifyConnection(value: boolean | cdktf.IResolvable);
    resetVerifyConnection(): void;
    get verifyConnectionInput(): boolean | cdktf.IResolvable | undefined;
    private _cassandra;
    get cassandra(): DatabaseSecretBackendConnectionCassandraOutputReference;
    putCassandra(value: DatabaseSecretBackendConnectionCassandra): void;
    resetCassandra(): void;
    get cassandraInput(): DatabaseSecretBackendConnectionCassandra | undefined;
    private _couchbase;
    get couchbase(): DatabaseSecretBackendConnectionCouchbaseOutputReference;
    putCouchbase(value: DatabaseSecretBackendConnectionCouchbase): void;
    resetCouchbase(): void;
    get couchbaseInput(): DatabaseSecretBackendConnectionCouchbase | undefined;
    private _elasticsearch;
    get elasticsearch(): DatabaseSecretBackendConnectionElasticsearchOutputReference;
    putElasticsearch(value: DatabaseSecretBackendConnectionElasticsearch): void;
    resetElasticsearch(): void;
    get elasticsearchInput(): DatabaseSecretBackendConnectionElasticsearch | undefined;
    private _hana;
    get hana(): DatabaseSecretBackendConnectionHanaOutputReference;
    putHana(value: DatabaseSecretBackendConnectionHana): void;
    resetHana(): void;
    get hanaInput(): DatabaseSecretBackendConnectionHana | undefined;
    private _influxdb;
    get influxdb(): DatabaseSecretBackendConnectionInfluxdbOutputReference;
    putInfluxdb(value: DatabaseSecretBackendConnectionInfluxdb): void;
    resetInfluxdb(): void;
    get influxdbInput(): DatabaseSecretBackendConnectionInfluxdb | undefined;
    private _mongodb;
    get mongodb(): DatabaseSecretBackendConnectionMongodbOutputReference;
    putMongodb(value: DatabaseSecretBackendConnectionMongodb): void;
    resetMongodb(): void;
    get mongodbInput(): DatabaseSecretBackendConnectionMongodb | undefined;
    private _mongodbatlas;
    get mongodbatlas(): DatabaseSecretBackendConnectionMongodbatlasOutputReference;
    putMongodbatlas(value: DatabaseSecretBackendConnectionMongodbatlas): void;
    resetMongodbatlas(): void;
    get mongodbatlasInput(): DatabaseSecretBackendConnectionMongodbatlas | undefined;
    private _mssql;
    get mssql(): DatabaseSecretBackendConnectionMssqlOutputReference;
    putMssql(value: DatabaseSecretBackendConnectionMssql): void;
    resetMssql(): void;
    get mssqlInput(): DatabaseSecretBackendConnectionMssql | undefined;
    private _mysql;
    get mysql(): DatabaseSecretBackendConnectionMysqlOutputReference;
    putMysql(value: DatabaseSecretBackendConnectionMysql): void;
    resetMysql(): void;
    get mysqlInput(): DatabaseSecretBackendConnectionMysql | undefined;
    private _mysqlAurora;
    get mysqlAurora(): DatabaseSecretBackendConnectionMysqlAuroraOutputReference;
    putMysqlAurora(value: DatabaseSecretBackendConnectionMysqlAurora): void;
    resetMysqlAurora(): void;
    get mysqlAuroraInput(): DatabaseSecretBackendConnectionMysqlAurora | undefined;
    private _mysqlLegacy;
    get mysqlLegacy(): DatabaseSecretBackendConnectionMysqlLegacyOutputReference;
    putMysqlLegacy(value: DatabaseSecretBackendConnectionMysqlLegacy): void;
    resetMysqlLegacy(): void;
    get mysqlLegacyInput(): DatabaseSecretBackendConnectionMysqlLegacy | undefined;
    private _mysqlRds;
    get mysqlRds(): DatabaseSecretBackendConnectionMysqlRdsOutputReference;
    putMysqlRds(value: DatabaseSecretBackendConnectionMysqlRds): void;
    resetMysqlRds(): void;
    get mysqlRdsInput(): DatabaseSecretBackendConnectionMysqlRds | undefined;
    private _oracle;
    get oracle(): DatabaseSecretBackendConnectionOracleOutputReference;
    putOracle(value: DatabaseSecretBackendConnectionOracle): void;
    resetOracle(): void;
    get oracleInput(): DatabaseSecretBackendConnectionOracle | undefined;
    private _postgresql;
    get postgresql(): DatabaseSecretBackendConnectionPostgresqlOutputReference;
    putPostgresql(value: DatabaseSecretBackendConnectionPostgresql): void;
    resetPostgresql(): void;
    get postgresqlInput(): DatabaseSecretBackendConnectionPostgresql | undefined;
    private _redis;
    get redis(): DatabaseSecretBackendConnectionRedisOutputReference;
    putRedis(value: DatabaseSecretBackendConnectionRedis): void;
    resetRedis(): void;
    get redisInput(): DatabaseSecretBackendConnectionRedis | undefined;
    private _redisElasticache;
    get redisElasticache(): DatabaseSecretBackendConnectionRedisElasticacheOutputReference;
    putRedisElasticache(value: DatabaseSecretBackendConnectionRedisElasticache): void;
    resetRedisElasticache(): void;
    get redisElasticacheInput(): DatabaseSecretBackendConnectionRedisElasticache | undefined;
    private _redshift;
    get redshift(): DatabaseSecretBackendConnectionRedshiftOutputReference;
    putRedshift(value: DatabaseSecretBackendConnectionRedshift): void;
    resetRedshift(): void;
    get redshiftInput(): DatabaseSecretBackendConnectionRedshift | undefined;
    private _snowflake;
    get snowflake(): DatabaseSecretBackendConnectionSnowflakeOutputReference;
    putSnowflake(value: DatabaseSecretBackendConnectionSnowflake): void;
    resetSnowflake(): void;
    get snowflakeInput(): DatabaseSecretBackendConnectionSnowflake | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
