import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PkiSecretBackendCrlConfigConfig extends cdktf.TerraformMetaArguments {
    /**
    * Enables or disables periodic rebuilding of the CRL upon expiry.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_crl_config#auto_rebuild PkiSecretBackendCrlConfig#auto_rebuild}
    */
    readonly autoRebuild?: boolean | cdktf.IResolvable;
    /**
    * Grace period before CRL expiry to attempt rebuild of CRL.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_crl_config#auto_rebuild_grace_period PkiSecretBackendCrlConfig#auto_rebuild_grace_period}
    */
    readonly autoRebuildGracePeriod?: string;
    /**
    * The path of the PKI secret backend the resource belongs to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_crl_config#backend PkiSecretBackendCrlConfig#backend}
    */
    readonly backend: string;
    /**
    * Enable cross-cluster revocation request queues.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_crl_config#cross_cluster_revocation PkiSecretBackendCrlConfig#cross_cluster_revocation}
    */
    readonly crossClusterRevocation?: boolean | cdktf.IResolvable;
    /**
    * Interval to check for new revocations on, to regenerate the delta CRL.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_crl_config#delta_rebuild_interval PkiSecretBackendCrlConfig#delta_rebuild_interval}
    */
    readonly deltaRebuildInterval?: string;
    /**
    * Disables or enables CRL building
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_crl_config#disable PkiSecretBackendCrlConfig#disable}
    */
    readonly disable?: boolean | cdktf.IResolvable;
    /**
    * Enables or disables building of delta CRLs with up-to-date revocation information, augmenting the last complete CRL.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_crl_config#enable_delta PkiSecretBackendCrlConfig#enable_delta}
    */
    readonly enableDelta?: boolean | cdktf.IResolvable;
    /**
    * Specifies the time until expiration.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_crl_config#expiry PkiSecretBackendCrlConfig#expiry}
    */
    readonly expiry?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_crl_config#id PkiSecretBackendCrlConfig#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_crl_config#namespace PkiSecretBackendCrlConfig#namespace}
    */
    readonly namespace?: string;
    /**
    * Disables or enables the OCSP responder in Vault.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_crl_config#ocsp_disable PkiSecretBackendCrlConfig#ocsp_disable}
    */
    readonly ocspDisable?: boolean | cdktf.IResolvable;
    /**
    * The amount of time an OCSP response can be cached for, useful for OCSP stapling refresh durations.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_crl_config#ocsp_expiry PkiSecretBackendCrlConfig#ocsp_expiry}
    */
    readonly ocspExpiry?: string;
    /**
    * Enables unified CRL and OCSP building.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_crl_config#unified_crl PkiSecretBackendCrlConfig#unified_crl}
    */
    readonly unifiedCrl?: boolean | cdktf.IResolvable;
    /**
    * Enables serving the unified CRL and OCSP on the existing, previously cluster-local paths.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_crl_config#unified_crl_on_existing_paths PkiSecretBackendCrlConfig#unified_crl_on_existing_paths}
    */
    readonly unifiedCrlOnExistingPaths?: boolean | cdktf.IResolvable;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_crl_config vault_pki_secret_backend_crl_config}
*/
export declare class PkiSecretBackendCrlConfig extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_pki_secret_backend_crl_config";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_crl_config vault_pki_secret_backend_crl_config} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PkiSecretBackendCrlConfigConfig
    */
    constructor(scope: Construct, id: string, config: PkiSecretBackendCrlConfigConfig);
    private _autoRebuild?;
    get autoRebuild(): boolean | cdktf.IResolvable;
    set autoRebuild(value: boolean | cdktf.IResolvable);
    resetAutoRebuild(): void;
    get autoRebuildInput(): boolean | cdktf.IResolvable | undefined;
    private _autoRebuildGracePeriod?;
    get autoRebuildGracePeriod(): string;
    set autoRebuildGracePeriod(value: string);
    resetAutoRebuildGracePeriod(): void;
    get autoRebuildGracePeriodInput(): string | undefined;
    private _backend?;
    get backend(): string;
    set backend(value: string);
    get backendInput(): string | undefined;
    private _crossClusterRevocation?;
    get crossClusterRevocation(): boolean | cdktf.IResolvable;
    set crossClusterRevocation(value: boolean | cdktf.IResolvable);
    resetCrossClusterRevocation(): void;
    get crossClusterRevocationInput(): boolean | cdktf.IResolvable | undefined;
    private _deltaRebuildInterval?;
    get deltaRebuildInterval(): string;
    set deltaRebuildInterval(value: string);
    resetDeltaRebuildInterval(): void;
    get deltaRebuildIntervalInput(): string | undefined;
    private _disable?;
    get disable(): boolean | cdktf.IResolvable;
    set disable(value: boolean | cdktf.IResolvable);
    resetDisable(): void;
    get disableInput(): boolean | cdktf.IResolvable | undefined;
    private _enableDelta?;
    get enableDelta(): boolean | cdktf.IResolvable;
    set enableDelta(value: boolean | cdktf.IResolvable);
    resetEnableDelta(): void;
    get enableDeltaInput(): boolean | cdktf.IResolvable | undefined;
    private _expiry?;
    get expiry(): string;
    set expiry(value: string);
    resetExpiry(): void;
    get expiryInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _ocspDisable?;
    get ocspDisable(): boolean | cdktf.IResolvable;
    set ocspDisable(value: boolean | cdktf.IResolvable);
    resetOcspDisable(): void;
    get ocspDisableInput(): boolean | cdktf.IResolvable | undefined;
    private _ocspExpiry?;
    get ocspExpiry(): string;
    set ocspExpiry(value: string);
    resetOcspExpiry(): void;
    get ocspExpiryInput(): string | undefined;
    private _unifiedCrl?;
    get unifiedCrl(): boolean | cdktf.IResolvable;
    set unifiedCrl(value: boolean | cdktf.IResolvable);
    resetUnifiedCrl(): void;
    get unifiedCrlInput(): boolean | cdktf.IResolvable | undefined;
    private _unifiedCrlOnExistingPaths?;
    get unifiedCrlOnExistingPaths(): boolean | cdktf.IResolvable;
    set unifiedCrlOnExistingPaths(value: boolean | cdktf.IResolvable);
    resetUnifiedCrlOnExistingPaths(): void;
    get unifiedCrlOnExistingPathsInput(): boolean | cdktf.IResolvable | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
