import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PkiSecretBackendRootCertConfig extends cdktf.TerraformMetaArguments {
    /**
    * List of alternative names.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_root_cert#alt_names PkiSecretBackendRootCert#alt_names}
    */
    readonly altNames?: string[];
    /**
    * The PKI secret backend the resource belongs to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_root_cert#backend PkiSecretBackendRootCert#backend}
    */
    readonly backend: string;
    /**
    * CN of root to create.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_root_cert#common_name PkiSecretBackendRootCert#common_name}
    */
    readonly commonName: string;
    /**
    * The country.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_root_cert#country PkiSecretBackendRootCert#country}
    */
    readonly country?: string;
    /**
    * Flag to exclude CN from SANs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_root_cert#exclude_cn_from_sans PkiSecretBackendRootCert#exclude_cn_from_sans}
    */
    readonly excludeCnFromSans?: boolean | cdktf.IResolvable;
    /**
    * The format of data.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_root_cert#format PkiSecretBackendRootCert#format}
    */
    readonly format?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_root_cert#id PkiSecretBackendRootCert#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * List of alternative IPs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_root_cert#ip_sans PkiSecretBackendRootCert#ip_sans}
    */
    readonly ipSans?: string[];
    /**
    * The number of bits to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_root_cert#key_bits PkiSecretBackendRootCert#key_bits}
    */
    readonly keyBits?: number;
    /**
    * The desired key type.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_root_cert#key_type PkiSecretBackendRootCert#key_type}
    */
    readonly keyType?: string;
    /**
    * The locality.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_root_cert#locality PkiSecretBackendRootCert#locality}
    */
    readonly locality?: string;
    /**
    * The ID of the previously configured managed key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_root_cert#managed_key_id PkiSecretBackendRootCert#managed_key_id}
    */
    readonly managedKeyId?: string;
    /**
    * The name of the previously configured managed key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_root_cert#managed_key_name PkiSecretBackendRootCert#managed_key_name}
    */
    readonly managedKeyName?: string;
    /**
    * The maximum path length to encode in the generated certificate.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_root_cert#max_path_length PkiSecretBackendRootCert#max_path_length}
    */
    readonly maxPathLength?: number;
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_root_cert#namespace PkiSecretBackendRootCert#namespace}
    */
    readonly namespace?: string;
    /**
    * The organization.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_root_cert#organization PkiSecretBackendRootCert#organization}
    */
    readonly organization?: string;
    /**
    * List of other SANs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_root_cert#other_sans PkiSecretBackendRootCert#other_sans}
    */
    readonly otherSans?: string[];
    /**
    * The organization unit.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_root_cert#ou PkiSecretBackendRootCert#ou}
    */
    readonly ou?: string;
    /**
    * List of domains for which certificates are allowed to be issued.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_root_cert#permitted_dns_domains PkiSecretBackendRootCert#permitted_dns_domains}
    */
    readonly permittedDnsDomains?: string[];
    /**
    * The postal code.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_root_cert#postal_code PkiSecretBackendRootCert#postal_code}
    */
    readonly postalCode?: string;
    /**
    * The private key format.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_root_cert#private_key_format PkiSecretBackendRootCert#private_key_format}
    */
    readonly privateKeyFormat?: string;
    /**
    * The province.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_root_cert#province PkiSecretBackendRootCert#province}
    */
    readonly province?: string;
    /**
    * The street address.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_root_cert#street_address PkiSecretBackendRootCert#street_address}
    */
    readonly streetAddress?: string;
    /**
    * Time to live.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_root_cert#ttl PkiSecretBackendRootCert#ttl}
    */
    readonly ttl?: string;
    /**
    * Type of root to create. Must be either "exported" or "internal".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_root_cert#type PkiSecretBackendRootCert#type}
    */
    readonly type: string;
    /**
    * List of alternative URIs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_root_cert#uri_sans PkiSecretBackendRootCert#uri_sans}
    */
    readonly uriSans?: string[];
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_root_cert vault_pki_secret_backend_root_cert}
*/
export declare class PkiSecretBackendRootCert extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_pki_secret_backend_root_cert";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_root_cert vault_pki_secret_backend_root_cert} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PkiSecretBackendRootCertConfig
    */
    constructor(scope: Construct, id: string, config: PkiSecretBackendRootCertConfig);
    private _altNames?;
    get altNames(): string[];
    set altNames(value: string[]);
    resetAltNames(): void;
    get altNamesInput(): string[] | undefined;
    private _backend?;
    get backend(): string;
    set backend(value: string);
    get backendInput(): string | undefined;
    get certificate(): string;
    private _commonName?;
    get commonName(): string;
    set commonName(value: string);
    get commonNameInput(): string | undefined;
    private _country?;
    get country(): string;
    set country(value: string);
    resetCountry(): void;
    get countryInput(): string | undefined;
    private _excludeCnFromSans?;
    get excludeCnFromSans(): boolean | cdktf.IResolvable;
    set excludeCnFromSans(value: boolean | cdktf.IResolvable);
    resetExcludeCnFromSans(): void;
    get excludeCnFromSansInput(): boolean | cdktf.IResolvable | undefined;
    private _format?;
    get format(): string;
    set format(value: string);
    resetFormat(): void;
    get formatInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ipSans?;
    get ipSans(): string[];
    set ipSans(value: string[]);
    resetIpSans(): void;
    get ipSansInput(): string[] | undefined;
    get issuingCa(): string;
    private _keyBits?;
    get keyBits(): number;
    set keyBits(value: number);
    resetKeyBits(): void;
    get keyBitsInput(): number | undefined;
    private _keyType?;
    get keyType(): string;
    set keyType(value: string);
    resetKeyType(): void;
    get keyTypeInput(): string | undefined;
    private _locality?;
    get locality(): string;
    set locality(value: string);
    resetLocality(): void;
    get localityInput(): string | undefined;
    private _managedKeyId?;
    get managedKeyId(): string;
    set managedKeyId(value: string);
    resetManagedKeyId(): void;
    get managedKeyIdInput(): string | undefined;
    private _managedKeyName?;
    get managedKeyName(): string;
    set managedKeyName(value: string);
    resetManagedKeyName(): void;
    get managedKeyNameInput(): string | undefined;
    private _maxPathLength?;
    get maxPathLength(): number;
    set maxPathLength(value: number);
    resetMaxPathLength(): void;
    get maxPathLengthInput(): number | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _organization?;
    get organization(): string;
    set organization(value: string);
    resetOrganization(): void;
    get organizationInput(): string | undefined;
    private _otherSans?;
    get otherSans(): string[];
    set otherSans(value: string[]);
    resetOtherSans(): void;
    get otherSansInput(): string[] | undefined;
    private _ou?;
    get ou(): string;
    set ou(value: string);
    resetOu(): void;
    get ouInput(): string | undefined;
    private _permittedDnsDomains?;
    get permittedDnsDomains(): string[];
    set permittedDnsDomains(value: string[]);
    resetPermittedDnsDomains(): void;
    get permittedDnsDomainsInput(): string[] | undefined;
    private _postalCode?;
    get postalCode(): string;
    set postalCode(value: string);
    resetPostalCode(): void;
    get postalCodeInput(): string | undefined;
    private _privateKeyFormat?;
    get privateKeyFormat(): string;
    set privateKeyFormat(value: string);
    resetPrivateKeyFormat(): void;
    get privateKeyFormatInput(): string | undefined;
    private _province?;
    get province(): string;
    set province(value: string);
    resetProvince(): void;
    get provinceInput(): string | undefined;
    get serial(): string;
    get serialNumber(): string;
    private _streetAddress?;
    get streetAddress(): string;
    set streetAddress(value: string);
    resetStreetAddress(): void;
    get streetAddressInput(): string | undefined;
    private _ttl?;
    get ttl(): string;
    set ttl(value: string);
    resetTtl(): void;
    get ttlInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _uriSans?;
    get uriSans(): string[];
    set uriSans(value: string[]);
    resetUriSans(): void;
    get uriSansInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
