"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RaftSnapshotAgentConfig = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/raft_snapshot_agent_config vault_raft_snapshot_agent_config}
*/
class RaftSnapshotAgentConfig extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/raft_snapshot_agent_config vault_raft_snapshot_agent_config} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options RaftSnapshotAgentConfigConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'vault_raft_snapshot_agent_config',
            terraformGeneratorMetadata: {
                providerName: 'vault',
                providerVersion: '3.14.0',
                providerVersionConstraint: '~> 3.7'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        this._awsAccessKeyId = config.awsAccessKeyId;
        this._awsS3Bucket = config.awsS3Bucket;
        this._awsS3DisableTls = config.awsS3DisableTls;
        this._awsS3EnableKms = config.awsS3EnableKms;
        this._awsS3Endpoint = config.awsS3Endpoint;
        this._awsS3ForcePathStyle = config.awsS3ForcePathStyle;
        this._awsS3KmsKey = config.awsS3KmsKey;
        this._awsS3Region = config.awsS3Region;
        this._awsS3ServerSideEncryption = config.awsS3ServerSideEncryption;
        this._awsSecretAccessKey = config.awsSecretAccessKey;
        this._awsSessionToken = config.awsSessionToken;
        this._azureAccountKey = config.azureAccountKey;
        this._azureAccountName = config.azureAccountName;
        this._azureBlobEnvironment = config.azureBlobEnvironment;
        this._azureContainerName = config.azureContainerName;
        this._azureEndpoint = config.azureEndpoint;
        this._filePrefix = config.filePrefix;
        this._googleDisableTls = config.googleDisableTls;
        this._googleEndpoint = config.googleEndpoint;
        this._googleGcsBucket = config.googleGcsBucket;
        this._googleServiceAccountKey = config.googleServiceAccountKey;
        this._id = config.id;
        this._intervalSeconds = config.intervalSeconds;
        this._localMaxSpace = config.localMaxSpace;
        this._name = config.name;
        this._namespace = config.namespace;
        this._pathPrefix = config.pathPrefix;
        this._retain = config.retain;
        this._storageType = config.storageType;
    }
    get awsAccessKeyId() {
        return this.getStringAttribute('aws_access_key_id');
    }
    set awsAccessKeyId(value) {
        this._awsAccessKeyId = value;
    }
    resetAwsAccessKeyId() {
        this._awsAccessKeyId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get awsAccessKeyIdInput() {
        return this._awsAccessKeyId;
    }
    get awsS3Bucket() {
        return this.getStringAttribute('aws_s3_bucket');
    }
    set awsS3Bucket(value) {
        this._awsS3Bucket = value;
    }
    resetAwsS3Bucket() {
        this._awsS3Bucket = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get awsS3BucketInput() {
        return this._awsS3Bucket;
    }
    get awsS3DisableTls() {
        return this.getBooleanAttribute('aws_s3_disable_tls');
    }
    set awsS3DisableTls(value) {
        this._awsS3DisableTls = value;
    }
    resetAwsS3DisableTls() {
        this._awsS3DisableTls = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get awsS3DisableTlsInput() {
        return this._awsS3DisableTls;
    }
    get awsS3EnableKms() {
        return this.getBooleanAttribute('aws_s3_enable_kms');
    }
    set awsS3EnableKms(value) {
        this._awsS3EnableKms = value;
    }
    resetAwsS3EnableKms() {
        this._awsS3EnableKms = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get awsS3EnableKmsInput() {
        return this._awsS3EnableKms;
    }
    get awsS3Endpoint() {
        return this.getStringAttribute('aws_s3_endpoint');
    }
    set awsS3Endpoint(value) {
        this._awsS3Endpoint = value;
    }
    resetAwsS3Endpoint() {
        this._awsS3Endpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get awsS3EndpointInput() {
        return this._awsS3Endpoint;
    }
    get awsS3ForcePathStyle() {
        return this.getBooleanAttribute('aws_s3_force_path_style');
    }
    set awsS3ForcePathStyle(value) {
        this._awsS3ForcePathStyle = value;
    }
    resetAwsS3ForcePathStyle() {
        this._awsS3ForcePathStyle = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get awsS3ForcePathStyleInput() {
        return this._awsS3ForcePathStyle;
    }
    get awsS3KmsKey() {
        return this.getStringAttribute('aws_s3_kms_key');
    }
    set awsS3KmsKey(value) {
        this._awsS3KmsKey = value;
    }
    resetAwsS3KmsKey() {
        this._awsS3KmsKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get awsS3KmsKeyInput() {
        return this._awsS3KmsKey;
    }
    get awsS3Region() {
        return this.getStringAttribute('aws_s3_region');
    }
    set awsS3Region(value) {
        this._awsS3Region = value;
    }
    resetAwsS3Region() {
        this._awsS3Region = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get awsS3RegionInput() {
        return this._awsS3Region;
    }
    get awsS3ServerSideEncryption() {
        return this.getBooleanAttribute('aws_s3_server_side_encryption');
    }
    set awsS3ServerSideEncryption(value) {
        this._awsS3ServerSideEncryption = value;
    }
    resetAwsS3ServerSideEncryption() {
        this._awsS3ServerSideEncryption = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get awsS3ServerSideEncryptionInput() {
        return this._awsS3ServerSideEncryption;
    }
    get awsSecretAccessKey() {
        return this.getStringAttribute('aws_secret_access_key');
    }
    set awsSecretAccessKey(value) {
        this._awsSecretAccessKey = value;
    }
    resetAwsSecretAccessKey() {
        this._awsSecretAccessKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get awsSecretAccessKeyInput() {
        return this._awsSecretAccessKey;
    }
    get awsSessionToken() {
        return this.getStringAttribute('aws_session_token');
    }
    set awsSessionToken(value) {
        this._awsSessionToken = value;
    }
    resetAwsSessionToken() {
        this._awsSessionToken = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get awsSessionTokenInput() {
        return this._awsSessionToken;
    }
    get azureAccountKey() {
        return this.getStringAttribute('azure_account_key');
    }
    set azureAccountKey(value) {
        this._azureAccountKey = value;
    }
    resetAzureAccountKey() {
        this._azureAccountKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get azureAccountKeyInput() {
        return this._azureAccountKey;
    }
    get azureAccountName() {
        return this.getStringAttribute('azure_account_name');
    }
    set azureAccountName(value) {
        this._azureAccountName = value;
    }
    resetAzureAccountName() {
        this._azureAccountName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get azureAccountNameInput() {
        return this._azureAccountName;
    }
    get azureBlobEnvironment() {
        return this.getStringAttribute('azure_blob_environment');
    }
    set azureBlobEnvironment(value) {
        this._azureBlobEnvironment = value;
    }
    resetAzureBlobEnvironment() {
        this._azureBlobEnvironment = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get azureBlobEnvironmentInput() {
        return this._azureBlobEnvironment;
    }
    get azureContainerName() {
        return this.getStringAttribute('azure_container_name');
    }
    set azureContainerName(value) {
        this._azureContainerName = value;
    }
    resetAzureContainerName() {
        this._azureContainerName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get azureContainerNameInput() {
        return this._azureContainerName;
    }
    get azureEndpoint() {
        return this.getStringAttribute('azure_endpoint');
    }
    set azureEndpoint(value) {
        this._azureEndpoint = value;
    }
    resetAzureEndpoint() {
        this._azureEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get azureEndpointInput() {
        return this._azureEndpoint;
    }
    get filePrefix() {
        return this.getStringAttribute('file_prefix');
    }
    set filePrefix(value) {
        this._filePrefix = value;
    }
    resetFilePrefix() {
        this._filePrefix = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get filePrefixInput() {
        return this._filePrefix;
    }
    get googleDisableTls() {
        return this.getBooleanAttribute('google_disable_tls');
    }
    set googleDisableTls(value) {
        this._googleDisableTls = value;
    }
    resetGoogleDisableTls() {
        this._googleDisableTls = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get googleDisableTlsInput() {
        return this._googleDisableTls;
    }
    get googleEndpoint() {
        return this.getStringAttribute('google_endpoint');
    }
    set googleEndpoint(value) {
        this._googleEndpoint = value;
    }
    resetGoogleEndpoint() {
        this._googleEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get googleEndpointInput() {
        return this._googleEndpoint;
    }
    get googleGcsBucket() {
        return this.getStringAttribute('google_gcs_bucket');
    }
    set googleGcsBucket(value) {
        this._googleGcsBucket = value;
    }
    resetGoogleGcsBucket() {
        this._googleGcsBucket = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get googleGcsBucketInput() {
        return this._googleGcsBucket;
    }
    get googleServiceAccountKey() {
        return this.getStringAttribute('google_service_account_key');
    }
    set googleServiceAccountKey(value) {
        this._googleServiceAccountKey = value;
    }
    resetGoogleServiceAccountKey() {
        this._googleServiceAccountKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get googleServiceAccountKeyInput() {
        return this._googleServiceAccountKey;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get intervalSeconds() {
        return this.getNumberAttribute('interval_seconds');
    }
    set intervalSeconds(value) {
        this._intervalSeconds = value;
    }
    // Temporarily expose input value. Use with caution.
    get intervalSecondsInput() {
        return this._intervalSeconds;
    }
    get localMaxSpace() {
        return this.getNumberAttribute('local_max_space');
    }
    set localMaxSpace(value) {
        this._localMaxSpace = value;
    }
    resetLocalMaxSpace() {
        this._localMaxSpace = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get localMaxSpaceInput() {
        return this._localMaxSpace;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get namespace() {
        return this.getStringAttribute('namespace');
    }
    set namespace(value) {
        this._namespace = value;
    }
    resetNamespace() {
        this._namespace = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get namespaceInput() {
        return this._namespace;
    }
    get pathPrefix() {
        return this.getStringAttribute('path_prefix');
    }
    set pathPrefix(value) {
        this._pathPrefix = value;
    }
    // Temporarily expose input value. Use with caution.
    get pathPrefixInput() {
        return this._pathPrefix;
    }
    get retain() {
        return this.getNumberAttribute('retain');
    }
    set retain(value) {
        this._retain = value;
    }
    resetRetain() {
        this._retain = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get retainInput() {
        return this._retain;
    }
    get storageType() {
        return this.getStringAttribute('storage_type');
    }
    set storageType(value) {
        this._storageType = value;
    }
    // Temporarily expose input value. Use with caution.
    get storageTypeInput() {
        return this._storageType;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            aws_access_key_id: cdktf.stringToTerraform(this._awsAccessKeyId),
            aws_s3_bucket: cdktf.stringToTerraform(this._awsS3Bucket),
            aws_s3_disable_tls: cdktf.booleanToTerraform(this._awsS3DisableTls),
            aws_s3_enable_kms: cdktf.booleanToTerraform(this._awsS3EnableKms),
            aws_s3_endpoint: cdktf.stringToTerraform(this._awsS3Endpoint),
            aws_s3_force_path_style: cdktf.booleanToTerraform(this._awsS3ForcePathStyle),
            aws_s3_kms_key: cdktf.stringToTerraform(this._awsS3KmsKey),
            aws_s3_region: cdktf.stringToTerraform(this._awsS3Region),
            aws_s3_server_side_encryption: cdktf.booleanToTerraform(this._awsS3ServerSideEncryption),
            aws_secret_access_key: cdktf.stringToTerraform(this._awsSecretAccessKey),
            aws_session_token: cdktf.stringToTerraform(this._awsSessionToken),
            azure_account_key: cdktf.stringToTerraform(this._azureAccountKey),
            azure_account_name: cdktf.stringToTerraform(this._azureAccountName),
            azure_blob_environment: cdktf.stringToTerraform(this._azureBlobEnvironment),
            azure_container_name: cdktf.stringToTerraform(this._azureContainerName),
            azure_endpoint: cdktf.stringToTerraform(this._azureEndpoint),
            file_prefix: cdktf.stringToTerraform(this._filePrefix),
            google_disable_tls: cdktf.booleanToTerraform(this._googleDisableTls),
            google_endpoint: cdktf.stringToTerraform(this._googleEndpoint),
            google_gcs_bucket: cdktf.stringToTerraform(this._googleGcsBucket),
            google_service_account_key: cdktf.stringToTerraform(this._googleServiceAccountKey),
            id: cdktf.stringToTerraform(this._id),
            interval_seconds: cdktf.numberToTerraform(this._intervalSeconds),
            local_max_space: cdktf.numberToTerraform(this._localMaxSpace),
            name: cdktf.stringToTerraform(this._name),
            namespace: cdktf.stringToTerraform(this._namespace),
            path_prefix: cdktf.stringToTerraform(this._pathPrefix),
            retain: cdktf.numberToTerraform(this._retain),
            storage_type: cdktf.stringToTerraform(this._storageType),
        };
    }
}
exports.RaftSnapshotAgentConfig = RaftSnapshotAgentConfig;
_a = JSII_RTTI_SYMBOL_1;
RaftSnapshotAgentConfig[_a] = { fqn: "@cdktf/provider-vault.raftSnapshotAgentConfig.RaftSnapshotAgentConfig", version: "5.0.2" };
// =================
// STATIC PROPERTIES
// =================
RaftSnapshotAgentConfig.tfResourceType = "vault_raft_snapshot_agent_config";
//# sourceMappingURL=data:application/json;base64,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