'''
# `vault_identity_oidc_provider`

Refer to the Terraform Registory for docs: [`vault_identity_oidc_provider`](https://www.terraform.io/docs/providers/vault/r/identity_oidc_provider).
'''
import abc
import builtins
import datetime
import enum
import typing

import jsii
import publication
import typing_extensions

from typeguard import check_type

from .._jsii import *

import cdktf as _cdktf_9a9027ec
import constructs as _constructs_77d1e7e8


class IdentityOidcProvider(
    _cdktf_9a9027ec.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-vault.identityOidcProvider.IdentityOidcProvider",
):
    '''Represents a {@link https://www.terraform.io/docs/providers/vault/r/identity_oidc_provider vault_identity_oidc_provider}.'''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id_: builtins.str,
        *,
        name: builtins.str,
        allowed_client_ids: typing.Optional[typing.Sequence[builtins.str]] = None,
        https_enabled: typing.Optional[typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]] = None,
        id: typing.Optional[builtins.str] = None,
        issuer_host: typing.Optional[builtins.str] = None,
        namespace: typing.Optional[builtins.str] = None,
        scopes_supported: typing.Optional[typing.Sequence[builtins.str]] = None,
        connection: typing.Optional[typing.Union[typing.Union[_cdktf_9a9027ec.SSHProvisionerConnection, typing.Dict[builtins.str, typing.Any]], typing.Union[_cdktf_9a9027ec.WinrmProvisionerConnection, typing.Dict[builtins.str, typing.Any]]]] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.Sequence[_cdktf_9a9027ec.ITerraformDependable]] = None,
        for_each: typing.Optional[_cdktf_9a9027ec.ITerraformIterator] = None,
        lifecycle: typing.Optional[typing.Union[_cdktf_9a9027ec.TerraformResourceLifecycle, typing.Dict[builtins.str, typing.Any]]] = None,
        provider: typing.Optional[_cdktf_9a9027ec.TerraformProvider] = None,
        provisioners: typing.Optional[typing.Sequence[typing.Union[typing.Union[_cdktf_9a9027ec.FileProvisioner, typing.Dict[builtins.str, typing.Any]], typing.Union[_cdktf_9a9027ec.LocalExecProvisioner, typing.Dict[builtins.str, typing.Any]], typing.Union[_cdktf_9a9027ec.RemoteExecProvisioner, typing.Dict[builtins.str, typing.Any]]]]] = None,
    ) -> None:
        '''Create a new {@link https://www.terraform.io/docs/providers/vault/r/identity_oidc_provider vault_identity_oidc_provider} Resource.

        :param scope: The scope in which to define this construct.
        :param id_: The scoped construct ID. Must be unique amongst siblings in the same scope
        :param name: The name of the provider. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_oidc_provider#name IdentityOidcProvider#name}
        :param allowed_client_ids: The client IDs that are permitted to use the provider. If empty, no clients are allowed. If "*", all clients are allowed. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_oidc_provider#allowed_client_ids IdentityOidcProvider#allowed_client_ids}
        :param https_enabled: Set to true if the issuer endpoint uses HTTPS. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_oidc_provider#https_enabled IdentityOidcProvider#https_enabled}
        :param id: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_oidc_provider#id IdentityOidcProvider#id}. Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2. If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
        :param issuer_host: The host for the issuer. Can be either host or host:port. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_oidc_provider#issuer_host IdentityOidcProvider#issuer_host}
        :param namespace: Target namespace. (requires Enterprise). Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_oidc_provider#namespace IdentityOidcProvider#namespace}
        :param scopes_supported: The scopes available for requesting on the provider. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_oidc_provider#scopes_supported IdentityOidcProvider#scopes_supported}
        :param connection: 
        :param count: 
        :param depends_on: 
        :param for_each: 
        :param lifecycle: 
        :param provider: 
        :param provisioners: 
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__beeba15bf1d0d35d9855a5d7acb3c2369ccf76988496c887f0401286c78da18f)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id_", value=id_, expected_type=type_hints["id_"])
        config = IdentityOidcProviderConfig(
            name=name,
            allowed_client_ids=allowed_client_ids,
            https_enabled=https_enabled,
            id=id,
            issuer_host=issuer_host,
            namespace=namespace,
            scopes_supported=scopes_supported,
            connection=connection,
            count=count,
            depends_on=depends_on,
            for_each=for_each,
            lifecycle=lifecycle,
            provider=provider,
            provisioners=provisioners,
        )

        jsii.create(self.__class__, self, [scope, id_, config])

    @jsii.member(jsii_name="resetAllowedClientIds")
    def reset_allowed_client_ids(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetAllowedClientIds", []))

    @jsii.member(jsii_name="resetHttpsEnabled")
    def reset_https_enabled(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetHttpsEnabled", []))

    @jsii.member(jsii_name="resetId")
    def reset_id(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetId", []))

    @jsii.member(jsii_name="resetIssuerHost")
    def reset_issuer_host(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetIssuerHost", []))

    @jsii.member(jsii_name="resetNamespace")
    def reset_namespace(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetNamespace", []))

    @jsii.member(jsii_name="resetScopesSupported")
    def reset_scopes_supported(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetScopesSupported", []))

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "synthesizeAttributes", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="tfResourceType")
    def TF_RESOURCE_TYPE(cls) -> builtins.str:
        return typing.cast(builtins.str, jsii.sget(cls, "tfResourceType"))

    @builtins.property
    @jsii.member(jsii_name="issuer")
    def issuer(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "issuer"))

    @builtins.property
    @jsii.member(jsii_name="allowedClientIdsInput")
    def allowed_client_ids_input(self) -> typing.Optional[typing.List[builtins.str]]:
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "allowedClientIdsInput"))

    @builtins.property
    @jsii.member(jsii_name="httpsEnabledInput")
    def https_enabled_input(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]], jsii.get(self, "httpsEnabledInput"))

    @builtins.property
    @jsii.member(jsii_name="idInput")
    def id_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "idInput"))

    @builtins.property
    @jsii.member(jsii_name="issuerHostInput")
    def issuer_host_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "issuerHostInput"))

    @builtins.property
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "nameInput"))

    @builtins.property
    @jsii.member(jsii_name="namespaceInput")
    def namespace_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "namespaceInput"))

    @builtins.property
    @jsii.member(jsii_name="scopesSupportedInput")
    def scopes_supported_input(self) -> typing.Optional[typing.List[builtins.str]]:
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "scopesSupportedInput"))

    @builtins.property
    @jsii.member(jsii_name="allowedClientIds")
    def allowed_client_ids(self) -> typing.List[builtins.str]:
        return typing.cast(typing.List[builtins.str], jsii.get(self, "allowedClientIds"))

    @allowed_client_ids.setter
    def allowed_client_ids(self, value: typing.List[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__85edd323faabc6c9ade12806a7aa1650cf6e818aee9436068bd43e8ca7fd881f)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "allowedClientIds", value)

    @builtins.property
    @jsii.member(jsii_name="httpsEnabled")
    def https_enabled(self) -> typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]:
        return typing.cast(typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable], jsii.get(self, "httpsEnabled"))

    @https_enabled.setter
    def https_enabled(
        self,
        value: typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8d175f6b5bb4a55558c8dc11111770649b815b9800375bbe9c0d959157260c15)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "httpsEnabled", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "id"))

    @id.setter
    def id(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__41a3d81be01d291e42197b1be1bdde2b62b3a6c878efe97899e7318965ac0248)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="issuerHost")
    def issuer_host(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "issuerHost"))

    @issuer_host.setter
    def issuer_host(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__269987473796ccea590908f8aa48695bcac16f5363f8e2661372f20c7ff3e1f7)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "issuerHost", value)

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @name.setter
    def name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a9c84848421061d480c6015a5d8949853822851f59fed12af6353090de81fc48)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="namespace")
    def namespace(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "namespace"))

    @namespace.setter
    def namespace(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__eace529541d8f438e1be15e1527158f1181e7134181cfb43a57377c29144ad10)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "namespace", value)

    @builtins.property
    @jsii.member(jsii_name="scopesSupported")
    def scopes_supported(self) -> typing.List[builtins.str]:
        return typing.cast(typing.List[builtins.str], jsii.get(self, "scopesSupported"))

    @scopes_supported.setter
    def scopes_supported(self, value: typing.List[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ba6dd770816b67edc1c8ec9a7aad9826399a80456c9851bf7d9d690f4e791062)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "scopesSupported", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-vault.identityOidcProvider.IdentityOidcProviderConfig",
    jsii_struct_bases=[_cdktf_9a9027ec.TerraformMetaArguments],
    name_mapping={
        "connection": "connection",
        "count": "count",
        "depends_on": "dependsOn",
        "for_each": "forEach",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "provisioners": "provisioners",
        "name": "name",
        "allowed_client_ids": "allowedClientIds",
        "https_enabled": "httpsEnabled",
        "id": "id",
        "issuer_host": "issuerHost",
        "namespace": "namespace",
        "scopes_supported": "scopesSupported",
    },
)
class IdentityOidcProviderConfig(_cdktf_9a9027ec.TerraformMetaArguments):
    def __init__(
        self,
        *,
        connection: typing.Optional[typing.Union[typing.Union[_cdktf_9a9027ec.SSHProvisionerConnection, typing.Dict[builtins.str, typing.Any]], typing.Union[_cdktf_9a9027ec.WinrmProvisionerConnection, typing.Dict[builtins.str, typing.Any]]]] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.Sequence[_cdktf_9a9027ec.ITerraformDependable]] = None,
        for_each: typing.Optional[_cdktf_9a9027ec.ITerraformIterator] = None,
        lifecycle: typing.Optional[typing.Union[_cdktf_9a9027ec.TerraformResourceLifecycle, typing.Dict[builtins.str, typing.Any]]] = None,
        provider: typing.Optional[_cdktf_9a9027ec.TerraformProvider] = None,
        provisioners: typing.Optional[typing.Sequence[typing.Union[typing.Union[_cdktf_9a9027ec.FileProvisioner, typing.Dict[builtins.str, typing.Any]], typing.Union[_cdktf_9a9027ec.LocalExecProvisioner, typing.Dict[builtins.str, typing.Any]], typing.Union[_cdktf_9a9027ec.RemoteExecProvisioner, typing.Dict[builtins.str, typing.Any]]]]] = None,
        name: builtins.str,
        allowed_client_ids: typing.Optional[typing.Sequence[builtins.str]] = None,
        https_enabled: typing.Optional[typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]] = None,
        id: typing.Optional[builtins.str] = None,
        issuer_host: typing.Optional[builtins.str] = None,
        namespace: typing.Optional[builtins.str] = None,
        scopes_supported: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''
        :param connection: 
        :param count: 
        :param depends_on: 
        :param for_each: 
        :param lifecycle: 
        :param provider: 
        :param provisioners: 
        :param name: The name of the provider. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_oidc_provider#name IdentityOidcProvider#name}
        :param allowed_client_ids: The client IDs that are permitted to use the provider. If empty, no clients are allowed. If "*", all clients are allowed. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_oidc_provider#allowed_client_ids IdentityOidcProvider#allowed_client_ids}
        :param https_enabled: Set to true if the issuer endpoint uses HTTPS. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_oidc_provider#https_enabled IdentityOidcProvider#https_enabled}
        :param id: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_oidc_provider#id IdentityOidcProvider#id}. Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2. If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
        :param issuer_host: The host for the issuer. Can be either host or host:port. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_oidc_provider#issuer_host IdentityOidcProvider#issuer_host}
        :param namespace: Target namespace. (requires Enterprise). Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_oidc_provider#namespace IdentityOidcProvider#namespace}
        :param scopes_supported: The scopes available for requesting on the provider. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_oidc_provider#scopes_supported IdentityOidcProvider#scopes_supported}
        '''
        if isinstance(lifecycle, dict):
            lifecycle = _cdktf_9a9027ec.TerraformResourceLifecycle(**lifecycle)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__509b13e1fb828d7b068c36ceefc91b5f0a3dc7d9ef689a26c9ad8c26465c27a0)
            check_type(argname="argument connection", value=connection, expected_type=type_hints["connection"])
            check_type(argname="argument count", value=count, expected_type=type_hints["count"])
            check_type(argname="argument depends_on", value=depends_on, expected_type=type_hints["depends_on"])
            check_type(argname="argument for_each", value=for_each, expected_type=type_hints["for_each"])
            check_type(argname="argument lifecycle", value=lifecycle, expected_type=type_hints["lifecycle"])
            check_type(argname="argument provider", value=provider, expected_type=type_hints["provider"])
            check_type(argname="argument provisioners", value=provisioners, expected_type=type_hints["provisioners"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument allowed_client_ids", value=allowed_client_ids, expected_type=type_hints["allowed_client_ids"])
            check_type(argname="argument https_enabled", value=https_enabled, expected_type=type_hints["https_enabled"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument issuer_host", value=issuer_host, expected_type=type_hints["issuer_host"])
            check_type(argname="argument namespace", value=namespace, expected_type=type_hints["namespace"])
            check_type(argname="argument scopes_supported", value=scopes_supported, expected_type=type_hints["scopes_supported"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "name": name,
        }
        if connection is not None:
            self._values["connection"] = connection
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if for_each is not None:
            self._values["for_each"] = for_each
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if provisioners is not None:
            self._values["provisioners"] = provisioners
        if allowed_client_ids is not None:
            self._values["allowed_client_ids"] = allowed_client_ids
        if https_enabled is not None:
            self._values["https_enabled"] = https_enabled
        if id is not None:
            self._values["id"] = id
        if issuer_host is not None:
            self._values["issuer_host"] = issuer_host
        if namespace is not None:
            self._values["namespace"] = namespace
        if scopes_supported is not None:
            self._values["scopes_supported"] = scopes_supported

    @builtins.property
    def connection(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.SSHProvisionerConnection, _cdktf_9a9027ec.WinrmProvisionerConnection]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("connection")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.SSHProvisionerConnection, _cdktf_9a9027ec.WinrmProvisionerConnection]], result)

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        '''
        result = self._values.get("count")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def depends_on(
        self,
    ) -> typing.Optional[typing.List[_cdktf_9a9027ec.ITerraformDependable]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("depends_on")
        return typing.cast(typing.Optional[typing.List[_cdktf_9a9027ec.ITerraformDependable]], result)

    @builtins.property
    def for_each(self) -> typing.Optional[_cdktf_9a9027ec.ITerraformIterator]:
        '''
        :stability: experimental
        '''
        result = self._values.get("for_each")
        return typing.cast(typing.Optional[_cdktf_9a9027ec.ITerraformIterator], result)

    @builtins.property
    def lifecycle(self) -> typing.Optional[_cdktf_9a9027ec.TerraformResourceLifecycle]:
        '''
        :stability: experimental
        '''
        result = self._values.get("lifecycle")
        return typing.cast(typing.Optional[_cdktf_9a9027ec.TerraformResourceLifecycle], result)

    @builtins.property
    def provider(self) -> typing.Optional[_cdktf_9a9027ec.TerraformProvider]:
        '''
        :stability: experimental
        '''
        result = self._values.get("provider")
        return typing.cast(typing.Optional[_cdktf_9a9027ec.TerraformProvider], result)

    @builtins.property
    def provisioners(
        self,
    ) -> typing.Optional[typing.List[typing.Union[_cdktf_9a9027ec.FileProvisioner, _cdktf_9a9027ec.LocalExecProvisioner, _cdktf_9a9027ec.RemoteExecProvisioner]]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("provisioners")
        return typing.cast(typing.Optional[typing.List[typing.Union[_cdktf_9a9027ec.FileProvisioner, _cdktf_9a9027ec.LocalExecProvisioner, _cdktf_9a9027ec.RemoteExecProvisioner]]], result)

    @builtins.property
    def name(self) -> builtins.str:
        '''The name of the provider.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_oidc_provider#name IdentityOidcProvider#name}
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def allowed_client_ids(self) -> typing.Optional[typing.List[builtins.str]]:
        '''The client IDs that are permitted to use the provider.

        If empty, no clients are allowed. If "*", all clients are allowed.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_oidc_provider#allowed_client_ids IdentityOidcProvider#allowed_client_ids}
        '''
        result = self._values.get("allowed_client_ids")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def https_enabled(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]]:
        '''Set to true if the issuer endpoint uses HTTPS.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_oidc_provider#https_enabled IdentityOidcProvider#https_enabled}
        '''
        result = self._values.get("https_enabled")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]], result)

    @builtins.property
    def id(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_oidc_provider#id IdentityOidcProvider#id}.

        Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
        If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
        '''
        result = self._values.get("id")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def issuer_host(self) -> typing.Optional[builtins.str]:
        '''The host for the issuer. Can be either host or host:port.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_oidc_provider#issuer_host IdentityOidcProvider#issuer_host}
        '''
        result = self._values.get("issuer_host")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def namespace(self) -> typing.Optional[builtins.str]:
        '''Target namespace. (requires Enterprise).

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_oidc_provider#namespace IdentityOidcProvider#namespace}
        '''
        result = self._values.get("namespace")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def scopes_supported(self) -> typing.Optional[typing.List[builtins.str]]:
        '''The scopes available for requesting on the provider.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_oidc_provider#scopes_supported IdentityOidcProvider#scopes_supported}
        '''
        result = self._values.get("scopes_supported")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "IdentityOidcProviderConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


__all__ = [
    "IdentityOidcProvider",
    "IdentityOidcProviderConfig",
]

publication.publish()

def _typecheckingstub__beeba15bf1d0d35d9855a5d7acb3c2369ccf76988496c887f0401286c78da18f(
    scope: _constructs_77d1e7e8.Construct,
    id_: builtins.str,
    *,
    name: builtins.str,
    allowed_client_ids: typing.Optional[typing.Sequence[builtins.str]] = None,
    https_enabled: typing.Optional[typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]] = None,
    id: typing.Optional[builtins.str] = None,
    issuer_host: typing.Optional[builtins.str] = None,
    namespace: typing.Optional[builtins.str] = None,
    scopes_supported: typing.Optional[typing.Sequence[builtins.str]] = None,
    connection: typing.Optional[typing.Union[typing.Union[_cdktf_9a9027ec.SSHProvisionerConnection, typing.Dict[builtins.str, typing.Any]], typing.Union[_cdktf_9a9027ec.WinrmProvisionerConnection, typing.Dict[builtins.str, typing.Any]]]] = None,
    count: typing.Optional[jsii.Number] = None,
    depends_on: typing.Optional[typing.Sequence[_cdktf_9a9027ec.ITerraformDependable]] = None,
    for_each: typing.Optional[_cdktf_9a9027ec.ITerraformIterator] = None,
    lifecycle: typing.Optional[typing.Union[_cdktf_9a9027ec.TerraformResourceLifecycle, typing.Dict[builtins.str, typing.Any]]] = None,
    provider: typing.Optional[_cdktf_9a9027ec.TerraformProvider] = None,
    provisioners: typing.Optional[typing.Sequence[typing.Union[typing.Union[_cdktf_9a9027ec.FileProvisioner, typing.Dict[builtins.str, typing.Any]], typing.Union[_cdktf_9a9027ec.LocalExecProvisioner, typing.Dict[builtins.str, typing.Any]], typing.Union[_cdktf_9a9027ec.RemoteExecProvisioner, typing.Dict[builtins.str, typing.Any]]]]] = None,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__85edd323faabc6c9ade12806a7aa1650cf6e818aee9436068bd43e8ca7fd881f(
    value: typing.List[builtins.str],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__8d175f6b5bb4a55558c8dc11111770649b815b9800375bbe9c0d959157260c15(
    value: typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__41a3d81be01d291e42197b1be1bdde2b62b3a6c878efe97899e7318965ac0248(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__269987473796ccea590908f8aa48695bcac16f5363f8e2661372f20c7ff3e1f7(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__a9c84848421061d480c6015a5d8949853822851f59fed12af6353090de81fc48(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__eace529541d8f438e1be15e1527158f1181e7134181cfb43a57377c29144ad10(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__ba6dd770816b67edc1c8ec9a7aad9826399a80456c9851bf7d9d690f4e791062(
    value: typing.List[builtins.str],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__509b13e1fb828d7b068c36ceefc91b5f0a3dc7d9ef689a26c9ad8c26465c27a0(
    *,
    connection: typing.Optional[typing.Union[typing.Union[_cdktf_9a9027ec.SSHProvisionerConnection, typing.Dict[builtins.str, typing.Any]], typing.Union[_cdktf_9a9027ec.WinrmProvisionerConnection, typing.Dict[builtins.str, typing.Any]]]] = None,
    count: typing.Optional[jsii.Number] = None,
    depends_on: typing.Optional[typing.Sequence[_cdktf_9a9027ec.ITerraformDependable]] = None,
    for_each: typing.Optional[_cdktf_9a9027ec.ITerraformIterator] = None,
    lifecycle: typing.Optional[typing.Union[_cdktf_9a9027ec.TerraformResourceLifecycle, typing.Dict[builtins.str, typing.Any]]] = None,
    provider: typing.Optional[_cdktf_9a9027ec.TerraformProvider] = None,
    provisioners: typing.Optional[typing.Sequence[typing.Union[typing.Union[_cdktf_9a9027ec.FileProvisioner, typing.Dict[builtins.str, typing.Any]], typing.Union[_cdktf_9a9027ec.LocalExecProvisioner, typing.Dict[builtins.str, typing.Any]], typing.Union[_cdktf_9a9027ec.RemoteExecProvisioner, typing.Dict[builtins.str, typing.Any]]]]] = None,
    name: builtins.str,
    allowed_client_ids: typing.Optional[typing.Sequence[builtins.str]] = None,
    https_enabled: typing.Optional[typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]] = None,
    id: typing.Optional[builtins.str] = None,
    issuer_host: typing.Optional[builtins.str] = None,
    namespace: typing.Optional[builtins.str] = None,
    scopes_supported: typing.Optional[typing.Sequence[builtins.str]] = None,
) -> None:
    """Type checking stubs"""
    pass
