# type: ignore
import re

import setuptools

version = ""
requirements = ["discord.py>=2.0.0", "aiohttp>=3.7.4,<4", "orjson"]
with open("pomice/__init__.py") as f:
    version = re.search(
        r'^__version__\s*=\s*[\'"]([^\'"]*)[\'"]',
        f.read(),
        re.MULTILINE,
    ).group(1)

if not version:
    raise RuntimeError("version is not set")

if version.endswith(("a", "b", "rc")):
    # append version identifier based on commit count
    try:
        import subprocess

        p = subprocess.Popen(
            ["git", "rev-list", "--count", "HEAD"],
            stdout=subprocess.PIPE,
            stderr=subprocess.PIPE,
        )
        out, err = p.communicate()
        if out:
            version += out.decode("utf-8").strip()
        p = subprocess.Popen(
            ["git", "rev-parse", "--short", "HEAD"],
            stdout=subprocess.PIPE,
            stderr=subprocess.PIPE,
        )
        out, err = p.communicate()
        if out:
            version += "+g" + out.decode("utf-8").strip()
    except Exception:
        pass


with open("README.md") as f:
    readme = f.read()

setuptools.setup(
    name="pomice",
    author="cloudwithax",
    version=version,
    url="https://github.com/cloudwithax/pomice",
    packages=setuptools.find_packages(),
    license="GPL",
    description="The modern Lavalink wrapper designed for Discord.py",
    long_description=readme,
    long_description_content_type="text/markdown",
    package_data={"pomice": ["py.typed"]},
    include_package_data=True,
    install_requires=requirements,
    extra_require=None,
    classifiers=[
        "Framework :: AsyncIO",
        "Operating System :: OS Independent",
        "Natural Language :: English",
        "Intended Audience :: Developers",
        "Programming Language :: Python :: 3 :: Only",
        "Programming Language :: Python :: 3.8",
        "Topic :: Software Development :: Libraries :: Python Modules",
        "Topic :: Software Development :: Libraries",
        "Topic :: Internet",
    ],
    python_requires=">=3.8",
    keywords=["pomice", "lavalink", "discord.py"],
)
