# coding: utf-8

"""
    Intrinio API

    Welcome to the Intrinio API! Through our Financial Data Marketplace, we offer a wide selection of financial data feed APIs sourced by our own proprietary processes as well as from many data vendors. For a complete API request / response reference please view the [Intrinio API documentation](https://intrinio.com/documentation/api_v2). If you need additional help in using the API, please visit the [Intrinio website](https://intrinio.com) and click on the chat icon in the lower right corner.  # noqa: E501

    OpenAPI spec version: 2.9.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class Company(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'ticker': 'str',
        'name': 'str',
        'lei': 'str',
        'legal_name': 'str',
        'stock_exchange': 'str',
        'sic': 'str',
        'short_description': 'str',
        'long_description': 'str',
        'ceo': 'str',
        'company_url': 'str',
        'business_address': 'str',
        'mailing_address': 'str',
        'business_phone_no': 'str',
        'hq_address1': 'str',
        'hq_address2': 'str',
        'hq_address_city': 'str',
        'hq_address_postal_code': 'str',
        'entity_legal_form': 'str',
        'cik': 'str',
        'latest_filing_date': 'date',
        'hq_state': 'str',
        'hq_country': 'str',
        'inc_state': 'str',
        'inc_country': 'str',
        'employees': 'int',
        'entity_status': 'str',
        'sector': 'str',
        'industry_category': 'str',
        'industry_group': 'str',
        'template': 'str',
        'standardized_active': 'bool',
        'first_fundamental_date': 'date',
        'last_fundamental_date': 'date',
        'first_stock_price_date': 'date',
        'last_stock_price_date': 'date'
    }

    attribute_map = {
        'id': 'id',
        'ticker': 'ticker',
        'name': 'name',
        'lei': 'lei',
        'legal_name': 'legal_name',
        'stock_exchange': 'stock_exchange',
        'sic': 'sic',
        'short_description': 'short_description',
        'long_description': 'long_description',
        'ceo': 'ceo',
        'company_url': 'company_url',
        'business_address': 'business_address',
        'mailing_address': 'mailing_address',
        'business_phone_no': 'business_phone_no',
        'hq_address1': 'hq_address1',
        'hq_address2': 'hq_address2',
        'hq_address_city': 'hq_address_city',
        'hq_address_postal_code': 'hq_address_postal_code',
        'entity_legal_form': 'entity_legal_form',
        'cik': 'cik',
        'latest_filing_date': 'latest_filing_date',
        'hq_state': 'hq_state',
        'hq_country': 'hq_country',
        'inc_state': 'inc_state',
        'inc_country': 'inc_country',
        'employees': 'employees',
        'entity_status': 'entity_status',
        'sector': 'sector',
        'industry_category': 'industry_category',
        'industry_group': 'industry_group',
        'template': 'template',
        'standardized_active': 'standardized_active',
        'first_fundamental_date': 'first_fundamental_date',
        'last_fundamental_date': 'last_fundamental_date',
        'first_stock_price_date': 'first_stock_price_date',
        'last_stock_price_date': 'last_stock_price_date'
    }

    def __init__(self, id=None, ticker=None, name=None, lei=None, legal_name=None, stock_exchange=None, sic=None, short_description=None, long_description=None, ceo=None, company_url=None, business_address=None, mailing_address=None, business_phone_no=None, hq_address1=None, hq_address2=None, hq_address_city=None, hq_address_postal_code=None, entity_legal_form=None, cik=None, latest_filing_date=None, hq_state=None, hq_country=None, inc_state=None, inc_country=None, employees=None, entity_status=None, sector=None, industry_category=None, industry_group=None, template=None, standardized_active=None, first_fundamental_date=None, last_fundamental_date=None, first_stock_price_date=None, last_stock_price_date=None):  # noqa: E501
        """Company - a model defined in Swagger"""  # noqa: E501

        self._id = None
        self._ticker = None
        self._name = None
        self._lei = None
        self._legal_name = None
        self._stock_exchange = None
        self._sic = None
        self._short_description = None
        self._long_description = None
        self._ceo = None
        self._company_url = None
        self._business_address = None
        self._mailing_address = None
        self._business_phone_no = None
        self._hq_address1 = None
        self._hq_address2 = None
        self._hq_address_city = None
        self._hq_address_postal_code = None
        self._entity_legal_form = None
        self._cik = None
        self._latest_filing_date = None
        self._hq_state = None
        self._hq_country = None
        self._inc_state = None
        self._inc_country = None
        self._employees = None
        self._entity_status = None
        self._sector = None
        self._industry_category = None
        self._industry_group = None
        self._template = None
        self._standardized_active = None
        self._first_fundamental_date = None
        self._last_fundamental_date = None
        self._first_stock_price_date = None
        self._last_stock_price_date = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if ticker is not None:
            self.ticker = ticker
        if name is not None:
            self.name = name
        if lei is not None:
            self.lei = lei
        if legal_name is not None:
            self.legal_name = legal_name
        if stock_exchange is not None:
            self.stock_exchange = stock_exchange
        if sic is not None:
            self.sic = sic
        if short_description is not None:
            self.short_description = short_description
        if long_description is not None:
            self.long_description = long_description
        if ceo is not None:
            self.ceo = ceo
        if company_url is not None:
            self.company_url = company_url
        if business_address is not None:
            self.business_address = business_address
        if mailing_address is not None:
            self.mailing_address = mailing_address
        if business_phone_no is not None:
            self.business_phone_no = business_phone_no
        if hq_address1 is not None:
            self.hq_address1 = hq_address1
        if hq_address2 is not None:
            self.hq_address2 = hq_address2
        if hq_address_city is not None:
            self.hq_address_city = hq_address_city
        if hq_address_postal_code is not None:
            self.hq_address_postal_code = hq_address_postal_code
        if entity_legal_form is not None:
            self.entity_legal_form = entity_legal_form
        if cik is not None:
            self.cik = cik
        if latest_filing_date is not None:
            self.latest_filing_date = latest_filing_date
        if hq_state is not None:
            self.hq_state = hq_state
        if hq_country is not None:
            self.hq_country = hq_country
        if inc_state is not None:
            self.inc_state = inc_state
        if inc_country is not None:
            self.inc_country = inc_country
        if employees is not None:
            self.employees = employees
        if entity_status is not None:
            self.entity_status = entity_status
        if sector is not None:
            self.sector = sector
        if industry_category is not None:
            self.industry_category = industry_category
        if industry_group is not None:
            self.industry_group = industry_group
        if template is not None:
            self.template = template
        if standardized_active is not None:
            self.standardized_active = standardized_active
        if first_fundamental_date is not None:
            self.first_fundamental_date = first_fundamental_date
        if last_fundamental_date is not None:
            self.last_fundamental_date = last_fundamental_date
        if first_stock_price_date is not None:
            self.first_stock_price_date = first_stock_price_date
        if last_stock_price_date is not None:
            self.last_stock_price_date = last_stock_price_date

    @property
    def id(self):
        """Gets the id of this Company.  # noqa: E501

        The Intrinio ID of the company  # noqa: E501

        :return: The id of this Company.  # noqa: E501
        :rtype: str
        """
        return self._id
        
    @property
    def id_dict(self):
        """Gets the id of this Company.  # noqa: E501

        The Intrinio ID of the company as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The id of this Company.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.id
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'id': value }

        
        return result
        

    @id.setter
    def id(self, id):
        """Sets the id of this Company.

        The Intrinio ID of the company  # noqa: E501

        :param id: The id of this Company.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def ticker(self):
        """Gets the ticker of this Company.  # noqa: E501

        The stock market ticker symbol associated with the company's common stock securities  # noqa: E501

        :return: The ticker of this Company.  # noqa: E501
        :rtype: str
        """
        return self._ticker
        
    @property
    def ticker_dict(self):
        """Gets the ticker of this Company.  # noqa: E501

        The stock market ticker symbol associated with the company's common stock securities as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The ticker of this Company.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.ticker
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'ticker': value }

        
        return result
        

    @ticker.setter
    def ticker(self, ticker):
        """Sets the ticker of this Company.

        The stock market ticker symbol associated with the company's common stock securities  # noqa: E501

        :param ticker: The ticker of this Company.  # noqa: E501
        :type: str
        """

        self._ticker = ticker

    @property
    def name(self):
        """Gets the name of this Company.  # noqa: E501

        The company's common name  # noqa: E501

        :return: The name of this Company.  # noqa: E501
        :rtype: str
        """
        return self._name
        
    @property
    def name_dict(self):
        """Gets the name of this Company.  # noqa: E501

        The company's common name as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The name of this Company.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.name
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'name': value }

        
        return result
        

    @name.setter
    def name(self, name):
        """Sets the name of this Company.

        The company's common name  # noqa: E501

        :param name: The name of this Company.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def lei(self):
        """Gets the lei of this Company.  # noqa: E501

        The Legal Entity Identifier (LEI) assigned to the company  # noqa: E501

        :return: The lei of this Company.  # noqa: E501
        :rtype: str
        """
        return self._lei
        
    @property
    def lei_dict(self):
        """Gets the lei of this Company.  # noqa: E501

        The Legal Entity Identifier (LEI) assigned to the company as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The lei of this Company.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.lei
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'lei': value }

        
        return result
        

    @lei.setter
    def lei(self, lei):
        """Sets the lei of this Company.

        The Legal Entity Identifier (LEI) assigned to the company  # noqa: E501

        :param lei: The lei of this Company.  # noqa: E501
        :type: str
        """

        self._lei = lei

    @property
    def legal_name(self):
        """Gets the legal_name of this Company.  # noqa: E501

        The company's official legal name  # noqa: E501

        :return: The legal_name of this Company.  # noqa: E501
        :rtype: str
        """
        return self._legal_name
        
    @property
    def legal_name_dict(self):
        """Gets the legal_name of this Company.  # noqa: E501

        The company's official legal name as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The legal_name of this Company.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.legal_name
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'legal_name': value }

        
        return result
        

    @legal_name.setter
    def legal_name(self, legal_name):
        """Sets the legal_name of this Company.

        The company's official legal name  # noqa: E501

        :param legal_name: The legal_name of this Company.  # noqa: E501
        :type: str
        """

        self._legal_name = legal_name

    @property
    def stock_exchange(self):
        """Gets the stock_exchange of this Company.  # noqa: E501

        The Stock Exchange where the company's common stock is primarily traded  # noqa: E501

        :return: The stock_exchange of this Company.  # noqa: E501
        :rtype: str
        """
        return self._stock_exchange
        
    @property
    def stock_exchange_dict(self):
        """Gets the stock_exchange of this Company.  # noqa: E501

        The Stock Exchange where the company's common stock is primarily traded as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The stock_exchange of this Company.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.stock_exchange
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'stock_exchange': value }

        
        return result
        

    @stock_exchange.setter
    def stock_exchange(self, stock_exchange):
        """Sets the stock_exchange of this Company.

        The Stock Exchange where the company's common stock is primarily traded  # noqa: E501

        :param stock_exchange: The stock_exchange of this Company.  # noqa: E501
        :type: str
        """

        self._stock_exchange = stock_exchange

    @property
    def sic(self):
        """Gets the sic of this Company.  # noqa: E501

        The Standard Industrial Classification (SIC) determined by the company and filed with the SEC  # noqa: E501

        :return: The sic of this Company.  # noqa: E501
        :rtype: str
        """
        return self._sic
        
    @property
    def sic_dict(self):
        """Gets the sic of this Company.  # noqa: E501

        The Standard Industrial Classification (SIC) determined by the company and filed with the SEC as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The sic of this Company.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.sic
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'sic': value }

        
        return result
        

    @sic.setter
    def sic(self, sic):
        """Sets the sic of this Company.

        The Standard Industrial Classification (SIC) determined by the company and filed with the SEC  # noqa: E501

        :param sic: The sic of this Company.  # noqa: E501
        :type: str
        """

        self._sic = sic

    @property
    def short_description(self):
        """Gets the short_description of this Company.  # noqa: E501

        A one or two sentence description of the company's operations  # noqa: E501

        :return: The short_description of this Company.  # noqa: E501
        :rtype: str
        """
        return self._short_description
        
    @property
    def short_description_dict(self):
        """Gets the short_description of this Company.  # noqa: E501

        A one or two sentence description of the company's operations as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The short_description of this Company.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.short_description
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'short_description': value }

        
        return result
        

    @short_description.setter
    def short_description(self, short_description):
        """Sets the short_description of this Company.

        A one or two sentence description of the company's operations  # noqa: E501

        :param short_description: The short_description of this Company.  # noqa: E501
        :type: str
        """

        self._short_description = short_description

    @property
    def long_description(self):
        """Gets the long_description of this Company.  # noqa: E501

        A one paragraph description of the company's operations and other corporate actions  # noqa: E501

        :return: The long_description of this Company.  # noqa: E501
        :rtype: str
        """
        return self._long_description
        
    @property
    def long_description_dict(self):
        """Gets the long_description of this Company.  # noqa: E501

        A one paragraph description of the company's operations and other corporate actions as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The long_description of this Company.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.long_description
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'long_description': value }

        
        return result
        

    @long_description.setter
    def long_description(self, long_description):
        """Sets the long_description of this Company.

        A one paragraph description of the company's operations and other corporate actions  # noqa: E501

        :param long_description: The long_description of this Company.  # noqa: E501
        :type: str
        """

        self._long_description = long_description

    @property
    def ceo(self):
        """Gets the ceo of this Company.  # noqa: E501

        The Chief Executive Officer of the company  # noqa: E501

        :return: The ceo of this Company.  # noqa: E501
        :rtype: str
        """
        return self._ceo
        
    @property
    def ceo_dict(self):
        """Gets the ceo of this Company.  # noqa: E501

        The Chief Executive Officer of the company as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The ceo of this Company.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.ceo
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'ceo': value }

        
        return result
        

    @ceo.setter
    def ceo(self, ceo):
        """Sets the ceo of this Company.

        The Chief Executive Officer of the company  # noqa: E501

        :param ceo: The ceo of this Company.  # noqa: E501
        :type: str
        """

        self._ceo = ceo

    @property
    def company_url(self):
        """Gets the company_url of this Company.  # noqa: E501

        The URL of the company's primary corporate website or primary internet property  # noqa: E501

        :return: The company_url of this Company.  # noqa: E501
        :rtype: str
        """
        return self._company_url
        
    @property
    def company_url_dict(self):
        """Gets the company_url of this Company.  # noqa: E501

        The URL of the company's primary corporate website or primary internet property as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The company_url of this Company.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.company_url
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'company_url': value }

        
        return result
        

    @company_url.setter
    def company_url(self, company_url):
        """Sets the company_url of this Company.

        The URL of the company's primary corporate website or primary internet property  # noqa: E501

        :param company_url: The company_url of this Company.  # noqa: E501
        :type: str
        """

        self._company_url = company_url

    @property
    def business_address(self):
        """Gets the business_address of this Company.  # noqa: E501

        The company's business address  # noqa: E501

        :return: The business_address of this Company.  # noqa: E501
        :rtype: str
        """
        return self._business_address
        
    @property
    def business_address_dict(self):
        """Gets the business_address of this Company.  # noqa: E501

        The company's business address as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The business_address of this Company.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.business_address
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'business_address': value }

        
        return result
        

    @business_address.setter
    def business_address(self, business_address):
        """Sets the business_address of this Company.

        The company's business address  # noqa: E501

        :param business_address: The business_address of this Company.  # noqa: E501
        :type: str
        """

        self._business_address = business_address

    @property
    def mailing_address(self):
        """Gets the mailing_address of this Company.  # noqa: E501

        The mailing address reported by the company  # noqa: E501

        :return: The mailing_address of this Company.  # noqa: E501
        :rtype: str
        """
        return self._mailing_address
        
    @property
    def mailing_address_dict(self):
        """Gets the mailing_address of this Company.  # noqa: E501

        The mailing address reported by the company as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The mailing_address of this Company.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.mailing_address
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'mailing_address': value }

        
        return result
        

    @mailing_address.setter
    def mailing_address(self, mailing_address):
        """Sets the mailing_address of this Company.

        The mailing address reported by the company  # noqa: E501

        :param mailing_address: The mailing_address of this Company.  # noqa: E501
        :type: str
        """

        self._mailing_address = mailing_address

    @property
    def business_phone_no(self):
        """Gets the business_phone_no of this Company.  # noqa: E501

        The phone number reported by the company  # noqa: E501

        :return: The business_phone_no of this Company.  # noqa: E501
        :rtype: str
        """
        return self._business_phone_no
        
    @property
    def business_phone_no_dict(self):
        """Gets the business_phone_no of this Company.  # noqa: E501

        The phone number reported by the company as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The business_phone_no of this Company.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.business_phone_no
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'business_phone_no': value }

        
        return result
        

    @business_phone_no.setter
    def business_phone_no(self, business_phone_no):
        """Sets the business_phone_no of this Company.

        The phone number reported by the company  # noqa: E501

        :param business_phone_no: The business_phone_no of this Company.  # noqa: E501
        :type: str
        """

        self._business_phone_no = business_phone_no

    @property
    def hq_address1(self):
        """Gets the hq_address1 of this Company.  # noqa: E501

        The company's headquarters address - line 1  # noqa: E501

        :return: The hq_address1 of this Company.  # noqa: E501
        :rtype: str
        """
        return self._hq_address1
        
    @property
    def hq_address1_dict(self):
        """Gets the hq_address1 of this Company.  # noqa: E501

        The company's headquarters address - line 1 as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The hq_address1 of this Company.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.hq_address1
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'hq_address1': value }

        
        return result
        

    @hq_address1.setter
    def hq_address1(self, hq_address1):
        """Sets the hq_address1 of this Company.

        The company's headquarters address - line 1  # noqa: E501

        :param hq_address1: The hq_address1 of this Company.  # noqa: E501
        :type: str
        """

        self._hq_address1 = hq_address1

    @property
    def hq_address2(self):
        """Gets the hq_address2 of this Company.  # noqa: E501

        The company's headquarters address - line 2  # noqa: E501

        :return: The hq_address2 of this Company.  # noqa: E501
        :rtype: str
        """
        return self._hq_address2
        
    @property
    def hq_address2_dict(self):
        """Gets the hq_address2 of this Company.  # noqa: E501

        The company's headquarters address - line 2 as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The hq_address2 of this Company.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.hq_address2
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'hq_address2': value }

        
        return result
        

    @hq_address2.setter
    def hq_address2(self, hq_address2):
        """Sets the hq_address2 of this Company.

        The company's headquarters address - line 2  # noqa: E501

        :param hq_address2: The hq_address2 of this Company.  # noqa: E501
        :type: str
        """

        self._hq_address2 = hq_address2

    @property
    def hq_address_city(self):
        """Gets the hq_address_city of this Company.  # noqa: E501

        The company's headquarters city  # noqa: E501

        :return: The hq_address_city of this Company.  # noqa: E501
        :rtype: str
        """
        return self._hq_address_city
        
    @property
    def hq_address_city_dict(self):
        """Gets the hq_address_city of this Company.  # noqa: E501

        The company's headquarters city as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The hq_address_city of this Company.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.hq_address_city
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'hq_address_city': value }

        
        return result
        

    @hq_address_city.setter
    def hq_address_city(self, hq_address_city):
        """Sets the hq_address_city of this Company.

        The company's headquarters city  # noqa: E501

        :param hq_address_city: The hq_address_city of this Company.  # noqa: E501
        :type: str
        """

        self._hq_address_city = hq_address_city

    @property
    def hq_address_postal_code(self):
        """Gets the hq_address_postal_code of this Company.  # noqa: E501

        The company's headquarters postal code  # noqa: E501

        :return: The hq_address_postal_code of this Company.  # noqa: E501
        :rtype: str
        """
        return self._hq_address_postal_code
        
    @property
    def hq_address_postal_code_dict(self):
        """Gets the hq_address_postal_code of this Company.  # noqa: E501

        The company's headquarters postal code as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The hq_address_postal_code of this Company.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.hq_address_postal_code
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'hq_address_postal_code': value }

        
        return result
        

    @hq_address_postal_code.setter
    def hq_address_postal_code(self, hq_address_postal_code):
        """Sets the hq_address_postal_code of this Company.

        The company's headquarters postal code  # noqa: E501

        :param hq_address_postal_code: The hq_address_postal_code of this Company.  # noqa: E501
        :type: str
        """

        self._hq_address_postal_code = hq_address_postal_code

    @property
    def entity_legal_form(self):
        """Gets the entity_legal_form of this Company.  # noqa: E501

        The company's legal organization form  # noqa: E501

        :return: The entity_legal_form of this Company.  # noqa: E501
        :rtype: str
        """
        return self._entity_legal_form
        
    @property
    def entity_legal_form_dict(self):
        """Gets the entity_legal_form of this Company.  # noqa: E501

        The company's legal organization form as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The entity_legal_form of this Company.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.entity_legal_form
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'entity_legal_form': value }

        
        return result
        

    @entity_legal_form.setter
    def entity_legal_form(self, entity_legal_form):
        """Sets the entity_legal_form of this Company.

        The company's legal organization form  # noqa: E501

        :param entity_legal_form: The entity_legal_form of this Company.  # noqa: E501
        :type: str
        """

        self._entity_legal_form = entity_legal_form

    @property
    def cik(self):
        """Gets the cik of this Company.  # noqa: E501

        The Central Index Key (CIK) assigned to the company by the SEC as a unique identifier, used in SEC filings  # noqa: E501

        :return: The cik of this Company.  # noqa: E501
        :rtype: str
        """
        return self._cik
        
    @property
    def cik_dict(self):
        """Gets the cik of this Company.  # noqa: E501

        The Central Index Key (CIK) assigned to the company by the SEC as a unique identifier, used in SEC filings as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The cik of this Company.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.cik
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'cik': value }

        
        return result
        

    @cik.setter
    def cik(self, cik):
        """Sets the cik of this Company.

        The Central Index Key (CIK) assigned to the company by the SEC as a unique identifier, used in SEC filings  # noqa: E501

        :param cik: The cik of this Company.  # noqa: E501
        :type: str
        """

        self._cik = cik

    @property
    def latest_filing_date(self):
        """Gets the latest_filing_date of this Company.  # noqa: E501

        The date of the company's last filing with the SEC  # noqa: E501

        :return: The latest_filing_date of this Company.  # noqa: E501
        :rtype: date
        """
        return self._latest_filing_date
        
    @property
    def latest_filing_date_dict(self):
        """Gets the latest_filing_date of this Company.  # noqa: E501

        The date of the company's last filing with the SEC as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The latest_filing_date of this Company.  # noqa: E501
        :rtype: date
        """

        result = None

        value = self.latest_filing_date
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'latest_filing_date': value }

        
        return result
        

    @latest_filing_date.setter
    def latest_filing_date(self, latest_filing_date):
        """Sets the latest_filing_date of this Company.

        The date of the company's last filing with the SEC  # noqa: E501

        :param latest_filing_date: The latest_filing_date of this Company.  # noqa: E501
        :type: date
        """

        self._latest_filing_date = latest_filing_date

    @property
    def hq_state(self):
        """Gets the hq_state of this Company.  # noqa: E501

        The state (US & Canada Only) where the company headquarters are located  # noqa: E501

        :return: The hq_state of this Company.  # noqa: E501
        :rtype: str
        """
        return self._hq_state
        
    @property
    def hq_state_dict(self):
        """Gets the hq_state of this Company.  # noqa: E501

        The state (US & Canada Only) where the company headquarters are located as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The hq_state of this Company.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.hq_state
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'hq_state': value }

        
        return result
        

    @hq_state.setter
    def hq_state(self, hq_state):
        """Sets the hq_state of this Company.

        The state (US & Canada Only) where the company headquarters are located  # noqa: E501

        :param hq_state: The hq_state of this Company.  # noqa: E501
        :type: str
        """

        self._hq_state = hq_state

    @property
    def hq_country(self):
        """Gets the hq_country of this Company.  # noqa: E501

        The country where the company headquarters are located  # noqa: E501

        :return: The hq_country of this Company.  # noqa: E501
        :rtype: str
        """
        return self._hq_country
        
    @property
    def hq_country_dict(self):
        """Gets the hq_country of this Company.  # noqa: E501

        The country where the company headquarters are located as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The hq_country of this Company.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.hq_country
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'hq_country': value }

        
        return result
        

    @hq_country.setter
    def hq_country(self, hq_country):
        """Sets the hq_country of this Company.

        The country where the company headquarters are located  # noqa: E501

        :param hq_country: The hq_country of this Company.  # noqa: E501
        :type: str
        """

        self._hq_country = hq_country

    @property
    def inc_state(self):
        """Gets the inc_state of this Company.  # noqa: E501

        The state (US & Canada Only) where the company is incorporated  # noqa: E501

        :return: The inc_state of this Company.  # noqa: E501
        :rtype: str
        """
        return self._inc_state
        
    @property
    def inc_state_dict(self):
        """Gets the inc_state of this Company.  # noqa: E501

        The state (US & Canada Only) where the company is incorporated as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The inc_state of this Company.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.inc_state
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'inc_state': value }

        
        return result
        

    @inc_state.setter
    def inc_state(self, inc_state):
        """Sets the inc_state of this Company.

        The state (US & Canada Only) where the company is incorporated  # noqa: E501

        :param inc_state: The inc_state of this Company.  # noqa: E501
        :type: str
        """

        self._inc_state = inc_state

    @property
    def inc_country(self):
        """Gets the inc_country of this Company.  # noqa: E501

        The country where the company is incorporated  # noqa: E501

        :return: The inc_country of this Company.  # noqa: E501
        :rtype: str
        """
        return self._inc_country
        
    @property
    def inc_country_dict(self):
        """Gets the inc_country of this Company.  # noqa: E501

        The country where the company is incorporated as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The inc_country of this Company.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.inc_country
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'inc_country': value }

        
        return result
        

    @inc_country.setter
    def inc_country(self, inc_country):
        """Sets the inc_country of this Company.

        The country where the company is incorporated  # noqa: E501

        :param inc_country: The inc_country of this Company.  # noqa: E501
        :type: str
        """

        self._inc_country = inc_country

    @property
    def employees(self):
        """Gets the employees of this Company.  # noqa: E501

        The number of employees working for the company  # noqa: E501

        :return: The employees of this Company.  # noqa: E501
        :rtype: int
        """
        return self._employees
        
    @property
    def employees_dict(self):
        """Gets the employees of this Company.  # noqa: E501

        The number of employees working for the company as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The employees of this Company.  # noqa: E501
        :rtype: int
        """

        result = None

        value = self.employees
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'employees': value }

        
        return result
        

    @employees.setter
    def employees(self, employees):
        """Sets the employees of this Company.

        The number of employees working for the company  # noqa: E501

        :param employees: The employees of this Company.  # noqa: E501
        :type: int
        """

        self._employees = employees

    @property
    def entity_status(self):
        """Gets the entity_status of this Company.  # noqa: E501


        :return: The entity_status of this Company.  # noqa: E501
        :rtype: str
        """
        return self._entity_status
        
    @property
    def entity_status_dict(self):
        """Gets the entity_status of this Company.  # noqa: E501


        :return: The entity_status of this Company.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.entity_status
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'entity_status': value }

        
        return result
        

    @entity_status.setter
    def entity_status(self, entity_status):
        """Sets the entity_status of this Company.


        :param entity_status: The entity_status of this Company.  # noqa: E501
        :type: str
        """

        self._entity_status = entity_status

    @property
    def sector(self):
        """Gets the sector of this Company.  # noqa: E501

        The company's operating sector  # noqa: E501

        :return: The sector of this Company.  # noqa: E501
        :rtype: str
        """
        return self._sector
        
    @property
    def sector_dict(self):
        """Gets the sector of this Company.  # noqa: E501

        The company's operating sector as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The sector of this Company.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.sector
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'sector': value }

        
        return result
        

    @sector.setter
    def sector(self, sector):
        """Sets the sector of this Company.

        The company's operating sector  # noqa: E501

        :param sector: The sector of this Company.  # noqa: E501
        :type: str
        """

        self._sector = sector

    @property
    def industry_category(self):
        """Gets the industry_category of this Company.  # noqa: E501

        The company's operating industry category  # noqa: E501

        :return: The industry_category of this Company.  # noqa: E501
        :rtype: str
        """
        return self._industry_category
        
    @property
    def industry_category_dict(self):
        """Gets the industry_category of this Company.  # noqa: E501

        The company's operating industry category as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The industry_category of this Company.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.industry_category
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'industry_category': value }

        
        return result
        

    @industry_category.setter
    def industry_category(self, industry_category):
        """Sets the industry_category of this Company.

        The company's operating industry category  # noqa: E501

        :param industry_category: The industry_category of this Company.  # noqa: E501
        :type: str
        """

        self._industry_category = industry_category

    @property
    def industry_group(self):
        """Gets the industry_group of this Company.  # noqa: E501

        The company's operating industry group  # noqa: E501

        :return: The industry_group of this Company.  # noqa: E501
        :rtype: str
        """
        return self._industry_group
        
    @property
    def industry_group_dict(self):
        """Gets the industry_group of this Company.  # noqa: E501

        The company's operating industry group as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The industry_group of this Company.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.industry_group
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'industry_group': value }

        
        return result
        

    @industry_group.setter
    def industry_group(self, industry_group):
        """Sets the industry_group of this Company.

        The company's operating industry group  # noqa: E501

        :param industry_group: The industry_group of this Company.  # noqa: E501
        :type: str
        """

        self._industry_group = industry_group

    @property
    def template(self):
        """Gets the template of this Company.  # noqa: E501

        The financial statement template used by Intrinio to standardize the as reported data  # noqa: E501

        :return: The template of this Company.  # noqa: E501
        :rtype: str
        """
        return self._template
        
    @property
    def template_dict(self):
        """Gets the template of this Company.  # noqa: E501

        The financial statement template used by Intrinio to standardize the as reported data as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The template of this Company.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.template
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'template': value }

        
        return result
        

    @template.setter
    def template(self, template):
        """Sets the template of this Company.

        The financial statement template used by Intrinio to standardize the as reported data  # noqa: E501

        :param template: The template of this Company.  # noqa: E501
        :type: str
        """

        self._template = template

    @property
    def standardized_active(self):
        """Gets the standardized_active of this Company.  # noqa: E501

        If true, the company has standardized and as reported fundamental data via the Intrinio API; if false, the company has as-reported data only  # noqa: E501

        :return: The standardized_active of this Company.  # noqa: E501
        :rtype: bool
        """
        return self._standardized_active
        
    @property
    def standardized_active_dict(self):
        """Gets the standardized_active of this Company.  # noqa: E501

        If true, the company has standardized and as reported fundamental data via the Intrinio API; if false, the company has as-reported data only as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The standardized_active of this Company.  # noqa: E501
        :rtype: bool
        """

        result = None

        value = self.standardized_active
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'standardized_active': value }

        
        return result
        

    @standardized_active.setter
    def standardized_active(self, standardized_active):
        """Sets the standardized_active of this Company.

        If true, the company has standardized and as reported fundamental data via the Intrinio API; if false, the company has as-reported data only  # noqa: E501

        :param standardized_active: The standardized_active of this Company.  # noqa: E501
        :type: bool
        """

        self._standardized_active = standardized_active

    @property
    def first_fundamental_date(self):
        """Gets the first_fundamental_date of this Company.  # noqa: E501

        The period end date of the company's first reported fundamental  # noqa: E501

        :return: The first_fundamental_date of this Company.  # noqa: E501
        :rtype: date
        """
        return self._first_fundamental_date
        
    @property
    def first_fundamental_date_dict(self):
        """Gets the first_fundamental_date of this Company.  # noqa: E501

        The period end date of the company's first reported fundamental as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The first_fundamental_date of this Company.  # noqa: E501
        :rtype: date
        """

        result = None

        value = self.first_fundamental_date
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'first_fundamental_date': value }

        
        return result
        

    @first_fundamental_date.setter
    def first_fundamental_date(self, first_fundamental_date):
        """Sets the first_fundamental_date of this Company.

        The period end date of the company's first reported fundamental  # noqa: E501

        :param first_fundamental_date: The first_fundamental_date of this Company.  # noqa: E501
        :type: date
        """

        self._first_fundamental_date = first_fundamental_date

    @property
    def last_fundamental_date(self):
        """Gets the last_fundamental_date of this Company.  # noqa: E501

        The period end date of the company's last reported fundamental  # noqa: E501

        :return: The last_fundamental_date of this Company.  # noqa: E501
        :rtype: date
        """
        return self._last_fundamental_date
        
    @property
    def last_fundamental_date_dict(self):
        """Gets the last_fundamental_date of this Company.  # noqa: E501

        The period end date of the company's last reported fundamental as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The last_fundamental_date of this Company.  # noqa: E501
        :rtype: date
        """

        result = None

        value = self.last_fundamental_date
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'last_fundamental_date': value }

        
        return result
        

    @last_fundamental_date.setter
    def last_fundamental_date(self, last_fundamental_date):
        """Sets the last_fundamental_date of this Company.

        The period end date of the company's last reported fundamental  # noqa: E501

        :param last_fundamental_date: The last_fundamental_date of this Company.  # noqa: E501
        :type: date
        """

        self._last_fundamental_date = last_fundamental_date

    @property
    def first_stock_price_date(self):
        """Gets the first_stock_price_date of this Company.  # noqa: E501

        The date of the company's first stock price, based on the company's primary security, which is typically traded on US exchages  # noqa: E501

        :return: The first_stock_price_date of this Company.  # noqa: E501
        :rtype: date
        """
        return self._first_stock_price_date
        
    @property
    def first_stock_price_date_dict(self):
        """Gets the first_stock_price_date of this Company.  # noqa: E501

        The date of the company's first stock price, based on the company's primary security, which is typically traded on US exchages as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The first_stock_price_date of this Company.  # noqa: E501
        :rtype: date
        """

        result = None

        value = self.first_stock_price_date
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'first_stock_price_date': value }

        
        return result
        

    @first_stock_price_date.setter
    def first_stock_price_date(self, first_stock_price_date):
        """Sets the first_stock_price_date of this Company.

        The date of the company's first stock price, based on the company's primary security, which is typically traded on US exchages  # noqa: E501

        :param first_stock_price_date: The first_stock_price_date of this Company.  # noqa: E501
        :type: date
        """

        self._first_stock_price_date = first_stock_price_date

    @property
    def last_stock_price_date(self):
        """Gets the last_stock_price_date of this Company.  # noqa: E501

        The date of the company's last stock price, based on the company's primary security, which is typically traded on US exchages  # noqa: E501

        :return: The last_stock_price_date of this Company.  # noqa: E501
        :rtype: date
        """
        return self._last_stock_price_date
        
    @property
    def last_stock_price_date_dict(self):
        """Gets the last_stock_price_date of this Company.  # noqa: E501

        The date of the company's last stock price, based on the company's primary security, which is typically traded on US exchages as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The last_stock_price_date of this Company.  # noqa: E501
        :rtype: date
        """

        result = None

        value = self.last_stock_price_date
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'last_stock_price_date': value }

        
        return result
        

    @last_stock_price_date.setter
    def last_stock_price_date(self, last_stock_price_date):
        """Sets the last_stock_price_date of this Company.

        The date of the company's last stock price, based on the company's primary security, which is typically traded on US exchages  # noqa: E501

        :param last_stock_price_date: The last_stock_price_date of this Company.  # noqa: E501
        :type: date
        """

        self._last_stock_price_date = last_stock_price_date

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Company):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
