"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpPrivateIntegration = void 0;
const aws_apigatewayv2_alpha_1 = require("@aws-cdk/aws-apigatewayv2-alpha");
/**
 * The HTTP Private integration resource for HTTP API
 *
 * @internal
 */
class HttpPrivateIntegration extends aws_apigatewayv2_alpha_1.HttpRouteIntegration {
    constructor() {
        super(...arguments);
        this.httpMethod = aws_apigatewayv2_alpha_1.HttpMethod.ANY;
        this.payloadFormatVersion = aws_apigatewayv2_alpha_1.PayloadFormatVersion.VERSION_1_0; // 1.0 is required and is the only supported format
        this.integrationType = aws_apigatewayv2_alpha_1.HttpIntegrationType.HTTP_PROXY;
        this.connectionType = aws_apigatewayv2_alpha_1.HttpConnectionType.VPC_LINK;
    }
    /**
     * Adds a vpcLink to the API if not passed in the options
     *
     * @internal
     */
    _configureVpcLink(bindOptions, configOptions) {
        let vpcLink = configOptions.vpcLink;
        if (!vpcLink) {
            if (!configOptions.vpc) {
                throw new Error('One of vpcLink or vpc should be provided for private integration');
            }
            vpcLink = bindOptions.route.httpApi.addVpcLink({ vpc: configOptions.vpc });
        }
        return vpcLink;
    }
}
exports.HttpPrivateIntegration = HttpPrivateIntegration;
//# sourceMappingURL=data:application/json;base64,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