"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BucketPrivacy = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
class BucketPrivacy {
    visit(node) {
        if (node instanceof aws_cdk_lib_1.aws_s3.CfnBucket) {
            const bucket = node;
            bucket.bucketEncryption = {
                serverSideEncryptionConfiguration: [
                    {
                        serverSideEncryptionByDefault: {
                            kmsMasterKeyId: undefined,
                            sseAlgorithm: "AES256",
                        },
                    },
                ],
            };
            bucket.publicAccessBlockConfiguration = {
                blockPublicAcls: true,
                blockPublicPolicy: true,
                ignorePublicAcls: true,
                restrictPublicBuckets: true,
            };
        }
        if (node instanceof aws_cdk_lib_1.aws_s3.CfnBucketPolicy) {
            const bucketPolicy = node;
            console.log(bucketPolicy.policyDocument);
        }
    }
}
exports.BucketPrivacy = BucketPrivacy;
_a = JSII_RTTI_SYMBOL_1;
BucketPrivacy[_a] = { fqn: "@pepperize/cdk-private-bucket.BucketPrivacy", version: "0.0.537" };
//# sourceMappingURL=data:application/json;base64,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