# ezbeq

A simple web browser for [beqcatalogue](https://beqcatalogue.readthedocs.io/en/latest/) which integrates with [minidsp-rs](https://github.com/mrene/minidsp-rs)
for local remote control of a minidsp or HTP-1.

# Setup

## Windows / MacOS

Python is required so use an appropriate package manager to install it. 

[chocolatey](https://chocolatey.org/) is a convenient choice for Windows
[homebrew](https://docs.brew.sh/Installation) is the equivalent for MacOS

## Linux

Use your distro package manager to install python.

## Installation

Example is provided for rpi users

    $ ssh pi@myrpi
    $ sudo apt install python3 python3-venv python3-pip libyaml-dev
    $ mkdir python
    $ cd python
    $ python3 -m venv ezbeq
    $ cd ezbeq
    $ . bin/activate
    $ pip install ezbeq

### Using with a Minidsp

Install minidsp-rs as per the provided instructionshttps://github.com/mrene/minidsp-rs#installation

### Using with a Monolith HTP-1

See the configuration section below

## Upgrade

    $ ssh pi@myrpi
    $ cd python/ezbeq
    $ . bin/activate
    $ pip install --upgrade --force-reinstall ezbeq

then restart the app

## Running the app manually

    $ ssh pi@myrpi
    $ cd python/ezbeq
    $ . bin/activate
    $ ./bin/ezbeq
      Loading config from /home/pi/.ezbeq/ezbeq.yml
      2021-01-16 08:43:15,374 - twisted - INFO - __init__ - Serving ui from /home/pi/python/ezbeq/lib/python3.8/site-packages/ezbeq/ui

Now open http://youripaddress:8080/index.html in your browser 

## Configuration

See `$HOME/.ezbeq/ezbeq.yml`

The only intended option for override is the port option which sets the port the UI and API is accessible on. This defaults to 8080.

### Using a custom catalogue

If `catalogueUrl` is added to the configuration, e.g.

    catalogueUrl: http://localhost:9999

ezbeq will instead load the catalogue from `http://localhost:9999/database.json`

This provides the ability to run ezbeq against a custom, or locally provided, catalogue.

### Configuring Devices

The devices section contains a list of supported device, the format varies by the type of device and each item is a named device with the name subsequently appearing the UI (if multiple devices are listed)

#### Minidsp

Default values are shown, the only required value is the type field

```
  minidsp:
    cmdTimeout: 10
    exe: minidsp
    ignoreRetcode: false
    options: ''
    slotChangeDelay: false
    type: minidsp
```

* cmdTime: default timeout in seconds for a command sent to minidsp-rs to complete
* exe: location of the minidsp-rs executable
* ignoreRetcode: if true, errors generated by minidsp-rs will be ignored (for debugging/local testing only)
* options: additional command line switches to pass to minidsp-rs (refer to minidsp-rs docs for details)
* type: minidsp 
* slotChangeDelay: if true, the command to change the slot is always sent to minidsp-rs as a separate command.

By default, it is assumed the Minidsp 2x4HD is in use. To use a different model, specify via the device_type option. For example:

```
  minidsp:
    cmdTimeout: 10
    exe: minidsp
    ignoreRetcode: false
    options: ''
    type: minidsp
    device_type: 4x10
```

A full list of supported models is provided below.

##### Minidsp Variants

Device support largely tracks [minidsp-rs device support](https://minidsp-rs.pages.dev/devices).

BEQ MV adjustments are applied to input peq channels only. 

###### [2x4HD](https://www.minidsp.com/products/minidsp-in-a-box/minidsp-2x4-hd)

set `device_type: 24HD`

BEQ filters are written to both input channels.

##### [Flex](https://www.minidsp.com/products/minidsp-in-a-box/flex)

configure as per 2x4HD 

add `slotChangeDelay: true` to workaround issues with slow slot changing

Dirac mode (PEQ on output) is only supported at present via a custom configuration. 

###### [DDRC-24](https://www.minidsp.com/products/dirac-series/ddrc-24)

set `device_type: DDRC24`

BEQ filters are written to all output channels.

###### [DDRC-88](https://www.minidsp.com/products/dirac-series/ddrc-88a)

set `device_type: DDRC88`

BEQ filters are written to output channel 3 by default.

Add the `sw_channels` config key to override this, provide a list of channel indexes (0 based) to which the filters should be written. For example to write to the last two output channels:

    device_type: DDRC88
    sw_channels:
    - 6
    - 7

###### [4x10](https://www.minidsp.com/products/plugins/4x10-plug-in-detail)

set `device_type: 4x10`

The limited biquad capacity (5 per channel) means that filters are split across input and output channels and there is no capacity for user filters.

###### [10x10](https://www.minidsp.com/products/plugins/4x10-10x10-plug-ins/10x10-plug-in-detail)

set `device_type: 10x10`

The limited biquad capacity (6 per channel) means that filters are split across input and output channels and the last 2 biquads per output channel are left under user control.

To avoid this, use the crossover biquads to hold the remaining beq biquads. This leaves the output PEQ untouched. Set `use_xo` to one of the following values to activate this mode:

* all : apply beq to both crossover groups
* 0 (or true) : apply beq to crossover group 0
* 1 : apply beq to crossover group 1

###### [SHD](https://www.minidsp.com/products/streaming-hd-series/shd)

set `device_type: SHD` 

BEQ filters are written to all output channels.

##### Custom Layouts

TODO

#### Monolith HTP1

```
  htp1:
    ip: 192.168.1.181
    channels:
    - sub1
```

* ip: ip address of the HTP1
* channels: list of channels to apply filters to (sub1, sub2 and sub3 are the standard subwoofer channels in the HTP1)

#### JRiver Media Center

NB: Media Network must be enabled

```
  jriver:
    address: 192.168.1.181:52199
    auth:
      user: foo
      pass: thisismypass
    secure: true  
    channels:
    - SW
    - C9
    - C10
    block: 2
```
* address: the ip and port on which the Media Center media network is listening 
* auth is optional, leave this out if MCWS is not secured
* secure is optional, leave this out if SSL is not used
* supported channels are L R C SW SL SR RL RR and C9 upto C32 (if more than 8 channel output is used)
* block is 1 or 2 and refers to the dsp slots Parametric Equalizer and Parametric Equalizer 2 respectively 

This information is **not** validated, it is left to the user to configure the output format on the zone to match the supplied configuration.

#### Q-Sys

[Q-Sys Designer](https://www.qsc.com/resources/software-and-firmware/q-sys-designer-software/) is supported via the [QRC](https://q-syshelp.qsc.com/Content/External_Control_APIs/QRC/QRC_Overview.htm) protocol

```
  qsys:
    ip: 192.168.1.181
    port: 1710
    timeout_secs: 2
    components: 
    - beq
    content_info:
    - beq_movie_info:
        text.1: title
        text.2: genres
        text.3: audio_types
        text.4: mv_adjust
        text.5: overview
        text.6: images[0]
        text.7: images[1]
    type: qsys
```

Configuration of the audio pipeline in Q-Sys Designer is left as an exercise for the user. 

The component referred to in the configuration is a [Parametric Equaliser](https://q-syshelp.qsc.com/Content/Schematic_Library/equalizer_parametric.htm) which should be configured with:

* at least 10 bands
* q factor

The component name should be supplied in the configuration above.

An optional `content_info` list of components can also be supplied. Each named component listed (`beq_movie_info` in the example above) is a [Custom Control](https://q-syshelp.qsc.com/Index.htm#Schematic_Library/custom_controls.htm) component which contains 1 or more text fields. The listed fields are a mapping of control key to `CatalogueEntry` field name.

The images field has special treatment as there can be a variable number of images, may be multiple images

## Starting ezbeq on bootup

This is optional but recommended, it ensures the app starts automatically whenever the rpi boots up and makes
sure it restarts automatically if it ever crashes.

We will achieve this by creating and enabling a `systemd` service.

1) Create a file ezbeq.service in the appropriate location for your distro (e.g. ``/etc/systemd/system/`` for debian)::

```
[Unit]
Description=ezbeq
After=network.target

[Service]
Type=simple
User=pi
WorkingDirectory=/home/pi
ExecStart=/home/pi/python/ezbeq/bin/ezbeq
Restart=always
RestartSec=1

[Install]
WantedBy=multi-user.target
```

2) enable the service and start it up::

```
$ sudo systemctl enable ezbeq.service
$ sudo service ezbeq start
$ sudo journalctl -u ezbeq.service
-- Logs begin at Sat 2019-08-17 12:17:02 BST, end at Sun 2019-08-18 21:58:43 BST. --
Aug 18 21:58:36 swoop systemd[1]: Started ezbeq.
```

3) reboot and repeat step 2 to verify the recorder has automatically started
