# coding: utf-8

"""
    Arthur Scope

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List
from arthur_client.api_bindings.models.aggregation_metric_type import AggregationMetricType
from typing import Optional, Set
from typing_extensions import Self

class ReportedCustomAggregation(BaseModel):
    """
    ReportedCustomAggregation
    """ # noqa: E501
    metric_name: StrictStr = Field(description="Name of the reported aggregation metric.")
    description: StrictStr = Field(description="Description of the reported aggregation metric and what it aggregates.")
    value_column: StrictStr = Field(description="Name of the column returned from the SQL query holding the metric value.")
    timestamp_column: StrictStr = Field(description="Name of the column returned from the SQL query holding the timestamp buckets.")
    metric_kind: AggregationMetricType = Field(description="Return type of the reported aggregation metric value.")
    dimension_columns: List[StrictStr] = Field(description="Name of any dimension columns returned from the SQL query. Max length is 1.")
    __properties: ClassVar[List[str]] = ["metric_name", "description", "value_column", "timestamp_column", "metric_kind", "dimension_columns"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ReportedCustomAggregation from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ReportedCustomAggregation from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "metric_name": obj.get("metric_name"),
            "description": obj.get("description"),
            "value_column": obj.get("value_column"),
            "timestamp_column": obj.get("timestamp_column"),
            "metric_kind": obj.get("metric_kind"),
            "dimension_columns": obj.get("dimension_columns")
        })
        return _obj


