from __future__ import annotations

from contextlib import contextmanager as contextmanager
from threading import Thread as Thread
from typing import Any, Optional

from .checkpoint_saver import CheckpointSaver as CheckpointSaver
from .checkpoint_saver import PaddleModel as PaddleModel
from .checkpoint_saver import SerializableBase as SerializableBase

g_train_epoch_range: Any
g_checker: Any
logger: Any
generator: Any
CONST_CHECKPOINT: str
CONST_MEMORYINIT: str
CONST_DACP_TYPE: str
CONST_ACP_TYPE: str
g_acp_type: Any
g_program_attr: Any

class AutoCheckpointChecker:
    def __init__(self) -> None: ...
    def get_range_checkpoint_path(self, name: Any): ...
    def get_exe_checkpoint_path(self, name: Any): ...
    def get_job_path(self): ...
    @property
    def save_checkpoint_inter(self): ...
    def valid(self): ...
    @property
    def trainer_id(self): ...
    @property
    def run_env(self): ...
    @property
    def platform(self): ...
    @property
    def job_id(self): ...
    @property
    def hdfs_home(self): ...
    @property
    def hdfs_name(self): ...
    @property
    def ce_test(self): ...
    @property
    def hdfs_ugi(self): ...
    @property
    def hdfs_checkpoint_path(self): ...
    @staticmethod
    def generate_range_name(): ...

class ExeTrainStatus(SerializableBase):
    def __init__(self) -> None: ...
    def __eq__(self, t: Any) -> Any: ...
    def __ne__(self, t: Any) -> Any: ...
    def serialize(self, path: Any) -> None: ...
    def deserialize(self, path: Any) -> None: ...

class TrainEpochRange(SerializableBase):
    def __init__(
        self, max_epoch_num: Any, name: Any, checkpoint_inter: Optional[Any] = ..., restored: bool = ...
    ) -> None: ...
    @property
    def name(self): ...
    def serialize(self, path: Any) -> None: ...
    @property
    def restored_from(self): ...
    def deserialize(self, path: Any) -> None: ...
    def next(self) -> None: ...
    def get(self): ...
    def save_checkpoint(self) -> None: ...

def train_epoch_range(max_epoch_num: Any, save_checkpoint_inter: Optional[Any] = ...) -> None: ...
