from __future__ import annotations

from typing import Any, Optional

from paddle.nn import Layer

from ..._typing import DataLayoutND, Tensor
from ...framework import ParamAttr

class CELU(Layer):
    def __init__(self, alpha: float = ..., name: Optional[str] = ...) -> None: ...
    def forward(self, x: Tensor) -> Tensor: ...
    def extra_repr(self) -> str: ...
    __call__ = forward

class ELU(Layer):
    def __init__(self, alpha: float = ..., name: Optional[str] = ...) -> None: ...
    def forward(self, x: Tensor) -> Tensor: ...
    def extra_repr(self) -> str: ...
    __call__ = forward

class GELU(Layer):
    def __init__(self, approximate: bool = ..., name: Optional[str] = ...) -> None: ...
    def forward(self, x: Tensor) -> Tensor: ...
    def extra_repr(self) -> str: ...
    __call__ = forward

class Hardshrink(Layer):
    def __init__(self, threshold: float = ..., name: Optional[str] = ...) -> None: ...
    def forward(self, x: Tensor) -> Tensor: ...
    def extra_repr(self) -> str: ...
    __call__ = forward

class Hardswish(Layer):
    def __init__(self, name: Optional[str] = ...) -> None: ...
    def forward(self, x: Tensor) -> Tensor: ...
    def extra_repr(self) -> str: ...
    __call__ = forward

class Tanh(Layer):
    def __init__(self, name: Optional[str] = ...) -> None: ...
    def forward(self, x: Tensor) -> Tensor: ...
    def extra_repr(self) -> str: ...
    __call__ = forward

class Hardtanh(Layer):
    def __init__(self, min: float = ..., max: float = ..., name: Optional[str] = ...) -> None: ...
    def forward(self, x: Tensor) -> Tensor: ...
    def extra_repr(self) -> str: ...
    __call__ = forward

class PReLU(Layer):
    def __init__(
        self,
        num_parameters: int = ...,
        init: float = ...,
        weight_attr: Optional[ParamAttr] = ...,
        data_format: DataLayoutND = ...,
        name: Optional[str] = ...,
    ) -> None: ...
    def forward(self, x: Tensor) -> Tensor: ...
    def extra_repr(self) -> str: ...
    __call__ = forward

class ReLU(Layer):
    def __init__(self, name: Optional[str] = ...) -> None: ...
    def forward(self, x: Tensor) -> Tensor: ...
    def extra_repr(self) -> str: ...
    __call__ = forward

class ReLU6(Layer):
    def __init__(self, name: Optional[str] = ...) -> None: ...
    def forward(self, x: Tensor) -> Tensor: ...
    def extra_repr(self) -> str: ...
    __call__ = forward

class SELU(Layer):
    def __init__(self, scale: float = ..., alpha: float = ..., name: Optional[str] = ...) -> None: ...
    def forward(self, x: Tensor) -> Tensor: ...
    def extra_repr(self) -> str: ...
    __call__ = forward

class LeakyReLU(Layer):
    def __init__(self, negative_slope: float = ..., name: Optional[str] = ...) -> None: ...
    def forward(self, x: Tensor) -> Tensor: ...
    def extra_repr(self) -> str: ...
    __call__ = forward

class Sigmoid(Layer):
    def __init__(self, name: Optional[str] = ...) -> None: ...
    def forward(self, x: Tensor) -> Tensor: ...
    def extra_repr(self) -> str: ...
    __call__ = forward

class Hardsigmoid(Layer):
    def __init__(self, name: Optional[str] = ...) -> None: ...
    def forward(self, x: Tensor) -> Tensor: ...
    def extra_repr(self) -> str: ...
    __call__ = forward

class Softplus(Layer):
    def __init__(self, beta: int = ..., threshold: int = ..., name: Optional[str] = ...) -> None: ...
    def forward(self, x: Tensor) -> Tensor: ...
    def extra_repr(self) -> str: ...
    __call__ = forward

class Softshrink(Layer):
    def __init__(self, threshold: float = ..., name: Optional[str] = ...) -> None: ...
    def forward(self, x: Tensor) -> Tensor: ...
    def extra_repr(self) -> str: ...
    __call__ = forward

class Softsign(Layer):
    def __init__(self, name: Optional[str] = ...) -> None: ...
    def forward(self, x: Tensor) -> Tensor: ...
    def extra_repr(self) -> str: ...
    __call__ = forward

class Swish(Layer):
    def __init__(self, name: Optional[str] = ...) -> None: ...
    def forward(self, x: Tensor) -> Tensor: ...
    def extra_repr(self) -> str: ...
    __call__ = forward

class Mish(Layer):
    def __init__(self, name: Optional[str] = ...) -> None: ...
    def forward(self, x: Tensor) -> Tensor: ...
    def extra_repr(self) -> str: ...
    __call__ = forward

class Tanhshrink(Layer):
    def __init__(self, name: Optional[str] = ...) -> None: ...
    def forward(self, x: Tensor) -> Tensor: ...
    def extra_repr(self) -> str: ...
    __call__ = forward

class ThresholdedReLU(Layer):
    def __init__(self, threshold: float = ..., name: Optional[str] = ...) -> None: ...
    def forward(self, x: Tensor) -> Tensor: ...
    def extra_repr(self) -> str: ...
    __call__ = forward

class Silu(Layer):
    def __init__(self, name: Optional[str] = ...) -> None: ...
    def forward(self, x: Tensor) -> Tensor: ...
    def extra_repr(self) -> str: ...
    __call__ = forward

class LogSigmoid(Layer):
    def __init__(self, name: Optional[str] = ...) -> None: ...
    def forward(self, x: Tensor) -> Tensor: ...
    def extra_repr(self) -> str: ...
    __call__ = forward

class Softmax(Layer):
    def __init__(self, axis: int = ..., name: Optional[str] = ...) -> None: ...
    def forward(self, x: Tensor) -> Tensor: ...
    def extra_repr(self) -> str: ...
    __call__ = forward

class LogSoftmax(Layer):
    def __init__(self, axis: int = ..., name: Optional[str] = ...) -> None: ...
    def forward(self, x: Tensor) -> Tensor: ...
    def extra_repr(self) -> str: ...
    __call__ = forward

class Maxout(Layer):
    def __init__(self, groups: Any, axis: int = ..., name: Optional[str] = ...) -> None: ...
    def forward(self, x: Tensor) -> Tensor: ...
    def extra_repr(self) -> str: ...
    __call__ = forward
