# polyaxon-sdk
Polyaxon SDKs and REST API specification.

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.1.8-rc6
- Package version: 1.1.8-rc6
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://github.com/polyaxon/polyaxon](https://github.com/polyaxon/polyaxon)

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import polyaxon_sdk
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import polyaxon_sdk
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function

import time
import polyaxon_sdk
from polyaxon_sdk.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = polyaxon_sdk.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKey
configuration = polyaxon_sdk.Configuration(
    host = "http://localhost",
    api_key = {
        'Authorization': 'YOUR_API_KEY'
    }
)
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Authorization'] = 'Bearer'


# Enter a context with an instance of the API client
with polyaxon_sdk.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = polyaxon_sdk.AccessResourcesV1Api(api_client)
    owner = 'owner_example' # str | Owner of the namespace
body = polyaxon_sdk.V1AccessResource() # V1AccessResource | Artifact store body

    try:
        # Create access resource
        api_response = api_instance.create_access_resource(owner, body)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling AccessResourcesV1Api->create_access_resource: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AccessResourcesV1Api* | [**create_access_resource**](docs/AccessResourcesV1Api.md#create_access_resource) | **POST** /api/v1/orgs/{owner}/access_resources | Create access resource
*AccessResourcesV1Api* | [**delete_access_resource**](docs/AccessResourcesV1Api.md#delete_access_resource) | **DELETE** /api/v1/orgs/{owner}/access_resources/{uuid} | Delete access resource
*AccessResourcesV1Api* | [**get_access_resource**](docs/AccessResourcesV1Api.md#get_access_resource) | **GET** /api/v1/orgs/{owner}/access_resources/{uuid} | Get access resource
*AccessResourcesV1Api* | [**list_access_resource_names**](docs/AccessResourcesV1Api.md#list_access_resource_names) | **GET** /api/v1/orgs/{owner}/access_resources/names | List access resource names
*AccessResourcesV1Api* | [**list_access_resources**](docs/AccessResourcesV1Api.md#list_access_resources) | **GET** /api/v1/orgs/{owner}/access_resources | List access resources
*AccessResourcesV1Api* | [**patch_access_resource**](docs/AccessResourcesV1Api.md#patch_access_resource) | **PATCH** /api/v1/orgs/{owner}/access_resources/{access_resource.uuid} | Patch access resource
*AccessResourcesV1Api* | [**update_access_resource**](docs/AccessResourcesV1Api.md#update_access_resource) | **PUT** /api/v1/orgs/{owner}/access_resources/{access_resource.uuid} | Update access resource
*AgentsV1Api* | [**create_agent**](docs/AgentsV1Api.md#create_agent) | **POST** /api/v1/orgs/{owner}/agents | Create agent
*AgentsV1Api* | [**create_agent_status**](docs/AgentsV1Api.md#create_agent_status) | **POST** /api/v1/orgs/{owner}/agents/{uuid}/statuses | Create new run status
*AgentsV1Api* | [**delete_agent**](docs/AgentsV1Api.md#delete_agent) | **DELETE** /api/v1/orgs/{owner}/agents/{uuid} | Delete agent
*AgentsV1Api* | [**get_agent**](docs/AgentsV1Api.md#get_agent) | **GET** /api/v1/orgs/{owner}/agents/{uuid} | Get agent
*AgentsV1Api* | [**get_agent_state**](docs/AgentsV1Api.md#get_agent_state) | **GET** /api/v1/orgs/{owner}/agents/{uuid}/state | Get State (queues/runs)
*AgentsV1Api* | [**get_agent_statuses**](docs/AgentsV1Api.md#get_agent_statuses) | **GET** /api/v1/orgs/{owner}/agents/{uuid}/statuses | Get agent status
*AgentsV1Api* | [**get_agent_token**](docs/AgentsV1Api.md#get_agent_token) | **GET** /api/v1/orgs/{owner}/agents/{agent}/token | Get agent token
*AgentsV1Api* | [**list_agent_names**](docs/AgentsV1Api.md#list_agent_names) | **GET** /api/v1/orgs/{owner}/agents/names | List agents names
*AgentsV1Api* | [**list_agents**](docs/AgentsV1Api.md#list_agents) | **GET** /api/v1/orgs/{owner}/agents | List agents
*AgentsV1Api* | [**patch_agent**](docs/AgentsV1Api.md#patch_agent) | **PATCH** /api/v1/orgs/{owner}/agents/{agent.uuid} | Patch agent
*AgentsV1Api* | [**patch_agent_token**](docs/AgentsV1Api.md#patch_agent_token) | **PATCH** /api/v1/orgs/{owner}/agents/{agent}/token | Patch agent token
*AgentsV1Api* | [**sync_agent**](docs/AgentsV1Api.md#sync_agent) | **PATCH** /api/v1/orgs/{owner}/agents/{agent.uuid}/sync | Sync agent
*AgentsV1Api* | [**update_agent**](docs/AgentsV1Api.md#update_agent) | **PUT** /api/v1/orgs/{owner}/agents/{agent.uuid} | Update agent
*AgentsV1Api* | [**update_agent_token**](docs/AgentsV1Api.md#update_agent_token) | **PUT** /api/v1/orgs/{owner}/agents/{agent}/token | Update agent token
*ArtifactsStoresV1Api* | [**upload_artifact**](docs/ArtifactsStoresV1Api.md#upload_artifact) | **POST** /api/v1/catalogs/{owner}/artifacts/{uuid}/upload | Upload artifact to a store
*AuthV1Api* | [**change_password**](docs/AuthV1Api.md#change_password) | **POST** /api/v1/auth/change-password | Change password
*AuthV1Api* | [**login**](docs/AuthV1Api.md#login) | **POST** /api/v1/auth/token | Login
*AuthV1Api* | [**reset_password**](docs/AuthV1Api.md#reset_password) | **POST** /api/v1/auth/reset-password | Reset password
*AuthV1Api* | [**reset_password_confirm**](docs/AuthV1Api.md#reset_password_confirm) | **POST** /api/v1/auth/reset-password-confirm | Reset password confirm
*AuthV1Api* | [**signup**](docs/AuthV1Api.md#signup) | **POST** /api/v1/auth/signup | Signup
*ComponentHubV1Api* | [**create_component_hub**](docs/ComponentHubV1Api.md#create_component_hub) | **POST** /api/v1/orgs/{owner}/components | Create hub component
*ComponentHubV1Api* | [**delete_component_hub**](docs/ComponentHubV1Api.md#delete_component_hub) | **DELETE** /api/v1/orgs/{owner}/components/{uuid} | Delete hub component
*ComponentHubV1Api* | [**get_component_hub**](docs/ComponentHubV1Api.md#get_component_hub) | **GET** /api/v1/orgs/{owner}/components/{uuid} | Get hub component
*ComponentHubV1Api* | [**list_component_hub_names**](docs/ComponentHubV1Api.md#list_component_hub_names) | **GET** /api/v1/orgs/{owner}/components/names | List hub component names
*ComponentHubV1Api* | [**list_component_hubs**](docs/ComponentHubV1Api.md#list_component_hubs) | **GET** /api/v1/orgs/{owner}/components | List hub components
*ComponentHubV1Api* | [**patch_component_hub**](docs/ComponentHubV1Api.md#patch_component_hub) | **PATCH** /api/v1/orgs/{owner}/components/{component.uuid} | Patch hub component
*ComponentHubV1Api* | [**update_component_hub**](docs/ComponentHubV1Api.md#update_component_hub) | **PUT** /api/v1/orgs/{owner}/components/{component.uuid} | Update hub component
*ConnectionsV1Api* | [**create_connection**](docs/ConnectionsV1Api.md#create_connection) | **POST** /api/v1/orgs/{owner}/connections | Create connection
*ConnectionsV1Api* | [**delete_connection**](docs/ConnectionsV1Api.md#delete_connection) | **DELETE** /api/v1/orgs/{owner}/connections/{uuid} | Delete connection
*ConnectionsV1Api* | [**get_connection**](docs/ConnectionsV1Api.md#get_connection) | **GET** /api/v1/orgs/{owner}/connections/{uuid} | Get connection
*ConnectionsV1Api* | [**list_connection_names**](docs/ConnectionsV1Api.md#list_connection_names) | **GET** /api/v1/orgs/{owner}/connections/names | List connections names
*ConnectionsV1Api* | [**list_connections**](docs/ConnectionsV1Api.md#list_connections) | **GET** /api/v1/orgs/{owner}/connections | List connections
*ConnectionsV1Api* | [**patch_connection**](docs/ConnectionsV1Api.md#patch_connection) | **PATCH** /api/v1/orgs/{owner}/connections/{connection.uuid} | Patch connection
*ConnectionsV1Api* | [**update_connection**](docs/ConnectionsV1Api.md#update_connection) | **PUT** /api/v1/orgs/{owner}/connections/{connection.uuid} | Update connection
*DashboardsV1Api* | [**create_dashboard**](docs/DashboardsV1Api.md#create_dashboard) | **POST** /api/v1/orgs/{owner}/dashboards | Create dashboard
*DashboardsV1Api* | [**delete_dashboard**](docs/DashboardsV1Api.md#delete_dashboard) | **DELETE** /api/v1/orgs/{owner}/dashboards/{uuid} | Delete dashboard
*DashboardsV1Api* | [**get_dashboard**](docs/DashboardsV1Api.md#get_dashboard) | **GET** /api/v1/orgs/{owner}/dashboards/{uuid} | Get dashboard
*DashboardsV1Api* | [**list_dashboard_names**](docs/DashboardsV1Api.md#list_dashboard_names) | **GET** /api/v1/orgs/{owner}/dashboards/names | List dashboard names
*DashboardsV1Api* | [**list_dashboards**](docs/DashboardsV1Api.md#list_dashboards) | **GET** /api/v1/orgs/{owner}/dashboards | List dashboards
*DashboardsV1Api* | [**patch_dashboard**](docs/DashboardsV1Api.md#patch_dashboard) | **PATCH** /api/v1/orgs/{owner}/dashboards/{dashboard.uuid} | Patch dashboard
*DashboardsV1Api* | [**update_dashboard**](docs/DashboardsV1Api.md#update_dashboard) | **PUT** /api/v1/orgs/{owner}/dashboards/{dashboard.uuid} | Update dashboard
*ModelRegistryV1Api* | [**create_model_registry**](docs/ModelRegistryV1Api.md#create_model_registry) | **POST** /api/v1/orgs/{owner}/models | Create hub model
*ModelRegistryV1Api* | [**delete_model_registry**](docs/ModelRegistryV1Api.md#delete_model_registry) | **DELETE** /api/v1/orgs/{owner}/models/{uuid} | Delete hub model
*ModelRegistryV1Api* | [**get_model_registry**](docs/ModelRegistryV1Api.md#get_model_registry) | **GET** /api/v1/orgs/{owner}/models/{uuid} | Get hub model
*ModelRegistryV1Api* | [**list_model_registry**](docs/ModelRegistryV1Api.md#list_model_registry) | **GET** /api/v1/orgs/{owner}/models | List hub models
*ModelRegistryV1Api* | [**list_model_registry_names**](docs/ModelRegistryV1Api.md#list_model_registry_names) | **GET** /api/v1/orgs/{owner}/models/names | List hub model names
*ModelRegistryV1Api* | [**patch_model_registry**](docs/ModelRegistryV1Api.md#patch_model_registry) | **PATCH** /api/v1/orgs/{owner}/models/{model.uuid} | Patch hub model
*ModelRegistryV1Api* | [**update_model_registry**](docs/ModelRegistryV1Api.md#update_model_registry) | **PUT** /api/v1/orgs/{owner}/models/{model.uuid} | Update hub model
*OrganizationsV1Api* | [**create_organization**](docs/OrganizationsV1Api.md#create_organization) | **POST** /api/v1/orgs/create | Create organization
*OrganizationsV1Api* | [**create_organization_member**](docs/OrganizationsV1Api.md#create_organization_member) | **POST** /api/v1/orgs/{owner}/members | Create organization member
*OrganizationsV1Api* | [**delete_organization**](docs/OrganizationsV1Api.md#delete_organization) | **DELETE** /api/v1/orgs/{owner} | Delete organization
*OrganizationsV1Api* | [**delete_organization_invitation**](docs/OrganizationsV1Api.md#delete_organization_invitation) | **DELETE** /api/v1/orgs/{owner}/invitations | Delete organization invitation details
*OrganizationsV1Api* | [**delete_organization_member**](docs/OrganizationsV1Api.md#delete_organization_member) | **DELETE** /api/v1/orgs/{owner}/members/{user} | Delete organization member details
*OrganizationsV1Api* | [**get_organization**](docs/OrganizationsV1Api.md#get_organization) | **GET** /api/v1/orgs/{owner} | Get organization
*OrganizationsV1Api* | [**get_organization_invitation**](docs/OrganizationsV1Api.md#get_organization_invitation) | **GET** /api/v1/orgs/{owner}/invitations | Get organization invitation details
*OrganizationsV1Api* | [**get_organization_member**](docs/OrganizationsV1Api.md#get_organization_member) | **GET** /api/v1/orgs/{owner}/members/{user} | Get organization member details
*OrganizationsV1Api* | [**get_organization_settings**](docs/OrganizationsV1Api.md#get_organization_settings) | **GET** /api/v1/orgs/{owner}/settings | Get organization settings
*OrganizationsV1Api* | [**list_organization_members**](docs/OrganizationsV1Api.md#list_organization_members) | **GET** /api/v1/orgs/{owner}/members | Get organization members
*OrganizationsV1Api* | [**list_organization_names**](docs/OrganizationsV1Api.md#list_organization_names) | **GET** /api/v1/orgs/names | List organizations names
*OrganizationsV1Api* | [**list_organizations**](docs/OrganizationsV1Api.md#list_organizations) | **GET** /api/v1/orgs/list | List organizations
*OrganizationsV1Api* | [**patch_organization**](docs/OrganizationsV1Api.md#patch_organization) | **PATCH** /api/v1/orgs/{owner} | Patch organization
*OrganizationsV1Api* | [**patch_organization_invitation**](docs/OrganizationsV1Api.md#patch_organization_invitation) | **PATCH** /api/v1/orgs/{owner}/invitations | Patch organization invitation
*OrganizationsV1Api* | [**patch_organization_member**](docs/OrganizationsV1Api.md#patch_organization_member) | **PATCH** /api/v1/orgs/{owner}/members/{member.user} | Patch organization member
*OrganizationsV1Api* | [**patch_organization_settings**](docs/OrganizationsV1Api.md#patch_organization_settings) | **PATCH** /api/v1/orgs/{owner}/settings | Patch oranization settings
*OrganizationsV1Api* | [**update_organization**](docs/OrganizationsV1Api.md#update_organization) | **PUT** /api/v1/orgs/{owner} | Update organization
*OrganizationsV1Api* | [**update_organization_invitation**](docs/OrganizationsV1Api.md#update_organization_invitation) | **PUT** /api/v1/orgs/{owner}/invitations | Update organization invitation
*OrganizationsV1Api* | [**update_organization_member**](docs/OrganizationsV1Api.md#update_organization_member) | **PUT** /api/v1/orgs/{owner}/members/{member.user} | Update organization member
*OrganizationsV1Api* | [**update_organization_settings**](docs/OrganizationsV1Api.md#update_organization_settings) | **PUT** /api/v1/orgs/{owner}/settings | Update organization settings
*ProjectDashboardsV1Api* | [**create_project_dashboard**](docs/ProjectDashboardsV1Api.md#create_project_dashboard) | **POST** /api/v1/{owner}/{project}/dashboards | Create project dashboard
*ProjectDashboardsV1Api* | [**delete_project_dashboard**](docs/ProjectDashboardsV1Api.md#delete_project_dashboard) | **DELETE** /api/v1/{owner}/{project}/dashboards/{uuid} | Delete project dashboard
*ProjectDashboardsV1Api* | [**get_project_dashboard**](docs/ProjectDashboardsV1Api.md#get_project_dashboard) | **GET** /api/v1/{owner}/{project}/dashboards/{uuid} | Get project dashboard
*ProjectDashboardsV1Api* | [**list_project_dashboard_names**](docs/ProjectDashboardsV1Api.md#list_project_dashboard_names) | **GET** /api/v1/{owner}/{project}/dashboards/names | List project dashboard
*ProjectDashboardsV1Api* | [**list_project_dashboards**](docs/ProjectDashboardsV1Api.md#list_project_dashboards) | **GET** /api/v1/{owner}/{project}/dashboards | List project dashboards
*ProjectDashboardsV1Api* | [**patch_project_dashboard**](docs/ProjectDashboardsV1Api.md#patch_project_dashboard) | **PATCH** /api/v1/{owner}/{project}/dashboards/{dashboard.uuid} | Patch project dashboard
*ProjectDashboardsV1Api* | [**promote_project_dashboard**](docs/ProjectDashboardsV1Api.md#promote_project_dashboard) | **POST** /api/v1/{owner}/{project}/dashboards/{uuid}/promote | Promote project dashboard
*ProjectDashboardsV1Api* | [**update_project_dashboard**](docs/ProjectDashboardsV1Api.md#update_project_dashboard) | **PUT** /api/v1/{owner}/{project}/dashboards/{dashboard.uuid} | Update project dashboard
*ProjectSearchesV1Api* | [**create_project_search**](docs/ProjectSearchesV1Api.md#create_project_search) | **POST** /api/v1/{owner}/{project}/searches | Create project search
*ProjectSearchesV1Api* | [**delete_project_search**](docs/ProjectSearchesV1Api.md#delete_project_search) | **DELETE** /api/v1/{owner}/{project}/searches/{uuid} | Delete project search
*ProjectSearchesV1Api* | [**get_project_search**](docs/ProjectSearchesV1Api.md#get_project_search) | **GET** /api/v1/{owner}/{project}/searches/{uuid} | Get project search
*ProjectSearchesV1Api* | [**list_project_search_names**](docs/ProjectSearchesV1Api.md#list_project_search_names) | **GET** /api/v1/{owner}/{project}/searches/names | List project search names
*ProjectSearchesV1Api* | [**list_project_searches**](docs/ProjectSearchesV1Api.md#list_project_searches) | **GET** /api/v1/{owner}/{project}/searches | List project searches
*ProjectSearchesV1Api* | [**patch_project_search**](docs/ProjectSearchesV1Api.md#patch_project_search) | **PATCH** /api/v1/{owner}/{project}/searches/{search.uuid} | Patch project search
*ProjectSearchesV1Api* | [**promote_project_search**](docs/ProjectSearchesV1Api.md#promote_project_search) | **POST** /api/v1/{owner}/{project}/searches/{uuid}/promote | Promote project search
*ProjectSearchesV1Api* | [**update_project_search**](docs/ProjectSearchesV1Api.md#update_project_search) | **PUT** /api/v1/{owner}/{project}/searches/{search.uuid} | Update project search
*ProjectsV1Api* | [**archive_project**](docs/ProjectsV1Api.md#archive_project) | **POST** /api/v1/{owner}/{project}/archive | Archive project
*ProjectsV1Api* | [**bookmark_project**](docs/ProjectsV1Api.md#bookmark_project) | **POST** /api/v1/{owner}/{project}/bookmark | Bookmark project
*ProjectsV1Api* | [**create_project**](docs/ProjectsV1Api.md#create_project) | **POST** /api/v1/{owner}/projects/create | Create new project
*ProjectsV1Api* | [**delete_project**](docs/ProjectsV1Api.md#delete_project) | **DELETE** /api/v1/{owner}/{project} | Delete project
*ProjectsV1Api* | [**disable_project_ci**](docs/ProjectsV1Api.md#disable_project_ci) | **DELETE** /api/v1/{owner}/{project}/ci | Disbale project CI
*ProjectsV1Api* | [**enable_project_ci**](docs/ProjectsV1Api.md#enable_project_ci) | **POST** /api/v1/{owner}/{project}/ci | Enable project CI
*ProjectsV1Api* | [**fetch_project_teams**](docs/ProjectsV1Api.md#fetch_project_teams) | **GET** /api/v1/{owner}/{project}/teams | Get project teams
*ProjectsV1Api* | [**get_project**](docs/ProjectsV1Api.md#get_project) | **GET** /api/v1/{owner}/{project} | Get project
*ProjectsV1Api* | [**get_project_settings**](docs/ProjectsV1Api.md#get_project_settings) | **GET** /api/v1/{owner}/{project}/settings | Get Project settings
*ProjectsV1Api* | [**list_archived_projects**](docs/ProjectsV1Api.md#list_archived_projects) | **GET** /api/v1/archives/{user}/projects | List archived projects for user
*ProjectsV1Api* | [**list_bookmarked_projects**](docs/ProjectsV1Api.md#list_bookmarked_projects) | **GET** /api/v1/bookmarks/{user}/projects | List bookmarked projects for user
*ProjectsV1Api* | [**list_project_names**](docs/ProjectsV1Api.md#list_project_names) | **GET** /api/v1/{owner}/projects/names | List project names
*ProjectsV1Api* | [**list_projects**](docs/ProjectsV1Api.md#list_projects) | **GET** /api/v1/{owner}/projects/list | List projects
*ProjectsV1Api* | [**patch_project**](docs/ProjectsV1Api.md#patch_project) | **PATCH** /api/v1/{owner}/{project.name} | Patch project
*ProjectsV1Api* | [**patch_project_settings**](docs/ProjectsV1Api.md#patch_project_settings) | **PATCH** /api/v1/{owner}/{project}/settings | Patch project settings
*ProjectsV1Api* | [**patch_project_teams**](docs/ProjectsV1Api.md#patch_project_teams) | **PATCH** /api/v1/{owner}/{project}/teams | Patch project teams
*ProjectsV1Api* | [**restore_project**](docs/ProjectsV1Api.md#restore_project) | **POST** /api/v1/{owner}/{project}/restore | Restore project
*ProjectsV1Api* | [**unbookmark_project**](docs/ProjectsV1Api.md#unbookmark_project) | **DELETE** /api/v1/{owner}/{project}/unbookmark | Unbookmark project
*ProjectsV1Api* | [**update_project**](docs/ProjectsV1Api.md#update_project) | **PUT** /api/v1/{owner}/{project.name} | Update project
*ProjectsV1Api* | [**update_project_settings**](docs/ProjectsV1Api.md#update_project_settings) | **PUT** /api/v1/{owner}/{project}/settings | Update project settings
*ProjectsV1Api* | [**update_project_teams**](docs/ProjectsV1Api.md#update_project_teams) | **PUT** /api/v1/{owner}/{project}/teams | Update project teams
*ProjectsV1Api* | [**upload_project_artifact**](docs/ProjectsV1Api.md#upload_project_artifact) | **POST** /api/v1/{owner}/{project}/artifacts/{uuid}/upload | Upload artifact to a store via project access
*QueuesV1Api* | [**create_queue**](docs/QueuesV1Api.md#create_queue) | **POST** /api/v1/orgs/{owner}/agents/{agent}/queues | Create queue
*QueuesV1Api* | [**delete_queue**](docs/QueuesV1Api.md#delete_queue) | **DELETE** /api/v1/orgs/{owner}/agents/{agent}/queues/{uuid} | Delete queue
*QueuesV1Api* | [**get_queue**](docs/QueuesV1Api.md#get_queue) | **GET** /api/v1/orgs/{owner}/agents/{agent}/queues/{uuid} | Get queue
*QueuesV1Api* | [**list_organization_queue_names**](docs/QueuesV1Api.md#list_organization_queue_names) | **GET** /api/v1/orgs/{owner}/queues/names | List organization level queues names
*QueuesV1Api* | [**list_organization_queues**](docs/QueuesV1Api.md#list_organization_queues) | **GET** /api/v1/orgs/{owner}/queues | List organization level queues
*QueuesV1Api* | [**list_queue_names**](docs/QueuesV1Api.md#list_queue_names) | **GET** /api/v1/orgs/{owner}/agents/{agent}/queues/names | List queues names
*QueuesV1Api* | [**list_queues**](docs/QueuesV1Api.md#list_queues) | **GET** /api/v1/orgs/{owner}/agents/{agent}/queues | List queues
*QueuesV1Api* | [**patch_queue**](docs/QueuesV1Api.md#patch_queue) | **PATCH** /api/v1/orgs/{owner}/agents/{agent}/queues/{queue.uuid} | Patch queue
*QueuesV1Api* | [**update_queue**](docs/QueuesV1Api.md#update_queue) | **PUT** /api/v1/orgs/{owner}/agents/{agent}/queues/{queue.uuid} | Update queue
*RunProfilesV1Api* | [**create_run_profile**](docs/RunProfilesV1Api.md#create_run_profile) | **POST** /api/v1/orgs/{owner}/run_profiles | Create run profile
*RunProfilesV1Api* | [**delete_run_profile**](docs/RunProfilesV1Api.md#delete_run_profile) | **DELETE** /api/v1/orgs/{owner}/run_profiles/{uuid} | Delete run profile
*RunProfilesV1Api* | [**get_run_profile**](docs/RunProfilesV1Api.md#get_run_profile) | **GET** /api/v1/orgs/{owner}/run_profiles/{uuid} | Get run profile
*RunProfilesV1Api* | [**list_run_profile_names**](docs/RunProfilesV1Api.md#list_run_profile_names) | **GET** /api/v1/orgs/{owner}/run_profiles/names | List run profiles names
*RunProfilesV1Api* | [**list_run_profiles**](docs/RunProfilesV1Api.md#list_run_profiles) | **GET** /api/v1/orgs/{owner}/run_profiles | List run profiles
*RunProfilesV1Api* | [**patch_run_profile**](docs/RunProfilesV1Api.md#patch_run_profile) | **PATCH** /api/v1/orgs/{owner}/run_profiles/{run_profile.uuid} | Patch run profile
*RunProfilesV1Api* | [**update_run_profile**](docs/RunProfilesV1Api.md#update_run_profile) | **PUT** /api/v1/orgs/{owner}/run_profiles/{run_profile.uuid} | Update run profile
*RunsV1Api* | [**archive_run**](docs/RunsV1Api.md#archive_run) | **POST** /api/v1/{owner}/{project}/runs/{uuid}/archive | Archive run
*RunsV1Api* | [**bookmark_run**](docs/RunsV1Api.md#bookmark_run) | **POST** /api/v1/{owner}/{project}/runs/{uuid}/bookmark | Bookmark run
*RunsV1Api* | [**bookmark_runs**](docs/RunsV1Api.md#bookmark_runs) | **POST** /api/v1/{owner}/{project}/runs/bookmark | Bookmark runs
*RunsV1Api* | [**collect_run_logs**](docs/RunsV1Api.md#collect_run_logs) | **POST** /streams/v1/{namespace}/_internal/{owner}/{project}/runs/{uuid}/logs | Collect run logs
*RunsV1Api* | [**copy_run**](docs/RunsV1Api.md#copy_run) | **POST** /api/v1/{entity.owner}/{entity.project}/runs/{entity.uuid}/copy | Restart run with copy
*RunsV1Api* | [**create_run**](docs/RunsV1Api.md#create_run) | **POST** /api/v1/{owner}/{project}/runs | Create new run
*RunsV1Api* | [**create_run_artifacts_lineage**](docs/RunsV1Api.md#create_run_artifacts_lineage) | **POST** /api/v1/{owner}/{project}/runs/{uuid}/artifacts_lineage | Create bulk run run artifacts lineage
*RunsV1Api* | [**create_run_status**](docs/RunsV1Api.md#create_run_status) | **POST** /api/v1/{owner}/{project}/runs/{uuid}/statuses | Create new run status
*RunsV1Api* | [**delete_run**](docs/RunsV1Api.md#delete_run) | **DELETE** /api/v1/{owner}/{project}/runs/{uuid} | Delete run
*RunsV1Api* | [**delete_run_artifact**](docs/RunsV1Api.md#delete_run_artifact) | **DELETE** /streams/v1/{namespace}/{owner}/{project}/runs/{uuid}/artifact | Delete run artifact
*RunsV1Api* | [**delete_run_artifact_lineage**](docs/RunsV1Api.md#delete_run_artifact_lineage) | **DELETE** /api/v1/{owner}/{project}/runs/{uuid}/artifacts_lineage/{name} | Delete run artifact lineage
*RunsV1Api* | [**delete_run_artifacts**](docs/RunsV1Api.md#delete_run_artifacts) | **DELETE** /streams/v1/{namespace}/{owner}/{project}/runs/{uuid}/artifacts | Delete run artifacts
*RunsV1Api* | [**delete_runs**](docs/RunsV1Api.md#delete_runs) | **DELETE** /api/v1/{owner}/{project}/runs/delete | Delete runs
*RunsV1Api* | [**get_multi_run_events**](docs/RunsV1Api.md#get_multi_run_events) | **GET** /streams/v1/{namespace}/{owner}/{project}/runs/multi/events/{kind} | Get multi runs events
*RunsV1Api* | [**get_run**](docs/RunsV1Api.md#get_run) | **GET** /api/v1/{owner}/{project}/runs/{uuid} | Get run
*RunsV1Api* | [**get_run_artifact**](docs/RunsV1Api.md#get_run_artifact) | **GET** /streams/v1/{namespace}/{owner}/{project}/runs/{uuid}/artifact | Get run artifact
*RunsV1Api* | [**get_run_artifact_lineage**](docs/RunsV1Api.md#get_run_artifact_lineage) | **GET** /api/v1/{owner}/{project}/runs/{uuid}/artifacts_lineage/{name} | Get run artifacts lineage
*RunsV1Api* | [**get_run_artifacts**](docs/RunsV1Api.md#get_run_artifacts) | **GET** /streams/v1/{namespace}/{owner}/{project}/runs/{uuid}/artifacts | Get run artifacts
*RunsV1Api* | [**get_run_artifacts_lineage**](docs/RunsV1Api.md#get_run_artifacts_lineage) | **GET** /api/v1/{owner}/{project}/runs/{uuid}/artifacts_lineage | Get run artifacts lineage
*RunsV1Api* | [**get_run_artifacts_lineage_names**](docs/RunsV1Api.md#get_run_artifacts_lineage_names) | **GET** /api/v1/{owner}/{project}/runs/{uuid}/artifacts_lineage/names | Get run artifacts lineage names
*RunsV1Api* | [**get_run_artifacts_tree**](docs/RunsV1Api.md#get_run_artifacts_tree) | **GET** /streams/v1/{namespace}/{owner}/{project}/runs/{uuid}/artifacts/tree | Get run artifacts tree
*RunsV1Api* | [**get_run_events**](docs/RunsV1Api.md#get_run_events) | **GET** /streams/v1/{namespace}/{owner}/{project}/runs/{uuid}/events/{kind} | Get run events
*RunsV1Api* | [**get_run_logs**](docs/RunsV1Api.md#get_run_logs) | **GET** /streams/v1/{namespace}/{owner}/{project}/runs/{uuid}/logs | Get run logs
*RunsV1Api* | [**get_run_namespace**](docs/RunsV1Api.md#get_run_namespace) | **GET** /api/v1/{owner}/{project}/runs/{uuid}/namespace | Get Run namespace
*RunsV1Api* | [**get_run_resources**](docs/RunsV1Api.md#get_run_resources) | **GET** /streams/v1/{namespace}/{owner}/{project}/runs/{uuid}/resources | Get run resources events
*RunsV1Api* | [**get_run_settings**](docs/RunsV1Api.md#get_run_settings) | **GET** /api/v1/{owner}/{project}/runs/{uuid}/settings | Get Run settings
*RunsV1Api* | [**get_run_statuses**](docs/RunsV1Api.md#get_run_statuses) | **GET** /api/v1/{owner}/{project}/runs/{uuid}/statuses | Get run statuses
*RunsV1Api* | [**get_runs_artifacts_lineage**](docs/RunsV1Api.md#get_runs_artifacts_lineage) | **GET** /api/v1/{owner}/{project}/runs/artifacts_lineage | Get runs artifacts lineage
*RunsV1Api* | [**impersonate_token**](docs/RunsV1Api.md#impersonate_token) | **POST** /api/v1/{owner}/{project}/runs/{uuid}/impersonate | Impersonate run token
*RunsV1Api* | [**invalidate_run**](docs/RunsV1Api.md#invalidate_run) | **POST** /api/v1/{owner}/{project}/runs/{uuid}/invalidate | Invalidate run
*RunsV1Api* | [**invalidate_runs**](docs/RunsV1Api.md#invalidate_runs) | **POST** /api/v1/{owner}/{project}/runs/invalidate | Invalidate runs
*RunsV1Api* | [**list_archived_runs**](docs/RunsV1Api.md#list_archived_runs) | **GET** /api/v1/archives/{user}/runs | List archived runs for user
*RunsV1Api* | [**list_bookmarked_runs**](docs/RunsV1Api.md#list_bookmarked_runs) | **GET** /api/v1/bookmarks/{user}/runs | List bookmarked runs for user
*RunsV1Api* | [**list_runs**](docs/RunsV1Api.md#list_runs) | **GET** /api/v1/{owner}/{project}/runs | List runs
*RunsV1Api* | [**notify_run_status**](docs/RunsV1Api.md#notify_run_status) | **POST** /streams/v1/{namespace}/{owner}/{project}/runs/{uuid}/notify | Notify run status
*RunsV1Api* | [**patch_run**](docs/RunsV1Api.md#patch_run) | **PATCH** /api/v1/{owner}/{project}/runs/{run.uuid} | Patch run
*RunsV1Api* | [**restart_run**](docs/RunsV1Api.md#restart_run) | **POST** /api/v1/{entity.owner}/{entity.project}/runs/{entity.uuid}/restart | Restart run
*RunsV1Api* | [**restore_run**](docs/RunsV1Api.md#restore_run) | **POST** /api/v1/{owner}/{project}/runs/{uuid}/restore | Restore run
*RunsV1Api* | [**resume_run**](docs/RunsV1Api.md#resume_run) | **POST** /api/v1/{entity.owner}/{entity.project}/runs/{entity.uuid}/resume | Resume run
*RunsV1Api* | [**start_run_tensorboard**](docs/RunsV1Api.md#start_run_tensorboard) | **POST** /api/v1/{owner}/{project}/runs/{uuid}/tensorboard/start | Start run tensorboard
*RunsV1Api* | [**stop_run**](docs/RunsV1Api.md#stop_run) | **POST** /api/v1/{owner}/{project}/runs/{uuid}/stop | Stop run
*RunsV1Api* | [**stop_run_tensorboard**](docs/RunsV1Api.md#stop_run_tensorboard) | **POST** /api/v1/{owner}/{project}/runs/{uuid}/tensorboard/stop | Stop run tensorboard
*RunsV1Api* | [**stop_runs**](docs/RunsV1Api.md#stop_runs) | **POST** /api/v1/{owner}/{project}/runs/stop | Stop runs
*RunsV1Api* | [**tag_runs**](docs/RunsV1Api.md#tag_runs) | **POST** /api/v1/{owner}/{project}/runs/tag | Tag runs
*RunsV1Api* | [**unbookmark_run**](docs/RunsV1Api.md#unbookmark_run) | **DELETE** /api/v1/{owner}/{project}/runs/{uuid}/unbookmark | Unbookmark run
*RunsV1Api* | [**update_run**](docs/RunsV1Api.md#update_run) | **PUT** /api/v1/{owner}/{project}/runs/{run.uuid} | Update run
*RunsV1Api* | [**upload_run_artifact**](docs/RunsV1Api.md#upload_run_artifact) | **POST** /api/v1/{owner}/{project}/runs/{uuid}/artifacts/upload | Upload an artifact file to a store via run access
*RunsV1Api* | [**upload_run_logs**](docs/RunsV1Api.md#upload_run_logs) | **POST** /api/v1/{owner}/{project}/runs/{uuid}/logs/upload | Upload a logs file to a store via run access
*SchemasV1Api* | [**no_op**](docs/SchemasV1Api.md#no_op) | **GET** /schemas | Get random
*SearchesV1Api* | [**create_search**](docs/SearchesV1Api.md#create_search) | **POST** /api/v1/orgs/{owner}/searches | Create search
*SearchesV1Api* | [**delete_search**](docs/SearchesV1Api.md#delete_search) | **DELETE** /api/v1/orgs/{owner}/searches/{uuid} | Delete search
*SearchesV1Api* | [**get_search**](docs/SearchesV1Api.md#get_search) | **GET** /api/v1/orgs/{owner}/searches/{uuid} | Get search
*SearchesV1Api* | [**list_search_names**](docs/SearchesV1Api.md#list_search_names) | **GET** /api/v1/orgs/{owner}/searches/names | List search names
*SearchesV1Api* | [**list_searches**](docs/SearchesV1Api.md#list_searches) | **GET** /api/v1/orgs/{owner}/searches | List searches
*SearchesV1Api* | [**patch_search**](docs/SearchesV1Api.md#patch_search) | **PATCH** /api/v1/orgs/{owner}/searches/{search.uuid} | Patch search
*SearchesV1Api* | [**update_search**](docs/SearchesV1Api.md#update_search) | **PUT** /api/v1/orgs/{owner}/searches/{search.uuid} | Update search
*TeamsV1Api* | [**create_team**](docs/TeamsV1Api.md#create_team) | **POST** /api/v1/orgs/{owner}/teams | Create team
*TeamsV1Api* | [**create_team_member**](docs/TeamsV1Api.md#create_team_member) | **POST** /api/v1/orgs/{owner}/teams/{team}/members | Create team member
*TeamsV1Api* | [**delete_team**](docs/TeamsV1Api.md#delete_team) | **DELETE** /api/v1/orgs/{owner}/teams/{team} | Delete team
*TeamsV1Api* | [**delete_team_member**](docs/TeamsV1Api.md#delete_team_member) | **DELETE** /api/v1/orgs/{owner}/teams/{team}/members/{user} | Delete team member details
*TeamsV1Api* | [**get_team**](docs/TeamsV1Api.md#get_team) | **GET** /api/v1/orgs/{owner}/teams/{team} | Get team
*TeamsV1Api* | [**get_team_member**](docs/TeamsV1Api.md#get_team_member) | **GET** /api/v1/orgs/{owner}/teams/{team}/members/{user} | Get team member details
*TeamsV1Api* | [**list_team_members**](docs/TeamsV1Api.md#list_team_members) | **GET** /api/v1/orgs/{owner}/teams/{team}/members | Get team members
*TeamsV1Api* | [**list_team_names**](docs/TeamsV1Api.md#list_team_names) | **GET** /api/v1/orgs/{owner}/teams/names | List teams names
*TeamsV1Api* | [**list_teams**](docs/TeamsV1Api.md#list_teams) | **GET** /api/v1/orgs/{owner}/teams | List teams
*TeamsV1Api* | [**patch_team**](docs/TeamsV1Api.md#patch_team) | **PATCH** /api/v1/orgs/{owner}/teams/{team.name} | Patch team
*TeamsV1Api* | [**patch_team_member**](docs/TeamsV1Api.md#patch_team_member) | **PATCH** /api/v1/orgs/{owner}/teams/{team}/members/{member.user} | Patch tram member
*TeamsV1Api* | [**update_team**](docs/TeamsV1Api.md#update_team) | **PUT** /api/v1/orgs/{owner}/teams/{team.name} | Update team
*TeamsV1Api* | [**update_team_member**](docs/TeamsV1Api.md#update_team_member) | **PUT** /api/v1/orgs/{owner}/teams/{team}/members/{member.user} | Update team member
*UsersV1Api* | [**create_token**](docs/UsersV1Api.md#create_token) | **POST** /api/v1/users/tokens | Create token
*UsersV1Api* | [**delete_token**](docs/UsersV1Api.md#delete_token) | **DELETE** /api/v1/users/tokens/{uuid} | Delete token
*UsersV1Api* | [**get_token**](docs/UsersV1Api.md#get_token) | **GET** /api/v1/users/tokens/{uuid} | Get token
*UsersV1Api* | [**get_user**](docs/UsersV1Api.md#get_user) | **GET** /api/v1/users | Get current user
*UsersV1Api* | [**list_tokens**](docs/UsersV1Api.md#list_tokens) | **GET** /api/v1/users/tokens | List tokens
*UsersV1Api* | [**patch_token**](docs/UsersV1Api.md#patch_token) | **PATCH** /api/v1/users/tokens/{token.uuid} | Patch token
*UsersV1Api* | [**patch_user**](docs/UsersV1Api.md#patch_user) | **PATCH** /api/v1/users | Patch current user
*UsersV1Api* | [**update_token**](docs/UsersV1Api.md#update_token) | **PUT** /api/v1/users/tokens/{token.uuid} | Update token
*UsersV1Api* | [**update_user**](docs/UsersV1Api.md#update_user) | **PUT** /api/v1/users | Update current user
*VersionsV1Api* | [**get_compatibility**](docs/VersionsV1Api.md#get_compatibility) | **GET** /api/v1/compatibility/{uuid}/{version}/{service} | Get compatibility versions
*VersionsV1Api* | [**get_installation**](docs/VersionsV1Api.md#get_installation) | **GET** /api/v1/installation | Get installation versions
*VersionsV1Api* | [**get_log_handler**](docs/VersionsV1Api.md#get_log_handler) | **GET** /api/v1/log_handler | Get log handler versions


## Documentation For Models

 - [AgentStateResponseAgentState](docs/AgentStateResponseAgentState.md)
 - [DashboardView](docs/DashboardView.md)
 - [ProtobufAny](docs/ProtobufAny.md)
 - [ProtobufNullValue](docs/ProtobufNullValue.md)
 - [RuntimeError](docs/RuntimeError.md)
 - [SparkDeployMode](docs/SparkDeployMode.md)
 - [V1AccessResource](docs/V1AccessResource.md)
 - [V1Action](docs/V1Action.md)
 - [V1Agent](docs/V1Agent.md)
 - [V1AgentStateResponse](docs/V1AgentStateResponse.md)
 - [V1AgentStatusBodyRequest](docs/V1AgentStatusBodyRequest.md)
 - [V1ArtifactKind](docs/V1ArtifactKind.md)
 - [V1ArtifactTree](docs/V1ArtifactTree.md)
 - [V1ArtifactsMount](docs/V1ArtifactsMount.md)
 - [V1ArtifactsType](docs/V1ArtifactsType.md)
 - [V1Auth](docs/V1Auth.md)
 - [V1AuthType](docs/V1AuthType.md)
 - [V1AverageStoppingPolicy](docs/V1AverageStoppingPolicy.md)
 - [V1Bayes](docs/V1Bayes.md)
 - [V1BucketConnection](docs/V1BucketConnection.md)
 - [V1Cache](docs/V1Cache.md)
 - [V1ClaimConnection](docs/V1ClaimConnection.md)
 - [V1CleanPodPolicy](docs/V1CleanPodPolicy.md)
 - [V1Cloning](docs/V1Cloning.md)
 - [V1CloningKind](docs/V1CloningKind.md)
 - [V1Compatibility](docs/V1Compatibility.md)
 - [V1CompiledOperation](docs/V1CompiledOperation.md)
 - [V1Component](docs/V1Component.md)
 - [V1ComponentHub](docs/V1ComponentHub.md)
 - [V1ConnectionKind](docs/V1ConnectionKind.md)
 - [V1ConnectionResponse](docs/V1ConnectionResponse.md)
 - [V1ConnectionSchema](docs/V1ConnectionSchema.md)
 - [V1ConnectionType](docs/V1ConnectionType.md)
 - [V1Credentials](docs/V1Credentials.md)
 - [V1CronSchedule](docs/V1CronSchedule.md)
 - [V1Dag](docs/V1Dag.md)
 - [V1DagRef](docs/V1DagRef.md)
 - [V1Dashboard](docs/V1Dashboard.md)
 - [V1Dask](docs/V1Dask.md)
 - [V1DiffStoppingPolicy](docs/V1DiffStoppingPolicy.md)
 - [V1DockerfileType](docs/V1DockerfileType.md)
 - [V1EarlyStopping](docs/V1EarlyStopping.md)
 - [V1EntitiesTags](docs/V1EntitiesTags.md)
 - [V1EntityNotificationBody](docs/V1EntityNotificationBody.md)
 - [V1EntityStatusBodyRequest](docs/V1EntityStatusBodyRequest.md)
 - [V1Environment](docs/V1Environment.md)
 - [V1Event](docs/V1Event.md)
 - [V1EventArtifact](docs/V1EventArtifact.md)
 - [V1EventAudio](docs/V1EventAudio.md)
 - [V1EventChart](docs/V1EventChart.md)
 - [V1EventChartKind](docs/V1EventChartKind.md)
 - [V1EventCurve](docs/V1EventCurve.md)
 - [V1EventCurveKind](docs/V1EventCurveKind.md)
 - [V1EventDataframe](docs/V1EventDataframe.md)
 - [V1EventHistogram](docs/V1EventHistogram.md)
 - [V1EventImage](docs/V1EventImage.md)
 - [V1EventModel](docs/V1EventModel.md)
 - [V1EventType](docs/V1EventType.md)
 - [V1EventVideo](docs/V1EventVideo.md)
 - [V1EventsResponse](docs/V1EventsResponse.md)
 - [V1ExactTimeSchedule](docs/V1ExactTimeSchedule.md)
 - [V1FailureEarlyStopping](docs/V1FailureEarlyStopping.md)
 - [V1Flink](docs/V1Flink.md)
 - [V1GcsType](docs/V1GcsType.md)
 - [V1GitConnection](docs/V1GitConnection.md)
 - [V1GitType](docs/V1GitType.md)
 - [V1GridSearch](docs/V1GridSearch.md)
 - [V1Hook](docs/V1Hook.md)
 - [V1HookTrigger](docs/V1HookTrigger.md)
 - [V1HostConnection](docs/V1HostConnection.md)
 - [V1HostPathConnection](docs/V1HostPathConnection.md)
 - [V1HpChoice](docs/V1HpChoice.md)
 - [V1HpGeomSpace](docs/V1HpGeomSpace.md)
 - [V1HpLinSpace](docs/V1HpLinSpace.md)
 - [V1HpLogNormal](docs/V1HpLogNormal.md)
 - [V1HpLogSpace](docs/V1HpLogSpace.md)
 - [V1HpLogUniform](docs/V1HpLogUniform.md)
 - [V1HpNormal](docs/V1HpNormal.md)
 - [V1HpPChoice](docs/V1HpPChoice.md)
 - [V1HpParams](docs/V1HpParams.md)
 - [V1HpQLogNormal](docs/V1HpQLogNormal.md)
 - [V1HpQLogUniform](docs/V1HpQLogUniform.md)
 - [V1HpQNormal](docs/V1HpQNormal.md)
 - [V1HpQUniform](docs/V1HpQUniform.md)
 - [V1HpRange](docs/V1HpRange.md)
 - [V1HpUniform](docs/V1HpUniform.md)
 - [V1HubRef](docs/V1HubRef.md)
 - [V1Hyperband](docs/V1Hyperband.md)
 - [V1Hyperopt](docs/V1Hyperopt.md)
 - [V1HyperoptAlgorithms](docs/V1HyperoptAlgorithms.md)
 - [V1IO](docs/V1IO.md)
 - [V1ImageType](docs/V1ImageType.md)
 - [V1Init](docs/V1Init.md)
 - [V1Installation](docs/V1Installation.md)
 - [V1IntervalSchedule](docs/V1IntervalSchedule.md)
 - [V1IoCond](docs/V1IoCond.md)
 - [V1Iterative](docs/V1Iterative.md)
 - [V1Job](docs/V1Job.md)
 - [V1K8sResourceSchema](docs/V1K8sResourceSchema.md)
 - [V1K8sResourceType](docs/V1K8sResourceType.md)
 - [V1KFReplica](docs/V1KFReplica.md)
 - [V1ListAccessResourcesResponse](docs/V1ListAccessResourcesResponse.md)
 - [V1ListAgentsResponse](docs/V1ListAgentsResponse.md)
 - [V1ListBookmarksResponse](docs/V1ListBookmarksResponse.md)
 - [V1ListComponentHubsResponse](docs/V1ListComponentHubsResponse.md)
 - [V1ListConnectionsResponse](docs/V1ListConnectionsResponse.md)
 - [V1ListDashboardsResponse](docs/V1ListDashboardsResponse.md)
 - [V1ListModelRegistryResponse](docs/V1ListModelRegistryResponse.md)
 - [V1ListOrganizationMembersResponse](docs/V1ListOrganizationMembersResponse.md)
 - [V1ListOrganizationsResponse](docs/V1ListOrganizationsResponse.md)
 - [V1ListProjectsResponse](docs/V1ListProjectsResponse.md)
 - [V1ListQueuesResponse](docs/V1ListQueuesResponse.md)
 - [V1ListRunArtifactsResponse](docs/V1ListRunArtifactsResponse.md)
 - [V1ListRunProfilesResponse](docs/V1ListRunProfilesResponse.md)
 - [V1ListRunsResponse](docs/V1ListRunsResponse.md)
 - [V1ListSearchesResponse](docs/V1ListSearchesResponse.md)
 - [V1ListTeamMembersResponse](docs/V1ListTeamMembersResponse.md)
 - [V1ListTeamsResponse](docs/V1ListTeamsResponse.md)
 - [V1ListTokenResponse](docs/V1ListTokenResponse.md)
 - [V1Log](docs/V1Log.md)
 - [V1LogHandler](docs/V1LogHandler.md)
 - [V1Logs](docs/V1Logs.md)
 - [V1MPIJob](docs/V1MPIJob.md)
 - [V1Mapping](docs/V1Mapping.md)
 - [V1Matrix](docs/V1Matrix.md)
 - [V1MatrixKind](docs/V1MatrixKind.md)
 - [V1MedianStoppingPolicy](docs/V1MedianStoppingPolicy.md)
 - [V1MetricEarlyStopping](docs/V1MetricEarlyStopping.md)
 - [V1ModelRegistry](docs/V1ModelRegistry.md)
 - [V1Notification](docs/V1Notification.md)
 - [V1NotificationTrigger](docs/V1NotificationTrigger.md)
 - [V1Operation](docs/V1Operation.md)
 - [V1OperationBody](docs/V1OperationBody.md)
 - [V1OperationCond](docs/V1OperationCond.md)
 - [V1Optimization](docs/V1Optimization.md)
 - [V1OptimizationMetric](docs/V1OptimizationMetric.md)
 - [V1OptimizationResource](docs/V1OptimizationResource.md)
 - [V1Organization](docs/V1Organization.md)
 - [V1OrganizationMember](docs/V1OrganizationMember.md)
 - [V1Param](docs/V1Param.md)
 - [V1ParamSearch](docs/V1ParamSearch.md)
 - [V1PasswordChange](docs/V1PasswordChange.md)
 - [V1PathRef](docs/V1PathRef.md)
 - [V1Pipeline](docs/V1Pipeline.md)
 - [V1PipelineKind](docs/V1PipelineKind.md)
 - [V1Plugins](docs/V1Plugins.md)
 - [V1PolyaxonInitContainer](docs/V1PolyaxonInitContainer.md)
 - [V1PolyaxonSidecarContainer](docs/V1PolyaxonSidecarContainer.md)
 - [V1Project](docs/V1Project.md)
 - [V1ProjectEntityResourceRequest](docs/V1ProjectEntityResourceRequest.md)
 - [V1ProjectSettings](docs/V1ProjectSettings.md)
 - [V1ProjectTeams](docs/V1ProjectTeams.md)
 - [V1PytorchJob](docs/V1PytorchJob.md)
 - [V1Queue](docs/V1Queue.md)
 - [V1RandomSearch](docs/V1RandomSearch.md)
 - [V1Ray](docs/V1Ray.md)
 - [V1Reference](docs/V1Reference.md)
 - [V1RepeatableSchedule](docs/V1RepeatableSchedule.md)
 - [V1ResourceType](docs/V1ResourceType.md)
 - [V1Run](docs/V1Run.md)
 - [V1RunArtifact](docs/V1RunArtifact.md)
 - [V1RunArtifacts](docs/V1RunArtifacts.md)
 - [V1RunKind](docs/V1RunKind.md)
 - [V1RunProfile](docs/V1RunProfile.md)
 - [V1RunSchema](docs/V1RunSchema.md)
 - [V1RunSettings](docs/V1RunSettings.md)
 - [V1RunSettingsCatalog](docs/V1RunSettingsCatalog.md)
 - [V1S3Type](docs/V1S3Type.md)
 - [V1Schedule](docs/V1Schedule.md)
 - [V1Schemas](docs/V1Schemas.md)
 - [V1Search](docs/V1Search.md)
 - [V1SearchSpec](docs/V1SearchSpec.md)
 - [V1Service](docs/V1Service.md)
 - [V1Spark](docs/V1Spark.md)
 - [V1SparkReplica](docs/V1SparkReplica.md)
 - [V1SparkType](docs/V1SparkType.md)
 - [V1Status](docs/V1Status.md)
 - [V1StatusCond](docs/V1StatusCond.md)
 - [V1StatusCondition](docs/V1StatusCondition.md)
 - [V1Statuses](docs/V1Statuses.md)
 - [V1TFJob](docs/V1TFJob.md)
 - [V1Team](docs/V1Team.md)
 - [V1TeamMember](docs/V1TeamMember.md)
 - [V1Termination](docs/V1Termination.md)
 - [V1Token](docs/V1Token.md)
 - [V1TriggerPolicy](docs/V1TriggerPolicy.md)
 - [V1TruncationStoppingPolicy](docs/V1TruncationStoppingPolicy.md)
 - [V1UriType](docs/V1UriType.md)
 - [V1UrlRef](docs/V1UrlRef.md)
 - [V1User](docs/V1User.md)
 - [V1UserEmail](docs/V1UserEmail.md)
 - [V1UserSingup](docs/V1UserSingup.md)
 - [V1Uuids](docs/V1Uuids.md)
 - [V1Version](docs/V1Version.md)
 - [V1WasbType](docs/V1WasbType.md)


## Documentation For Authorization


## ApiKey

- **Type**: API key
- **API key parameter name**: Authorization
- **Location**: HTTP header


## Author

contact@polyaxon.com


