# napari-threedee

[![License](https://img.shields.io/pypi/l/napari-threedee.svg?color=green)](https://github.com/alisterburt/napari-threedee/raw/main/LICENSE)
[![PyPI](https://img.shields.io/pypi/v/napari-threedee.svg?color=green)](https://pypi.org/project/napari-threedee)
[![Python Version](https://img.shields.io/pypi/pyversions/napari-threedee.svg?color=green)](https://python.org)
[![tests](https://github.com/alisterburt/napari-threedee/workflows/tests/badge.svg)](https://github.com/alisterburt/napari-threedee/actions)
[![codecov](https://codecov.io/gh/alisterburt/napari-threedee/branch/main/graph/badge.svg)](https://codecov.io/gh/alisterburt/napari-threedee)
[![napari hub](https://img.shields.io/endpoint?url=https://api.napari-hub.org/shields/napari-threedee)](https://napari-hub.org/plugins/napari-threedee)

A suite of useful tools based on 3D interactivity in napari

----------------------------------

This [napari] plugin was generated with [Cookiecutter] using [@napari]'s [cookiecutter-napari-plugin] template.

<!--
Don't miss the full getting started guide to set up your new package:
https://github.com/napari/cookiecutter-napari-plugin#getting-started

and review the napari docs for plugin developers:
https://napari.org/docs/plugins/index.html
-->

## Installation

You can install `napari-threedee` via [pip]:

    pip install napari-threedee



To install latest development version :

    pip install git+https://github.com/alisterburt/napari-threedee.git

## Example applications
<table border="0">
<tr><td>


<img src="https://user-images.githubusercontent.com/1120672/173021751-9206de7d-5675-4aac-aa9e-8585457a7799.gif"
width="300"/>

</td><td>

[mesh lighting control](https://github.com/napari-threedee/napari-threedee/blob/main/examples/plugin/mesh_headlight.py)

</td></tr><tr><td>

<img src="https://user-images.githubusercontent.com/1120672/173022286-2473b6b2-a20e-4514-88a4-8295e001f099.gif"
width="300"/>

</td><td>

[annotate points on planes](https://github.com/napari-threedee/napari-threedee/blob/main/examples/plugin/plane_point_annotator.py)

</td></tr><tr><td>

<img src="https://user-images.githubusercontent.com/1120672/173023185-b6936d1d-590c-4b9b-816a-3779dfe774da.gif"
width="300"/>

</td><td>

[render plane manipulator](https://github.com/napari-threedee/napari-threedee/blob/main/examples/plugin/render_plane_manipulator.py)

</td></tr><tr><td>

<img src="https://user-images.githubusercontent.com/1120672/173023795-7150d3c2-d3d1-4913-981d-1092c1b59f21.gif"
width="300"/>

</td><td>

[layer manipulator](https://github.com/napari-threedee/napari-threedee/blob/main/examples/plugin/layer_manipulator.py)

</td></tr><tr><td>

<img src="https://user-images.githubusercontent.com/1120672/173024361-2f05c68b-e94d-4734-9f5e-1606391e6463.gif"
width="300"/>

</td><td>

[point manipulator](https://github.com/napari-threedee/napari-threedee/blob/main/examples/plugin/points_manipulator.py)


</td></tr></table>


## Contributing

Contributions are very welcome. Tests can be run with [tox], please ensure
the coverage at least stays the same before you submit a pull request.

## License

Distributed under the terms of the [BSD-3] license,
"napari-threedee" is free and open source software

## Issues

If you encounter any problems, please [file an issue] along with a detailed description.

[napari]: https://github.com/napari/napari
[Cookiecutter]: https://github.com/audreyr/cookiecutter
[@napari]: https://github.com/napari
[MIT]: http://opensource.org/licenses/MIT
[BSD-3]: http://opensource.org/licenses/BSD-3-Clause
[GNU GPL v3.0]: http://www.gnu.org/licenses/gpl-3.0.txt
[GNU LGPL v3.0]: http://www.gnu.org/licenses/lgpl-3.0.txt
[Apache Software License 2.0]: http://www.apache.org/licenses/LICENSE-2.0
[Mozilla Public License 2.0]: https://www.mozilla.org/media/MPL/2.0/index.txt
[cookiecutter-napari-plugin]: https://github.com/napari/cookiecutter-napari-plugin

[file an issue]: https://github.com/alisterburt/napari-threedee/issues

[napari]: https://github.com/napari/napari
[tox]: https://tox.readthedocs.io/en/latest/
[pip]: https://pypi.org/project/pip/
[PyPI]: https://pypi.org/
