# type: ignore
"""content

Revision ID: 7c1c6e101059
Revises: aeb9fe314556
Create Date: 2021-05-31 02:56:29.998095

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = "7c1c6e101059"
down_revision = "aeb9fe314556"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("medias", schema=None) as batch_op:
        batch_op.alter_column(
            "created_at",
            existing_type=sa.DATETIME(),
            type_=sa.TIMESTAMP(),
            existing_nullable=True,
        )

    with op.batch_alter_table("messages", schema=None) as batch_op:
        batch_op.add_column(sa.Column("archived", sa.Boolean(), nullable=True))
        batch_op.alter_column(
            "created_at",
            existing_type=sa.DATETIME(),
            type_=sa.TIMESTAMP(),
            existing_nullable=True,
        )

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("messages", schema=None) as batch_op:
        batch_op.alter_column(
            "created_at",
            existing_type=sa.TIMESTAMP(),
            type_=sa.DATETIME(),
            existing_nullable=True,
        )
        batch_op.drop_column("archived")

    with op.batch_alter_table("medias", schema=None) as batch_op:
        batch_op.alter_column(
            "created_at",
            existing_type=sa.TIMESTAMP(),
            type_=sa.DATETIME(),
            existing_nullable=True,
        )

    # ### end Alembic commands ###
