# type: ignore
"""content

Revision ID: 2e4f8364f7e2
Revises: ebc3f4bb0782
Create Date: 2021-05-31 02:56:17.448718

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = "2e4f8364f7e2"
down_revision = "ebc3f4bb0782"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("medias", schema=None) as batch_op:
        batch_op.alter_column(
            "created_at",
            existing_type=sa.DATETIME(),
            type_=sa.TIMESTAMP(),
            existing_nullable=True,
        )

    with op.batch_alter_table("stories", schema=None) as batch_op:
        batch_op.add_column(sa.Column("archived", sa.Boolean(), nullable=True))
        batch_op.alter_column(
            "created_at",
            existing_type=sa.DATETIME(),
            type_=sa.TIMESTAMP(),
            existing_nullable=True,
        )

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("stories", schema=None) as batch_op:
        batch_op.alter_column(
            "created_at",
            existing_type=sa.TIMESTAMP(),
            type_=sa.DATETIME(),
            existing_nullable=True,
        )
        batch_op.drop_column("archived")

    with op.batch_alter_table("medias", schema=None) as batch_op:
        batch_op.alter_column(
            "created_at",
            existing_type=sa.TIMESTAMP(),
            type_=sa.DATETIME(),
            existing_nullable=True,
        )

    # ### end Alembic commands ###
