"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FileFormat = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/file_format snowflake_file_format}
*/
class FileFormat extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/file_format snowflake_file_format} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options FileFormatConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'snowflake_file_format',
            terraformGeneratorMetadata: {
                providerName: 'snowflake',
                providerVersion: '0.45.0',
                providerVersionConstraint: ' ~> 0.40'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        this._allowDuplicate = config.allowDuplicate;
        this._binaryAsText = config.binaryAsText;
        this._binaryFormat = config.binaryFormat;
        this._comment = config.comment;
        this._compression = config.compression;
        this._database = config.database;
        this._dateFormat = config.dateFormat;
        this._disableAutoConvert = config.disableAutoConvert;
        this._disableSnowflakeData = config.disableSnowflakeData;
        this._emptyFieldAsNull = config.emptyFieldAsNull;
        this._enableOctal = config.enableOctal;
        this._encoding = config.encoding;
        this._errorOnColumnCountMismatch = config.errorOnColumnCountMismatch;
        this._escape = config.escape;
        this._escapeUnenclosedField = config.escapeUnenclosedField;
        this._fieldDelimiter = config.fieldDelimiter;
        this._fieldOptionallyEnclosedBy = config.fieldOptionallyEnclosedBy;
        this._fileExtension = config.fileExtension;
        this._formatType = config.formatType;
        this._id = config.id;
        this._ignoreUtf8Errors = config.ignoreUtf8Errors;
        this._name = config.name;
        this._nullIf = config.nullIf;
        this._preserveSpace = config.preserveSpace;
        this._recordDelimiter = config.recordDelimiter;
        this._replaceInvalidCharacters = config.replaceInvalidCharacters;
        this._schema = config.schema;
        this._skipBlankLines = config.skipBlankLines;
        this._skipByteOrderMark = config.skipByteOrderMark;
        this._skipHeader = config.skipHeader;
        this._stripNullValues = config.stripNullValues;
        this._stripOuterArray = config.stripOuterArray;
        this._stripOuterElement = config.stripOuterElement;
        this._timeFormat = config.timeFormat;
        this._timestampFormat = config.timestampFormat;
        this._trimSpace = config.trimSpace;
    }
    get allowDuplicate() {
        return this.getBooleanAttribute('allow_duplicate');
    }
    set allowDuplicate(value) {
        this._allowDuplicate = value;
    }
    resetAllowDuplicate() {
        this._allowDuplicate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowDuplicateInput() {
        return this._allowDuplicate;
    }
    get binaryAsText() {
        return this.getBooleanAttribute('binary_as_text');
    }
    set binaryAsText(value) {
        this._binaryAsText = value;
    }
    resetBinaryAsText() {
        this._binaryAsText = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get binaryAsTextInput() {
        return this._binaryAsText;
    }
    get binaryFormat() {
        return this.getStringAttribute('binary_format');
    }
    set binaryFormat(value) {
        this._binaryFormat = value;
    }
    resetBinaryFormat() {
        this._binaryFormat = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get binaryFormatInput() {
        return this._binaryFormat;
    }
    get comment() {
        return this.getStringAttribute('comment');
    }
    set comment(value) {
        this._comment = value;
    }
    resetComment() {
        this._comment = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get commentInput() {
        return this._comment;
    }
    get compression() {
        return this.getStringAttribute('compression');
    }
    set compression(value) {
        this._compression = value;
    }
    resetCompression() {
        this._compression = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get compressionInput() {
        return this._compression;
    }
    get database() {
        return this.getStringAttribute('database');
    }
    set database(value) {
        this._database = value;
    }
    // Temporarily expose input value. Use with caution.
    get databaseInput() {
        return this._database;
    }
    get dateFormat() {
        return this.getStringAttribute('date_format');
    }
    set dateFormat(value) {
        this._dateFormat = value;
    }
    resetDateFormat() {
        this._dateFormat = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dateFormatInput() {
        return this._dateFormat;
    }
    get disableAutoConvert() {
        return this.getBooleanAttribute('disable_auto_convert');
    }
    set disableAutoConvert(value) {
        this._disableAutoConvert = value;
    }
    resetDisableAutoConvert() {
        this._disableAutoConvert = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get disableAutoConvertInput() {
        return this._disableAutoConvert;
    }
    get disableSnowflakeData() {
        return this.getBooleanAttribute('disable_snowflake_data');
    }
    set disableSnowflakeData(value) {
        this._disableSnowflakeData = value;
    }
    resetDisableSnowflakeData() {
        this._disableSnowflakeData = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get disableSnowflakeDataInput() {
        return this._disableSnowflakeData;
    }
    get emptyFieldAsNull() {
        return this.getBooleanAttribute('empty_field_as_null');
    }
    set emptyFieldAsNull(value) {
        this._emptyFieldAsNull = value;
    }
    resetEmptyFieldAsNull() {
        this._emptyFieldAsNull = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get emptyFieldAsNullInput() {
        return this._emptyFieldAsNull;
    }
    get enableOctal() {
        return this.getBooleanAttribute('enable_octal');
    }
    set enableOctal(value) {
        this._enableOctal = value;
    }
    resetEnableOctal() {
        this._enableOctal = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableOctalInput() {
        return this._enableOctal;
    }
    get encoding() {
        return this.getStringAttribute('encoding');
    }
    set encoding(value) {
        this._encoding = value;
    }
    resetEncoding() {
        this._encoding = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get encodingInput() {
        return this._encoding;
    }
    get errorOnColumnCountMismatch() {
        return this.getBooleanAttribute('error_on_column_count_mismatch');
    }
    set errorOnColumnCountMismatch(value) {
        this._errorOnColumnCountMismatch = value;
    }
    resetErrorOnColumnCountMismatch() {
        this._errorOnColumnCountMismatch = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get errorOnColumnCountMismatchInput() {
        return this._errorOnColumnCountMismatch;
    }
    get escape() {
        return this.getStringAttribute('escape');
    }
    set escape(value) {
        this._escape = value;
    }
    resetEscape() {
        this._escape = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get escapeInput() {
        return this._escape;
    }
    get escapeUnenclosedField() {
        return this.getStringAttribute('escape_unenclosed_field');
    }
    set escapeUnenclosedField(value) {
        this._escapeUnenclosedField = value;
    }
    resetEscapeUnenclosedField() {
        this._escapeUnenclosedField = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get escapeUnenclosedFieldInput() {
        return this._escapeUnenclosedField;
    }
    get fieldDelimiter() {
        return this.getStringAttribute('field_delimiter');
    }
    set fieldDelimiter(value) {
        this._fieldDelimiter = value;
    }
    resetFieldDelimiter() {
        this._fieldDelimiter = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get fieldDelimiterInput() {
        return this._fieldDelimiter;
    }
    get fieldOptionallyEnclosedBy() {
        return this.getStringAttribute('field_optionally_enclosed_by');
    }
    set fieldOptionallyEnclosedBy(value) {
        this._fieldOptionallyEnclosedBy = value;
    }
    resetFieldOptionallyEnclosedBy() {
        this._fieldOptionallyEnclosedBy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get fieldOptionallyEnclosedByInput() {
        return this._fieldOptionallyEnclosedBy;
    }
    get fileExtension() {
        return this.getStringAttribute('file_extension');
    }
    set fileExtension(value) {
        this._fileExtension = value;
    }
    resetFileExtension() {
        this._fileExtension = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get fileExtensionInput() {
        return this._fileExtension;
    }
    get formatType() {
        return this.getStringAttribute('format_type');
    }
    set formatType(value) {
        this._formatType = value;
    }
    // Temporarily expose input value. Use with caution.
    get formatTypeInput() {
        return this._formatType;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get ignoreUtf8Errors() {
        return this.getBooleanAttribute('ignore_utf8_errors');
    }
    set ignoreUtf8Errors(value) {
        this._ignoreUtf8Errors = value;
    }
    resetIgnoreUtf8Errors() {
        this._ignoreUtf8Errors = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ignoreUtf8ErrorsInput() {
        return this._ignoreUtf8Errors;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get nullIf() {
        return this.getListAttribute('null_if');
    }
    set nullIf(value) {
        this._nullIf = value;
    }
    resetNullIf() {
        this._nullIf = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get nullIfInput() {
        return this._nullIf;
    }
    get preserveSpace() {
        return this.getBooleanAttribute('preserve_space');
    }
    set preserveSpace(value) {
        this._preserveSpace = value;
    }
    resetPreserveSpace() {
        this._preserveSpace = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get preserveSpaceInput() {
        return this._preserveSpace;
    }
    get recordDelimiter() {
        return this.getStringAttribute('record_delimiter');
    }
    set recordDelimiter(value) {
        this._recordDelimiter = value;
    }
    resetRecordDelimiter() {
        this._recordDelimiter = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get recordDelimiterInput() {
        return this._recordDelimiter;
    }
    get replaceInvalidCharacters() {
        return this.getBooleanAttribute('replace_invalid_characters');
    }
    set replaceInvalidCharacters(value) {
        this._replaceInvalidCharacters = value;
    }
    resetReplaceInvalidCharacters() {
        this._replaceInvalidCharacters = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get replaceInvalidCharactersInput() {
        return this._replaceInvalidCharacters;
    }
    get schema() {
        return this.getStringAttribute('schema');
    }
    set schema(value) {
        this._schema = value;
    }
    // Temporarily expose input value. Use with caution.
    get schemaInput() {
        return this._schema;
    }
    get skipBlankLines() {
        return this.getBooleanAttribute('skip_blank_lines');
    }
    set skipBlankLines(value) {
        this._skipBlankLines = value;
    }
    resetSkipBlankLines() {
        this._skipBlankLines = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get skipBlankLinesInput() {
        return this._skipBlankLines;
    }
    get skipByteOrderMark() {
        return this.getBooleanAttribute('skip_byte_order_mark');
    }
    set skipByteOrderMark(value) {
        this._skipByteOrderMark = value;
    }
    resetSkipByteOrderMark() {
        this._skipByteOrderMark = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get skipByteOrderMarkInput() {
        return this._skipByteOrderMark;
    }
    get skipHeader() {
        return this.getNumberAttribute('skip_header');
    }
    set skipHeader(value) {
        this._skipHeader = value;
    }
    resetSkipHeader() {
        this._skipHeader = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get skipHeaderInput() {
        return this._skipHeader;
    }
    get stripNullValues() {
        return this.getBooleanAttribute('strip_null_values');
    }
    set stripNullValues(value) {
        this._stripNullValues = value;
    }
    resetStripNullValues() {
        this._stripNullValues = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get stripNullValuesInput() {
        return this._stripNullValues;
    }
    get stripOuterArray() {
        return this.getBooleanAttribute('strip_outer_array');
    }
    set stripOuterArray(value) {
        this._stripOuterArray = value;
    }
    resetStripOuterArray() {
        this._stripOuterArray = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get stripOuterArrayInput() {
        return this._stripOuterArray;
    }
    get stripOuterElement() {
        return this.getBooleanAttribute('strip_outer_element');
    }
    set stripOuterElement(value) {
        this._stripOuterElement = value;
    }
    resetStripOuterElement() {
        this._stripOuterElement = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get stripOuterElementInput() {
        return this._stripOuterElement;
    }
    get timeFormat() {
        return this.getStringAttribute('time_format');
    }
    set timeFormat(value) {
        this._timeFormat = value;
    }
    resetTimeFormat() {
        this._timeFormat = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timeFormatInput() {
        return this._timeFormat;
    }
    get timestampFormat() {
        return this.getStringAttribute('timestamp_format');
    }
    set timestampFormat(value) {
        this._timestampFormat = value;
    }
    resetTimestampFormat() {
        this._timestampFormat = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timestampFormatInput() {
        return this._timestampFormat;
    }
    get trimSpace() {
        return this.getBooleanAttribute('trim_space');
    }
    set trimSpace(value) {
        this._trimSpace = value;
    }
    resetTrimSpace() {
        this._trimSpace = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get trimSpaceInput() {
        return this._trimSpace;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            allow_duplicate: cdktf.booleanToTerraform(this._allowDuplicate),
            binary_as_text: cdktf.booleanToTerraform(this._binaryAsText),
            binary_format: cdktf.stringToTerraform(this._binaryFormat),
            comment: cdktf.stringToTerraform(this._comment),
            compression: cdktf.stringToTerraform(this._compression),
            database: cdktf.stringToTerraform(this._database),
            date_format: cdktf.stringToTerraform(this._dateFormat),
            disable_auto_convert: cdktf.booleanToTerraform(this._disableAutoConvert),
            disable_snowflake_data: cdktf.booleanToTerraform(this._disableSnowflakeData),
            empty_field_as_null: cdktf.booleanToTerraform(this._emptyFieldAsNull),
            enable_octal: cdktf.booleanToTerraform(this._enableOctal),
            encoding: cdktf.stringToTerraform(this._encoding),
            error_on_column_count_mismatch: cdktf.booleanToTerraform(this._errorOnColumnCountMismatch),
            escape: cdktf.stringToTerraform(this._escape),
            escape_unenclosed_field: cdktf.stringToTerraform(this._escapeUnenclosedField),
            field_delimiter: cdktf.stringToTerraform(this._fieldDelimiter),
            field_optionally_enclosed_by: cdktf.stringToTerraform(this._fieldOptionallyEnclosedBy),
            file_extension: cdktf.stringToTerraform(this._fileExtension),
            format_type: cdktf.stringToTerraform(this._formatType),
            id: cdktf.stringToTerraform(this._id),
            ignore_utf8_errors: cdktf.booleanToTerraform(this._ignoreUtf8Errors),
            name: cdktf.stringToTerraform(this._name),
            null_if: cdktf.listMapper(cdktf.stringToTerraform, false)(this._nullIf),
            preserve_space: cdktf.booleanToTerraform(this._preserveSpace),
            record_delimiter: cdktf.stringToTerraform(this._recordDelimiter),
            replace_invalid_characters: cdktf.booleanToTerraform(this._replaceInvalidCharacters),
            schema: cdktf.stringToTerraform(this._schema),
            skip_blank_lines: cdktf.booleanToTerraform(this._skipBlankLines),
            skip_byte_order_mark: cdktf.booleanToTerraform(this._skipByteOrderMark),
            skip_header: cdktf.numberToTerraform(this._skipHeader),
            strip_null_values: cdktf.booleanToTerraform(this._stripNullValues),
            strip_outer_array: cdktf.booleanToTerraform(this._stripOuterArray),
            strip_outer_element: cdktf.booleanToTerraform(this._stripOuterElement),
            time_format: cdktf.stringToTerraform(this._timeFormat),
            timestamp_format: cdktf.stringToTerraform(this._timestampFormat),
            trim_space: cdktf.booleanToTerraform(this._trimSpace),
        };
    }
}
exports.FileFormat = FileFormat;
_a = JSII_RTTI_SYMBOL_1;
FileFormat[_a] = { fqn: "@cdktf/provider-snowflake.FileFormat", version: "2.0.68" };
// =================
// STATIC PROPERTIES
// =================
FileFormat.tfResourceType = "snowflake_file_format";
//# sourceMappingURL=data:application/json;base64,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