/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.assembler.assemblers;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.assembler.JA;
import com.hp.hpl.jena.assembler.Mode;
import com.hp.hpl.jena.assembler.assemblers.AssemblerBase;
import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.ResourceUtils;

public class DocumentManagerAssembler
extends AssemblerBase {
    @Override
    public Object open(Assembler a, Resource root, Mode irrelevant) {
        this.checkType(root, JA.DocumentManager);
        OntDocumentManager result = this.createDocumentManager();
        result.setMetadataSearchPath(this.getPath(a, root), false);
        result.configure(ResourceUtils.reachableClosure(root), false);
        result.setFileManager(this.getFileManager(a, root));
        return result;
    }

    private String getPath(Assembler a, Resource root) {
        String s2 = DocumentManagerAssembler.getUniqueString(root, JA.policyPath);
        return s2 == null ? "file:ont-policy.rdf;file:etc/ont-policy.rdf" : s2;
    }

    private FileManager getFileManager(Assembler a, Resource root) {
        Resource fm = DocumentManagerAssembler.getUniqueResource(root, JA.fileManager);
        return fm == null ? FileManager.get() : (FileManager)a.open(fm);
    }

    protected OntDocumentManager createDocumentManager() {
        return new OntDocumentManager("");
    }
}

