/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.impl;

import com.hp.hpl.jena.graph.BulkUpdateHandler;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphEventManager;
import com.hp.hpl.jena.graph.GraphEvents;
import com.hp.hpl.jena.graph.GraphUtil;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.impl.GraphWithPerform;
import com.hp.hpl.jena.util.IteratorCollection;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SimpleBulkUpdateHandler
implements BulkUpdateHandler {
    protected GraphWithPerform graph;
    protected GraphEventManager manager;

    public SimpleBulkUpdateHandler(GraphWithPerform graph) {
        this.graph = graph;
        this.manager = graph.getEventManager();
    }

    @Override
    @Deprecated
    public void add(Triple[] triples) {
        for (int i = 0; i < triples.length; ++i) {
            this.graph.performAdd(triples[i]);
        }
        this.manager.notifyAddArray(this.graph, triples);
    }

    @Override
    @Deprecated
    public void add(List<Triple> triples) {
        this.add(triples, true);
    }

    protected void add(List<Triple> triples, boolean notify) {
        for (int i = 0; i < triples.size(); ++i) {
            this.graph.performAdd(triples.get(i));
        }
        if (notify) {
            this.manager.notifyAddList(this.graph, triples);
        }
    }

    @Override
    @Deprecated
    public void add(Iterator<Triple> it) {
        this.addIterator(it, true);
    }

    public void addIterator(Iterator<Triple> it, boolean notify) {
        List<Triple> s2 = IteratorCollection.iteratorToList(it);
        this.add(s2, false);
        if (notify) {
            this.manager.notifyAddIterator((Graph)this.graph, s2);
        }
    }

    @Override
    public void add(Graph g2) {
        this.add(g2, false);
    }

    @Override
    @Deprecated
    public void add(Graph g2, boolean withReifications) {
        this.addIterator(GraphUtil.findAll(g2), false);
        if (withReifications) {
            SimpleBulkUpdateHandler.addReifications(this.graph, g2);
        }
        this.manager.notifyAddGraph(this.graph, g2);
    }

    public static void addReifications(Graph ours, Graph g2) {
        Reifier r = g2.getReifier();
        ExtendedIterator<Node> it = r.allNodes();
        while (it.hasNext()) {
            Node node = (Node)it.next();
            ours.getReifier().reifyAs(node, r.getTriple(node));
        }
    }

    public static void deleteReifications(Graph ours, Graph g2) {
        Reifier r = g2.getReifier();
        ExtendedIterator<Node> it = r.allNodes();
        while (it.hasNext()) {
            Node node = (Node)it.next();
            ours.getReifier().remove(node, r.getTriple(node));
        }
    }

    @Override
    @Deprecated
    public void delete(Triple[] triples) {
        for (int i = 0; i < triples.length; ++i) {
            this.graph.performDelete(triples[i]);
        }
        this.manager.notifyDeleteArray(this.graph, triples);
    }

    @Override
    @Deprecated
    public void delete(List<Triple> triples) {
        this.delete(triples, true);
    }

    protected void delete(List<Triple> triples, boolean notify) {
        for (int i = 0; i < triples.size(); ++i) {
            this.graph.performDelete(triples.get(i));
        }
        if (notify) {
            this.manager.notifyDeleteList(this.graph, triples);
        }
    }

    @Override
    @Deprecated
    public void delete(Iterator<Triple> it) {
        this.deleteIterator(it, true);
    }

    public void deleteIterator(Iterator<Triple> it, boolean notify) {
        List<Triple> L = IteratorCollection.iteratorToList(it);
        this.delete(L, false);
        if (notify) {
            this.manager.notifyDeleteIterator((Graph)this.graph, L);
        }
    }

    private List<Triple> triplesOf(Graph g2) {
        ArrayList<Triple> L = new ArrayList<Triple>();
        ExtendedIterator<Triple> it = g2.find(Triple.ANY);
        while (it.hasNext()) {
            L.add((Triple)it.next());
        }
        return L;
    }

    @Override
    public void delete(Graph g2) {
        this.delete(g2, false);
    }

    @Override
    @Deprecated
    public void delete(Graph g2, boolean withReifications) {
        if (g2.dependsOn(this.graph)) {
            this.delete(this.triplesOf(g2));
        } else {
            this.deleteIterator(GraphUtil.findAll(g2), false);
        }
        if (withReifications) {
            SimpleBulkUpdateHandler.deleteReifications(this.graph, g2);
        }
        this.manager.notifyDeleteGraph(this.graph, g2);
    }

    @Override
    public void removeAll() {
        SimpleBulkUpdateHandler.removeAll(this.graph);
        this.notifyRemoveAll();
    }

    protected void notifyRemoveAll() {
        this.manager.notifyEvent(this.graph, GraphEvents.removeAll);
    }

    @Override
    public void remove(Node s2, Node p, Node o) {
        SimpleBulkUpdateHandler.removeAll(this.graph, s2, p, o);
        this.manager.notifyEvent(this.graph, GraphEvents.remove(s2, p, o));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAll(Graph g2, Node s2, Node p, Node o) {
        ExtendedIterator<Triple> it = g2.find(s2, p, o);
        try {
            while (it.hasNext()) {
                it.next();
                it.remove();
            }
        }
        finally {
            it.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAll(Graph g2) {
        ExtendedIterator<Triple> it = GraphUtil.findAll(g2);
        try {
            while (it.hasNext()) {
                it.next();
                it.remove();
            }
        }
        finally {
            it.close();
        }
    }
}

