/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphUtil;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.query.Domain;
import com.hp.hpl.jena.graph.query.Expression;
import com.hp.hpl.jena.graph.query.ExpressionSet;
import com.hp.hpl.jena.graph.query.NamedGraphMap;
import com.hp.hpl.jena.graph.query.NamedTripleBunches;
import com.hp.hpl.jena.graph.query.Rewrite;
import com.hp.hpl.jena.graph.query.SimpleQueryEngine;
import com.hp.hpl.jena.graph.query.Stage;
import com.hp.hpl.jena.graph.query.TripleSorter;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.ArrayList;
import java.util.List;

public class GraphQuery {
    public static final Node ANY = Node.ANY;
    public static final Node S = Node.createVariable("S");
    public static final Node P = Node.createVariable("P");
    public static final Node O = Node.createVariable("O");
    public static final Node X = Node.createVariable("X");
    public static final Node Y = Node.createVariable("Y");
    public static final Node Z = Node.createVariable("Z");
    private NamedTripleBunches triples = new NamedTripleBunches();
    private List<Triple> triplePattern = new ArrayList<Triple>();
    private ExpressionSet constraint = new ExpressionSet();
    private SimpleQueryEngine lastQueryEngine = null;
    private NamedGraphMap argMap = new NamedGraphMap();
    private TripleSorter sortMethod = TripleSorter.dontSort;

    public GraphQuery() {
    }

    public GraphQuery(Graph pattern) {
        this.addMatches(pattern);
    }

    public GraphQuery addMatch(Node s2, Node p, Node o) {
        return this.addNamedMatch("<this>", s2, p, o);
    }

    public GraphQuery addMatch(Triple t) {
        this.triplePattern.add(t);
        this.triples.add("<this>", t);
        return this;
    }

    private GraphQuery addNamedMatch(String name, Node s2, Node p, Node o) {
        this.triplePattern.add(Triple.create(s2, p, o));
        this.triples.add(name, Triple.create(s2, p, o));
        return this;
    }

    public List<Triple> getPattern() {
        return new ArrayList<Triple>(this.triplePattern);
    }

    public ExpressionSet getConstraints() {
        return this.constraint;
    }

    public GraphQuery addConstraint(Expression e) {
        if (e.isApply() && e.getFun().equals("urn:x-jena:expr:AND")) {
            for (int i = 0; i < e.argCount(); ++i) {
                this.addConstraint(e.getArg(i));
            }
        } else if (e.isApply() && e.argCount() == 2 && e.getFun().equals("urn:x-jena:expr:Q_StringMatch")) {
            this.constraint.add(Rewrite.rewriteStringMatch(e));
        } else {
            this.constraint.add(e);
        }
        return this;
    }

    private void addMatches(Graph p) {
        ExtendedIterator<Triple> it = GraphUtil.findAll(p);
        while (it.hasNext()) {
            this.addMatch((Triple)it.next());
        }
    }

    public ExtendedIterator<Domain> executeBindings(Graph g2, Node[] results) {
        return this.executeBindings(this.args().put("<this>", g2), results);
    }

    public ExtendedIterator<Domain> executeBindings(Graph g2, List<Stage> stages, Node[] results) {
        return this.executeBindings(stages, this.args().put("<this>", g2), results);
    }

    public ExtendedIterator<Domain> executeBindings(NamedGraphMap args, Node[] nodes) {
        return this.executeBindings(new ArrayList<Stage>(), args, nodes);
    }

    public ExtendedIterator<Domain> executeBindings(List<Stage> outStages, NamedGraphMap args, Node[] nodes) {
        SimpleQueryEngine e = new SimpleQueryEngine(this.triplePattern, this.sortMethod, this.constraint);
        ExtendedIterator<Domain> result = e.executeBindings(outStages, args, nodes);
        this.lastQueryEngine = e;
        return result;
    }

    public NamedGraphMap args() {
        return this.argMap;
    }

    public TripleSorter getSorter() {
        return this.sortMethod;
    }

    public void setTripleSorter(TripleSorter ts) {
        this.sortMethod = ts == null ? TripleSorter.dontSort : ts;
    }

    public int getVariableCount() {
        return this.lastQueryEngine.getVariableCount();
    }

    public static class UnboundVariableException
    extends JenaException {
        public UnboundVariableException(Node n) {
            super(n.toString());
        }
    }
}

