/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.mem;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.mem.ArrayBunch;
import com.hp.hpl.jena.mem.HashCommon;
import com.hp.hpl.jena.mem.NodeToTriplesMapBase;
import com.hp.hpl.jena.mem.SetBunch;
import com.hp.hpl.jena.mem.TripleBunch;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NullIterator;
import java.util.Iterator;
import java.util.Set;

public class NodeToTriplesMap
extends NodeToTriplesMapBase {
    public NodeToTriplesMap(Triple.Field indexField, Triple.Field f2, Triple.Field f3) {
        super(indexField, f2, f3);
    }

    @Override
    public boolean add(Triple t) {
        Object o = this.getIndexField(t);
        OpenSetBunch s2 = (OpenSetBunch)this.bunchMap.get(o);
        if (s2 == null) {
            s2 = this.createSetBunch();
            this.bunchMap.put(o, s2);
        }
        if (s2.baseSet().add(t)) {
            ++this.size;
            return true;
        }
        return false;
    }

    private OpenSetBunch createSetBunch() {
        return new OpenSetBunch();
    }

    @Override
    public boolean remove(Triple t) {
        Object o = this.getIndexField(t);
        OpenSetBunch s2 = (OpenSetBunch)this.bunchMap.get(o);
        if (s2 == null) {
            return false;
        }
        Set<Triple> base = s2.baseSet();
        boolean result = base.remove(t);
        if (result) {
            --this.size;
        }
        if (base.isEmpty()) {
            this.bunchMap.remove(o);
        }
        return result;
    }

    public ExtendedIterator<Triple> iterator(Object o, HashCommon.NotifyEmpty container) {
        TripleBunch b = this.bunchMap.get(o);
        return b == null ? NullIterator.instance() : b.iterator();
    }

    @Override
    public boolean contains(Triple t) {
        TripleBunch s2 = this.bunchMap.get(this.getIndexField(t));
        return s2 == null ? false : s2.contains(t);
    }

    protected static boolean equalsObjectOK(Triple t) {
        Node o = t.getObject();
        return o.isLiteral() ? o.getLiteralDatatype() == null : true;
    }

    @Override
    public boolean containsBySameValueAs(Triple t) {
        return NodeToTriplesMap.equalsObjectOK(t) ? this.contains(t) : this.slowContains(t);
    }

    protected boolean slowContains(Triple t) {
        TripleBunch s2 = this.bunchMap.get(this.getIndexField(t));
        if (s2 == null) {
            return false;
        }
        ExtendedIterator<Triple> it = s2.iterator();
        while (it.hasNext()) {
            if (!t.matches((Triple)it.next())) continue;
            return true;
        }
        return false;
    }

    public ExtendedIterator<Triple> iterateAll(Triple pattern) {
        return this.indexField.filterOn(pattern).and(this.f2.filterOn(pattern)).and(this.f3.filterOn(pattern)).filterKeep(this.iterateAll());
    }

    @Override
    public ExtendedIterator<Triple> iterator(Node index, Node n2, Node n3) {
        TripleBunch s2 = this.bunchMap.get(index.getIndexingValue());
        return s2 == null ? NullIterator.instance() : this.f2.filterOn(n2).and(this.f3.filterOn(n3)).filterKeep(s2.iterator());
    }

    @Override
    public Iterator<Triple> iteratorForIndexed(Object y) {
        return this.get(y).iterator();
    }

    private TripleBunch get(Object y) {
        return this.bunchMap.get(y);
    }

    private static class OpenSetBunch
    extends SetBunch {
        private static final TripleBunch empty = new ArrayBunch();

        public OpenSetBunch() {
            super(empty);
        }

        public Set<Triple> baseSet() {
            return this.elements;
        }
    }
}

