/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.Implementation;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.ontology.ComplementClass;
import com.hp.hpl.jena.ontology.ConversionException;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.ontology.impl.OntClassImpl;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.Iterator;

public class ComplementClassImpl
extends OntClassImpl
implements ComplementClass {
    public static Implementation factory = new Implementation(){

        @Override
        public EnhNode wrap(Node n, EnhGraph eg) {
            if (this.canWrap(n, eg)) {
                return new ComplementClassImpl(n, eg);
            }
            throw new ConversionException("Cannot convert node " + n + " to ComplementClass");
        }

        @Override
        public boolean canWrap(Node node, EnhGraph eg) {
            Profile profile = eg instanceof OntModel ? ((OntModel)((Object)eg)).getProfile() : null;
            Property comp = profile == null ? null : profile.COMPLEMENT_OF();
            return profile != null && profile.isSupported(node, eg, OntClass.class) && comp != null && eg.asGraph().contains(node, comp.asNode(), Node.ANY);
        }
    };

    public ComplementClassImpl(Node n, EnhGraph g2) {
        super(n, g2);
    }

    @Override
    public void setOperands(RDFList operands) {
        throw new UnsupportedOperationException("ComplementClass takes a single operand, not a list.");
    }

    @Override
    public void setOperand(Resource cls) {
        this.setPropertyValue(this.getProfile().COMPLEMENT_OF(), "COMPLEMENT_OF", cls);
    }

    @Override
    public void addOperand(Resource cls) {
        throw new UnsupportedOperationException("ComplementClass is only defined for  a single operand.");
    }

    @Override
    public void addOperands(Iterator<? extends Resource> classes) {
        throw new UnsupportedOperationException("ComplementClass is only defined for  a single operand.");
    }

    @Override
    public RDFList getOperands() {
        throw new UnsupportedOperationException("ComplementClass takes a single operand, not a list.");
    }

    @Override
    public ExtendedIterator<? extends OntClass> listOperands() {
        return this.listAs(this.getProfile().COMPLEMENT_OF(), "COMPLEMENT_OF", OntClass.class);
    }

    @Override
    public boolean hasOperand(Resource cls) {
        return this.hasPropertyValue(this.getProfile().COMPLEMENT_OF(), "COMPLEMENT_OF", cls);
    }

    @Override
    public OntClass getOperand() {
        return this.objectAs(this.getProfile().COMPLEMENT_OF(), "COMPLEMENT_OF", OntClass.class);
    }

    @Override
    public void removeOperand(Resource res) {
        this.removePropertyValue(this.getProfile().COMPLEMENT_OF(), "COMPLEMENT_OF", res);
    }

    @Override
    public Property operator() {
        return this.getProfile().COMPLEMENT_OF();
    }
}

